/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.jms.internal.support;

import java.util.Optional;
import java.util.function.Function;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.commons.lang.StringUtils;
import org.mule.extensions.jms.api.connection.JmsSpecification;
import org.mule.extensions.jms.api.connection.LookupJndiDestination;
import org.mule.extensions.jms.api.destination.ConsumerType;
import org.mule.extensions.jms.api.destination.TopicConsumer;
import org.mule.extensions.jms.api.exception.DestinationNotFoundException;
import org.mule.extensions.jms.internal.support.JmsSupport;
import org.mule.runtime.api.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jms20Support
implements JmsSupport {
    private Logger LOGGER = LoggerFactory.getLogger(Jms20Support.class);
    private final Function<String, Optional<Destination>> jndiObjectSupplier;
    private final LookupJndiDestination lookupJndiDestination;

    public Jms20Support() {
        this(LookupJndiDestination.NEVER, name -> null);
    }

    public Jms20Support(LookupJndiDestination lookupJndiDestination, Function<String, Optional<Destination>> jndiObjectSupplier) {
        Preconditions.checkArgument((lookupJndiDestination != null ? 1 : 0) != 0, (String)"The LookupJndiDestination cannot be null");
        Preconditions.checkArgument((jndiObjectSupplier != null ? 1 : 0) != 0, (String)"The JndiObjectSupplier cannot be null");
        this.lookupJndiDestination = lookupJndiDestination;
        this.jndiObjectSupplier = jndiObjectSupplier;
    }

    @Override
    public JmsSpecification getSpecification() {
        return JmsSpecification.JMS_2_0;
    }

    @Override
    public Connection createConnection(ConnectionFactory connectionFactory, String username, String password) throws JMSException {
        Preconditions.checkArgument((connectionFactory != null ? 1 : 0) != 0, (String)"connectionFactory cannot be null");
        return connectionFactory.createConnection(username, password);
    }

    @Override
    public Connection createConnection(ConnectionFactory connectionFactory) throws JMSException {
        if (connectionFactory == null) {
            throw new IllegalArgumentException("connectionFactory cannot be null");
        }
        return connectionFactory.createConnection();
    }

    @Override
    public Session createSession(Connection connection, boolean topic, boolean transacted, int ackMode) throws JMSException {
        return connection.createSession(transacted, transacted ? 0 : ackMode);
    }

    @Override
    public MessageProducer createProducer(Session session, Destination destination, boolean topic) throws JMSException {
        return session.createProducer(destination);
    }

    @Override
    public MessageConsumer createConsumer(Session session, Destination destination, String messageSelector, ConsumerType type) throws JMSException {
        if (!type.isTopic()) {
            return session.createConsumer(destination, messageSelector);
        }
        TopicConsumer topicConsumer = (TopicConsumer)type;
        if (topicConsumer.isDurable() && topicConsumer.isShared()) {
            return session.createSharedDurableConsumer((Topic)destination, topicConsumer.getSubscriptionName(), messageSelector);
        }
        if (topicConsumer.isDurable()) {
            return session.createDurableSubscriber((Topic)destination, topicConsumer.getSubscriptionName(), messageSelector, topicConsumer.isNoLocal());
        }
        if (topicConsumer.isShared()) {
            return session.createSharedConsumer((Topic)destination, topicConsumer.getSubscriptionName(), messageSelector);
        }
        return session.createConsumer(destination, messageSelector, topicConsumer.isNoLocal());
    }

    @Override
    public Destination createDestination(Session session, String name, boolean topic) throws JMSException, DestinationNotFoundException {
        if (this.getLookupJndiDestination().equals((Object)LookupJndiDestination.ALWAYS) || this.getLookupJndiDestination().equals((Object)LookupJndiDestination.TRY_ALWAYS)) {
            Optional<Destination> destination = this.createDestinationFromJndi(name);
            if (destination.isPresent()) {
                return destination.get();
            }
            if (this.getLookupJndiDestination().equals((Object)LookupJndiDestination.ALWAYS)) {
                if (this.LOGGER.isDebugEnabled()) {
                    this.LOGGER.debug(String.format("Failed to find JNDI destination [%s], but destination origin was forced as ALWAYS use JNDI. We have to stop execution.", name));
                }
                throw new DestinationNotFoundException(String.format("Failed to find JNDI destination [%s]", name));
            }
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug(String.format("Using non-JNDI destination [%s], will create one now", name));
        }
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (String)"Session cannot be null when creating a destination");
        Preconditions.checkArgument((!StringUtils.isBlank((String)name) ? 1 : 0) != 0, (String)"Destination name cannot be blank when creating a destination");
        if (topic) {
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug(String.format("Creating Topic Destination with name: [%s]", name));
            }
            return session.createTopic(name);
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug(String.format("Creating Queue Destination with name: [%s]", name));
        }
        return session.createQueue(name);
    }

    protected Optional<Destination> createDestinationFromJndi(String name) throws JMSException {
        Optional<Destination> dest = this.getJndiDestination(name);
        if (this.LOGGER.isDebugEnabled()) {
            String message = dest.isPresent() ? "located in JNDI, will use it now" : "not found using JNDI";
            this.LOGGER.debug(String.format("Destination [%s] %s", name, message));
        }
        return dest;
    }

    protected Optional<Destination> getJndiDestination(String name) {
        try {
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug(String.format("Looking up %s from JNDI", name));
            }
            return this.getJndiObjectSupplier().apply(name);
        }
        catch (Exception e) {
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug(String.format("Failed to look up destination [%s]: ", name), (Throwable)e);
            }
            return Optional.empty();
        }
    }

    @Override
    public Destination createTemporaryDestination(Session session) throws JMSException {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (String)"Session cannot be null when creating a destination");
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug(String.format("Creating temporary destination", new Object[0]));
        }
        return session.createTemporaryQueue();
    }

    @Override
    public void send(MessageProducer producer, Message message, boolean persistent, int priority, long ttl, boolean topic) throws JMSException {
        if (this.LOGGER.isDebugEnabled()) {
            Destination dest = producer.getDestination();
            this.LOGGER.debug(String.format("Sending message to [%s], persistent:[%s], with priority:[%s] and ttl:[%s]", dest instanceof Queue ? ((Queue)dest).getQueueName() : ((Topic)dest).getTopicName(), persistent, priority, ttl));
        }
        producer.send(message, persistent ? 2 : 1, priority, ttl);
    }

    private Function<String, Optional<Destination>> getJndiObjectSupplier() {
        return this.jndiObjectSupplier;
    }

    protected LookupJndiDestination getLookupJndiDestination() {
        return this.lookupJndiDestination;
    }
}

