/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.jms.internal.consume;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import org.apache.commons.lang.time.StopWatch;
import org.mule.extensions.jms.api.exception.JmsTimeoutException;
import org.mule.runtime.api.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmsMessageConsumer
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsMessageConsumer.class);
    private final MessageConsumer consumer;

    public JmsMessageConsumer(MessageConsumer consumer) {
        Preconditions.checkArgument((consumer != null ? 1 : 0) != 0, (String)"A non null MessageConsumer is required to use as delegate");
        this.consumer = consumer;
    }

    public void listen(MessageListener listener) throws JMSException {
        this.consumer.setMessageListener(listener);
    }

    public Message consume(Long maximumWaitTime) throws JMSException, JmsTimeoutException {
        if (maximumWaitTime == -1L) {
            return this.receive();
        }
        if (maximumWaitTime == 0L) {
            return this.receiveNoWait();
        }
        return this.receiveWithTimeout(maximumWaitTime);
    }

    @Override
    public void close() throws JMSException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Closing consumer " + this.consumer);
        }
        this.consumer.close();
    }

    private Message receiveWithTimeout(Long maximumWaitTime) throws JMSException, JmsTimeoutException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Waiting for a message, timeout will be in [%s] millis", maximumWaitTime));
        }
        StopWatch timeoutValidator = new StopWatch();
        timeoutValidator.start();
        Message message = this.consumer.receive(maximumWaitTime.longValue());
        timeoutValidator.stop();
        if (message == null && timeoutValidator.getTime() > maximumWaitTime) {
            throw new JmsTimeoutException("Failed to retrieve a Message, operation timed out");
        }
        return message;
    }

    private Message receiveNoWait() throws JMSException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Trying to consume an immediately available message");
        }
        return this.consumer.receiveNoWait();
    }

    private Message receive() throws JMSException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("No Timeout set, waiting for a message until one arrives");
        }
        return this.consumer.receive();
    }
}

