/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.jms.internal.connection;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.TopicConnection;
import org.apache.commons.lang.StringUtils;
import org.mule.extensions.jms.api.connection.caching.CachingConfiguration;
import org.mule.extensions.jms.internal.support.JmsSupport;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.util.Preconditions;
import org.springframework.jms.connection.CachingConnectionFactory;

public class JmsCachingConnectionFactory
extends CachingConnectionFactory
implements Stoppable,
Disposable {
    private final String username;
    private final String password;
    private final JmsSupport jmsSupport;
    private final String clientId;

    public JmsCachingConnectionFactory(ConnectionFactory targetConnectionFactory, String username, String password, String clientId, CachingConfiguration config, JmsSupport jmsSupport, ExceptionListener exceptionListener) {
        super(targetConnectionFactory);
        Preconditions.checkArgument((!(targetConnectionFactory instanceof CachingConnectionFactory) ? 1 : 0) != 0, (String)"The ConnectionFactory provided shouldn't be wrapped in a JmsCachingConnectionFactory");
        super.setCacheConsumers(config.isConsumersCache());
        super.setCacheProducers(config.isProducersCache());
        super.setSessionCacheSize(config.getSessionCacheSize());
        super.setReconnectOnException(false);
        super.setExceptionListener(exceptionListener);
        this.username = username;
        this.password = password;
        this.clientId = clientId;
        this.jmsSupport = jmsSupport;
    }

    protected Connection doCreateConnection() throws JMSException {
        Connection connection = StringUtils.isBlank((String)this.username) ? this.jmsSupport.createConnection(this.getTargetConnectionFactory()) : this.jmsSupport.createConnection(this.getTargetConnectionFactory(), this.username, this.password);
        if (!StringUtils.isBlank((String)this.clientId)) {
            connection.setClientID(this.clientId);
        }
        return connection;
    }

    public void stop() {
        this.resetConnection();
    }

    public void dispose() {
        this.destroy();
    }

    public Connection createConnection(String username, String password) throws JMSException {
        throw new IllegalStateException("JmsCachingConnectionFactory does not support creating a connection with username and password. Provide the desired username and password when the instance is defined");
    }

    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        throw new IllegalStateException("JmsCachingConnectionFactory does not support creating a connection with username and password. Provide the desired username and password when the instance is defined");
    }

    public TopicConnection createTopicConnection(String username, String password) throws JMSException {
        throw new IllegalStateException("JmsCachingConnectionFactory does not support creating a connection with username and password. Provide the desired username and password when the instance is defined");
    }

    public JMSContext createContext() {
        return null;
    }

    public JMSContext createContext(String userName, String password) {
        return null;
    }

    public JMSContext createContext(String userName, String password, int sessionMode) {
        return null;
    }

    public JMSContext createContext(int sessionMode) {
        return null;
    }
}

