/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.jms.internal.common;

import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.commons.lang.StringUtils;
import org.mule.extensions.jms.api.config.AckMode;
import org.mule.extensions.jms.api.connection.JmsConnection;
import org.mule.extensions.jms.api.connection.JmsSession;
import org.mule.extensions.jms.api.exception.JmsAckException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmsOperationCommons {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsOperationCommons.class);

    public static String resolveMessageContentType(Message message, String defaultType) {
        try {
            String contentType = message.getStringProperty("MM_MESSAGE_CONTENT_TYPE");
            return StringUtils.isBlank((String)contentType) ? defaultType : contentType;
        }
        catch (JMSException e) {
            LOGGER.warn(String.format("Failed to read the Message ContentType from its properties. A default value of [%s] will be used.", defaultType));
            return defaultType;
        }
    }

    public static <T> T resolveOverride(T configValue, T operationValue) {
        return operationValue == null ? configValue : operationValue;
    }

    public static void evaluateMessageAck(JmsConnection connection, AckMode ackMode, JmsSession session, Message received) throws JMSException {
        try {
            if (ackMode.equals((Object)AckMode.NONE)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Automatically performing an ACK over the message, since AckMode was NONE");
                }
                received.acknowledge();
            } else if (ackMode.equals((Object)AckMode.MANUAL)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Registering pending ACK on session: " + session.getAckId());
                }
                String id = session.getAckId().orElseThrow(() -> new IllegalArgumentException("An AckId is required when MANUAL AckMode is set"));
                connection.registerMessageForAck(id, received);
            }
        }
        catch (JMSException e) {
            throw new JmsAckException("An error occurred while acking message", (Exception)((Object)e));
        }
    }
}

