/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.jms.api.operation;

import javax.jms.Destination;
import javax.jms.Message;
import org.mule.extensions.jms.api.config.AckMode;
import org.mule.extensions.jms.api.config.JmsConfig;
import org.mule.extensions.jms.api.config.JmsProducerConfig;
import org.mule.extensions.jms.api.connection.JmsConnection;
import org.mule.extensions.jms.api.connection.JmsSession;
import org.mule.extensions.jms.api.destination.DestinationType;
import org.mule.extensions.jms.api.exception.JmsExtensionException;
import org.mule.extensions.jms.api.exception.JmsPublishException;
import org.mule.extensions.jms.api.exception.JmsPublisherErrorTypeProvider;
import org.mule.extensions.jms.api.message.MessageBuilder;
import org.mule.extensions.jms.internal.publish.JmsPublishParameters;
import org.mule.runtime.extension.api.annotation.dsl.xml.XmlHints;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.UseConfig;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmsPublish {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsPublish.class);

    @Throws(value={JmsPublisherErrorTypeProvider.class})
    public void publish(@UseConfig JmsConfig config, @Connection JmsConnection connection, @XmlHints(allowReferences=false) @Summary(value="The name of the Destination where the Message should be sent") String destination, @Optional(defaultValue="QUEUE") @Summary(value="The type of the Destination") DestinationType destinationType, @Optional @NullSafe @Summary(value="A builder for the message that will be published") MessageBuilder messageBuilder, @ParameterGroup(name="Publish Configuration") JmsPublishParameters overrides) throws JmsExtensionException {
        JmsProducerConfig producerConfig = config.getProducerConfig();
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Begin publish");
            }
            JmsSession session = connection.createSession(AckMode.AUTO, destinationType.isTopic());
            Message message = messageBuilder.build(connection.getJmsSupport(), session.get(), config);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Message built, sending message to [%s] using session [%s]", destination, session.get()));
            }
            Destination jmsDestination = connection.getJmsSupport().createDestination(session.get(), destination, destinationType.isTopic());
            connection.createProducer(session.get(), jmsDestination, destinationType.isTopic()).publish(message, producerConfig, overrides);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Finished publish");
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("An error occurred while sending a message to [%s]: ", destination), (Throwable)e);
            throw new JmsPublishException(String.format("An error occurred while sending a message to [%s]: ", destination), e);
        }
    }
}

