/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.jms.api.operation;

import java.util.concurrent.TimeUnit;
import javax.jms.Destination;
import javax.jms.Message;
import org.mule.extensions.jms.api.config.AckMode;
import org.mule.extensions.jms.api.config.JmsConfig;
import org.mule.extensions.jms.api.config.JmsConsumerConfig;
import org.mule.extensions.jms.api.connection.JmsConnection;
import org.mule.extensions.jms.api.connection.JmsSession;
import org.mule.extensions.jms.api.destination.ConsumerType;
import org.mule.extensions.jms.api.exception.JmsConsumeErrorTypeProvider;
import org.mule.extensions.jms.api.exception.JmsConsumeException;
import org.mule.extensions.jms.api.exception.JmsExtensionException;
import org.mule.extensions.jms.api.message.JmsAttributes;
import org.mule.extensions.jms.internal.common.JmsOperationCommons;
import org.mule.extensions.jms.internal.consume.JmsMessageConsumer;
import org.mule.extensions.jms.internal.message.JmsResultFactory;
import org.mule.extensions.jms.internal.metadata.JmsOutputResolver;
import org.mule.extensions.jms.internal.support.JmsSupport;
import org.mule.runtime.extension.api.annotation.dsl.xml.XmlHints;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.UseConfig;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmsConsume {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsConsume.class);
    private final JmsResultFactory resultFactory = new JmsResultFactory();

    @OutputResolver(output=JmsOutputResolver.class)
    @Throws(value={JmsConsumeErrorTypeProvider.class})
    public Result<Object, JmsAttributes> consume(@Connection JmsConnection connection, @UseConfig JmsConfig config, @XmlHints(allowReferences=false) @Summary(value="The name of the Destination from where the Message should be consumed") String destination, @Optional @Summary(value="The Type of the Consumer that should be used for the provided destination") ConsumerType consumerType, @Optional @Summary(value="The Session ACK mode to use when consuming a message") AckMode ackMode, @Optional @Summary(value="JMS selector to be used for filtering incoming messages") String selector, @Optional @Summary(value="The content type of the message body") String contentType, @Optional @Summary(value="The encoding of the message body") String encoding, @Optional(defaultValue="10000") @Summary(value="Maximum time to wait for a message to arrive before timeout") Long maximumWait, @Optional(defaultValue="MILLISECONDS") @Summary(value="Time unit to be used in the maximumWaitTime configuration") TimeUnit maximumWaitUnit) throws JmsExtensionException {
        JmsConsumerConfig consumerConfig = config.getConsumerConfig();
        consumerType = JmsOperationCommons.resolveOverride(consumerConfig.getConsumerType(), consumerType);
        ackMode = JmsOperationCommons.resolveOverride(consumerConfig.getAckMode(), ackMode);
        selector = JmsOperationCommons.resolveOverride(consumerConfig.getSelector(), selector);
        encoding = JmsOperationCommons.resolveOverride(config.getEncoding(), encoding);
        try {
            Message received;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Begin Consume");
            }
            JmsSupport jmsSupport = connection.getJmsSupport();
            JmsSession session = connection.createSession(ackMode, consumerType.isTopic());
            Destination jmsDestination = jmsSupport.createDestination(session.get(), destination, consumerType.isTopic());
            JmsMessageConsumer consumer = connection.createConsumer(session.get(), jmsDestination, selector, consumerType);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Consuming Message");
            }
            if ((received = consumer.consume(maximumWaitUnit.toMillis(maximumWait))) != null) {
                JmsOperationCommons.evaluateMessageAck(connection, ackMode, session, received);
                contentType = JmsOperationCommons.resolveOverride(JmsOperationCommons.resolveMessageContentType(received, config.getContentType()), contentType);
            }
            return this.resultFactory.createResult(received, jmsSupport.getSpecification(), contentType, encoding, session.getAckId());
        }
        catch (Exception e) {
            String msg = String.format("An error occurred while consuming a message from destination [%s] of type [%s]: ", destination, consumerType.isTopic() ? "TOPIC" : "QUEUE");
            LOGGER.error(msg, (Throwable)e);
            throw new JmsConsumeException(msg, e);
        }
    }
}

