/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.jms.api.connection.factory.jndi;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.NamingException;
import org.mule.extensions.jms.api.connection.factory.jndi.AbstractJndiNameResolver;
import org.mule.runtime.api.exception.MuleException;

public class CachedJndiNameResolver
extends AbstractJndiNameResolver {
    protected Map<String, Object> cache;

    @Override
    public Object lookup(String name) throws NamingException {
        Object result = this.findInCache(name);
        if (result == null) {
            result = this.findInContext(name);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object findInContext(String name) throws NamingException {
        try (Context jndiContext = this.createInitialContext();){
            Object result = jndiContext.lookup(name);
            if (result != null) {
                this.cache.put(name, result);
            }
            Object object = result;
            return object;
        }
    }

    private Object findInCache(String name) {
        Object result = null;
        if (name != null) {
            result = this.cache.get(name);
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug(String.format("Object: " + name + " was %sfound in the cache", result == null ? "not " : ""));
            }
        }
        return result;
    }

    @Override
    public void initialise() {
        this.cache = new ConcurrentHashMap<String, Object>();
    }

    @Override
    public void stop() throws MuleException {
        this.cache.clear();
    }
}

