/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jira;

import com.atlassian.jira.rpc.soap.beans.RemoteAvatar;
import com.atlassian.jira.rpc.soap.beans.RemoteComment;
import com.atlassian.jira.rpc.soap.beans.RemoteConfiguration;
import com.atlassian.jira.rpc.soap.beans.RemoteCustomFieldValue;
import com.atlassian.jira.rpc.soap.beans.RemoteField;
import com.atlassian.jira.rpc.soap.beans.RemoteGroup;
import com.atlassian.jira.rpc.soap.beans.RemoteIssue;
import com.atlassian.jira.rpc.soap.beans.RemotePermissionScheme;
import com.atlassian.jira.rpc.soap.beans.RemoteProject;
import com.atlassian.jira.rpc.soap.beans.RemoteProjectRole;
import com.atlassian.jira.rpc.soap.beans.RemoteProjectRoleActors;
import com.atlassian.jira.rpc.soap.beans.RemoteRoleActors;
import com.atlassian.jira.rpc.soap.beans.RemoteSecurityLevel;
import com.atlassian.jira.rpc.soap.beans.RemoteServerInfo;
import com.atlassian.jira.rpc.soap.beans.RemoteUser;
import com.atlassian.jira.rpc.soap.beans.RemoteVersion;
import com.atlassian.jira.rpc.soap.beans.RemoteWorklog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.mule.module.jira.Config;
import org.mule.module.jira.JiraConnectorException;

public class JiraConnector {
    private Config config;
    private static final String MULTIVALUED_FIELD_SEPARATOR = "\\|";
    private Map<String, String> customFieldsNamesToIdsMapping = null;
    private Calendar customFieldsCacheExpiration = null;

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    private Map<String, String> getCustomFieldsNamesToIdsMapping() {
        if (this.customFieldsNamesToIdsMapping == null || new GregorianCalendar().after(this.customFieldsCacheExpiration)) {
            this.customFieldsNamesToIdsMapping = new HashMap<String, String>();
            List<Object> customFields = this.config.getClient().getCustomFields(this.config.getToken());
            for (Object customField : customFields) {
                RemoteField remoteField = (RemoteField)customField;
                this.customFieldsNamesToIdsMapping.put(remoteField.getName(), remoteField.getId());
            }
            this.customFieldsCacheExpiration = new GregorianCalendar();
            this.customFieldsCacheExpiration.add(11, 1);
        }
        return this.customFieldsNamesToIdsMapping;
    }

    private Map<String, List<String>> convertFieldsToMultivaluedAndMapNamesToIds(Map<String, String> fields) {
        HashMap<String, List<String>> multivaluedFields = new HashMap<String, List<String>>();
        if (fields != null) {
            for (Map.Entry<String, String> field : fields.entrySet()) {
                String value;
                Map<String, String> customFields;
                String id;
                String fieldKey = field.getKey();
                if (this.config.getUseCustomFieldsExternalName().booleanValue() && (id = (customFields = this.getCustomFieldsNamesToIdsMapping()).get(fieldKey)) != null) {
                    fieldKey = id;
                }
                if ((value = field.getValue()) == null) {
                    value = "";
                }
                multivaluedFields.put(fieldKey, Arrays.asList(value.split(MULTIVALUED_FIELD_SEPARATOR)));
            }
        }
        return multivaluedFields;
    }

    private void mapCustomFieldsFromNamesToIds(RemoteIssue issue) {
        if (issue.getCustomFieldValues() != null && this.config.getUseCustomFieldsExternalName().booleanValue()) {
            Map<String, String> customFields = this.getCustomFieldsNamesToIdsMapping();
            for (RemoteCustomFieldValue field : issue.getCustomFieldValues()) {
                if (field.getCustomfieldId().startsWith("customfield_") || !customFields.containsKey(field.getCustomfieldId())) continue;
                field.setCustomfieldId(customFields.get(field.getCustomfieldId()));
            }
        }
    }

    public RemoteComment getComment(Long commentId) {
        return this.config.getClient().getComment(this.config.getToken(), commentId);
    }

    public RemoteConfiguration getConfiguration() {
        return this.config.getClient().getConfiguration(this.config.getToken());
    }

    public RemoteGroup createGroup(String groupName, String userName) {
        return this.config.getClient().createGroup(this.config.getToken(), groupName, userName);
    }

    public RemoteServerInfo getServerInfo() {
        return this.config.getClient().getServerInfo(this.config.getToken());
    }

    public RemoteGroup getGroup(String groupName) {
        return this.config.getClient().getGroup(this.config.getToken(), groupName);
    }

    public RemoteUser createUser(String username, String password, String fullName, String email) {
        return this.config.getClient().createUser(this.config.getToken(), username, password, fullName, email);
    }

    public RemoteComment addComment(String issueKey, String commentAuthor, String commentBody, String commentGroupLevel, String commentRoleLevel) {
        return this.config.getClient().addComment(this.config.getToken(), issueKey, commentAuthor, commentBody, commentGroupLevel, commentRoleLevel);
    }

    public List<Object> getComponents(String projectKey) {
        return this.config.getClient().getComponents(this.config.getToken(), projectKey);
    }

    public RemoteUser getUser(String username) {
        return this.config.getClient().getUser(this.config.getToken(), username);
    }

    public RemoteGroup updateGroup(String groupName, List<String> usernames) {
        return this.config.getClient().updateGroup(this.config.getToken(), groupName, usernames);
    }

    public void addUserToGroup(String groupName, String userName) {
        this.config.getClient().addUserToGroup(this.config.getToken(), groupName, userName);
    }

    public void removeUserFromGroup(String groupName, String userName) {
        this.config.getClient().removeUserFromGroup(this.config.getToken(), groupName, userName);
    }

    public RemoteIssue getIssue(String issueKey) {
        return this.config.getClient().getIssue(this.config.getToken(), issueKey);
    }

    public RemoteIssue createIssue(String assignee, String summary, String description, String dueDate, String environment, String priority, String project, String reporter, String type, Long votes, Map<String, String> customFields, String componentName, String componentId) {
        Map<String, List<String>> multivaluedFields = this.convertFieldsToMultivaluedAndMapNamesToIds(customFields);
        return this.config.getClient().createIssue(this.config.getToken(), assignee, summary, description, dueDate, environment, priority, project, reporter, type, votes, multivaluedFields, componentName, componentId);
    }

    public RemoteIssue createIssueUsingObject(RemoteIssue issue) {
        this.mapCustomFieldsFromNamesToIds(issue);
        return this.config.getClient().createIssue(this.config.getToken(), issue);
    }

    public RemoteIssue createIssueWithParent(RemoteIssue issue, String parentIssueKey) {
        this.mapCustomFieldsFromNamesToIds(issue);
        return this.config.getClient().createIssueWithParent(this.config.getToken(), issue, parentIssueKey);
    }

    public RemoteIssue createIssueWithSecurityLevel(String assignee, String summary, String description, String dueDate, String environment, String priority, String project, String reporter, String type, Long votes, Map<String, String> customFields, Long securityLevelId, String componentName, String componentId) {
        Map<String, List<String>> multivaluedFields = this.convertFieldsToMultivaluedAndMapNamesToIds(customFields);
        return this.config.getClient().createIssueWithSecurityLevel(this.config.getToken(), assignee, summary, description, dueDate, environment, priority, project, reporter, type, votes, multivaluedFields, securityLevelId, componentName, componentId);
    }

    public RemoteIssue updateIssue(String issueKey, Map<String, String> fields) {
        Map<String, List<String>> multivaluedFields = this.convertFieldsToMultivaluedAndMapNamesToIds(fields);
        return this.config.getClient().updateIssue(this.config.getToken(), issueKey, multivaluedFields);
    }

    public List<RemoteIssue> updateIssuesByJql(String jql, Map<String, String> fields, Integer maxRecordsToUpdate) {
        List<Object> issuesToUpdate = this.config.getClient().getIssuesFromJqlSearch(this.config.getToken(), jql, 10000);
        if (issuesToUpdate != null && maxRecordsToUpdate != null && issuesToUpdate.size() > maxRecordsToUpdate) {
            throw new JiraConnectorException("Couldn't execute update-issues-by-jql. The number of issues found by the jql query (" + issuesToUpdate.size() + ") was greater than the maxRecordsToUpdate given (" + maxRecordsToUpdate + ")");
        }
        if (CollectionUtils.isNotEmpty(issuesToUpdate)) {
            ArrayList<RemoteIssue> result = new ArrayList<RemoteIssue>();
            Map<String, List<String>> multivaluedFields = this.convertFieldsToMultivaluedAndMapNamesToIds(fields);
            for (Object issue : issuesToUpdate) {
                RemoteIssue updatedIssue = this.config.getClient().updateIssue(this.config.getToken(), ((RemoteIssue)issue).getKey(), multivaluedFields);
                result.add(updatedIssue);
            }
            return result;
        }
        throw new JiraConnectorException("Can't execute update. The jql search returned no issues");
    }

    public void deleteIssue(String issueKey) {
        this.config.getClient().deleteIssue(this.config.getToken(), issueKey);
    }

    public List<Object> getAvailableActions(String issueKey) {
        return this.config.getClient().getAvailableActions(this.config.getToken(), issueKey);
    }

    public List<Object> getSubTaskIssueTypes() {
        return this.config.getClient().getSubTaskIssueTypes(this.config.getToken());
    }

    public RemoteProject createProject(String key, String projectName, String description, String url, String lead, String permissionSchemeName, String notificationSchemeName, String securityShemeName) {
        return this.config.getClient().createProject(this.config.getToken(), key, projectName, description, url, lead, permissionSchemeName, notificationSchemeName, securityShemeName);
    }

    public RemoteProject createProjectUsingObject(RemoteProject project) {
        return this.config.getClient().createProject(this.config.getToken(), project);
    }

    public RemoteProject updateProject(String key, String projectName, String description, String url, String lead, String permissionSchemeName, String notificationSchemeName, String securityShemeName) {
        return this.config.getClient().updateProject(this.config.getToken(), key, projectName, description, url, lead, permissionSchemeName, notificationSchemeName, securityShemeName);
    }

    public RemoteProject getProjectByKey(String projectKey) {
        return this.config.getClient().getProjectByKey(this.config.getToken(), projectKey);
    }

    public void removeAllRoleActorsByProject(String projectKey) {
        this.config.getClient().removeAllRoleActorsByProject(this.config.getToken(), projectKey);
    }

    public List<Object> getPriorities() {
        return this.config.getClient().getPriorities(this.config.getToken());
    }

    public List<Object> getResolutions() {
        return this.config.getClient().getResolutions(this.config.getToken());
    }

    public List<Object> getIssueTypes() {
        return this.config.getClient().getIssueTypes(this.config.getToken());
    }

    public List<Object> getStatuses() {
        return this.config.getClient().getStatuses(this.config.getToken());
    }

    public List<Object> getIssueTypesForProject(String projectId) {
        return this.config.getClient().getIssueTypesForProject(this.config.getToken(), projectId);
    }

    public List<Object> getProjectRoles() {
        return this.config.getClient().getProjectRoles(this.config.getToken());
    }

    public RemoteProjectRole getProjectRole(Long projectRoleId) {
        return this.config.getClient().getProjectRole(this.config.getToken(), projectRoleId);
    }

    public RemoteProjectRoleActors getProjectRoleActors(Long projectRoleId, String projectKey) {
        return this.config.getClient().getProjectRoleActors(this.config.getToken(), projectRoleId, projectKey);
    }

    public RemoteRoleActors getDefaultRoleActors(Long projectRoleId) {
        return this.config.getClient().getDefaultRoleActors(this.config.getToken(), projectRoleId);
    }

    public void removeAllRoleActorsByNameAndType(String roleName, String type) {
        this.config.getClient().removeAllRoleActorsByNameAndType(this.config.getToken(), roleName, type);
    }

    public void deleteProjectRole(Long projectRoleId, Boolean confirm) {
        this.config.getClient().deleteProjectRole(this.config.getToken(), projectRoleId, confirm);
    }

    public void updateProjectRole(Long projectRoleId, String projectRoleName, String projectRoleDescription) {
        this.config.getClient().updateProjectRole(this.config.getToken(), projectRoleId, projectRoleName, projectRoleDescription);
    }

    public RemoteProjectRole createProjectRole(String projectRoleName, String projectRoleDescription) {
        return this.config.getClient().createProjectRole(this.config.getToken(), projectRoleName, projectRoleDescription);
    }

    public boolean isProjectRoleNameUnique(String roleName) {
        return this.config.getClient().isProjectRoleNameUnique(this.config.getToken(), roleName);
    }

    public void releaseVersion(String projectKey, String versionName) {
        this.config.getClient().releaseVersion(this.config.getToken(), projectKey, versionName);
    }

    public void addActorsToProjectRole(List<String> actors, Long projectRoleId, String projectKey, String actorType) {
        this.config.getClient().addActorsToProjectRole(this.config.getToken(), actors, projectRoleId, projectKey, actorType);
    }

    public void removeActorsFromProjectRole(List<String> actors, Long projectRoleId, String projectKey, String actorType) {
        this.config.getClient().removeActorsFromProjectRole(this.config.getToken(), actors, projectRoleId, projectKey, actorType);
    }

    public void addDefaultActorsToProjectRole(List<String> actors, Long projectRoleId, String type) {
        this.config.getClient().addDefaultActorsToProjectRole(this.config.getToken(), actors, projectRoleId, type);
    }

    public void removeDefaultActorsFromProjectRole(List<String> actors, Long remoteProjectRoleId, String type) {
        this.config.getClient().removeDefaultActorsFromProjectRole(this.config.getToken(), actors, remoteProjectRoleId, type);
    }

    public List<Object> getAssociatedNotificationSchemes(Long projectRoleId) {
        return this.config.getClient().getAssociatedNotificationSchemes(this.config.getToken(), projectRoleId);
    }

    public List<Object> getAssociatedPermissionSchemes(Long projectRoleId) {
        return this.config.getClient().getAssociatedPermissionSchemes(this.config.getToken(), projectRoleId);
    }

    public void deleteProject(String projectKey) {
        this.config.getClient().deleteProject(this.config.getToken(), projectKey);
    }

    public RemoteProject getProjectById(Long projectId) {
        return this.config.getClient().getProjectById(this.config.getToken(), projectId);
    }

    public List<Object> getVersions(String projectKey) {
        return this.config.getClient().getVersions(this.config.getToken(), projectKey);
    }

    public List<Object> getComments(String issueKey) {
        return this.config.getClient().getComments(this.config.getToken(), issueKey);
    }

    public List<Object> getFavouriteFilters() {
        return this.config.getClient().getFavouriteFilters(this.config.getToken());
    }

    public void archiveVersion(String projectKey, String versionName, Boolean archive) {
        this.config.getClient().archiveVersion(this.config.getToken(), projectKey, versionName, archive);
    }

    public List<Object> getFieldsForEdit(String issueKey) {
        return this.config.getClient().getFieldsForEdit(this.config.getToken(), issueKey);
    }

    public List<Object> getSubTaskIssueTypesForProject(String projectId) {
        return this.config.getClient().getSubTaskIssueTypesForProject(this.config.getToken(), projectId);
    }

    public String login(String username, String password) {
        return this.config.getClient().login(username, password);
    }

    public RemoteSecurityLevel getSecurityLevel(String issueKey) {
        return this.config.getClient().getSecurityLevel(this.config.getToken(), issueKey);
    }

    public List<Object> getCustomFields() {
        return this.config.getClient().getCustomFields(this.config.getToken());
    }

    public boolean logout(String token) {
        return this.config.getClient().logout(token);
    }

    public RemoteProject getProjectWithSchemesById(Long projectId) {
        return this.config.getClient().getProjectWithSchemesById(this.config.getToken(), projectId);
    }

    public List<Object> getSecurityLevels(String projectKey) {
        return this.config.getClient().getSecurityLevels(this.config.getToken(), projectKey);
    }

    public List<Object> getProjectAvatars(String projectKey, Boolean includeSystemAvatars) {
        return this.config.getClient().getProjectAvatars(this.config.getToken(), projectKey, includeSystemAvatars);
    }

    public void setProjectAvatar(String projectKey, Long avatarId) {
        this.config.getClient().setProjectAvatar(this.config.getToken(), projectKey, avatarId);
    }

    public RemoteAvatar getProjectAvatar(String projectKey) {
        return this.config.getClient().getProjectAvatar(this.config.getToken(), projectKey);
    }

    public void deleteProjectAvatar(Long avatarId) {
        this.config.getClient().deleteProjectAvatar(this.config.getToken(), avatarId);
    }

    public List<Object> getNotificationSchemes() {
        return this.config.getClient().getNotificationSchemes(this.config.getToken());
    }

    public List<Object> getPermissionSchemes() {
        return this.config.getClient().getPermissionSchemes(this.config.getToken());
    }

    public List<Object> getAllPermissions() {
        return this.config.getClient().getAllPermissions(this.config.getToken());
    }

    public RemotePermissionScheme createPermissionScheme(String permissionName, String description) {
        return this.config.getClient().createPermissionScheme(this.config.getToken(), permissionName, description);
    }

    public RemotePermissionScheme addPermissionTo(String permissionSchemeName, Long permissionCode, String entityName) {
        return this.config.getClient().addPermissionTo(this.config.getToken(), permissionSchemeName, permissionCode, entityName);
    }

    public RemotePermissionScheme deletePermissionFrom(String permissionSchemeName, Long permissionCode, String entityName) {
        return this.config.getClient().deletePermissionFrom(this.config.getToken(), permissionSchemeName, permissionCode, entityName);
    }

    public void deletePermissionScheme(String permissionSchemeName) {
        this.config.getClient().deletePermissionScheme(this.config.getToken(), permissionSchemeName);
    }

    public List<Object> getAttachmentsFromIssue(String issueKey) {
        return this.config.getClient().getAttachmentsFromIssue(this.config.getToken(), issueKey);
    }

    public boolean hasPermissionToEditComment(Long commentId) {
        return this.config.getClient().hasPermissionToEditComment(this.config.getToken(), commentId);
    }

    public RemoteComment editComment(Long commentId, String body, String updateAuthor) {
        return this.config.getClient().editComment(this.config.getToken(), commentId, body, updateAuthor);
    }

    public List<Object> getFieldsForAction(String issueKey, String actionIdString) {
        return this.config.getClient().getFieldsForAction(this.config.getToken(), issueKey, actionIdString);
    }

    public RemoteIssue getIssueById(String issueId) {
        return this.config.getClient().getIssueById(this.config.getToken(), issueId);
    }

    public void deleteWorklogWithNewRemainingEstimate(String workLogId, String newRemainingEstimate) {
        this.config.getClient().deleteWorklogWithNewRemainingEstimate(this.config.getToken(), workLogId, newRemainingEstimate);
    }

    public void deleteWorklogAndAutoAdjustRemainingEstimate(String worklogId) {
        this.config.getClient().deleteWorklogAndAutoAdjustRemainingEstimate(this.config.getToken(), worklogId);
    }

    public void deleteWorklogAndRetainRemainingEstimate(String worklogId) {
        this.config.getClient().deleteWorklogAndRetainRemainingEstimate(this.config.getToken(), worklogId);
    }

    public List<Object> getWorklogs(String issueKey) {
        return this.config.getClient().getWorklogs(this.config.getToken(), issueKey);
    }

    public boolean hasPermissionToCreateWorklog(String issueKey) {
        return this.config.getClient().hasPermissionToCreateWorklog(this.config.getToken(), issueKey);
    }

    public boolean hasPermissionToDeleteWorklog(String worklogId) {
        return this.config.getClient().hasPermissionToDeleteWorklog(this.config.getToken(), worklogId);
    }

    public boolean hasPermissionToUpdateWorklog(String worklogId) {
        return this.config.getClient().hasPermissionToUpdateWorklog(this.config.getToken(), worklogId);
    }

    public void updateWorklogWithNewRemainingEstimate(String issueKey, String worklogId, String newRemainingEstimate, String comment, String groupLevel, String roleLevelId) {
        this.config.getClient().updateWorklogWithNewRemainingEstimate(this.config.getToken(), issueKey, worklogId, comment, groupLevel, roleLevelId, newRemainingEstimate);
    }

    public RemoteVersion addVersion(String projectKey, String versionName, Boolean archived, Boolean released, String releaseDate) {
        return this.config.getClient().addVersion(this.config.getToken(), projectKey, versionName, archived, released, releaseDate);
    }

    public Calendar getResolutionDateByKey(String issueKey) {
        return this.config.getClient().getResolutionDateByKey(this.config.getToken(), issueKey);
    }

    public Calendar getResolutionDateById(Long issueId) {
        return this.config.getClient().getResolutionDateById(this.config.getToken(), issueId);
    }

    public long getIssueCountForFilter(String filterId) {
        return this.config.getClient().getIssueCountForFilter(this.config.getToken(), filterId);
    }

    public List<Object> getIssuesFromTextSearchWithProject(List<String> projectKeys, String searchTerms, Integer maxNumResults) {
        return this.config.getClient().getIssuesFromTextSearchWithProject(this.config.getToken(), projectKeys, searchTerms, maxNumResults);
    }

    public List<Object> getIssuesFromJqlSearch(String jqlSearch, Integer maxNumResults) {
        return this.config.getClient().getIssuesFromJqlSearch(this.config.getToken(), jqlSearch, maxNumResults);
    }

    public void deleteUser(String username) {
        this.config.getClient().deleteUser(this.config.getToken(), username);
    }

    public void deleteGroup(String groupName, String swapGroupName) {
        this.config.getClient().deleteGroup(this.config.getToken(), groupName, swapGroupName);
    }

    public void refreshCustomFields() {
        this.config.getClient().refreshCustomFields(this.config.getToken());
    }

    public boolean addBase64EncodedAttachmentsToIssue(String issueKey, List<String> fileNames, List<String> base64EncodedAttachmentData) {
        return this.config.getClient().addBase64EncodedAttachmentsToIssue(this.config.getToken(), issueKey, fileNames, base64EncodedAttachmentData);
    }

    public List<Object> getIssuesFromFilterWithLimit(String filterId, Integer offset, Integer maxNumResults) {
        return this.config.getClient().getIssuesFromFilterWithLimit(this.config.getToken(), filterId, offset, maxNumResults);
    }

    public List<Object> getIssuesFromTextSearchWithLimit(String searchTerms, Integer offset, Integer maxNumResults) {
        return this.config.getClient().getIssuesFromTextSearchWithLimit(this.config.getToken(), searchTerms, offset, maxNumResults);
    }

    public List<Object> getProjectsNoSchemes() {
        return this.config.getClient().getProjectsNoSchemes(this.config.getToken());
    }

    public void setNewProjectAvatar(String projectKey, String contentType, String base64ImageData) {
        this.config.getClient().setNewProjectAvatar(this.config.getToken(), projectKey, contentType, base64ImageData);
    }

    public RemoteIssue progressWorkflowAction(String issueKey, String actionIdString, Map<String, String> fields) {
        Map<String, List<String>> multivaluedFields = this.convertFieldsToMultivaluedAndMapNamesToIds(fields);
        return this.config.getClient().progressWorkflowAction(this.config.getToken(), issueKey, actionIdString, multivaluedFields);
    }

    public RemoteWorklog addWorklogAndAutoAdjustRemainingEstimate(String issueKey, String timeSpent, String startDate, String comment, String groupLevel, String roleLevelId) {
        return this.config.getClient().addWorklogAndAutoAdjustRemainingEstimate(this.config.getToken(), issueKey, timeSpent, startDate, comment, groupLevel, roleLevelId);
    }

    public RemoteWorklog addWorklogWithNewRemainingEstimate(String issueKey, String timeSpent, String startDate, String newRemainingEstimate, String comment, String groupLevel, String roleLevelId) {
        return this.config.getClient().addWorklogWithNewRemainingEstimate(this.config.getToken(), issueKey, timeSpent, startDate, newRemainingEstimate, comment, groupLevel, roleLevelId);
    }

    public RemoteWorklog addWorklogAndRetainRemainingEstimate(String issueKey, String timeSpent, String startDate, String comment, String groupLevel, String roleLevelId) {
        return this.config.getClient().addWorklogAndRetainRemainingEstimate(this.config.getToken(), issueKey, timeSpent, startDate, comment, groupLevel, roleLevelId);
    }

    public List<Object> getSecuritySchemes() {
        return this.config.getClient().getSecuritySchemes(this.config.getToken());
    }
}

