/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jira;

import java.util.List;
import org.mule.api.ConnectionException;
import org.mule.module.jira.JiraClientAdaptor;
import org.mule.module.jira.JiraClientFactory;
import org.mule.module.jira.api.JiraClient;

public class Config {
    private Boolean useCustomFieldsExternalName;
    private JiraClient<List<Object>> client;
    private String token;
    private String connectionUser;
    private String connectionAddress;

    public void connect(String connectionUser, String connectionPassword, String connectionAddress) throws ConnectionException {
        this.connectionUser = connectionUser;
        this.connectionAddress = connectionAddress;
        this.client = JiraClientAdaptor.adapt(JiraClientFactory.getClient(connectionAddress));
        this.token = this.client.login(connectionUser, connectionPassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        try {
            if (this.token != null) {
                this.client.logout(this.token);
            }
        }
        finally {
            this.token = null;
            this.client = null;
        }
    }

    public boolean validateConnection() {
        return this.token != null;
    }

    public String toString() {
        return String.format("{username='%s', address='%s'}", this.connectionUser, this.connectionAddress);
    }

    public JiraClient<List<Object>> getClient() {
        return this.client;
    }

    public String getConnectionUser() {
        return this.connectionUser;
    }

    public void setConnectionUser(String connectionUser) {
        this.connectionUser = connectionUser;
    }

    public String getConnectionAddress() {
        return this.connectionAddress;
    }

    public void setConnectionAddress(String connectionAddress) {
        this.connectionAddress = connectionAddress;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Boolean getUseCustomFieldsExternalName() {
        return this.useCustomFieldsExternalName;
    }

    public void setUseCustomFieldsExternalName(Boolean useCustomFieldsExternalName) {
        this.useCustomFieldsExternalName = useCustomFieldsExternalName;
    }
}

