
package org.mule.module.jira.processors;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.jira.JiraConnector;
import org.mule.module.jira.JiraConnectorException;
import org.mule.module.jira.connectivity.JiraConnectorConnectionManager;
import org.mule.module.jira.process.ProcessAdapter;
import org.mule.module.jira.process.ProcessCallback;
import org.mule.module.jira.process.ProcessTemplate;


/**
 * CreateUserMessageProcessor invokes the {@link org.mule.module.jira.JiraConnector#createUser(java.lang.String, java.lang.String, java.lang.String, java.lang.String)} method in {@link JiraConnector }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.4.0", date = "2014-01-17T11:35:48-03:00", comments = "Build 3.4.0.1555.8df15c1")
public class CreateUserMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Initialisable, Startable, Stoppable, MessageProcessor
{

    protected Object username;
    protected String _usernameType;
    protected Object password;
    protected String _passwordType;
    protected Object fullName;
    protected String _fullNameType;
    protected Object email;
    protected String _emailType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets username
     * 
     * @param value Value to set
     */
    public void setUsername(Object value) {
        this.username = value;
    }

    /**
     * Sets email
     * 
     * @param value Value to set
     */
    public void setEmail(Object value) {
        this.email = value;
    }

    /**
     * Sets fullName
     * 
     * @param value Value to set
     */
    public void setFullName(Object value) {
        this.fullName = value;
    }

    /**
     * Sets password
     * 
     * @param value Value to set
     */
    public void setPassword(Object value) {
        this.password = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(JiraConnectorConnectionManager.class, true, event);
            final String _transformedUsername = ((String) evaluateAndTransform(getMuleContext(), event, CreateUserMessageProcessor.class.getDeclaredField("_usernameType").getGenericType(), null, username));
            final String _transformedPassword = ((String) evaluateAndTransform(getMuleContext(), event, CreateUserMessageProcessor.class.getDeclaredField("_passwordType").getGenericType(), null, password));
            final String _transformedFullName = ((String) evaluateAndTransform(getMuleContext(), event, CreateUserMessageProcessor.class.getDeclaredField("_fullNameType").getGenericType(), null, fullName));
            final String _transformedEmail = ((String) evaluateAndTransform(getMuleContext(), event, CreateUserMessageProcessor.class.getDeclaredField("_emailType").getGenericType(), null, email));
            Object resultPayload;
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return Arrays.asList(new Class[] {JiraConnectorException.class });
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((JiraConnector) object).createUser(_transformedUsername, _transformedPassword, _transformedFullName, _transformedEmail);
                }

            }
            , this, event);
            overwritePayload(event, resultPayload);
            return event;
        } catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("createUser"), event, e);
        }
    }

}
