
package org.mule.module.jira.processors;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Generated;
import com.atlassian.jira.rest.client.api.domain.Issue;
import org.joda.time.DateTime;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.jira.JiraConnector;
import org.mule.module.jira.api.rest.JiraClientAuthenticationException;
import org.mule.module.jira.connectivity.JiraConnectorConnectionManager;
import org.mule.module.jira.process.ProcessAdapter;
import org.mule.module.jira.process.ProcessCallback;
import org.mule.module.jira.process.ProcessTemplate;


/**
 * AddEffortMessageProcessor invokes the {@link org.mule.module.jira.JiraConnector#addEffort(com.atlassian.jira.rest.client.api.domain.Issue, java.lang.String, org.joda.time.DateTime, int, java.lang.String)} method in {@link JiraConnector }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.4.0", date = "2014-01-17T11:35:48-03:00", comments = "Build 3.4.0.1555.8df15c1")
public class AddEffortMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Initialisable, Startable, Stoppable, MessageProcessor
{

    protected Object issue;
    protected Issue _issueType;
    protected Object authorUri;
    protected String _authorUriType;
    protected Object date;
    protected DateTime _dateType;
    protected Object minutes;
    protected int _minutesType;
    protected Object comment;
    protected String _commentType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets minutes
     * 
     * @param value Value to set
     */
    public void setMinutes(Object value) {
        this.minutes = value;
    }

    /**
     * Sets issue
     * 
     * @param value Value to set
     */
    public void setIssue(Object value) {
        this.issue = value;
    }

    /**
     * Sets comment
     * 
     * @param value Value to set
     */
    public void setComment(Object value) {
        this.comment = value;
    }

    /**
     * Sets date
     * 
     * @param value Value to set
     */
    public void setDate(Object value) {
        this.date = value;
    }

    /**
     * Sets authorUri
     * 
     * @param value Value to set
     */
    public void setAuthorUri(Object value) {
        this.authorUri = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(JiraConnectorConnectionManager.class, true, event);
            final Issue _transformedIssue = ((Issue) evaluateAndTransform(getMuleContext(), event, AddEffortMessageProcessor.class.getDeclaredField("_issueType").getGenericType(), null, issue));
            final String _transformedAuthorUri = ((String) evaluateAndTransform(getMuleContext(), event, AddEffortMessageProcessor.class.getDeclaredField("_authorUriType").getGenericType(), null, authorUri));
            final DateTime _transformedDate = ((DateTime) evaluateAndTransform(getMuleContext(), event, AddEffortMessageProcessor.class.getDeclaredField("_dateType").getGenericType(), null, date));
            final Integer _transformedMinutes = ((Integer) evaluateAndTransform(getMuleContext(), event, AddEffortMessageProcessor.class.getDeclaredField("_minutesType").getGenericType(), null, minutes));
            final String _transformedComment = ((String) evaluateAndTransform(getMuleContext(), event, AddEffortMessageProcessor.class.getDeclaredField("_commentType").getGenericType(), null, comment));
            Object resultPayload;
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return Arrays.asList(new Class[] {JiraClientAuthenticationException.class });
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((JiraConnector) object).addEffort(_transformedIssue, _transformedAuthorUri, _transformedDate, _transformedMinutes, _transformedComment);
                }

            }
            , this, event);
            overwritePayload(event, resultPayload);
            return event;
        } catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("addEffort"), event, e);
        }
    }

}
