/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jira;

import com.atlassian.jira.rpc.soap.beans.RemoteAvatar;
import com.atlassian.jira.rpc.soap.beans.RemoteComment;
import com.atlassian.jira.rpc.soap.beans.RemoteConfiguration;
import com.atlassian.jira.rpc.soap.beans.RemoteCustomFieldValue;
import com.atlassian.jira.rpc.soap.beans.RemoteField;
import com.atlassian.jira.rpc.soap.beans.RemoteGroup;
import com.atlassian.jira.rpc.soap.beans.RemoteIssue;
import com.atlassian.jira.rpc.soap.beans.RemotePermissionScheme;
import com.atlassian.jira.rpc.soap.beans.RemoteProject;
import com.atlassian.jira.rpc.soap.beans.RemoteProjectRole;
import com.atlassian.jira.rpc.soap.beans.RemoteProjectRoleActors;
import com.atlassian.jira.rpc.soap.beans.RemoteRoleActors;
import com.atlassian.jira.rpc.soap.beans.RemoteSecurityLevel;
import com.atlassian.jira.rpc.soap.beans.RemoteServerInfo;
import com.atlassian.jira.rpc.soap.beans.RemoteUser;
import com.atlassian.jira.rpc.soap.beans.RemoteVersion;
import com.atlassian.jira.rpc.soap.beans.RemoteWorklog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.mule.api.ConnectionException;
import org.mule.module.jira.JiraClientAdaptor;
import org.mule.module.jira.JiraClientFactory;
import org.mule.module.jira.JiraConnectorException;
import org.mule.module.jira.api.JiraClient;

public class JiraConnector {
    private JiraClient<List<Object>> client;
    private String token;
    private String connectionUser;
    private String connectionAddress;
    private Boolean useCustomFieldsExternalName;
    private static final String MULTIVALUED_FIELD_SEPARATOR = "\\|";
    private Map<String, String> customFieldsNamesToIdsMapping = null;
    private Calendar customFieldsCacheExpiration = null;

    private Map<String, String> getCustomFieldsNamesToIdsMapping() {
        if (this.customFieldsNamesToIdsMapping == null || new GregorianCalendar().after(this.customFieldsCacheExpiration)) {
            this.customFieldsNamesToIdsMapping = new HashMap<String, String>();
            List<Object> customFields = this.client.getCustomFields(this.token);
            for (Object customField : customFields) {
                RemoteField remoteField = (RemoteField)customField;
                this.customFieldsNamesToIdsMapping.put(remoteField.getName(), remoteField.getId());
            }
            this.customFieldsCacheExpiration = new GregorianCalendar();
            this.customFieldsCacheExpiration.add(11, 1);
        }
        return this.customFieldsNamesToIdsMapping;
    }

    private Map<String, List<String>> convertFieldsToMultivaluedAndMapNamesToIds(Map<String, String> fields) {
        HashMap<String, List<String>> multivaluedFields = new HashMap<String, List<String>>();
        if (fields != null) {
            for (Map.Entry<String, String> field : fields.entrySet()) {
                String value;
                Map<String, String> customFields;
                String id;
                String fieldKey = field.getKey();
                if (this.useCustomFieldsExternalName.booleanValue() && (id = (customFields = this.getCustomFieldsNamesToIdsMapping()).get(fieldKey)) != null) {
                    fieldKey = id;
                }
                if ((value = field.getValue()) == null) {
                    value = "";
                }
                multivaluedFields.put(fieldKey, Arrays.asList(value.split(MULTIVALUED_FIELD_SEPARATOR)));
            }
        }
        return multivaluedFields;
    }

    private void mapCustomFieldsFromNamesToIds(RemoteIssue issue) {
        if (issue.getCustomFieldValues() != null && this.useCustomFieldsExternalName.booleanValue()) {
            Map<String, String> customFields = this.getCustomFieldsNamesToIdsMapping();
            for (RemoteCustomFieldValue field : issue.getCustomFieldValues()) {
                if (field.getCustomfieldId().startsWith("customfield_") || !customFields.containsKey(field.getCustomfieldId())) continue;
                field.setCustomfieldId(customFields.get(field.getCustomfieldId()));
            }
        }
    }

    public RemoteComment getComment(Long commentId) {
        return this.client.getComment(this.token, commentId);
    }

    public RemoteConfiguration getConfiguration() {
        return this.client.getConfiguration(this.token);
    }

    public RemoteGroup createGroup(String groupName, String userName) {
        return this.client.createGroup(this.token, groupName, userName);
    }

    public RemoteServerInfo getServerInfo() {
        return this.client.getServerInfo(this.token);
    }

    public RemoteGroup getGroup(String groupName) {
        return this.client.getGroup(this.token, groupName);
    }

    public RemoteUser createUser(String username, String password, String fullName, String email) {
        return this.client.createUser(this.token, username, password, fullName, email);
    }

    public RemoteComment addComment(String issueKey, String commentAuthor, String commentBody, String commentGroupLevel, String commentRoleLevel) {
        return this.client.addComment(this.token, issueKey, commentAuthor, commentBody, commentGroupLevel, commentRoleLevel);
    }

    public List<Object> getComponents(String projectKey) {
        return this.client.getComponents(this.token, projectKey);
    }

    public RemoteUser getUser(String username) {
        return this.client.getUser(this.token, username);
    }

    public RemoteGroup updateGroup(String groupName, List<String> usernames) {
        return this.client.updateGroup(this.token, groupName, usernames);
    }

    public void addUserToGroup(String groupName, String userName) {
        this.client.addUserToGroup(this.token, groupName, userName);
    }

    public void removeUserFromGroup(String groupName, String userName) {
        this.client.removeUserFromGroup(this.token, groupName, userName);
    }

    public RemoteIssue getIssue(String issueKey) {
        return this.client.getIssue(this.token, issueKey);
    }

    public RemoteIssue createIssue(String assignee, String summary, String description, String dueDate, String environment, String priority, String project, String reporter, String type, Long votes, Map<String, String> customFields, String componentName, String componentId) {
        Map<String, List<String>> multivaluedFields = this.convertFieldsToMultivaluedAndMapNamesToIds(customFields);
        return this.client.createIssue(this.token, assignee, summary, description, dueDate, environment, priority, project, reporter, type, votes, multivaluedFields, componentName, componentId);
    }

    public RemoteIssue createIssueUsingObject(RemoteIssue issue) {
        this.mapCustomFieldsFromNamesToIds(issue);
        return this.client.createIssue(this.token, issue);
    }

    public RemoteIssue createIssueWithSecurityLevel(String assignee, String summary, String description, String dueDate, String environment, String priority, String project, String reporter, String type, Long votes, Map<String, String> customFields, Long securityLevelId, String componentName, String componentId) {
        Map<String, List<String>> multivaluedFields = this.convertFieldsToMultivaluedAndMapNamesToIds(customFields);
        return this.client.createIssueWithSecurityLevel(this.token, assignee, summary, description, dueDate, environment, priority, project, reporter, type, votes, multivaluedFields, securityLevelId, componentName, componentId);
    }

    public RemoteIssue updateIssue(String issueKey, Map<String, String> fields) {
        Map<String, List<String>> multivaluedFields = this.convertFieldsToMultivaluedAndMapNamesToIds(fields);
        return this.client.updateIssue(this.token, issueKey, multivaluedFields);
    }

    public List<RemoteIssue> updateIssuesByJql(String jql, Map<String, String> fields, Integer maxRecordsToUpdate) {
        List<Object> issuesToUpdate = this.client.getIssuesFromJqlSearch(this.token, jql, 10000);
        if (issuesToUpdate != null && maxRecordsToUpdate != null && issuesToUpdate.size() > maxRecordsToUpdate) {
            throw new JiraConnectorException("Couldn't execute update-issues-by-jql. The number of issues found by the jql query (" + issuesToUpdate.size() + ") was greater than the maxRecordsToUpdate given (" + maxRecordsToUpdate + ")");
        }
        if (CollectionUtils.isNotEmpty(issuesToUpdate)) {
            ArrayList<RemoteIssue> result = new ArrayList<RemoteIssue>();
            Map<String, List<String>> multivaluedFields = this.convertFieldsToMultivaluedAndMapNamesToIds(fields);
            for (Object issue : issuesToUpdate) {
                RemoteIssue updatedIssue = this.client.updateIssue(this.token, ((RemoteIssue)issue).getKey(), multivaluedFields);
                result.add(updatedIssue);
            }
            return result;
        }
        throw new JiraConnectorException("Can't execute update. The jql search returned no issues");
    }

    public void deleteIssue(String issueKey) {
        this.client.deleteIssue(this.token, issueKey);
    }

    public List<Object> getAvailableActions(String issueKey) {
        return this.client.getAvailableActions(this.token, issueKey);
    }

    public List<Object> getSubTaskIssueTypes() {
        return this.client.getSubTaskIssueTypes(this.token);
    }

    public RemoteProject createProject(String key, String projectName, String description, String url, String lead, String permissionSchemeName, String notificationSchemeName, String securityShemeName) {
        return this.client.createProject(this.token, key, projectName, description, url, lead, permissionSchemeName, notificationSchemeName, securityShemeName);
    }

    public RemoteProject createProjectUsingObject(RemoteProject project) {
        return this.client.createProject(this.token, project);
    }

    public RemoteProject updateProject(String key, String description, String url, String lead, String permissionSchemeName, String notificationSchemeName, String securityShemeName) {
        return this.client.updateProject(this.token, key, description, url, lead, permissionSchemeName, notificationSchemeName, securityShemeName);
    }

    public RemoteProject getProjectByKey(String projectKey) {
        return this.client.getProjectByKey(this.token, projectKey);
    }

    public void removeAllRoleActorsByProject(String projectKey) {
        this.client.removeAllRoleActorsByProject(this.token, projectKey);
    }

    public List<Object> getPriorities() {
        return this.client.getPriorities(this.token);
    }

    public List<Object> getResolutions() {
        return this.client.getResolutions(this.token);
    }

    public List<Object> getIssueTypes() {
        return this.client.getIssueTypes(this.token);
    }

    public List<Object> getStatuses() {
        return this.client.getStatuses(this.token);
    }

    public List<Object> getIssueTypesForProject(String projectId) {
        return this.client.getIssueTypesForProject(this.token, projectId);
    }

    public List<Object> getProjectRoles() {
        return this.client.getProjectRoles(this.token);
    }

    public RemoteProjectRole getProjectRole(Long projectRoleId) {
        return this.client.getProjectRole(this.token, projectRoleId);
    }

    public RemoteProjectRoleActors getProjectRoleActors(Long projectRoleId, String projectKey) {
        return this.client.getProjectRoleActors(this.token, projectRoleId, projectKey);
    }

    public RemoteRoleActors getDefaultRoleActors(Long projectRoleId) {
        return this.client.getDefaultRoleActors(this.token, projectRoleId);
    }

    public void removeAllRoleActorsByNameAndType(String roleName, String type) {
        this.client.removeAllRoleActorsByNameAndType(this.token, roleName, type);
    }

    public void deleteProjectRole(Long projectRoleId, Boolean confirm) {
        this.client.deleteProjectRole(this.token, projectRoleId, confirm);
    }

    public void updateProjectRole(Long projectRoleId, String projectRoleName, String projectRoleDescription) {
        this.client.updateProjectRole(this.token, projectRoleId, projectRoleName, projectRoleDescription);
    }

    public RemoteProjectRole createProjectRole(String projectRoleName, String projectRoleDescription) {
        return this.client.createProjectRole(this.token, projectRoleName, projectRoleDescription);
    }

    public boolean isProjectRoleNameUnique(String roleName) {
        return this.client.isProjectRoleNameUnique(this.token, roleName);
    }

    public void releaseVersion(String projectKey, String versionName) {
        this.client.releaseVersion(this.token, projectKey, versionName);
    }

    public void addActorsToProjectRole(List<String> actors, Long projectRoleId, String projectKey, String actorType) {
        this.client.addActorsToProjectRole(this.token, actors, projectRoleId, projectKey, actorType);
    }

    public void removeActorsFromProjectRole(List<String> actors, Long projectRoleId, String projectKey, String actorType) {
        this.client.removeActorsFromProjectRole(this.token, actors, projectRoleId, projectKey, actorType);
    }

    public void addDefaultActorsToProjectRole(List<String> actors, Long projectRoleId, String type) {
        this.client.addDefaultActorsToProjectRole(this.token, actors, projectRoleId, type);
    }

    public void removeDefaultActorsFromProjectRole(List<String> actors, Long remoteProjectRoleId, String type) {
        this.client.removeDefaultActorsFromProjectRole(this.token, actors, remoteProjectRoleId, type);
    }

    public List<Object> getAssociatedNotificationSchemes(Long projectRoleId) {
        return this.client.getAssociatedNotificationSchemes(this.token, projectRoleId);
    }

    public List<Object> getAssociatedPermissionSchemes(Long projectRoleId) {
        return this.client.getAssociatedPermissionSchemes(this.token, projectRoleId);
    }

    public void deleteProject(String projectKey) {
        this.client.deleteProject(this.token, projectKey);
    }

    public RemoteProject getProjectById(Long projectId) {
        return this.client.getProjectById(this.token, projectId);
    }

    public List<Object> getVersions(String projectKey) {
        return this.client.getVersions(this.token, projectKey);
    }

    public List<Object> getComments(String issueKey) {
        return this.client.getComments(this.token, issueKey);
    }

    public List<Object> getFavouriteFilters() {
        return this.client.getFavouriteFilters(this.token);
    }

    public void archiveVersion(String projectKey, String versionName, Boolean archive) {
        this.client.archiveVersion(this.token, projectKey, versionName, archive);
    }

    public List<Object> getFieldsForEdit(String issueKey) {
        return this.client.getFieldsForEdit(this.token, issueKey);
    }

    public List<Object> getSubTaskIssueTypesForProject(String projectId) {
        return this.client.getSubTaskIssueTypesForProject(this.token, projectId);
    }

    public String login(String username, String password) {
        return this.client.login(username, password);
    }

    public RemoteSecurityLevel getSecurityLevel(String issueKey) {
        return this.client.getSecurityLevel(this.token, issueKey);
    }

    public List<Object> getCustomFields() {
        return this.client.getCustomFields(this.token);
    }

    public boolean logout(String token) {
        return this.client.logout(token);
    }

    public RemoteProject getProjectWithSchemesById(Long projectId) {
        return this.client.getProjectWithSchemesById(this.token, projectId);
    }

    public List<Object> getSecurityLevels(String projectKey) {
        return this.client.getSecurityLevels(this.token, projectKey);
    }

    public List<Object> getProjectAvatars(String projectKey, Boolean includeSystemAvatars) {
        return this.client.getProjectAvatars(this.token, projectKey, includeSystemAvatars);
    }

    public void setProjectAvatar(String projectKey, Long avatarId) {
        this.client.setProjectAvatar(this.token, projectKey, avatarId);
    }

    public RemoteAvatar getProjectAvatar(String projectKey) {
        return this.client.getProjectAvatar(this.token, projectKey);
    }

    public void deleteProjectAvatar(Long avatarId) {
        this.client.deleteProjectAvatar(this.token, avatarId);
    }

    public List<Object> getNotificationSchemes() {
        return this.client.getNotificationSchemes(this.token);
    }

    public List<Object> getPermissionSchemes() {
        return this.client.getPermissionSchemes(this.token);
    }

    public List<Object> getAllPermissions() {
        return this.client.getAllPermissions(this.token);
    }

    public RemotePermissionScheme createPermissionScheme(String permissionName, String description) {
        return this.client.createPermissionScheme(this.token, permissionName, description);
    }

    public RemotePermissionScheme addPermissionTo(String permissionSchemeName, Long permissionCode, String entityName) {
        return this.client.addPermissionTo(this.token, permissionSchemeName, permissionCode, entityName);
    }

    public RemotePermissionScheme deletePermissionFrom(String permissionSchemeName, Long permissionCode, String entityName) {
        return this.client.deletePermissionFrom(this.token, permissionSchemeName, permissionCode, entityName);
    }

    public void deletePermissionScheme(String permissionSchemeName) {
        this.client.deletePermissionScheme(this.token, permissionSchemeName);
    }

    public List<Object> getAttachmentsFromIssue(String issueKey) {
        return this.client.getAttachmentsFromIssue(this.token, issueKey);
    }

    public boolean hasPermissionToEditComment(Long commentId) {
        return this.client.hasPermissionToEditComment(this.token, commentId);
    }

    public RemoteComment editComment(Long commentId, String body, String updateAuthor) {
        return this.client.editComment(this.token, commentId, body, updateAuthor);
    }

    public List<Object> getFieldsForAction(String issueKey, String actionIdString) {
        return this.client.getFieldsForAction(this.token, issueKey, actionIdString);
    }

    public RemoteIssue getIssueById(String issueId) {
        return this.client.getIssueById(this.token, issueId);
    }

    public void deleteWorklogWithNewRemainingEstimate(String workLogId, String newRemainingEstimate) {
        this.client.deleteWorklogWithNewRemainingEstimate(this.token, workLogId, newRemainingEstimate);
    }

    public void deleteWorklogAndAutoAdjustRemainingEstimate(String worklogId) {
        this.client.deleteWorklogAndAutoAdjustRemainingEstimate(this.token, worklogId);
    }

    public void deleteWorklogAndRetainRemainingEstimate(String worklogId) {
        this.client.deleteWorklogAndRetainRemainingEstimate(this.token, worklogId);
    }

    public List<Object> getWorklogs(String issueKey) {
        return this.client.getWorklogs(this.token, issueKey);
    }

    public boolean hasPermissionToCreateWorklog(String issueKey) {
        return this.client.hasPermissionToCreateWorklog(this.token, issueKey);
    }

    public boolean hasPermissionToDeleteWorklog(String worklogId) {
        return this.client.hasPermissionToDeleteWorklog(this.token, worklogId);
    }

    public boolean hasPermissionToUpdateWorklog(String worklogId) {
        return this.client.hasPermissionToUpdateWorklog(this.token, worklogId);
    }

    public void updateWorklogWithNewRemainingEstimate(String issueKey, String worklogId, String newRemainingEstimate, String comment, String groupLevel, String roleLevelId) {
        this.client.updateWorklogWithNewRemainingEstimate(this.token, issueKey, worklogId, comment, groupLevel, roleLevelId, newRemainingEstimate);
    }

    public RemoteVersion addVersion(String projectKey, String versionName, Boolean archived, Boolean released, String releaseDate) {
        return this.client.addVersion(this.token, projectKey, versionName, archived, released, releaseDate);
    }

    public Calendar getResolutionDateByKey(String issueKey) {
        return this.client.getResolutionDateByKey(this.token, issueKey);
    }

    public Calendar getResolutionDateById(Long issueId) {
        return this.client.getResolutionDateById(this.token, issueId);
    }

    public long getIssueCountForFilter(String filterId) {
        return this.client.getIssueCountForFilter(this.token, filterId);
    }

    public List<Object> getIssuesFromTextSearchWithProject(List<String> projectKeys, String searchTerms, Integer maxNumResults) {
        return this.client.getIssuesFromTextSearchWithProject(this.token, projectKeys, searchTerms, maxNumResults);
    }

    public List<Object> getIssuesFromJqlSearch(String jqlSearch, Integer maxNumResults) {
        return this.client.getIssuesFromJqlSearch(this.token, jqlSearch, maxNumResults);
    }

    public void deleteUser(String username) {
        this.client.deleteUser(this.token, username);
    }

    public void deleteGroup(String groupName, String swapGroupName) {
        this.client.deleteGroup(this.token, groupName, swapGroupName);
    }

    public void refreshCustomFields() {
        this.client.refreshCustomFields(this.token);
    }

    public boolean addBase64EncodedAttachmentsToIssue(String issueKey, List<String> fileNames, List<String> base64EncodedAttachmentData) {
        return this.client.addBase64EncodedAttachmentsToIssue(this.token, issueKey, fileNames, base64EncodedAttachmentData);
    }

    public List<Object> getIssuesFromFilterWithLimit(String filterId, Integer offset, Integer maxNumResults) {
        return this.client.getIssuesFromFilterWithLimit(this.token, filterId, offset, maxNumResults);
    }

    public List<Object> getIssuesFromTextSearchWithLimit(String searchTerms, Integer offset, Integer maxNumResults) {
        return this.client.getIssuesFromTextSearchWithLimit(this.token, searchTerms, offset, maxNumResults);
    }

    public List<Object> getProjectsNoSchemes() {
        return this.client.getProjectsNoSchemes(this.token);
    }

    public void setNewProjectAvatar(String projectKey, String contentType, String base64ImageData) {
        this.client.setNewProjectAvatar(this.token, projectKey, contentType, base64ImageData);
    }

    public RemoteIssue progressWorkflowAction(String issueKey, String actionIdString, Map<String, String> fields) {
        Map<String, List<String>> multivaluedFields = this.convertFieldsToMultivaluedAndMapNamesToIds(fields);
        return this.client.progressWorkflowAction(this.token, issueKey, actionIdString, multivaluedFields);
    }

    public RemoteWorklog addWorklogAndAutoAdjustRemainingEstimate(String issueKey, String timeSpent, String startDate, String comment, String groupLevel, String roleLevelId) {
        return this.client.addWorklogAndAutoAdjustRemainingEstimate(this.token, issueKey, timeSpent, startDate, comment, groupLevel, roleLevelId);
    }

    public RemoteWorklog addWorklogWithNewRemainingEstimate(String issueKey, String timeSpent, String startDate, String newRemainingEstimate, String comment, String groupLevel, String roleLevelId) {
        return this.client.addWorklogWithNewRemainingEstimate(this.token, issueKey, timeSpent, startDate, newRemainingEstimate, comment, groupLevel, roleLevelId);
    }

    public RemoteWorklog addWorklogAndRetainRemainingEstimate(String issueKey, String timeSpent, String startDate, String comment, String groupLevel, String roleLevelId) {
        return this.client.addWorklogAndRetainRemainingEstimate(this.token, issueKey, timeSpent, startDate, comment, groupLevel, roleLevelId);
    }

    public List<Object> getSecuritySchemes() {
        return this.client.getSecuritySchemes(this.token);
    }

    public void setClient(JiraClient<?> client) {
        this.client = JiraClientAdaptor.adapt(client);
    }

    public String getConnectionUser() {
        return this.connectionUser;
    }

    public void setConnectionUser(String connectionUser) {
        this.connectionUser = connectionUser;
    }

    public String getConnectionAddress() {
        return this.connectionAddress;
    }

    public void setConnectionAddress(String connectionAddress) {
        this.connectionAddress = connectionAddress;
    }

    public Boolean getUseCustomFieldsExternalName() {
        return this.useCustomFieldsExternalName;
    }

    public void setUseCustomFieldsExternalName(Boolean useCustomFieldsExternalName) {
        this.useCustomFieldsExternalName = useCustomFieldsExternalName;
    }

    public void connect(String connectionUser, String connectionPassword, String connectionAddress) throws ConnectionException {
        this.connectionUser = connectionUser;
        this.connectionAddress = connectionAddress;
        this.setClient(JiraClientFactory.getClient(connectionAddress));
        this.token = this.login(connectionUser, connectionPassword);
    }

    public void disconnect() {
        if (this.token != null) {
            String oldToken = this.token;
            this.token = null;
            this.logout(oldToken);
            this.client = null;
        }
    }

    public boolean validateConnection() {
        return this.token != null;
    }

    public String toString() {
        return "{username='" + this.connectionUser + "', address='" + this.connectionAddress + "'}";
    }
}

