
package org.mule.module.jira.processors;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.jira.JiraConnector;
import org.mule.module.jira.JiraConnectorException;
import org.mule.module.jira.connectivity.JiraConnectorConnectionManager;
import org.mule.module.jira.process.ProcessAdapter;
import org.mule.module.jira.process.ProcessCallback;
import org.mule.module.jira.process.ProcessTemplate;


/**
 * GetIssuesFromTextSearchWithProjectMessageProcessor invokes the {@link org.mule.module.jira.JiraConnector#getIssuesFromTextSearchWithProject(java.util.List, java.lang.String, java.lang.Integer)} method in {@link JiraConnector }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.4.0", date = "2013-06-12T02:35:53-03:00", comments = "Build 3.4.0.1555.8df15c1")
public class GetIssuesFromTextSearchWithProjectMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Initialisable, Startable, Stoppable, MessageProcessor
{

    protected Object projectKeys;
    protected List<String> _projectKeysType;
    protected Object searchTerms;
    protected String _searchTermsType;
    protected Object maxNumResults;
    protected Integer _maxNumResultsType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets searchTerms
     * 
     * @param value Value to set
     */
    public void setSearchTerms(Object value) {
        this.searchTerms = value;
    }

    /**
     * Sets projectKeys
     * 
     * @param value Value to set
     */
    public void setProjectKeys(Object value) {
        this.projectKeys = value;
    }

    /**
     * Sets maxNumResults
     * 
     * @param value Value to set
     */
    public void setMaxNumResults(Object value) {
        this.maxNumResults = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(JiraConnectorConnectionManager.class, true, event);
            final List<String> _transformedProjectKeys = ((List<String> ) evaluateAndTransform(getMuleContext(), event, GetIssuesFromTextSearchWithProjectMessageProcessor.class.getDeclaredField("_projectKeysType").getGenericType(), null, projectKeys));
            final String _transformedSearchTerms = ((String) evaluateAndTransform(getMuleContext(), event, GetIssuesFromTextSearchWithProjectMessageProcessor.class.getDeclaredField("_searchTermsType").getGenericType(), null, searchTerms));
            final Integer _transformedMaxNumResults = ((Integer) evaluateAndTransform(getMuleContext(), event, GetIssuesFromTextSearchWithProjectMessageProcessor.class.getDeclaredField("_maxNumResultsType").getGenericType(), null, maxNumResults));
            Object resultPayload;
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return Arrays.asList(new Class[] {JiraConnectorException.class });
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((JiraConnector) object).getIssuesFromTextSearchWithProject(_transformedProjectKeys, _transformedSearchTerms, _transformedMaxNumResults);
                }

            }
            , this, event);
            overwritePayload(event, resultPayload);
            return event;
        } catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("getIssuesFromTextSearchWithProject"), event, e);
        }
    }

}
