
package org.mule.module.jira.processors;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.jira.JiraConnector;
import org.mule.module.jira.JiraConnectorException;
import org.mule.module.jira.connectivity.JiraConnectorConnectionManager;
import org.mule.module.jira.process.ProcessAdapter;
import org.mule.module.jira.process.ProcessCallback;
import org.mule.module.jira.process.ProcessTemplate;


/**
 * EditCommentMessageProcessor invokes the {@link org.mule.module.jira.JiraConnector#editComment(java.lang.Long, java.lang.String, java.lang.String)} method in {@link JiraConnector }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.4.0", date = "2013-06-12T02:35:53-03:00", comments = "Build 3.4.0.1555.8df15c1")
public class EditCommentMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Initialisable, Startable, Stoppable, MessageProcessor
{

    protected Object commentId;
    protected Long _commentIdType;
    protected Object body;
    protected String _bodyType;
    protected Object updateAuthor;
    protected String _updateAuthorType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets body
     * 
     * @param value Value to set
     */
    public void setBody(Object value) {
        this.body = value;
    }

    /**
     * Sets updateAuthor
     * 
     * @param value Value to set
     */
    public void setUpdateAuthor(Object value) {
        this.updateAuthor = value;
    }

    /**
     * Sets commentId
     * 
     * @param value Value to set
     */
    public void setCommentId(Object value) {
        this.commentId = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(JiraConnectorConnectionManager.class, true, event);
            final Long _transformedCommentId = ((Long) evaluateAndTransform(getMuleContext(), event, EditCommentMessageProcessor.class.getDeclaredField("_commentIdType").getGenericType(), null, commentId));
            final String _transformedBody = ((String) evaluateAndTransform(getMuleContext(), event, EditCommentMessageProcessor.class.getDeclaredField("_bodyType").getGenericType(), null, body));
            final String _transformedUpdateAuthor = ((String) evaluateAndTransform(getMuleContext(), event, EditCommentMessageProcessor.class.getDeclaredField("_updateAuthorType").getGenericType(), null, updateAuthor));
            Object resultPayload;
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return Arrays.asList(new Class[] {JiraConnectorException.class });
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((JiraConnector) object).editComment(_transformedCommentId, _transformedBody, _transformedUpdateAuthor);
                }

            }
            , this, event);
            overwritePayload(event, resultPayload);
            return event;
        } catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("editComment"), event, e);
        }
    }

}
