
package org.mule.module.jira.processors;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.jira.JiraConnector;
import org.mule.module.jira.JiraConnectorException;
import org.mule.module.jira.connectivity.JiraConnectorConnectionManager;
import org.mule.module.jira.process.ProcessAdapter;
import org.mule.module.jira.process.ProcessCallback;
import org.mule.module.jira.process.ProcessTemplate;


/**
 * CreateIssueMessageProcessor invokes the {@link org.mule.module.jira.JiraConnector#createIssue(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.Long, java.util.Map, java.lang.String, java.lang.String)} method in {@link JiraConnector }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.4.0", date = "2013-05-29T11:20:00-03:00", comments = "Build 3.4.0.1555.8df15c1")
public class CreateIssueMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Initialisable, Startable, Stoppable, MessageProcessor
{

    protected Object assignee;
    protected String _assigneeType;
    protected Object summary;
    protected String _summaryType;
    protected Object description;
    protected String _descriptionType;
    protected Object dueDate;
    protected String _dueDateType;
    protected Object environment;
    protected String _environmentType;
    protected Object priority;
    protected String _priorityType;
    protected Object project;
    protected String _projectType;
    protected Object reporter;
    protected String _reporterType;
    protected Object type;
    protected String _typeType;
    protected Object votes;
    protected Long _votesType;
    protected Object customFields;
    protected Map<String, String> _customFieldsType;
    protected Object componentName;
    protected String _componentNameType;
    protected Object componentId;
    protected String _componentIdType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets summary
     * 
     * @param value Value to set
     */
    public void setSummary(Object value) {
        this.summary = value;
    }

    /**
     * Sets customFields
     * 
     * @param value Value to set
     */
    public void setCustomFields(Object value) {
        this.customFields = value;
    }

    /**
     * Sets votes
     * 
     * @param value Value to set
     */
    public void setVotes(Object value) {
        this.votes = value;
    }

    /**
     * Sets assignee
     * 
     * @param value Value to set
     */
    public void setAssignee(Object value) {
        this.assignee = value;
    }

    /**
     * Sets type
     * 
     * @param value Value to set
     */
    public void setType(Object value) {
        this.type = value;
    }

    /**
     * Sets componentId
     * 
     * @param value Value to set
     */
    public void setComponentId(Object value) {
        this.componentId = value;
    }

    /**
     * Sets reporter
     * 
     * @param value Value to set
     */
    public void setReporter(Object value) {
        this.reporter = value;
    }

    /**
     * Sets project
     * 
     * @param value Value to set
     */
    public void setProject(Object value) {
        this.project = value;
    }

    /**
     * Sets environment
     * 
     * @param value Value to set
     */
    public void setEnvironment(Object value) {
        this.environment = value;
    }

    /**
     * Sets componentName
     * 
     * @param value Value to set
     */
    public void setComponentName(Object value) {
        this.componentName = value;
    }

    /**
     * Sets description
     * 
     * @param value Value to set
     */
    public void setDescription(Object value) {
        this.description = value;
    }

    /**
     * Sets priority
     * 
     * @param value Value to set
     */
    public void setPriority(Object value) {
        this.priority = value;
    }

    /**
     * Sets dueDate
     * 
     * @param value Value to set
     */
    public void setDueDate(Object value) {
        this.dueDate = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(JiraConnectorConnectionManager.class, true, event);
            final String _transformedAssignee = ((String) evaluateAndTransform(getMuleContext(), event, CreateIssueMessageProcessor.class.getDeclaredField("_assigneeType").getGenericType(), null, assignee));
            final String _transformedSummary = ((String) evaluateAndTransform(getMuleContext(), event, CreateIssueMessageProcessor.class.getDeclaredField("_summaryType").getGenericType(), null, summary));
            final String _transformedDescription = ((String) evaluateAndTransform(getMuleContext(), event, CreateIssueMessageProcessor.class.getDeclaredField("_descriptionType").getGenericType(), null, description));
            final String _transformedDueDate = ((String) evaluateAndTransform(getMuleContext(), event, CreateIssueMessageProcessor.class.getDeclaredField("_dueDateType").getGenericType(), null, dueDate));
            final String _transformedEnvironment = ((String) evaluateAndTransform(getMuleContext(), event, CreateIssueMessageProcessor.class.getDeclaredField("_environmentType").getGenericType(), null, environment));
            final String _transformedPriority = ((String) evaluateAndTransform(getMuleContext(), event, CreateIssueMessageProcessor.class.getDeclaredField("_priorityType").getGenericType(), null, priority));
            final String _transformedProject = ((String) evaluateAndTransform(getMuleContext(), event, CreateIssueMessageProcessor.class.getDeclaredField("_projectType").getGenericType(), null, project));
            final String _transformedReporter = ((String) evaluateAndTransform(getMuleContext(), event, CreateIssueMessageProcessor.class.getDeclaredField("_reporterType").getGenericType(), null, reporter));
            final String _transformedType = ((String) evaluateAndTransform(getMuleContext(), event, CreateIssueMessageProcessor.class.getDeclaredField("_typeType").getGenericType(), null, type));
            final Long _transformedVotes = ((Long) evaluateAndTransform(getMuleContext(), event, CreateIssueMessageProcessor.class.getDeclaredField("_votesType").getGenericType(), null, votes));
            final Map<String, String> _transformedCustomFields = ((Map<String, String> ) evaluateAndTransform(getMuleContext(), event, CreateIssueMessageProcessor.class.getDeclaredField("_customFieldsType").getGenericType(), null, customFields));
            final String _transformedComponentName = ((String) evaluateAndTransform(getMuleContext(), event, CreateIssueMessageProcessor.class.getDeclaredField("_componentNameType").getGenericType(), null, componentName));
            final String _transformedComponentId = ((String) evaluateAndTransform(getMuleContext(), event, CreateIssueMessageProcessor.class.getDeclaredField("_componentIdType").getGenericType(), null, componentId));
            Object resultPayload;
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return Arrays.asList(new Class[] {JiraConnectorException.class });
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((JiraConnector) object).createIssue(_transformedAssignee, _transformedSummary, _transformedDescription, _transformedDueDate, _transformedEnvironment, _transformedPriority, _transformedProject, _transformedReporter, _transformedType, _transformedVotes, _transformedCustomFields, _transformedComponentName, _transformedComponentId);
                }

            }
            , this, event);
            overwritePayload(event, resultPayload);
            return event;
        } catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("createIssue"), event, e);
        }
    }

}
