
package org.mule.module.jira.processors;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.process.ProcessAdapter;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessTemplate;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.jira.JiraConnector;
import org.mule.module.jira.JiraConnectorException;
import org.mule.module.jira.connectivity.JiraConnectorConnectionManager;


/**
 * UpdateIssuesByJqlMessageProcessor invokes the {@link org.mule.module.jira.JiraConnector#updateIssuesByJql(java.lang.String, java.util.Map, java.lang.Integer)} method in {@link JiraConnector }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.3.2", date = "2013-02-15T01:44:44-03:00", comments = "Build UNNAMED.1372.db235f3")
public class UpdateIssuesByJqlMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Initialisable, Startable, Stoppable, MessageProcessor
{

    protected Object jql;
    protected String _jqlType;
    protected Object fields;
    protected Map<String, String> _fieldsType;
    protected Object maxRecordsToUpdate;
    protected Integer _maxRecordsToUpdateType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets maxRecordsToUpdate
     * 
     * @param value Value to set
     */
    public void setMaxRecordsToUpdate(Object value) {
        this.maxRecordsToUpdate = value;
    }

    /**
     * Sets jql
     * 
     * @param value Value to set
     */
    public void setJql(Object value) {
        this.jql = value;
    }

    /**
     * Sets fields
     * 
     * @param value Value to set
     */
    public void setFields(Object value) {
        this.fields = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(JiraConnectorConnectionManager.class, true, event);
            final String _transformedJql = ((String) evaluateAndTransform(getMuleContext(), event, UpdateIssuesByJqlMessageProcessor.class.getDeclaredField("_jqlType").getGenericType(), null, jql));
            final Map<String, String> _transformedFields = ((Map<String, String> ) evaluateAndTransform(getMuleContext(), event, UpdateIssuesByJqlMessageProcessor.class.getDeclaredField("_fieldsType").getGenericType(), null, fields));
            final Integer _transformedMaxRecordsToUpdate = ((Integer) evaluateAndTransform(getMuleContext(), event, UpdateIssuesByJqlMessageProcessor.class.getDeclaredField("_maxRecordsToUpdateType").getGenericType(), null, maxRecordsToUpdate));
            Object resultPayload;
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return Arrays.asList(new Class[] {JiraConnectorException.class });
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((JiraConnector) object).updateIssuesByJql(_transformedJql, _transformedFields, _transformedMaxRecordsToUpdate);
                }

            }
            , this, event);
            overwritePayload(event, resultPayload);
            return event;
        } catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("updateIssuesByJql"), event, e);
        }
    }

}
