
package org.mule.module.jira.processors;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.process.ProcessAdapter;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessTemplate;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.jira.JiraConnector;
import org.mule.module.jira.JiraConnectorException;
import org.mule.module.jira.connectivity.JiraConnectorConnectionManager;


/**
 * AddWorklogAndAutoAdjustRemainingEstimateMessageProcessor invokes the {@link org.mule.module.jira.JiraConnector#addWorklogAndAutoAdjustRemainingEstimate(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)} method in {@link JiraConnector }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.3.2", date = "2013-02-15T01:44:44-03:00", comments = "Build UNNAMED.1372.db235f3")
public class AddWorklogAndAutoAdjustRemainingEstimateMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Initialisable, Startable, Stoppable, MessageProcessor
{

    protected Object issueKey;
    protected String _issueKeyType;
    protected Object timeSpent;
    protected String _timeSpentType;
    protected Object startDate;
    protected String _startDateType;
    protected Object comment;
    protected String _commentType;
    protected Object groupLevel;
    protected String _groupLevelType;
    protected Object roleLevelId;
    protected String _roleLevelIdType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets startDate
     * 
     * @param value Value to set
     */
    public void setStartDate(Object value) {
        this.startDate = value;
    }

    /**
     * Sets groupLevel
     * 
     * @param value Value to set
     */
    public void setGroupLevel(Object value) {
        this.groupLevel = value;
    }

    /**
     * Sets issueKey
     * 
     * @param value Value to set
     */
    public void setIssueKey(Object value) {
        this.issueKey = value;
    }

    /**
     * Sets roleLevelId
     * 
     * @param value Value to set
     */
    public void setRoleLevelId(Object value) {
        this.roleLevelId = value;
    }

    /**
     * Sets comment
     * 
     * @param value Value to set
     */
    public void setComment(Object value) {
        this.comment = value;
    }

    /**
     * Sets timeSpent
     * 
     * @param value Value to set
     */
    public void setTimeSpent(Object value) {
        this.timeSpent = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(JiraConnectorConnectionManager.class, true, event);
            final String _transformedIssueKey = ((String) evaluateAndTransform(getMuleContext(), event, AddWorklogAndAutoAdjustRemainingEstimateMessageProcessor.class.getDeclaredField("_issueKeyType").getGenericType(), null, issueKey));
            final String _transformedTimeSpent = ((String) evaluateAndTransform(getMuleContext(), event, AddWorklogAndAutoAdjustRemainingEstimateMessageProcessor.class.getDeclaredField("_timeSpentType").getGenericType(), null, timeSpent));
            final String _transformedStartDate = ((String) evaluateAndTransform(getMuleContext(), event, AddWorklogAndAutoAdjustRemainingEstimateMessageProcessor.class.getDeclaredField("_startDateType").getGenericType(), null, startDate));
            final String _transformedComment = ((String) evaluateAndTransform(getMuleContext(), event, AddWorklogAndAutoAdjustRemainingEstimateMessageProcessor.class.getDeclaredField("_commentType").getGenericType(), null, comment));
            final String _transformedGroupLevel = ((String) evaluateAndTransform(getMuleContext(), event, AddWorklogAndAutoAdjustRemainingEstimateMessageProcessor.class.getDeclaredField("_groupLevelType").getGenericType(), null, groupLevel));
            final String _transformedRoleLevelId = ((String) evaluateAndTransform(getMuleContext(), event, AddWorklogAndAutoAdjustRemainingEstimateMessageProcessor.class.getDeclaredField("_roleLevelIdType").getGenericType(), null, roleLevelId));
            Object resultPayload;
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return Arrays.asList(new Class[] {JiraConnectorException.class });
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((JiraConnector) object).addWorklogAndAutoAdjustRemainingEstimate(_transformedIssueKey, _transformedTimeSpent, _transformedStartDate, _transformedComment, _transformedGroupLevel, _transformedRoleLevelId);
                }

            }
            , this, event);
            overwritePayload(event, resultPayload);
            return event;
        } catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("addWorklogAndAutoAdjustRemainingEstimate"), event, e);
        }
    }

}
