/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jira.connectivity;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.mule.api.Capabilities;
import org.mule.api.Capability;
import org.mule.api.ConnectionManager;
import org.mule.api.MetadataAware;
import org.mule.api.MuleContext;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.process.ProcessAdapter;
import org.mule.api.process.ProcessTemplate;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.config.PoolingProfile;
import org.mule.module.jira.adapters.JiraConnectorConnectionIdentifierAdapter;
import org.mule.module.jira.connectivity.JiraConnectorConnectionFactory;
import org.mule.module.jira.connectivity.JiraConnectorConnectionKey;
import org.mule.module.jira.connectivity.ManagedConnectionProcessTemplate;

public class JiraConnectorConnectionManager
implements Capabilities,
ConnectionManager<JiraConnectorConnectionKey, JiraConnectorConnectionIdentifierAdapter>,
MetadataAware,
MuleContextAware,
Initialisable,
ProcessAdapter<JiraConnectorConnectionIdentifierAdapter> {
    private String connectionUser;
    private String connectionPassword;
    private String connectionAddress;
    private Boolean useCustomFieldsExternalName;
    protected MuleContext muleContext;
    protected FlowConstruct flowConstruct;
    private GenericKeyedObjectPool connectionPool;
    protected PoolingProfile connectionPoolingProfile;
    protected RetryPolicyTemplate retryPolicyTemplate;
    private static final String MODULE_NAME = "Jira";
    private static final String MODULE_VERSION = "2.3.1";
    private static final String DEVKIT_VERSION = "3.3.1";
    private static final String DEVKIT_BUILD = "UNNAMED.1297.150f2c9";

    public void setUseCustomFieldsExternalName(Boolean value) {
        this.useCustomFieldsExternalName = value;
    }

    public Boolean getUseCustomFieldsExternalName() {
        return this.useCustomFieldsExternalName;
    }

    public void setMuleContext(MuleContext value) {
        this.muleContext = value;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void setFlowConstruct(FlowConstruct value) {
        this.flowConstruct = value;
    }

    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    public void setConnectionPoolingProfile(PoolingProfile value) {
        this.connectionPoolingProfile = value;
    }

    public PoolingProfile getConnectionPoolingProfile() {
        return this.connectionPoolingProfile;
    }

    public void setRetryPolicyTemplate(RetryPolicyTemplate value) {
        this.retryPolicyTemplate = value;
    }

    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    public void setConnectionUser(String value) {
        this.connectionUser = value;
    }

    public String getConnectionUser() {
        return this.connectionUser;
    }

    public void setConnectionPassword(String value) {
        this.connectionPassword = value;
    }

    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    public void setConnectionAddress(String value) {
        this.connectionAddress = value;
    }

    public String getConnectionAddress() {
        return this.connectionAddress;
    }

    public void initialise() {
        GenericKeyedObjectPool.Config config = new GenericKeyedObjectPool.Config();
        if (this.connectionPoolingProfile != null) {
            config.maxIdle = this.connectionPoolingProfile.getMaxIdle();
            config.maxActive = this.connectionPoolingProfile.getMaxActive();
            config.maxWait = this.connectionPoolingProfile.getMaxWait();
            config.whenExhaustedAction = (byte)this.connectionPoolingProfile.getExhaustedAction();
        }
        this.connectionPool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)new JiraConnectorConnectionFactory(this), config);
        if (this.retryPolicyTemplate == null) {
            this.retryPolicyTemplate = (RetryPolicyTemplate)this.muleContext.getRegistry().lookupObject("_defaultRetryPolicyTemplate");
        }
    }

    public JiraConnectorConnectionIdentifierAdapter acquireConnection(JiraConnectorConnectionKey key) throws Exception {
        return (JiraConnectorConnectionIdentifierAdapter)this.connectionPool.borrowObject((Object)key);
    }

    public void releaseConnection(JiraConnectorConnectionKey key, JiraConnectorConnectionIdentifierAdapter connection) throws Exception {
        this.connectionPool.returnObject((Object)key, (Object)connection);
    }

    public void destroyConnection(JiraConnectorConnectionKey key, JiraConnectorConnectionIdentifierAdapter connection) throws Exception {
        this.connectionPool.invalidateObject((Object)key, (Object)connection);
    }

    public boolean isCapableOf(Capability capability) {
        if (capability == Capability.LIFECYCLE_CAPABLE) {
            return true;
        }
        return capability == Capability.CONNECTION_MANAGEMENT_CAPABLE;
    }

    public <P> ProcessTemplate<P, JiraConnectorConnectionIdentifierAdapter> getProcessTemplate() {
        return new ManagedConnectionProcessTemplate(this, this.muleContext);
    }

    public JiraConnectorConnectionKey getDefaultConnectionKey() {
        return new JiraConnectorConnectionKey(this.getConnectionUser(), this.getConnectionPassword(), this.getConnectionAddress());
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getModuleVersion() {
        return MODULE_VERSION;
    }

    public String getDevkitVersion() {
        return DEVKIT_VERSION;
    }

    public String getDevkitBuild() {
        return DEVKIT_BUILD;
    }
}

