/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jira.api;

import com.atlassian.jira.rpc.soap.beans.RemoteAttachment;
import com.atlassian.jira.rpc.soap.beans.RemoteAvatar;
import com.atlassian.jira.rpc.soap.beans.RemoteComment;
import com.atlassian.jira.rpc.soap.beans.RemoteComponent;
import com.atlassian.jira.rpc.soap.beans.RemoteConfiguration;
import com.atlassian.jira.rpc.soap.beans.RemoteEntity;
import com.atlassian.jira.rpc.soap.beans.RemoteField;
import com.atlassian.jira.rpc.soap.beans.RemoteFilter;
import com.atlassian.jira.rpc.soap.beans.RemoteGroup;
import com.atlassian.jira.rpc.soap.beans.RemoteIssue;
import com.atlassian.jira.rpc.soap.beans.RemoteIssueType;
import com.atlassian.jira.rpc.soap.beans.RemoteNamedObject;
import com.atlassian.jira.rpc.soap.beans.RemotePermission;
import com.atlassian.jira.rpc.soap.beans.RemotePermissionScheme;
import com.atlassian.jira.rpc.soap.beans.RemotePriority;
import com.atlassian.jira.rpc.soap.beans.RemoteProject;
import com.atlassian.jira.rpc.soap.beans.RemoteProjectRole;
import com.atlassian.jira.rpc.soap.beans.RemoteProjectRoleActors;
import com.atlassian.jira.rpc.soap.beans.RemoteResolution;
import com.atlassian.jira.rpc.soap.beans.RemoteRoleActors;
import com.atlassian.jira.rpc.soap.beans.RemoteScheme;
import com.atlassian.jira.rpc.soap.beans.RemoteSecurityLevel;
import com.atlassian.jira.rpc.soap.beans.RemoteServerInfo;
import com.atlassian.jira.rpc.soap.beans.RemoteStatus;
import com.atlassian.jira.rpc.soap.beans.RemoteUser;
import com.atlassian.jira.rpc.soap.beans.RemoteVersion;
import com.atlassian.jira.rpc.soap.beans.RemoteWorklog;
import com.atlassian.jira.rpc.soap.jirasoapservice_v2.JiraSoapService;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.Validate;
import org.mule.module.jira.JiraConnectorException;
import org.mule.module.jira.api.AxisJiraClientHelper;
import org.mule.module.jira.api.AxisJiraSoapServiceProvider;
import org.mule.module.jira.api.JiraClient;

public class AxisJiraClient
implements JiraClient<Object[]> {
    private AxisJiraSoapServiceProvider serviceProvider;
    private AxisJiraClientHelper helper;
    private JiraSoapService service;

    public AxisJiraClient(@NotNull AxisJiraSoapServiceProvider serviceProvider) {
        Validate.notNull((Object)serviceProvider);
        this.serviceProvider = serviceProvider;
        this.helper = new AxisJiraClientHelper(this);
    }

    @Override
    public RemoteComment getComment(String token, Long id) {
        try {
            return this.getService().getComment(token, id);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteConfiguration getConfiguration(String token) {
        try {
            return this.getService().getConfiguration(token);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteGroup createGroup(String token, String groupName, String userName) {
        try {
            RemoteUser user = this.getUser(token, userName);
            return this.getService().createGroup(token, groupName, user);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteServerInfo getServerInfo(String token) {
        try {
            return this.getService().getServerInfo(token);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteGroup getGroup(String token, String groupName) {
        try {
            return this.getService().getGroup(token, groupName);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteUser createUser(String token, String username, String password, String fullName, String email) {
        try {
            return this.getService().createUser(token, username, password, fullName, email);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public void addComment(String token, String issueKey, String commentAuthor, String commentBody, String commentGroupLevel, String commentRoleLevel) {
        try {
            RemoteComment comment = this.helper.createComment(commentAuthor, commentBody, commentGroupLevel, commentRoleLevel);
            this.getService().addComment(token, issueKey, comment);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteComponent[] getComponents(String token, String projectKey) {
        try {
            return this.getService().getComponents(token, projectKey);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteUser getUser(String token, String username) {
        try {
            return this.getService().getUser(token, username);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public void addUserToGroup(String token, String groupName, String userName) {
        try {
            this.getService().addUserToGroup(token, this.getGroup(token, groupName), this.getUser(token, userName));
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public void removeUserFromGroup(String token, String groupName, String userName) {
        try {
            this.getService().removeUserFromGroup(token, this.getGroup(token, groupName), this.getUser(token, userName));
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteIssue getIssue(String token, String issueKey) {
        try {
            return this.getService().getIssue(token, issueKey);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteIssue createIssue(String token, String assignee, String summary, String description, String dueDate, String environment, String priority, String project, String reporter, String type, Long votes, Map<String, List<String>> customFields, String componentName, String componentId) {
        RemoteIssue issue = this.helper.createIssue(assignee, summary, description, dueDate, environment, priority, project, reporter, type, votes, customFields, componentName, componentId);
        try {
            return this.getService().createIssue(token, issue);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteIssue createIssue(String token, RemoteIssue issue) {
        try {
            return this.getService().createIssue(token, issue);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteIssue updateIssue(String token, String issueKey, Map<String, List<String>> fields) {
        try {
            return this.getService().updateIssue(token, issueKey, this.helper.createRemoteFieldValues(fields));
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemotePermissionScheme addPermissionTo(String token, String permissionSchemeName, Long permissionCode, String entityName) {
        try {
            RemotePermissionScheme permissionScheme = this.helper.getPermissionScheme(token, permissionSchemeName);
            RemotePermission remotePermission = this.helper.getPermission(token, permissionCode);
            RemoteEntity entity = this.helper.getUserOrUserGroupByName(token, entityName);
            return this.getService().addPermissionTo(token, permissionScheme, remotePermission, entity);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemotePermissionScheme deletePermissionFrom(String token, String permissionSchemeName, Long permissionCode, String entityName) {
        try {
            RemotePermissionScheme permissionScheme = this.helper.getPermissionScheme(token, permissionSchemeName);
            RemotePermission remotePermission = this.helper.getPermission(token, permissionCode);
            RemoteEntity entity = this.helper.getUserOrUserGroupByName(token, entityName);
            return this.getService().deletePermissionFrom(token, permissionScheme, remotePermission, entity);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public void deleteIssue(String token, String issueKey) {
        try {
            this.getService().deleteIssue(token, issueKey);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteNamedObject[] getAvailableActions(String token, String issueKey) {
        try {
            return this.getService().getAvailableActions(token, issueKey);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteIssueType[] getSubTaskIssueTypes(String token) {
        try {
            return this.getService().getSubTaskIssueTypes(token);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteProject getProjectByKey(String token, String projectKey) {
        try {
            return this.getService().getProjectByKey(token, projectKey);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemotePriority[] getPriorities(String token) {
        try {
            return this.getService().getPriorities(token);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteResolution[] getResolutions(String token) {
        try {
            return this.getService().getResolutions(token);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteIssueType[] getIssueTypes(String token) {
        try {
            return this.getService().getIssueTypes(token);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteStatus[] getStatuses(String token) {
        try {
            return this.getService().getStatuses(token);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteIssueType[] getIssueTypesForProject(String token, String projectId) {
        try {
            return this.getService().getIssueTypesForProject(token, projectId);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteProjectRole[] getProjectRoles(String token) {
        try {
            return this.getService().getProjectRoles(token);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteProjectRole getProjectRole(String token, Long id) {
        try {
            return this.getService().getProjectRole(token, id);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteRoleActors getDefaultRoleActors(String token, Long projectRoleId) {
        try {
            return this.getService().getDefaultRoleActors(token, this.getProjectRole(token, projectRoleId));
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public void removeAllRoleActorsByNameAndType(String token, String name, String type) {
        try {
            this.getService().removeAllRoleActorsByNameAndType(token, name, type);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public void deleteProjectRole(String token, Long projectRoleId, Boolean confirm) {
        try {
            this.getService().deleteProjectRole(token, this.getProjectRole(token, projectRoleId), confirm);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public void addDefaultActorsToProjectRole(String token, List<String> actors, Long projectRoleId, String type) {
        try {
            this.getService().addDefaultActorsToProjectRole(token, this.toStringArray(actors), this.getProjectRole(token, projectRoleId), type);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteProject getProjectById(String token, Long projectId) {
        try {
            return this.getService().getProjectById(token, projectId);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteProjectRole createProjectRole(String token, String projectRoleName, String projectRoleDescription) {
        RemoteProjectRole projectRole = new RemoteProjectRole();
        projectRole.setName(projectRoleName);
        projectRole.setDescription(projectRoleDescription);
        try {
            return this.getService().createProjectRole(token, projectRole);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public void addActorsToProjectRole(String token, List<String> actors, Long projectRoleId, String projectKey, String actorType) {
        RemoteProjectRole projectRole = this.getProjectRole(token, projectRoleId);
        RemoteProject project = this.getProjectByKey(token, projectKey);
        try {
            this.getService().addActorsToProjectRole(token, this.toStringArray(actors), projectRole, project, actorType);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public void removeActorsFromProjectRole(String token, List<String> actors, Long projectRoleId, String projectKey, String actorType) {
        RemoteProjectRole projectRole = this.getProjectRole(token, projectRoleId);
        RemoteProject project = this.getProjectByKey(token, projectKey);
        try {
            this.getService().removeActorsFromProjectRole(token, this.toStringArray(actors), projectRole, project, actorType);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public boolean isProjectRoleNameUnique(String token, String name) {
        try {
            return this.getService().isProjectRoleNameUnique(token, name);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public void updateProjectRole(String token, Long projectRoleId, String projectRoleName, String projectRoleDescription) {
        RemoteProjectRole projectRole = this.getProjectRole(token, projectRoleId);
        this.helper.updateProjectRoleName(projectRole, projectRoleName);
        this.helper.updateProjectRoleDescription(projectRole, projectRoleDescription);
        try {
            this.getService().updateProjectRole(token, projectRole);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public void removeDefaultActorsFromProjectRole(String token, List<String> actors, Long projectRoleId, String type) {
        try {
            this.getService().removeDefaultActorsFromProjectRole(token, this.toStringArray(actors), this.getProjectRole(token, projectRoleId), type);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteScheme[] getAssociatedNotificationSchemes(String token, Long projectRoleId) {
        try {
            return this.getService().getAssociatedNotificationSchemes(token, this.getProjectRole(token, projectRoleId));
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteScheme[] getAssociatedPermissionSchemes(String token, Long projectRoleId) {
        try {
            return this.getService().getAssociatedPermissionSchemes(token, this.getProjectRole(token, projectRoleId));
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteVersion[] getVersions(String token, String projectKey) {
        try {
            return this.getService().getVersions(token, projectKey);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteComment[] getComments(String token, String issueKey) {
        try {
            return this.getService().getComments(token, issueKey);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public void deleteProject(String token, String projectKey) {
        try {
            this.getService().deleteProject(token, projectKey);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteField[] getFieldsForEdit(String token, String issueKey) {
        try {
            return this.getService().getFieldsForEdit(token, issueKey);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteIssueType[] getSubTaskIssueTypesForProject(String token, String projectId) {
        try {
            return this.getService().getSubTaskIssueTypesForProject(token, projectId);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteSecurityLevel getSecurityLevel(String token, String issueKey) {
        try {
            return this.getService().getSecurityLevel(token, issueKey);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteProject getProjectWithSchemesById(String token, Long projectId) {
        try {
            return this.getService().getProjectWithSchemesById(token, projectId);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteFilter[] getFavouriteFilters(String token) {
        try {
            return this.getService().getFavouriteFilters(token);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public void archiveVersion(String token, String projectKey, String versionName, Boolean archive) {
        try {
            this.getService().archiveVersion(token, projectKey, versionName, archive);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public void releaseVersion(String token, String projectKey, String versionName) {
        RemoteVersion version = this.helper.getVersion(token, projectKey, versionName);
        try {
            this.getService().releaseVersion(token, projectKey, version);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteSecurityLevel[] getSecurityLevels(String token, String projectKey) {
        try {
            return this.getService().getSecurityLevels(token, projectKey);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteAvatar[] getProjectAvatars(String token, String projectKey, Boolean includeSystemAvatars) {
        try {
            return this.getService().getProjectAvatars(token, projectKey, includeSystemAvatars);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public void setProjectAvatar(String token, String projectKey, Long avatarId) {
        try {
            this.getService().setProjectAvatar(token, projectKey, avatarId);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteAvatar getProjectAvatar(String token, String projectKey) {
        try {
            return this.getService().getProjectAvatar(token, projectKey);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public void deleteProjectAvatar(String token, Long avatarId) {
        try {
            this.getService().deleteProjectAvatar(token, avatarId);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteScheme[] getNotificationSchemes(String token) {
        try {
            return this.getService().getNotificationSchemes(token);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemotePermissionScheme[] getPermissionSchemes(String token) {
        try {
            return this.getService().getPermissionSchemes(token);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteAttachment[] getAttachmentsFromIssue(String token, String issueKey) {
        try {
            return this.getService().getAttachmentsFromIssue(token, issueKey);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteField[] getFieldsForAction(String token, String issueKey, String actionIdString) {
        try {
            return this.getService().getFieldsForAction(token, issueKey, actionIdString);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteIssue progressWorkflowAction(String token, String issueKey, String actionIdString, Map<String, List<String>> fields) {
        try {
            return this.getService().progressWorkflowAction(token, issueKey, actionIdString, this.helper.createRemoteFieldValues(fields));
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public void deleteWorklogWithNewRemainingEstimate(String token, String workLogId, String newRemainingEstimate) {
        try {
            this.getService().deleteWorklogWithNewRemainingEstimate(token, workLogId, newRemainingEstimate);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public void deleteWorklogAndAutoAdjustRemainingEstimate(String token, String worklogId) {
        try {
            this.getService().deleteWorklogAndAutoAdjustRemainingEstimate(token, worklogId);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public void updateWorklogWithNewRemainingEstimate(String token, String issueKey, String worklogId, String comment, String groupLevel, String roleLevelId, String newRemainingEstimate) {
        RemoteWorklog worklog = this.helper.getWorklog(token, issueKey, worklogId);
        this.helper.updateWorkLog(worklog, comment, groupLevel, roleLevelId);
        try {
            this.getService().updateWorklogWithNewRemainingEstimate(token, worklog, newRemainingEstimate);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public void deleteWorklogAndRetainRemainingEstimate(String token, String worklogId) {
        try {
            this.getService().deleteWorklogAndRetainRemainingEstimate(token, worklogId);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteWorklog[] getWorklogs(String token, String issueKey) {
        try {
            return this.getService().getWorklogs(token, issueKey);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public boolean hasPermissionToCreateWorklog(String token, String issueKey) {
        try {
            return this.getService().hasPermissionToCreateWorklog(token, issueKey);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public boolean hasPermissionToDeleteWorklog(String token, String worklogId) {
        try {
            return this.getService().hasPermissionToDeleteWorklog(token, worklogId);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public boolean hasPermissionToUpdateWorklog(String token, String worklogId) {
        try {
            return this.getService().hasPermissionToUpdateWorklog(token, worklogId);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public Calendar getResolutionDateByKey(String token, String issueKey) {
        try {
            return this.getService().getResolutionDateByKey(token, issueKey);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public Calendar getResolutionDateById(String token, Long issueId) {
        try {
            return this.getService().getResolutionDateById(token, issueId);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public long getIssueCountForFilter(String token, String filterId) {
        try {
            return this.getService().getIssueCountForFilter(token, filterId);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteIssue[] getIssuesFromTextSearchWithProject(String token, List<String> projectKeys, String searchTerms, Integer maxNumResults) {
        try {
            return this.getService().getIssuesFromTextSearchWithProject(token, this.toStringArray(projectKeys), searchTerms, maxNumResults);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteIssue[] getIssuesFromJqlSearch(String token, String jqlSearch, Integer maxNumResults) {
        try {
            return this.getService().getIssuesFromJqlSearch(token, jqlSearch, maxNumResults);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public void deleteUser(String token, String username) {
        try {
            this.getService().deleteUser(token, username);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public void deleteGroup(String token, String groupName, String swapGroupName) {
        try {
            this.getService().deleteGroup(token, groupName, swapGroupName);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public void refreshCustomFields(String token) {
        try {
            this.getService().refreshCustomFields(token);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public boolean addBase64EncodedAttachmentsToIssue(String token, String issueKey, List<String> fileNames, List<String> base64EncodedAttachmentData) {
        try {
            return this.getService().addBase64EncodedAttachmentsToIssue(token, issueKey, this.toStringArray(fileNames), this.toStringArray(base64EncodedAttachmentData));
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteIssue[] getIssuesFromFilterWithLimit(String token, String filterId, Integer offset, Integer maxNumResults) {
        try {
            return this.getService().getIssuesFromFilterWithLimit(token, filterId, offset, maxNumResults);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteIssue[] getIssuesFromTextSearchWithLimit(String token, String searchTerms, Integer offset, Integer maxNumResults) {
        try {
            return this.getService().getIssuesFromTextSearchWithLimit(token, searchTerms, offset, maxNumResults);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteProject[] getProjectsNoSchemes(String token) {
        try {
            return this.getService().getProjectsNoSchemes(token);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteScheme[] getSecuritySchemes(String token) {
        try {
            return this.getService().getSecuritySchemes(token);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteVersion addVersion(String token, String projectKey, String versionName, Boolean archived, Boolean released, String releaseDate) {
        RemoteVersion version = this.helper.createVersion(versionName, archived, released, releaseDate);
        try {
            return this.getService().addVersion(token, projectKey, version);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public void setNewProjectAvatar(String token, String projectKey, String contentType, String base64ImageData) {
        try {
            this.getService().setNewProjectAvatar(token, projectKey, contentType, base64ImageData);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteField[] getCustomFields(String token) {
        try {
            return this.getService().getCustomFields(token);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public void deletePermissionScheme(String token, String permissionSchemeName) {
        try {
            this.getService().deletePermissionScheme(token, permissionSchemeName);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteIssue getIssueById(String token, String issueId) {
        try {
            return this.getService().getIssueById(token, issueId);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteGroup updateGroup(String token, String groupName, List<String> usernames) {
        RemoteGroup group = this.getGroup(token, groupName);
        RemoteUser[] usersToAddToGroup = this.helper.getRemoteUsers(token, this.toStringArray(usernames)).toArray(new RemoteUser[usernames.size()]);
        group.setUsers(usersToAddToGroup);
        try {
            return this.getService().updateGroup(token, group);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public void removeAllRoleActorsByProject(String token, String projectKey) {
        try {
            this.getService().removeAllRoleActorsByProject(token, this.getProjectByKey(token, projectKey));
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteProjectRoleActors getProjectRoleActors(String token, Long projectRoleId, String projectKey) {
        try {
            return this.getService().getProjectRoleActors(token, this.getProjectRole(token, projectRoleId), this.getProjectByKey(token, projectKey));
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public boolean logout(String token) {
        try {
            return this.getService().logout(token);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemotePermission[] getAllPermissions(String token) {
        try {
            return this.getService().getAllPermissions(token);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemotePermissionScheme createPermissionScheme(String token, String name, String description) {
        try {
            return this.getService().createPermissionScheme(token, name, description);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public String login(String username, String password) {
        try {
            return this.getService().login(username, password);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteIssue createIssueWithSecurityLevel(String token, String asignee, String summary, String description, String dueDate, String environment, String priority, String project, String reporter, String type, Long votes, Map<String, List<String>> customFields, Long securityLevelId, String componentName, String componentId) {
        RemoteIssue issue = this.createIssue(token, asignee, summary, description, dueDate, environment, priority, project, reporter, type, votes, customFields, componentName, componentId);
        try {
            return this.getService().createIssueWithSecurityLevel(token, issue, securityLevelId);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public boolean hasPermissionToEditComment(String token, Long commentId) {
        try {
            return this.getService().hasPermissionToEditComment(token, this.getComment(token, commentId));
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteComment editComment(String token, Long commentId, String body, String updateAuthor) {
        RemoteComment comment = this.getComment(token, commentId);
        this.helper.updateCommentBody(comment, body);
        this.helper.updateCommentAuthor(comment, updateAuthor);
        try {
            return this.getService().editComment(token, comment);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteProject createProject(String token, String key, String name, String description, String url, String lead, String permissionSchemeName, String notificationSchemeName, String securityShemeName) {
        RemotePermissionScheme permissionScheme = this.helper.getPermissionScheme(token, permissionSchemeName);
        RemoteScheme notificationScheme = this.helper.getNotificationScheme(token, notificationSchemeName);
        RemoteScheme securityScheme = this.helper.getSecurityScheme(token, securityShemeName);
        try {
            return this.getService().createProject(token, key, name, description, url, lead, permissionScheme, notificationScheme, securityScheme);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteProject updateProject(String token, String key, String description, String url, String lead, String permissionSchemeName, String notificationSchemeName, String securityShemeName) {
        RemoteProject project = this.getProjectByKey(token, key);
        this.helper.updateDescription(project, description);
        this.helper.updateUrl(project, url);
        this.helper.updateLead(project, lead);
        this.helper.updatePermissionScheme(token, permissionSchemeName, project);
        this.helper.updateNotificationScheme(token, notificationSchemeName, project);
        this.helper.upateSecurityScheme(token, securityShemeName, project);
        try {
            return this.getService().updateProject(token, project);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteWorklog addWorklogAndAutoAdjustRemainingEstimate(String token, String issueKey, String timeSpent, String startDate, String comment, String groupLevel, String roleLevelId) {
        RemoteWorklog remoteWorklog = this.helper.createRemoteWorklog(timeSpent, startDate, comment, groupLevel, roleLevelId);
        try {
            return this.getService().addWorklogAndAutoAdjustRemainingEstimate(token, issueKey, remoteWorklog);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteWorklog addWorklogWithNewRemainingEstimate(String token, String issueKey, String timeSpent, String startDate, String newRemainingEstimate, String comment, String groupLevel, String roleLevelId) {
        RemoteWorklog remoteWorklog = this.helper.createRemoteWorklog(timeSpent, startDate, comment, groupLevel, roleLevelId);
        try {
            return this.getService().addWorklogWithNewRemainingEstimate(token, issueKey, remoteWorklog, newRemainingEstimate);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    @Override
    public RemoteWorklog addWorklogAndRetainRemainingEstimate(String token, String issueKey, String timeSpent, String startDate, String comment, String groupLevel, String roleLevelId) {
        RemoteWorklog remoteWorklog = this.helper.createRemoteWorklog(timeSpent, startDate, comment, groupLevel, roleLevelId);
        try {
            return this.getService().addWorklogAndRetainRemainingEstimate(token, issueKey, remoteWorklog);
        }
        catch (RemoteException e) {
            throw new JiraConnectorException(e);
        }
    }

    private JiraSoapService getService() throws RemoteException {
        if (this.service == null) {
            this.service = this.serviceProvider.getService();
        }
        return this.service;
    }

    private String[] toStringArray(List<String> list) {
        if (list == null) {
            return new String[0];
        }
        return list.toArray(new String[list.size()]);
    }
}

