
package org.mule.module.jira.config;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.module.jira.processors.AddWorklogWithNewRemainingEstimateMessageProcessor;
import org.mule.util.TemplateParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class AddWorklogWithNewRemainingEstimateDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public AddWorklogWithNewRemainingEstimateDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(AddWorklogWithNewRemainingEstimateMessageProcessor.class.getName());
        String configRef = element.getAttribute("config-ref");
        if ((configRef!= null)&&(!StringUtils.isBlank(configRef))) {
            builder.addPropertyValue("moduleObject", configRef);
        }
        if ((element.getAttribute("issueKey")!= null)&&(!StringUtils.isBlank(element.getAttribute("issueKey")))) {
            builder.addPropertyValue("issueKey", element.getAttribute("issueKey"));
        }
        if ((element.getAttribute("timeSpent")!= null)&&(!StringUtils.isBlank(element.getAttribute("timeSpent")))) {
            builder.addPropertyValue("timeSpent", element.getAttribute("timeSpent"));
        }
        if ((element.getAttribute("startDate")!= null)&&(!StringUtils.isBlank(element.getAttribute("startDate")))) {
            builder.addPropertyValue("startDate", element.getAttribute("startDate"));
        }
        if ((element.getAttribute("newRemainingEstimate")!= null)&&(!StringUtils.isBlank(element.getAttribute("newRemainingEstimate")))) {
            builder.addPropertyValue("newRemainingEstimate", element.getAttribute("newRemainingEstimate"));
        }
        if ((element.getAttribute("comment")!= null)&&(!StringUtils.isBlank(element.getAttribute("comment")))) {
            builder.addPropertyValue("comment", element.getAttribute("comment"));
        }
        if ((element.getAttribute("groupLevel")!= null)&&(!StringUtils.isBlank(element.getAttribute("groupLevel")))) {
            builder.addPropertyValue("groupLevel", element.getAttribute("groupLevel"));
        }
        if ((element.getAttribute("roleLevelId")!= null)&&(!StringUtils.isBlank(element.getAttribute("roleLevelId")))) {
            builder.addPropertyValue("roleLevelId", element.getAttribute("roleLevelId"));
        }
        if ((element.getAttribute("retryMax")!= null)&&(!StringUtils.isBlank(element.getAttribute("retryMax")))) {
            builder.addPropertyValue("retryMax", element.getAttribute("retryMax"));
        }
        if ((element.getAttribute("connectionUser")!= null)&&(!StringUtils.isBlank(element.getAttribute("connectionUser")))) {
            builder.addPropertyValue("connectionUser", element.getAttribute("connectionUser"));
        }
        if ((element.getAttribute("connectionPassword")!= null)&&(!StringUtils.isBlank(element.getAttribute("connectionPassword")))) {
            builder.addPropertyValue("connectionPassword", element.getAttribute("connectionPassword"));
        }
        if ((element.getAttribute("connectionAddress")!= null)&&(!StringUtils.isBlank(element.getAttribute("connectionAddress")))) {
            builder.addPropertyValue("connectionAddress", element.getAttribute("connectionAddress"));
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        MutablePropertyValues propertyValues = parserContent.getContainingBeanDefinition().getPropertyValues();
        if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.config.spring.factories.PollingMessageSourceFactoryBean")) {
            propertyValues.addPropertyValue("messageProcessor", definition);
        } else {
            if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.enricher.MessageEnricher")) {
                propertyValues.addPropertyValue("enrichmentMessageProcessor", definition);
            } else {
                PropertyValue messageProcessors = propertyValues.getPropertyValue("messageProcessors");
                if ((messageProcessors == null)||(messageProcessors.getValue() == null)) {
                    propertyValues.addPropertyValue("messageProcessors", new ManagedList());
                }
                List listMessageProcessors = ((List) propertyValues.getPropertyValue("messageProcessors").getValue());
                listMessageProcessors.add(definition);
            }
        }
        return definition;
    }

    protected String getAttributeValue(Element element, String attributeName) {
        if (!StringUtils.isEmpty(element.getAttribute(attributeName))) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    private String generateChildBeanName(Element element) {
        String id = SpringXMLUtils.getNameOrId(element);
        if (StringUtils.isBlank(id)) {
            String parentId = SpringXMLUtils.getNameOrId(((Element) element.getParentNode()));
            return ((("."+ parentId)+":")+ element.getLocalName());
        } else {
            return id;
        }
    }

}
