
package org.mule.module.jira.config.spring;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.module.jira.config.ProgressWorkflowActionMessageProcessor;
import org.mule.util.TemplateParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ProgressWorkflowActionDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public ProgressWorkflowActionDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ProgressWorkflowActionMessageProcessor.class.getName());
        String configRef = element.getAttribute("config-ref");
        if ((configRef!= null)&&(!StringUtils.isBlank(configRef))) {
            builder.addPropertyValue("moduleObject", configRef);
        }
        if ((element.getAttribute("token")!= null)&&(!StringUtils.isBlank(element.getAttribute("token")))) {
            builder.addPropertyValue("token", element.getAttribute("token"));
        }
        if ((element.getAttribute("issueKey")!= null)&&(!StringUtils.isBlank(element.getAttribute("issueKey")))) {
            builder.addPropertyValue("issueKey", element.getAttribute("issueKey"));
        }
        if ((element.getAttribute("actionIdString")!= null)&&(!StringUtils.isBlank(element.getAttribute("actionIdString")))) {
            builder.addPropertyValue("actionIdString", element.getAttribute("actionIdString"));
        }
        Element fieldsListElement = null;
        fieldsListElement = DomUtils.getChildElementByTagName(element, "fields");
        List<Element> fieldsListChilds = null;
        if (fieldsListElement!= null) {
            String fieldsRef = fieldsListElement.getAttribute("ref");
            if ((fieldsRef!= null)&&(!StringUtils.isBlank(fieldsRef))) {
                if ((!fieldsRef.startsWith(patternInfo.getPrefix()))&&(!fieldsRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("fields", new RuntimeBeanReference(fieldsRef));
                } else {
                    builder.addPropertyValue("fields", fieldsRef);
                }
            } else {
                ManagedMap fields = new ManagedMap();
                fieldsListChilds = DomUtils.getChildElementsByTagName(fieldsListElement, "field");
                if (fieldsListChilds!= null) {
                    if (fieldsListChilds.size() == 0) {
                        fieldsListChilds = DomUtils.getChildElements(fieldsListElement);
                    }
                    for (Element fieldsChild: fieldsListChilds) {
                        String fieldsValueRef = fieldsChild.getAttribute("value-ref");
                        String fieldsKeyRef = fieldsChild.getAttribute("key-ref");
                        Object valueObject = null;
                        Object keyObject = null;
                        if ((fieldsValueRef!= null)&&(!StringUtils.isBlank(fieldsValueRef))) {
                            valueObject = new RuntimeBeanReference(fieldsValueRef);
                        } else {
                            List<Element> innerfieldListChilds = null;
                            if (fieldsChild!= null) {
                                String innerfieldRef = fieldsChild.getAttribute("ref");
                                if ((innerfieldRef!= null)&&(!StringUtils.isBlank(innerfieldRef))) {
                                    if ((!innerfieldRef.startsWith(patternInfo.getPrefix()))&&(!innerfieldRef.endsWith(patternInfo.getSuffix()))) {
                                        builder.addPropertyValue("inner-field", new RuntimeBeanReference(innerfieldRef));
                                    } else {
                                        builder.addPropertyValue("inner-field", innerfieldRef);
                                    }
                                } else {
                                    ManagedList innerfield = new ManagedList();
                                    innerfieldListChilds = DomUtils.getChildElementsByTagName(fieldsChild, "inner-field");
                                    if (innerfieldListChilds!= null) {
                                        for (Element innerfieldChild: innerfieldListChilds) {
                                            String valueRef = innerfieldChild.getAttribute("value-ref");
                                            if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                                                innerfield.add(new RuntimeBeanReference(valueRef));
                                            } else {
                                                innerfield.add(innerfieldChild.getTextContent());
                                            }
                                        }
                                    }
                                    valueObject = innerfield;
                                }
                            }
                        }
                        if ((fieldsKeyRef!= null)&&(!StringUtils.isBlank(fieldsKeyRef))) {
                            keyObject = new RuntimeBeanReference(fieldsKeyRef);
                        } else {
                            keyObject = fieldsChild.getAttribute("key");
                        }
                        if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                            keyObject = fieldsChild.getTagName();
                        }
                        fields.put(keyObject, valueObject);
                    }
                }
                builder.addPropertyValue("fields", fields);
            }
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        MutablePropertyValues propertyValues = parserContent.getContainingBeanDefinition().getPropertyValues();
        if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.config.spring.factories.PollingMessageSourceFactoryBean")) {
            propertyValues.addPropertyValue("messageProcessor", definition);
        } else {
            PropertyValue messageProcessors = propertyValues.getPropertyValue("messageProcessors");
            if ((messageProcessors == null)||(messageProcessors.getValue() == null)) {
                propertyValues.addPropertyValue("messageProcessors", new ManagedList());
            }
            List listMessageProcessors = ((List) propertyValues.getPropertyValue("messageProcessors").getValue());
            listMessageProcessors.add(definition);
        }
        return definition;
    }

    protected String getAttributeValue(Element element, String attributeName) {
        if (!StringUtils.isEmpty(element.getAttribute(attributeName))) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    private String generateChildBeanName(Element element) {
        String id = SpringXMLUtils.getNameOrId(element);
        if (StringUtils.isBlank(id)) {
            String parentId = SpringXMLUtils.getNameOrId(((Element) element.getParentNode()));
            return ((("."+ parentId)+":")+ element.getLocalName());
        } else {
            return id;
        }
    }

}
