
package org.mule.module.jira.config.spring;

import org.springframework.beans.factory.xml.NamespaceHandlerSupport;


/**
 * Registers bean definitions parsers for handling elements in <code>http://www.mulesoft.org/schema/mule/jira</code>.
 * 
 */
public class JiraConnectorNamespaceHandler
    extends NamespaceHandlerSupport
{


    /**
     * Invoked by the {@link DefaultBeanDefinitionDocumentReader} after construction but before any custom elements are parsed. 
     * @see NamespaceHandlerSupport#registerBeanDefinitionParser(String, BeanDefinitionParser)
     * 
     */
    public void init() {
        registerBeanDefinitionParser("config", new JiraConnectorConfigDefinitionParser());
        registerBeanDefinitionParser("get-comment", new GetCommentDefinitionParser());
        registerBeanDefinitionParser("get-configuration", new GetConfigurationDefinitionParser());
        registerBeanDefinitionParser("create-group", new CreateGroupDefinitionParser());
        registerBeanDefinitionParser("get-server-info", new GetServerInfoDefinitionParser());
        registerBeanDefinitionParser("get-group", new GetGroupDefinitionParser());
        registerBeanDefinitionParser("create-user", new CreateUserDefinitionParser());
        registerBeanDefinitionParser("add-comment", new AddCommentDefinitionParser());
        registerBeanDefinitionParser("get-components", new GetComponentsDefinitionParser());
        registerBeanDefinitionParser("get-user", new GetUserDefinitionParser());
        registerBeanDefinitionParser("update-group", new UpdateGroupDefinitionParser());
        registerBeanDefinitionParser("add-user-to-group", new AddUserToGroupDefinitionParser());
        registerBeanDefinitionParser("remove-user-from-group", new RemoveUserFromGroupDefinitionParser());
        registerBeanDefinitionParser("get-issue", new GetIssueDefinitionParser());
        registerBeanDefinitionParser("create-issue", new CreateIssueDefinitionParser());
        registerBeanDefinitionParser("create-issue-with-security-level", new CreateIssueWithSecurityLevelDefinitionParser());
        registerBeanDefinitionParser("update-issue", new UpdateIssueDefinitionParser());
        registerBeanDefinitionParser("delete-issue", new DeleteIssueDefinitionParser());
        registerBeanDefinitionParser("get-available-actions", new GetAvailableActionsDefinitionParser());
        registerBeanDefinitionParser("get-sub-task-issue-types", new GetSubTaskIssueTypesDefinitionParser());
        registerBeanDefinitionParser("create-project", new CreateProjectDefinitionParser());
        registerBeanDefinitionParser("update-project", new UpdateProjectDefinitionParser());
        registerBeanDefinitionParser("get-project-by-key", new GetProjectByKeyDefinitionParser());
        registerBeanDefinitionParser("remove-all-role-actors-by-project", new RemoveAllRoleActorsByProjectDefinitionParser());
        registerBeanDefinitionParser("get-priorities", new GetPrioritiesDefinitionParser());
        registerBeanDefinitionParser("get-resolutions", new GetResolutionsDefinitionParser());
        registerBeanDefinitionParser("get-issue-types", new GetIssueTypesDefinitionParser());
        registerBeanDefinitionParser("get-statuses", new GetStatusesDefinitionParser());
        registerBeanDefinitionParser("get-issue-types-for-project", new GetIssueTypesForProjectDefinitionParser());
        registerBeanDefinitionParser("get-project-roles", new GetProjectRolesDefinitionParser());
        registerBeanDefinitionParser("get-project-role", new GetProjectRoleDefinitionParser());
        registerBeanDefinitionParser("get-project-role-actors", new GetProjectRoleActorsDefinitionParser());
        registerBeanDefinitionParser("get-default-role-actors", new GetDefaultRoleActorsDefinitionParser());
        registerBeanDefinitionParser("remove-all-role-actors-by-name-and-type", new RemoveAllRoleActorsByNameAndTypeDefinitionParser());
        registerBeanDefinitionParser("delete-project-role", new DeleteProjectRoleDefinitionParser());
        registerBeanDefinitionParser("update-project-role", new UpdateProjectRoleDefinitionParser());
        registerBeanDefinitionParser("create-project-role", new CreateProjectRoleDefinitionParser());
        registerBeanDefinitionParser("is-project-role-name-unique", new IsProjectRoleNameUniqueDefinitionParser());
        registerBeanDefinitionParser("release-version", new ReleaseVersionDefinitionParser());
        registerBeanDefinitionParser("add-actors-to-project-role", new AddActorsToProjectRoleDefinitionParser());
        registerBeanDefinitionParser("remove-actors-from-project-role", new RemoveActorsFromProjectRoleDefinitionParser());
        registerBeanDefinitionParser("add-default-actors-to-project-role", new AddDefaultActorsToProjectRoleDefinitionParser());
        registerBeanDefinitionParser("remove-default-actors-from-project-role", new RemoveDefaultActorsFromProjectRoleDefinitionParser());
        registerBeanDefinitionParser("get-associated-notification-schemes", new GetAssociatedNotificationSchemesDefinitionParser());
        registerBeanDefinitionParser("get-associated-permission-schemes", new GetAssociatedPermissionSchemesDefinitionParser());
        registerBeanDefinitionParser("delete-project", new DeleteProjectDefinitionParser());
        registerBeanDefinitionParser("get-project-by-id", new GetProjectByIdDefinitionParser());
        registerBeanDefinitionParser("get-versions", new GetVersionsDefinitionParser());
        registerBeanDefinitionParser("get-comments", new GetCommentsDefinitionParser());
        registerBeanDefinitionParser("get-favourite-filters", new GetFavouriteFiltersDefinitionParser());
        registerBeanDefinitionParser("archive-version", new ArchiveVersionDefinitionParser());
        registerBeanDefinitionParser("get-fields-for-edit", new GetFieldsForEditDefinitionParser());
        registerBeanDefinitionParser("get-sub-task-issue-types-for-project", new GetSubTaskIssueTypesForProjectDefinitionParser());
        registerBeanDefinitionParser("login", new LoginDefinitionParser());
        registerBeanDefinitionParser("get-security-level", new GetSecurityLevelDefinitionParser());
        registerBeanDefinitionParser("get-custom-fields", new GetCustomFieldsDefinitionParser());
        registerBeanDefinitionParser("logout", new LogoutDefinitionParser());
        registerBeanDefinitionParser("get-project-with-schemes-by-id", new GetProjectWithSchemesByIdDefinitionParser());
        registerBeanDefinitionParser("get-security-levels", new GetSecurityLevelsDefinitionParser());
        registerBeanDefinitionParser("get-project-avatars", new GetProjectAvatarsDefinitionParser());
        registerBeanDefinitionParser("set-project-avatar", new SetProjectAvatarDefinitionParser());
        registerBeanDefinitionParser("get-project-avatar", new GetProjectAvatarDefinitionParser());
        registerBeanDefinitionParser("delete-project-avatar", new DeleteProjectAvatarDefinitionParser());
        registerBeanDefinitionParser("get-notification-schemes", new GetNotificationSchemesDefinitionParser());
        registerBeanDefinitionParser("get-permission-schemes", new GetPermissionSchemesDefinitionParser());
        registerBeanDefinitionParser("get-all-permissions", new GetAllPermissionsDefinitionParser());
        registerBeanDefinitionParser("create-permission-scheme", new CreatePermissionSchemeDefinitionParser());
        registerBeanDefinitionParser("add-permission-to", new AddPermissionToDefinitionParser());
        registerBeanDefinitionParser("delete-permission-from", new DeletePermissionFromDefinitionParser());
        registerBeanDefinitionParser("delete-permission-scheme", new DeletePermissionSchemeDefinitionParser());
        registerBeanDefinitionParser("get-attachments-from-issue", new GetAttachmentsFromIssueDefinitionParser());
        registerBeanDefinitionParser("has-permission-to-edit-comment", new HasPermissionToEditCommentDefinitionParser());
        registerBeanDefinitionParser("edit-comment", new EditCommentDefinitionParser());
        registerBeanDefinitionParser("get-fields-for-action", new GetFieldsForActionDefinitionParser());
        registerBeanDefinitionParser("get-issue-by-id", new GetIssueByIdDefinitionParser());
        registerBeanDefinitionParser("delete-worklog-with-new-remaining-estimate", new DeleteWorklogWithNewRemainingEstimateDefinitionParser());
        registerBeanDefinitionParser("delete-worklog-and-auto-adjust-remaining-estimate", new DeleteWorklogAndAutoAdjustRemainingEstimateDefinitionParser());
        registerBeanDefinitionParser("delete-worklog-and-retain-remaining-estimate", new DeleteWorklogAndRetainRemainingEstimateDefinitionParser());
        registerBeanDefinitionParser("get-worklogs", new GetWorklogsDefinitionParser());
        registerBeanDefinitionParser("has-permission-to-create-worklog", new HasPermissionToCreateWorklogDefinitionParser());
        registerBeanDefinitionParser("has-permission-to-delete-worklog", new HasPermissionToDeleteWorklogDefinitionParser());
        registerBeanDefinitionParser("has-permission-to-update-worklog", new HasPermissionToUpdateWorklogDefinitionParser());
        registerBeanDefinitionParser("update-worklog-with-new-remaining-estimate", new UpdateWorklogWithNewRemainingEstimateDefinitionParser());
        registerBeanDefinitionParser("add-version", new AddVersionDefinitionParser());
        registerBeanDefinitionParser("get-resolution-date-by-key", new GetResolutionDateByKeyDefinitionParser());
        registerBeanDefinitionParser("get-resolution-date-by-id", new GetResolutionDateByIdDefinitionParser());
        registerBeanDefinitionParser("get-issue-count-for-filter", new GetIssueCountForFilterDefinitionParser());
        registerBeanDefinitionParser("get-issues-from-text-search-with-project", new GetIssuesFromTextSearchWithProjectDefinitionParser());
        registerBeanDefinitionParser("get-issues-from-jql-search", new GetIssuesFromJqlSearchDefinitionParser());
        registerBeanDefinitionParser("delete-user", new DeleteUserDefinitionParser());
        registerBeanDefinitionParser("delete-group", new DeleteGroupDefinitionParser());
        registerBeanDefinitionParser("refresh-custom-fields", new RefreshCustomFieldsDefinitionParser());
        registerBeanDefinitionParser("add-base64-encoded-attachments-to-issue", new AddBase64EncodedAttachmentsToIssueDefinitionParser());
        registerBeanDefinitionParser("get-issues-from-filter-with-limit", new GetIssuesFromFilterWithLimitDefinitionParser());
        registerBeanDefinitionParser("get-issues-from-text-search-with-limit", new GetIssuesFromTextSearchWithLimitDefinitionParser());
        registerBeanDefinitionParser("get-projects-no-schemes", new GetProjectsNoSchemesDefinitionParser());
        registerBeanDefinitionParser("set-new-project-avatar", new SetNewProjectAvatarDefinitionParser());
        registerBeanDefinitionParser("progress-workflow-action", new ProgressWorkflowActionDefinitionParser());
        registerBeanDefinitionParser("get-security-schemes", new GetSecuritySchemesDefinitionParser());
    }

}
