
package org.mule.module.jira.config.spring;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.module.jira.config.ProgressWorkflowActionMessageProcessor;
import org.mule.util.TemplateParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ProgressWorkflowActionDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public ProgressWorkflowActionDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ProgressWorkflowActionMessageProcessor.class.getName());
        String configRef = element.getAttribute("config-ref");
        if ((configRef!= null)&&(!StringUtils.isBlank(configRef))) {
            builder.addPropertyValue("moduleObject", new RuntimeBeanReference(configRef));
        }
        if ((element.getAttribute("token")!= null)&&(!StringUtils.isBlank(element.getAttribute("token")))) {
            builder.addPropertyValue("token", element.getAttribute("token"));
        }
        if ((element.getAttribute("issueKey")!= null)&&(!StringUtils.isBlank(element.getAttribute("issueKey")))) {
            builder.addPropertyValue("issueKey", element.getAttribute("issueKey"));
        }
        if ((element.getAttribute("actionIdString")!= null)&&(!StringUtils.isBlank(element.getAttribute("actionIdString")))) {
            builder.addPropertyValue("actionIdString", element.getAttribute("actionIdString"));
        }
        Element fieldIdsListElement = null;
        fieldIdsListElement = DomUtils.getChildElementByTagName(element, "field-ids");
        List<Element> fieldIdsListChilds = null;
        if (fieldIdsListElement!= null) {
            String fieldIdsRef = fieldIdsListElement.getAttribute("ref");
            if ((fieldIdsRef!= null)&&(!StringUtils.isBlank(fieldIdsRef))) {
                if ((!fieldIdsRef.startsWith(patternInfo.getPrefix()))&&(!fieldIdsRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("fieldIds", new RuntimeBeanReference(fieldIdsRef));
                } else {
                    builder.addPropertyValue("fieldIds", fieldIdsRef);
                }
            } else {
                ManagedList fieldIds = new ManagedList();
                fieldIdsListChilds = DomUtils.getChildElementsByTagName(fieldIdsListElement, "field-id");
                if (fieldIdsListChilds!= null) {
                    for (Element fieldIdsChild: fieldIdsListChilds) {
                        String valueRef = fieldIdsChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            fieldIds.add(new RuntimeBeanReference(valueRef));
                        } else {
                            fieldIds.add(fieldIdsChild.getTextContent());
                        }
                    }
                }
                builder.addPropertyValue("fieldIds", fieldIds);
            }
        }
        Element fieldsValuesListElement = null;
        fieldsValuesListElement = DomUtils.getChildElementByTagName(element, "fields-values");
        List<Element> fieldsValuesListChilds = null;
        if (fieldsValuesListElement!= null) {
            String fieldsValuesRef = fieldsValuesListElement.getAttribute("ref");
            if ((fieldsValuesRef!= null)&&(!StringUtils.isBlank(fieldsValuesRef))) {
                if ((!fieldsValuesRef.startsWith(patternInfo.getPrefix()))&&(!fieldsValuesRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("fieldsValues", new RuntimeBeanReference(fieldsValuesRef));
                } else {
                    builder.addPropertyValue("fieldsValues", fieldsValuesRef);
                }
            } else {
                ManagedList fieldsValues = new ManagedList();
                fieldsValuesListChilds = DomUtils.getChildElementsByTagName(fieldsValuesListElement, "fields-value");
                if (fieldsValuesListChilds!= null) {
                    for (Element fieldsValuesChild: fieldsValuesListChilds) {
                        String valueRef = fieldsValuesChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            fieldsValues.add(new RuntimeBeanReference(valueRef));
                        } else {
                            fieldsValues.add(fieldsValuesChild.getTextContent());
                        }
                    }
                }
                builder.addPropertyValue("fieldsValues", fieldsValues);
            }
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        MutablePropertyValues propertyValues = parserContent.getContainingBeanDefinition().getPropertyValues();
        if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.config.spring.factories.PollingMessageSourceFactoryBean")) {
            propertyValues.addPropertyValue("messageProcessor", definition);
        } else {
            PropertyValue messageProcessors = propertyValues.getPropertyValue("messageProcessors");
            if ((messageProcessors == null)||(messageProcessors.getValue() == null)) {
                propertyValues.addPropertyValue("messageProcessors", new ManagedList());
            }
            List listMessageProcessors = ((List) propertyValues.getPropertyValue("messageProcessors").getValue());
            listMessageProcessors.add(definition);
        }
        return definition;
    }

    protected String getAttributeValue(Element element, String attributeName) {
        if (!StringUtils.isEmpty(element.getAttribute(attributeName))) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    private String generateChildBeanName(Element element) {
        String id = SpringXMLUtils.getNameOrId(element);
        if (StringUtils.isBlank(id)) {
            String parentId = SpringXMLUtils.getNameOrId(((Element) element.getParentNode()));
            return ((("."+ parentId)+":")+ element.getLocalName());
        } else {
            return id;
        }
    }

}
