
package org.mule.module.jira.config.spring;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.module.jira.config.CreateProjectMessageProcessor;
import org.mule.util.TemplateParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class CreateProjectDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public CreateProjectDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(CreateProjectMessageProcessor.class.getName());
        String configRef = element.getAttribute("config-ref");
        if ((configRef!= null)&&(!StringUtils.isBlank(configRef))) {
            builder.addPropertyValue("moduleObject", new RuntimeBeanReference(configRef));
        }
        if ((element.getAttribute("token")!= null)&&(!StringUtils.isBlank(element.getAttribute("token")))) {
            builder.addPropertyValue("token", element.getAttribute("token"));
        }
        if ((element.getAttribute("key")!= null)&&(!StringUtils.isBlank(element.getAttribute("key")))) {
            builder.addPropertyValue("key", element.getAttribute("key"));
        }
        if ((element.getAttribute("name")!= null)&&(!StringUtils.isBlank(element.getAttribute("name")))) {
            builder.addPropertyValue("name", element.getAttribute("name"));
        }
        if ((element.getAttribute("description")!= null)&&(!StringUtils.isBlank(element.getAttribute("description")))) {
            builder.addPropertyValue("description", element.getAttribute("description"));
        }
        if ((element.getAttribute("url")!= null)&&(!StringUtils.isBlank(element.getAttribute("url")))) {
            builder.addPropertyValue("url", element.getAttribute("url"));
        }
        if ((element.getAttribute("lead")!= null)&&(!StringUtils.isBlank(element.getAttribute("lead")))) {
            builder.addPropertyValue("lead", element.getAttribute("lead"));
        }
        if ((element.getAttribute("permissionSchemeName")!= null)&&(!StringUtils.isBlank(element.getAttribute("permissionSchemeName")))) {
            builder.addPropertyValue("permissionSchemeName", element.getAttribute("permissionSchemeName"));
        }
        if ((element.getAttribute("notificationSchemeName")!= null)&&(!StringUtils.isBlank(element.getAttribute("notificationSchemeName")))) {
            builder.addPropertyValue("notificationSchemeName", element.getAttribute("notificationSchemeName"));
        }
        if ((element.getAttribute("securityShemeName")!= null)&&(!StringUtils.isBlank(element.getAttribute("securityShemeName")))) {
            builder.addPropertyValue("securityShemeName", element.getAttribute("securityShemeName"));
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        MutablePropertyValues propertyValues = parserContent.getContainingBeanDefinition().getPropertyValues();
        if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.config.spring.factories.PollingMessageSourceFactoryBean")) {
            propertyValues.addPropertyValue("messageProcessor", definition);
        } else {
            PropertyValue messageProcessors = propertyValues.getPropertyValue("messageProcessors");
            if ((messageProcessors == null)||(messageProcessors.getValue() == null)) {
                propertyValues.addPropertyValue("messageProcessors", new ManagedList());
            }
            List listMessageProcessors = ((List) propertyValues.getPropertyValue("messageProcessors").getValue());
            listMessageProcessors.add(definition);
        }
        return definition;
    }

    protected String getAttributeValue(Element element, String attributeName) {
        if (!StringUtils.isEmpty(element.getAttribute(attributeName))) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    private String generateChildBeanName(Element element) {
        String id = SpringXMLUtils.getNameOrId(element);
        if (StringUtils.isBlank(id)) {
            String parentId = SpringXMLUtils.getNameOrId(((Element) element.getParentNode()));
            return ((("."+ parentId)+":")+ element.getLocalName());
        } else {
            return id;
        }
    }

}
