
package org.mule.module.jira.config.spring;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.module.jira.config.GetIssuesFromTextSearchWithProjectMessageProcessor;
import org.mule.util.TemplateParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class GetIssuesFromTextSearchWithProjectDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public GetIssuesFromTextSearchWithProjectDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(GetIssuesFromTextSearchWithProjectMessageProcessor.class.getName());
        String configRef = element.getAttribute("config-ref");
        if ((configRef!= null)&&(!StringUtils.isBlank(configRef))) {
            builder.addPropertyValue("moduleObject", new RuntimeBeanReference(configRef));
        }
        if ((element.getAttribute("token")!= null)&&(!StringUtils.isBlank(element.getAttribute("token")))) {
            builder.addPropertyValue("token", element.getAttribute("token"));
        }
        Element projectKeysListElement = null;
        projectKeysListElement = DomUtils.getChildElementByTagName(element, "project-keys");
        List<Element> projectKeysListChilds = null;
        if (projectKeysListElement!= null) {
            String projectKeysRef = projectKeysListElement.getAttribute("ref");
            if ((projectKeysRef!= null)&&(!StringUtils.isBlank(projectKeysRef))) {
                if ((!projectKeysRef.startsWith(patternInfo.getPrefix()))&&(!projectKeysRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("projectKeys", new RuntimeBeanReference(projectKeysRef));
                } else {
                    builder.addPropertyValue("projectKeys", projectKeysRef);
                }
            } else {
                ManagedList projectKeys = new ManagedList();
                projectKeysListChilds = DomUtils.getChildElementsByTagName(projectKeysListElement, "project-key");
                if (projectKeysListChilds!= null) {
                    for (Element projectKeysChild: projectKeysListChilds) {
                        String valueRef = projectKeysChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            projectKeys.add(new RuntimeBeanReference(valueRef));
                        } else {
                            projectKeys.add(projectKeysChild.getTextContent());
                        }
                    }
                }
                builder.addPropertyValue("projectKeys", projectKeys);
            }
        }
        if ((element.getAttribute("searchTerms")!= null)&&(!StringUtils.isBlank(element.getAttribute("searchTerms")))) {
            builder.addPropertyValue("searchTerms", element.getAttribute("searchTerms"));
        }
        if ((element.getAttribute("maxNumResults")!= null)&&(!StringUtils.isBlank(element.getAttribute("maxNumResults")))) {
            builder.addPropertyValue("maxNumResults", element.getAttribute("maxNumResults"));
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        MutablePropertyValues propertyValues = parserContent.getContainingBeanDefinition().getPropertyValues();
        if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.config.spring.factories.PollingMessageSourceFactoryBean")) {
            propertyValues.addPropertyValue("messageProcessor", definition);
        } else {
            PropertyValue messageProcessors = propertyValues.getPropertyValue("messageProcessors");
            if ((messageProcessors == null)||(messageProcessors.getValue() == null)) {
                propertyValues.addPropertyValue("messageProcessors", new ManagedList());
            }
            List listMessageProcessors = ((List) propertyValues.getPropertyValue("messageProcessors").getValue());
            listMessageProcessors.add(definition);
        }
        return definition;
    }

    protected String getAttributeValue(Element element, String attributeName) {
        if (!StringUtils.isEmpty(element.getAttribute(attributeName))) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    private String generateChildBeanName(Element element) {
        String id = SpringXMLUtils.getNameOrId(element);
        if (StringUtils.isBlank(id)) {
            String parentId = SpringXMLUtils.getNameOrId(((Element) element.getParentNode()));
            return ((("."+ parentId)+":")+ element.getLocalName());
        } else {
            return id;
        }
    }

}
