
package org.mule.module.jira.config.spring;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.module.jira.config.CreateIssueWithSecurityLevelMessageProcessor;
import org.mule.util.TemplateParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class CreateIssueWithSecurityLevelDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public CreateIssueWithSecurityLevelDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(CreateIssueWithSecurityLevelMessageProcessor.class.getName());
        String configRef = element.getAttribute("config-ref");
        if ((configRef!= null)&&(!StringUtils.isBlank(configRef))) {
            builder.addPropertyValue("moduleObject", new RuntimeBeanReference(configRef));
        }
        if ((element.getAttribute("token")!= null)&&(!StringUtils.isBlank(element.getAttribute("token")))) {
            builder.addPropertyValue("token", element.getAttribute("token"));
        }
        if ((element.getAttribute("assignee")!= null)&&(!StringUtils.isBlank(element.getAttribute("assignee")))) {
            builder.addPropertyValue("assignee", element.getAttribute("assignee"));
        }
        if ((element.getAttribute("summary")!= null)&&(!StringUtils.isBlank(element.getAttribute("summary")))) {
            builder.addPropertyValue("summary", element.getAttribute("summary"));
        }
        if ((element.getAttribute("description")!= null)&&(!StringUtils.isBlank(element.getAttribute("description")))) {
            builder.addPropertyValue("description", element.getAttribute("description"));
        }
        if ((element.getAttribute("dueDate")!= null)&&(!StringUtils.isBlank(element.getAttribute("dueDate")))) {
            builder.addPropertyValue("dueDate", element.getAttribute("dueDate"));
        }
        if ((element.getAttribute("environment")!= null)&&(!StringUtils.isBlank(element.getAttribute("environment")))) {
            builder.addPropertyValue("environment", element.getAttribute("environment"));
        }
        if ((element.getAttribute("priority")!= null)&&(!StringUtils.isBlank(element.getAttribute("priority")))) {
            builder.addPropertyValue("priority", element.getAttribute("priority"));
        }
        if ((element.getAttribute("project")!= null)&&(!StringUtils.isBlank(element.getAttribute("project")))) {
            builder.addPropertyValue("project", element.getAttribute("project"));
        }
        if ((element.getAttribute("reporter")!= null)&&(!StringUtils.isBlank(element.getAttribute("reporter")))) {
            builder.addPropertyValue("reporter", element.getAttribute("reporter"));
        }
        if ((element.getAttribute("type")!= null)&&(!StringUtils.isBlank(element.getAttribute("type")))) {
            builder.addPropertyValue("type", element.getAttribute("type"));
        }
        if ((element.getAttribute("votes")!= null)&&(!StringUtils.isBlank(element.getAttribute("votes")))) {
            builder.addPropertyValue("votes", element.getAttribute("votes"));
        }
        Element customFieldKeysListElement = null;
        customFieldKeysListElement = DomUtils.getChildElementByTagName(element, "custom-field-keys");
        List<Element> customFieldKeysListChilds = null;
        if (customFieldKeysListElement!= null) {
            String customFieldKeysRef = customFieldKeysListElement.getAttribute("ref");
            if ((customFieldKeysRef!= null)&&(!StringUtils.isBlank(customFieldKeysRef))) {
                if ((!customFieldKeysRef.startsWith(patternInfo.getPrefix()))&&(!customFieldKeysRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("customFieldKeys", new RuntimeBeanReference(customFieldKeysRef));
                } else {
                    builder.addPropertyValue("customFieldKeys", customFieldKeysRef);
                }
            } else {
                ManagedList customFieldKeys = new ManagedList();
                customFieldKeysListChilds = DomUtils.getChildElementsByTagName(customFieldKeysListElement, "custom-field-key");
                if (customFieldKeysListChilds!= null) {
                    for (Element customFieldKeysChild: customFieldKeysListChilds) {
                        String valueRef = customFieldKeysChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            customFieldKeys.add(new RuntimeBeanReference(valueRef));
                        } else {
                            customFieldKeys.add(customFieldKeysChild.getTextContent());
                        }
                    }
                }
                builder.addPropertyValue("customFieldKeys", customFieldKeys);
            }
        }
        Element customFieldValuesListElement = null;
        customFieldValuesListElement = DomUtils.getChildElementByTagName(element, "custom-field-values");
        List<Element> customFieldValuesListChilds = null;
        if (customFieldValuesListElement!= null) {
            String customFieldValuesRef = customFieldValuesListElement.getAttribute("ref");
            if ((customFieldValuesRef!= null)&&(!StringUtils.isBlank(customFieldValuesRef))) {
                if ((!customFieldValuesRef.startsWith(patternInfo.getPrefix()))&&(!customFieldValuesRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("customFieldValues", new RuntimeBeanReference(customFieldValuesRef));
                } else {
                    builder.addPropertyValue("customFieldValues", customFieldValuesRef);
                }
            } else {
                ManagedList customFieldValues = new ManagedList();
                customFieldValuesListChilds = DomUtils.getChildElementsByTagName(customFieldValuesListElement, "custom-field-value");
                if (customFieldValuesListChilds!= null) {
                    for (Element customFieldValuesChild: customFieldValuesListChilds) {
                        String valueRef = customFieldValuesChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            customFieldValues.add(new RuntimeBeanReference(valueRef));
                        } else {
                            customFieldValues.add(customFieldValuesChild.getTextContent());
                        }
                    }
                }
                builder.addPropertyValue("customFieldValues", customFieldValues);
            }
        }
        if ((element.getAttribute("securityLevelId")!= null)&&(!StringUtils.isBlank(element.getAttribute("securityLevelId")))) {
            builder.addPropertyValue("securityLevelId", element.getAttribute("securityLevelId"));
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        MutablePropertyValues propertyValues = parserContent.getContainingBeanDefinition().getPropertyValues();
        if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.config.spring.factories.PollingMessageSourceFactoryBean")) {
            propertyValues.addPropertyValue("messageProcessor", definition);
        } else {
            PropertyValue messageProcessors = propertyValues.getPropertyValue("messageProcessors");
            if ((messageProcessors == null)||(messageProcessors.getValue() == null)) {
                propertyValues.addPropertyValue("messageProcessors", new ManagedList());
            }
            List listMessageProcessors = ((List) propertyValues.getPropertyValue("messageProcessors").getValue());
            listMessageProcessors.add(definition);
        }
        return definition;
    }

    protected String getAttributeValue(Element element, String attributeName) {
        if (!StringUtils.isEmpty(element.getAttribute(attributeName))) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    private String generateChildBeanName(Element element) {
        String id = SpringXMLUtils.getNameOrId(element);
        if (StringUtils.isBlank(id)) {
            String parentId = SpringXMLUtils.getNameOrId(((Element) element.getParentNode()));
            return ((("."+ parentId)+":")+ element.getLocalName());
        } else {
            return id;
        }
    }

}
