/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jira.config;

import com.atlassian.jira.rpc.soap.beans.RemoteIssueType;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.jira.JiraCloudConnector;
import org.mule.transformer.TransformerTemplate;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.NullPayload;
import org.mule.util.TemplateParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetIssueTypesForProjectMessageProcessor
implements MessageProcessor,
Initialisable,
MuleContextAware {
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    protected JiraCloudConnector object;
    protected Object token;
    protected Object projectId;
    protected TemplateParser.PatternInfo patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    protected ExpressionManager expressionManager;
    protected MuleContext muleContext;

    public void initialise() throws InitialisationException {
        if (this.object == null) {
            this.lookupObjectInstance();
        }
        this.expressionManager = this.muleContext.getExpressionManager();
    }

    protected void lookupObjectInstance() throws InitialisationException {
        try {
            this.object = (JiraCloudConnector)this.muleContext.getRegistry().lookupObject(JiraCloudConnector.class);
        }
        catch (RegistrationException e) {
            throw new InitialisationException(CoreMessages.initialisationFailure((String)String.format("Multiple instances of '%s' were found in the registry so you need to configure a specific instance", this.object.getClass())), (Initialisable)this);
        }
        if (this.object == null) {
            try {
                this.object = new JiraCloudConnector();
                this.muleContext.getRegistry().registerObject("org.mule.module.jira.JiraCloudConnector", (Object)this.object);
            }
            catch (RegistrationException e) {
                throw new InitialisationException(CoreMessages.initialisationFailure((String)"Cannot create a new instance of 'org.mule.module.jira.JiraCloudConnector'"), (Initialisable)this);
            }
        }
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        MuleMessage message = event.getMessage();
        MuleEvent resultEvent = event;
        String token = null;
        String projectId = null;
        try {
            if (this.token != null) {
                token = this.transformArgument(this.evaluateExpressionCandidate(this.token, message), String.class);
            }
            if (this.projectId != null) {
                projectId = this.transformArgument(this.evaluateExpressionCandidate(this.projectId, message), String.class);
            }
        }
        catch (TransformerException e) {
            throw new MessagingException(event, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new MessagingException(event, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new MessagingException(event, (Throwable)e);
        }
        try {
            RemoteIssueType[] result = this.object.getIssueTypesForProject(token, projectId);
            resultEvent = this.createResultEvent(event, result);
        }
        catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke((String)this.object.toString()), event, (Throwable)e);
        }
        return resultEvent;
    }

    protected <U, V> V evaluateArgument(MuleEvent event, U template, Class<V> type) throws MessagingException {
        MuleMessage message = event.getMessage();
        try {
            return this.transformArgument(this.evaluateExpressionCandidate(template, message), type);
        }
        catch (TransformerException e) {
            throw new MessagingException(event, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new MessagingException(event, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new MessagingException(event, (Throwable)e);
        }
    }

    protected <T> T evaluateExpressionCandidate(T expressionCandidate, MuleMessage message) throws TransformerException {
        if (expressionCandidate.getClass().isArray()) {
            Object[] collectionTemplate = (Object[])expressionCandidate;
            ArrayList<Object> newCollection = new ArrayList<Object>();
            for (int i = 0; i < collectionTemplate.length; ++i) {
                newCollection.add(this.evaluateExpressionCandidate(collectionTemplate[i], message));
            }
            return (T)newCollection.toArray();
        }
        if (expressionCandidate instanceof Collection) {
            Collection collectionTemplate = (Collection)expressionCandidate;
            ArrayList newCollection = new ArrayList();
            for (Object object : collectionTemplate) {
                newCollection.add(this.evaluateExpressionCandidate(object, message));
            }
            return (T)newCollection;
        }
        if (expressionCandidate instanceof Map) {
            Map mapTemplate = (Map)expressionCandidate;
            HashMap newMap = new HashMap();
            for (Map.Entry entry : mapTemplate.entrySet()) {
                newMap.put(this.evaluateExpressionCandidate(entry.getKey(), message), this.evaluateExpressionCandidate(entry.getValue(), message));
            }
            return (T)newMap;
        }
        if (expressionCandidate instanceof String[]) {
            String[] stringArrayTemplate = (String[])expressionCandidate;
            String[] newArray = new String[stringArrayTemplate.length];
            for (int j = 0; j < stringArrayTemplate.length; ++j) {
                newArray[j] = this.evaluateExpressionCandidate(stringArrayTemplate[j], message);
            }
            return (T)newArray;
        }
        if (expressionCandidate instanceof String) {
            String expression = (String)expressionCandidate;
            Object arg = expression.startsWith(this.patternInfo.getPrefix()) && expression.endsWith(this.patternInfo.getSuffix()) ? this.expressionManager.evaluate(expression, message) : this.expressionManager.parse(expression, message);
            if (arg instanceof MuleMessage) {
                arg = ((MuleMessage)arg).getPayload();
            }
            return (T)arg;
        }
        return expressionCandidate;
    }

    private <U, V> V transformArgument(U arg, Class<V> type) throws TransformerException, IllegalAccessException, InstantiationException {
        if (arg.getClass().isArray()) {
            Object[] collection = (Object[])arg;
            Object newCollection = Array.newInstance(type.getComponentType(), collection.length);
            for (int i = 0; i < collection.length; ++i) {
                Array.set(newCollection, i, this.transformArgument(collection[i], type.getComponentType()));
            }
            return (V)newCollection;
        }
        if (!type.isAssignableFrom(arg.getClass())) {
            DataType source = DataTypeFactory.create(arg.getClass());
            DataType target = DataTypeFactory.create(type);
            Transformer t = this.muleContext.getRegistry().lookupTransformer(source, target);
            Object result = t.transform(arg);
            return (V)result;
        }
        return (V)arg;
    }

    private <U, V> List<V> transformList(U arg, Class<V> generic) throws TransformerException, InstantiationException, IllegalAccessException {
        List collection = (List)arg;
        ArrayList<V> newCollection = new ArrayList<V>();
        for (Object object : collection) {
            newCollection.add(this.transformArgument(object, generic));
        }
        return newCollection;
    }

    private <U, K, V> Map<K, V> transformMap(U arg, Class<K> genericKey, Class<V> genericObj) throws TransformerException, InstantiationException, IllegalAccessException {
        Map collection = (Map)arg;
        HashMap<K, V> newCollection = new HashMap<K, V>();
        for (Object key : collection.keySet()) {
            Object object = collection.get(key);
            newCollection.put(this.transformArgument(key, genericKey), this.transformArgument(object, genericObj));
        }
        return newCollection;
    }

    protected MuleEvent createResultEvent(MuleEvent event, Object result) throws MuleException {
        if (result instanceof MuleMessage) {
            return new DefaultMuleEvent((MuleMessage)result, event);
        }
        if (result != null) {
            event.getMessage().applyTransformers(event, Collections.singletonList(new TransformerTemplate((TransformerTemplate.TransformerCallback)new TransformerTemplate.OverwitePayloadCallback(result))));
            return event;
        }
        return new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)NullPayload.getInstance(), event.getMuleContext()), event);
    }

    public String toString() {
        return String.format("GetIssueTypesForProjectMessageProcessor [object=%s, methodName=getIssueTypesForProject]", this.object);
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void setToken(Object value) {
        this.token = value;
    }

    public void setProjectId(Object value) {
        this.projectId = value;
    }

    public void setObject(JiraCloudConnector object) {
        this.object = object;
    }
}

