/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jira.api;

import com.atlassian.jira.rpc.soap.beans.RemoteComment;
import com.atlassian.jira.rpc.soap.beans.RemoteCustomFieldValue;
import com.atlassian.jira.rpc.soap.beans.RemoteEntity;
import com.atlassian.jira.rpc.soap.beans.RemoteFieldValue;
import com.atlassian.jira.rpc.soap.beans.RemoteGroup;
import com.atlassian.jira.rpc.soap.beans.RemoteIssue;
import com.atlassian.jira.rpc.soap.beans.RemotePermission;
import com.atlassian.jira.rpc.soap.beans.RemotePermissionScheme;
import com.atlassian.jira.rpc.soap.beans.RemoteProject;
import com.atlassian.jira.rpc.soap.beans.RemoteProjectRole;
import com.atlassian.jira.rpc.soap.beans.RemoteScheme;
import com.atlassian.jira.rpc.soap.beans.RemoteUser;
import com.atlassian.jira.rpc.soap.beans.RemoteVersion;
import com.atlassian.jira.rpc.soap.beans.RemoteWorklog;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.mule.module.jira.JiraCloudConnectorException;
import org.mule.module.jira.api.AxisJiraClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisJiraClientHelper {
    private static final String DATE_FORMAT = "MM-dd-yyy'T'HH:mm:ss";
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("MM-dd-yyy'T'HH:mm:ss");
    private AxisJiraClient axisJiraClient;

    public AxisJiraClientHelper(AxisJiraClient axisJiraClient) {
        this.axisJiraClient = axisJiraClient;
    }

    protected RemoteComment createComment(String commentAuthor, String commentBody, String commentGroupLevel, String commentRoleLevel) {
        RemoteComment remoteComment = new RemoteComment();
        remoteComment.setAuthor(commentAuthor);
        remoteComment.setBody(commentBody);
        remoteComment.setGroupLevel(commentGroupLevel);
        remoteComment.setRoleLevel(commentRoleLevel);
        return remoteComment;
    }

    protected RemoteIssue createIssue(String assignee, String summary, String description, String dueDate, String environment, String priority, String project, String reporter, String type, Long votes, String[] customFieldKeys, String[] customerFieldValues) {
        RemoteIssue remoteIssue = new RemoteIssue();
        remoteIssue.setAssignee(assignee);
        remoteIssue.setSummary(summary);
        remoteIssue.setDescription(description);
        remoteIssue.setDuedate(this.getCalendar(dueDate));
        remoteIssue.setEnvironment(environment);
        remoteIssue.setPriority(priority);
        remoteIssue.setProject(project);
        remoteIssue.setReporter(reporter);
        remoteIssue.setType(type);
        remoteIssue.setVotes(votes);
        remoteIssue.setCustomFieldValues(this.getRemoteCustomFieldValues(customFieldKeys, customerFieldValues));
        return remoteIssue;
    }

    protected RemoteCustomFieldValue[] getRemoteCustomFieldValues(String[] customFieldKeys, String[] customFieldValues) {
        if (customFieldKeys == null || customFieldValues == null) {
            return null;
        }
        if (customFieldKeys.length != customFieldValues.length) {
            throw new JiraCloudConnectorException("The number of keys provided does not match the number of value sets");
        }
        RemoteCustomFieldValue[] result = new RemoteCustomFieldValue[customFieldKeys.length];
        for (int i = 0; i < customFieldKeys.length; ++i) {
            result[i] = new RemoteCustomFieldValue(customFieldKeys[i], "", new String[]{customFieldValues[i]});
        }
        return result;
    }

    protected Calendar getCalendar(String dateString) {
        if (dateString == null) {
            return null;
        }
        try {
            Calendar calendar = Calendar.getInstance();
            Date date = SIMPLE_DATE_FORMAT.parse(dateString);
            calendar.setTime(date);
            return calendar;
        }
        catch (ParseException e) {
            throw new JiraCloudConnectorException("Could not parse date string: " + dateString + " expected format is: " + DATE_FORMAT, e);
        }
    }

    protected List<RemoteUser> getRemoteUsers(String token, String[] usernames) {
        if (usernames.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<RemoteUser> remoteUsers = new ArrayList<RemoteUser>(usernames.length);
        for (String username : usernames) {
            RemoteUser user = this.axisJiraClient.getUser(token, username);
            if (user == null) {
                throw new JiraCloudConnectorException("No user exists with username: " + username);
            }
            remoteUsers.add(user);
        }
        return remoteUsers;
    }

    protected RemotePermissionScheme getPermissionScheme(String token, String permissionSchemeName) {
        RemotePermissionScheme[] permissionSchemes;
        if (permissionSchemeName == null) {
            return null;
        }
        for (RemotePermissionScheme permissionScheme : permissionSchemes = this.axisJiraClient.getPermissionSchemes(token)) {
            if (!permissionScheme.getName().equals(permissionSchemeName)) continue;
            return permissionScheme;
        }
        throw new JiraCloudConnectorException("Permission scheme not found found with name: " + permissionSchemeName);
    }

    protected RemoteScheme getNotificationScheme(String token, String notificationSchemeName) {
        RemoteScheme[] notificationSchemes;
        if (notificationSchemeName == null) {
            return null;
        }
        for (RemoteScheme notificationScheme : notificationSchemes = this.axisJiraClient.getNotificationSchemes(token)) {
            if (!notificationScheme.getName().equals(notificationSchemeName)) continue;
            return notificationScheme;
        }
        throw new JiraCloudConnectorException("Notification scheme not found with name: " + notificationSchemeName);
    }

    protected RemoteScheme getSecurityScheme(String token, String securityShemeName) {
        RemoteScheme[] securitySchemes;
        if (securityShemeName == null) {
            return null;
        }
        for (RemoteScheme securityScheme : securitySchemes = this.axisJiraClient.getSecuritySchemes(token)) {
            if (!securityScheme.getName().equals(securityShemeName)) continue;
            return securityScheme;
        }
        throw new JiraCloudConnectorException("Security scheme not found with name: " + securityShemeName);
    }

    protected void upateSecurityScheme(String token, String securityShemeName, RemoteProject project) {
        RemoteScheme securityScheme = this.getSecurityScheme(token, securityShemeName);
        if (securityScheme != null) {
            project.setIssueSecurityScheme(securityScheme);
        }
    }

    protected void updateNotificationScheme(String token, String notificationSchemeName, RemoteProject project) {
        RemoteScheme notificationScheme = this.getNotificationScheme(token, notificationSchemeName);
        if (notificationScheme != null) {
            project.setNotificationScheme(notificationScheme);
        }
    }

    protected void updatePermissionScheme(String token, String permissionSchemeName, RemoteProject project) {
        RemotePermissionScheme permissionScheme = this.getPermissionScheme(token, permissionSchemeName);
        if (permissionScheme != null) {
            project.setPermissionScheme(permissionScheme);
        }
    }

    protected void updateDescription(RemoteProject project, String description) {
        if (description != null) {
            project.setDescription(description);
        }
    }

    protected void updateUrl(RemoteProject project, String url) {
        if (url != null) {
            project.setUrl(url);
        }
    }

    protected void updateLead(RemoteProject project, String lead) {
        if (lead != null) {
            project.setLead(lead);
        }
    }

    protected void updateProjectRoleName(RemoteProjectRole projectRole, String projectRoleName) {
        if (projectRoleName != null) {
            projectRole.setName(projectRoleName);
        }
    }

    protected void updateProjectRoleDescription(RemoteProjectRole projectRole, String projectRoleDescription) {
        if (projectRoleDescription != null) {
            projectRole.setName(projectRoleDescription);
        }
    }

    protected void updateCommentBody(RemoteComment comment, String body) {
        if (body != null) {
            comment.setBody(body);
        }
    }

    protected void updateCommentAuthor(RemoteComment comment, String updateAuthor) {
        if (updateAuthor != null) {
            comment.setUpdateAuthor(updateAuthor);
        }
    }

    protected RemoteVersion getVersion(String token, String projectKey, String versionName) {
        RemoteVersion[] versions;
        for (RemoteVersion version : versions = this.axisJiraClient.getVersions(token, projectKey)) {
            if (!version.getName().equals(versionName)) continue;
            return version;
        }
        throw new JiraCloudConnectorException("Version not found found with name: " + versionName);
    }

    protected RemoteWorklog getWorklog(String token, String issueKey, String worklogId) {
        RemoteWorklog[] worklogs;
        for (RemoteWorklog worklog : worklogs = this.axisJiraClient.getWorklogs(token, issueKey)) {
            if (!worklog.getId().equals(worklogId)) continue;
            return worklog;
        }
        throw new JiraCloudConnectorException("Worklok not found found with id: " + worklogId);
    }

    protected void updateWorkLog(RemoteWorklog worklog, String comment, String groupLevel, String roleLevelId) {
        if (comment != null) {
            worklog.setComment(comment);
        }
        if (groupLevel != null) {
            worklog.setGroupLevel(groupLevel);
        }
        if (roleLevelId != null) {
            worklog.setRoleLevelId(roleLevelId);
        }
    }

    protected RemoteVersion createVersion(String versionName, Boolean archived, Boolean released, String releaseDate) {
        RemoteVersion version = new RemoteVersion();
        version.setName(versionName);
        version.setArchived(archived);
        version.setReleased(released);
        version.setReleaseDate(this.getCalendar(releaseDate));
        return version;
    }

    protected RemoteFieldValue[] createFieldValues(String[] fieldIds, String[] fieldValues) {
        if (fieldIds == null || fieldValues == null) {
            return null;
        }
        if (fieldIds.length != fieldValues.length) {
            throw new JiraCloudConnectorException("The number of field ids provided does not match the number of value sets");
        }
        RemoteFieldValue[] result = new RemoteFieldValue[fieldIds.length];
        for (int i = 0; i < fieldIds.length; ++i) {
            result[i] = new RemoteFieldValue(fieldIds[i], new String[]{fieldValues[i]});
        }
        return result;
    }

    protected RemoteEntity getUserOrUserGroupByName(String token, String entityName) {
        RemoteUser user = this.axisJiraClient.getUser(token, entityName);
        if (user != null) {
            return user;
        }
        RemoteGroup group = this.axisJiraClient.getGroup(token, entityName);
        if (group != null) {
            return group;
        }
        throw new JiraCloudConnectorException("No user or group found with name: " + entityName);
    }

    protected RemotePermission getPermission(String token, Long permissionCode) {
        RemotePermission[] allPermissions;
        for (RemotePermission permission : allPermissions = this.axisJiraClient.getAllPermissions(token)) {
            if (!permission.getPermission().equals(permissionCode)) continue;
            return permission;
        }
        throw new JiraCloudConnectorException("No permission found for code: " + permissionCode);
    }
}

