/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jira;

import com.atlassian.jira.rpc.soap.beans.RemoteAttachment;
import com.atlassian.jira.rpc.soap.beans.RemoteAvatar;
import com.atlassian.jira.rpc.soap.beans.RemoteComment;
import com.atlassian.jira.rpc.soap.beans.RemoteComponent;
import com.atlassian.jira.rpc.soap.beans.RemoteConfiguration;
import com.atlassian.jira.rpc.soap.beans.RemoteField;
import com.atlassian.jira.rpc.soap.beans.RemoteFilter;
import com.atlassian.jira.rpc.soap.beans.RemoteGroup;
import com.atlassian.jira.rpc.soap.beans.RemoteIssue;
import com.atlassian.jira.rpc.soap.beans.RemoteIssueType;
import com.atlassian.jira.rpc.soap.beans.RemoteNamedObject;
import com.atlassian.jira.rpc.soap.beans.RemotePermission;
import com.atlassian.jira.rpc.soap.beans.RemotePermissionScheme;
import com.atlassian.jira.rpc.soap.beans.RemotePriority;
import com.atlassian.jira.rpc.soap.beans.RemoteProject;
import com.atlassian.jira.rpc.soap.beans.RemoteProjectRole;
import com.atlassian.jira.rpc.soap.beans.RemoteProjectRoleActors;
import com.atlassian.jira.rpc.soap.beans.RemoteResolution;
import com.atlassian.jira.rpc.soap.beans.RemoteRoleActors;
import com.atlassian.jira.rpc.soap.beans.RemoteScheme;
import com.atlassian.jira.rpc.soap.beans.RemoteSecurityLevel;
import com.atlassian.jira.rpc.soap.beans.RemoteServerInfo;
import com.atlassian.jira.rpc.soap.beans.RemoteStatus;
import com.atlassian.jira.rpc.soap.beans.RemoteUser;
import com.atlassian.jira.rpc.soap.beans.RemoteVersion;
import com.atlassian.jira.rpc.soap.beans.RemoteWorklog;
import java.util.Calendar;
import org.mule.module.jira.JiraClientAdaptor;
import org.mule.module.jira.JiraClientFactory;
import org.mule.module.jira.api.JiraClient;

public class JiraCloudConnector {
    private JiraClient client;
    private String username;
    private String password;
    private String address;

    public RemoteComment getComment(String token, Long commentId) {
        return this.getClient().getComment(this.createTokenIfNecessary(token), commentId);
    }

    public RemoteConfiguration getConfiguration(String token) {
        return this.getClient().getConfiguration(this.createTokenIfNecessary(token));
    }

    public RemoteGroup createGroup(String token, String groupName, String userName) {
        return this.getClient().createGroup(this.createTokenIfNecessary(token), groupName, userName);
    }

    public RemoteServerInfo getServerInfo(String token) {
        return this.getClient().getServerInfo(this.createTokenIfNecessary(token));
    }

    public RemoteGroup getGroup(String token, String groupName) {
        return this.getClient().getGroup(this.createTokenIfNecessary(token), groupName);
    }

    public RemoteUser createUser(String token, String username, String password, String fullName, String email) {
        return this.getClient().createUser(this.createTokenIfNecessary(token), username, password, fullName, email);
    }

    public void addComment(String token, String issueKey, String commentAuthor, String commentBody, String commentGroupLevel, String commentRoleLevel) {
        this.getClient().addComment(this.createTokenIfNecessary(token), issueKey, commentAuthor, commentBody, commentGroupLevel, commentRoleLevel);
    }

    public RemoteComponent[] getComponents(String token, String projectKey) {
        return this.getClient().getComponents(this.createTokenIfNecessary(token), projectKey);
    }

    public RemoteUser getUser(String token, String username) {
        return this.getClient().getUser(this.createTokenIfNecessary(token), username);
    }

    public RemoteGroup updateGroup(String token, String groupName, String[] usernames) {
        return this.getClient().updateGroup(this.createTokenIfNecessary(token), groupName, usernames);
    }

    public void addUserToGroup(String token, String groupName, String userName) {
        this.getClient().addUserToGroup(this.createTokenIfNecessary(token), groupName, userName);
    }

    public void removeUserFromGroup(String token, String groupName, String userName) {
        this.getClient().removeUserFromGroup(this.createTokenIfNecessary(token), groupName, userName);
    }

    public RemoteIssue getIssue(String token, String issueKey) {
        return this.getClient().getIssue(this.createTokenIfNecessary(token), issueKey);
    }

    public RemoteIssue createIssue(String token, String assignee, String summary, String description, String dueDate, String environment, String priority, String project, String reporter, String type, Long votes, String[] customFieldKeys, String[] customFieldValues) {
        return this.getClient().createIssue(this.createTokenIfNecessary(token), assignee, summary, description, dueDate, environment, priority, project, reporter, type, votes, customFieldKeys, customFieldValues);
    }

    public RemoteIssue createIssueWithSecurityLevel(String token, String assignee, String summary, String description, String dueDate, String environment, String priority, String project, String reporter, String type, Long votes, String[] customFieldKeys, String[] customFieldValues, Long securityLevelId) {
        return this.getClient().createIssueWithSecurityLevel(this.createTokenIfNecessary(token), assignee, summary, description, dueDate, environment, priority, project, reporter, type, votes, customFieldKeys, customFieldValues, securityLevelId);
    }

    public RemoteIssue updateIssue(String token, String issueKey, String[] fieldIds, String[] fieldValues) {
        return this.getClient().updateIssue(this.createTokenIfNecessary(token), issueKey, fieldIds, fieldValues);
    }

    public void deleteIssue(String token, String issueKey) {
        this.getClient().deleteIssue(this.createTokenIfNecessary(token), issueKey);
    }

    public RemoteNamedObject[] getAvailableActions(String token, String issueKey) {
        return this.getClient().getAvailableActions(this.createTokenIfNecessary(token), issueKey);
    }

    public RemoteIssueType[] getSubTaskIssueTypes(String token) {
        return this.getClient().getSubTaskIssueTypes(this.createTokenIfNecessary(token));
    }

    public RemoteProject createProject(String token, String key, String name, String description, String url, String lead, String permissionSchemeName, String notificationSchemeName, String securityShemeName) {
        return this.getClient().createProject(this.createTokenIfNecessary(token), key, name, description, url, lead, permissionSchemeName, notificationSchemeName, securityShemeName);
    }

    public RemoteProject updateProject(String token, String key, String description, String url, String lead, String permissionSchemeName, String notificationSchemeName, String securityShemeName) {
        return this.getClient().updateProject(this.createTokenIfNecessary(token), key, description, url, lead, permissionSchemeName, notificationSchemeName, securityShemeName);
    }

    public RemoteProject getProjectByKey(String token, String projectKey) {
        return this.getClient().getProjectByKey(this.createTokenIfNecessary(token), projectKey);
    }

    public void removeAllRoleActorsByProject(String token, String projectKey) {
        this.getClient().removeAllRoleActorsByProject(this.createTokenIfNecessary(token), projectKey);
    }

    public RemotePriority[] getPriorities(String token) {
        return this.getClient().getPriorities(this.createTokenIfNecessary(token));
    }

    public RemoteResolution[] getResolutions(String token) {
        return this.getClient().getResolutions(this.createTokenIfNecessary(token));
    }

    public RemoteIssueType[] getIssueTypes(String token) {
        return this.getClient().getIssueTypes(this.createTokenIfNecessary(token));
    }

    public RemoteStatus[] getStatuses(String token) {
        return this.getClient().getStatuses(this.createTokenIfNecessary(token));
    }

    public RemoteIssueType[] getIssueTypesForProject(String token, String projectId) {
        return this.getClient().getIssueTypesForProject(this.createTokenIfNecessary(token), projectId);
    }

    public RemoteProjectRole[] getProjectRoles(String token) {
        return this.getClient().getProjectRoles(this.createTokenIfNecessary(token));
    }

    public RemoteProjectRole getProjectRole(String token, Long projectRoleId) {
        return this.getClient().getProjectRole(this.createTokenIfNecessary(token), projectRoleId);
    }

    public RemoteProjectRoleActors getProjectRoleActors(String token, Long projectRoleId, String projectKey) {
        return this.getClient().getProjectRoleActors(this.createTokenIfNecessary(token), projectRoleId, projectKey);
    }

    public RemoteRoleActors getDefaultRoleActors(String token, Long projectRoleId) {
        return this.getClient().getDefaultRoleActors(this.createTokenIfNecessary(token), projectRoleId);
    }

    public void removeAllRoleActorsByNameAndType(String token, String name, String type) {
        this.getClient().removeAllRoleActorsByNameAndType(this.createTokenIfNecessary(token), name, type);
    }

    public void deleteProjectRole(String token, Long projectRoleId, Boolean confirm) {
        this.getClient().deleteProjectRole(this.createTokenIfNecessary(token), projectRoleId, confirm);
    }

    public void updateProjectRole(String token, Long projectRoleId, String projectRoleName, String projectRoleDescription) {
        this.getClient().updateProjectRole(this.createTokenIfNecessary(token), projectRoleId, projectRoleName, projectRoleDescription);
    }

    public RemoteProjectRole createProjectRole(String token, String projectRoleName, String projectRoleDescription) {
        return this.getClient().createProjectRole(this.createTokenIfNecessary(token), projectRoleName, projectRoleDescription);
    }

    public boolean isProjectRoleNameUnique(String token, String name) {
        return this.getClient().isProjectRoleNameUnique(this.createTokenIfNecessary(token), name);
    }

    public void releaseVersion(String token, String projectKey, String versionName) {
        this.getClient().releaseVersion(this.createTokenIfNecessary(token), projectKey, versionName);
    }

    public void addActorsToProjectRole(String token, String[] actors, Long projectRoleId, String projectKey, String actorType) {
        this.getClient().addActorsToProjectRole(this.createTokenIfNecessary(token), actors, projectRoleId, projectKey, actorType);
    }

    public void removeActorsFromProjectRole(String token, String[] actors, Long projectRoleId, String projectKey, String actorType) {
        this.getClient().removeActorsFromProjectRole(this.createTokenIfNecessary(token), actors, projectRoleId, projectKey, actorType);
    }

    public void addDefaultActorsToProjectRole(String token, String[] actors, Long projectRoleId, String type) {
        this.getClient().addDefaultActorsToProjectRole(this.createTokenIfNecessary(token), actors, projectRoleId, type);
    }

    public void removeDefaultActorsFromProjectRole(String token, String[] actors, Long remoteProjectRoleId, String type) {
        this.getClient().removeDefaultActorsFromProjectRole(this.createTokenIfNecessary(token), actors, remoteProjectRoleId, type);
    }

    public RemoteScheme[] getAssociatedNotificationSchemes(String token, Long projectRoleId) {
        return this.getClient().getAssociatedNotificationSchemes(this.createTokenIfNecessary(token), projectRoleId);
    }

    public RemoteScheme[] getAssociatedPermissionSchemes(String token, Long projectRoleId) {
        return this.getClient().getAssociatedPermissionSchemes(this.createTokenIfNecessary(token), projectRoleId);
    }

    public void deleteProject(String token, String projectKey) {
        this.getClient().deleteProject(this.createTokenIfNecessary(token), projectKey);
    }

    public RemoteProject getProjectById(String token, Long projectId) {
        return this.getClient().getProjectById(this.createTokenIfNecessary(token), projectId);
    }

    public RemoteVersion[] getVersions(String token, String projectKey) {
        return this.getClient().getVersions(this.createTokenIfNecessary(token), projectKey);
    }

    public RemoteComment[] getComments(String token, String issueKey) {
        return this.getClient().getComments(this.createTokenIfNecessary(token), issueKey);
    }

    public RemoteFilter[] getFavouriteFilters(String token) {
        return this.getClient().getFavouriteFilters(this.createTokenIfNecessary(token));
    }

    public void archiveVersion(String token, String projectKey, String versionName, Boolean archive) {
        this.getClient().archiveVersion(this.createTokenIfNecessary(token), projectKey, versionName, archive);
    }

    public RemoteField[] getFieldsForEdit(String token, String issueKey) {
        return this.getClient().getFieldsForEdit(this.createTokenIfNecessary(token), issueKey);
    }

    public RemoteIssueType[] getSubTaskIssueTypesForProject(String token, String projectId) {
        return this.getClient().getSubTaskIssueTypesForProject(this.createTokenIfNecessary(token), projectId);
    }

    public String login(String username, String password) {
        return this.getClient().login(username, password);
    }

    public RemoteSecurityLevel getSecurityLevel(String token, String issueKey) {
        return this.getClient().getSecurityLevel(this.createTokenIfNecessary(token), issueKey);
    }

    public RemoteField[] getCustomFields(String token) {
        return this.getClient().getCustomFields(this.createTokenIfNecessary(token));
    }

    public boolean logout(String token) {
        return this.getClient().logout(token);
    }

    public RemoteProject getProjectWithSchemesById(String token, Long projectId) {
        return this.getClient().getProjectWithSchemesById(this.createTokenIfNecessary(token), projectId);
    }

    public RemoteSecurityLevel[] getSecurityLevels(String token, String projectKey) {
        return this.getClient().getSecurityLevels(this.createTokenIfNecessary(token), projectKey);
    }

    public RemoteAvatar[] getProjectAvatars(String token, String projectKey, Boolean includeSystemAvatars) {
        return this.getClient().getProjectAvatars(this.createTokenIfNecessary(token), projectKey, includeSystemAvatars);
    }

    public void setProjectAvatar(String token, String projectKey, Long avatarId) {
        this.getClient().setProjectAvatar(this.createTokenIfNecessary(token), projectKey, avatarId);
    }

    public RemoteAvatar getProjectAvatar(String token, String projectKey) {
        return this.getClient().getProjectAvatar(this.createTokenIfNecessary(token), projectKey);
    }

    public void deleteProjectAvatar(String token, Long avatarId) {
        this.getClient().deleteProjectAvatar(this.createTokenIfNecessary(token), avatarId);
    }

    public RemoteScheme[] getNotificationSchemes(String token) {
        return this.getClient().getNotificationSchemes(this.createTokenIfNecessary(token));
    }

    public RemotePermissionScheme[] getPermissionSchemes(String token) {
        return this.getClient().getPermissionSchemes(this.createTokenIfNecessary(token));
    }

    public RemotePermission[] getAllPermissions(String token) {
        return this.getClient().getAllPermissions(this.createTokenIfNecessary(token));
    }

    public RemotePermissionScheme createPermissionScheme(String token, String name, String description) {
        return this.getClient().createPermissionScheme(this.createTokenIfNecessary(token), name, description);
    }

    public RemotePermissionScheme addPermissionTo(String token, String permissionSchemeName, Long permissionCode, String entityName) {
        return this.getClient().addPermissionTo(this.createTokenIfNecessary(token), permissionSchemeName, permissionCode, entityName);
    }

    public RemotePermissionScheme deletePermissionFrom(String token, String permissionSchemeName, Long permissionCode, String entityName) {
        return this.getClient().deletePermissionFrom(this.createTokenIfNecessary(token), permissionSchemeName, permissionCode, entityName);
    }

    public void deletePermissionScheme(String token, String permissionSchemeName) {
        this.getClient().deletePermissionScheme(this.createTokenIfNecessary(token), permissionSchemeName);
    }

    public RemoteAttachment[] getAttachmentsFromIssue(String token, String issueKey) {
        return this.getClient().getAttachmentsFromIssue(this.createTokenIfNecessary(token), issueKey);
    }

    public boolean hasPermissionToEditComment(String token, Long commentId) {
        return this.getClient().hasPermissionToEditComment(this.createTokenIfNecessary(token), commentId);
    }

    public RemoteComment editComment(String token, Long commentId, String body, String updateAuthor) {
        return this.getClient().editComment(this.createTokenIfNecessary(token), commentId, body, updateAuthor);
    }

    public RemoteField[] getFieldsForAction(String token, String issueKey, String actionIdString) {
        return this.getClient().getFieldsForAction(this.createTokenIfNecessary(token), issueKey, actionIdString);
    }

    public RemoteIssue getIssueById(String token, String issueId) {
        return this.getClient().getIssueById(this.createTokenIfNecessary(token), issueId);
    }

    public void deleteWorklogWithNewRemainingEstimate(String token, String workLogId, String newRemainingEstimate) {
        this.getClient().deleteWorklogWithNewRemainingEstimate(this.createTokenIfNecessary(token), workLogId, newRemainingEstimate);
    }

    public void deleteWorklogAndAutoAdjustRemainingEstimate(String token, String worklogId) {
        this.getClient().deleteWorklogAndAutoAdjustRemainingEstimate(this.createTokenIfNecessary(token), worklogId);
    }

    public void deleteWorklogAndRetainRemainingEstimate(String token, String worklogId) {
        this.getClient().deleteWorklogAndRetainRemainingEstimate(this.createTokenIfNecessary(token), worklogId);
    }

    public RemoteWorklog[] getWorklogs(String token, String issueKey) {
        return this.getClient().getWorklogs(this.createTokenIfNecessary(token), issueKey);
    }

    public boolean hasPermissionToCreateWorklog(String token, String issueKey) {
        return this.getClient().hasPermissionToCreateWorklog(this.createTokenIfNecessary(token), issueKey);
    }

    public boolean hasPermissionToDeleteWorklog(String token, String worklogId) {
        return this.getClient().hasPermissionToDeleteWorklog(this.createTokenIfNecessary(token), worklogId);
    }

    public boolean hasPermissionToUpdateWorklog(String token, String worklogId) {
        return this.getClient().hasPermissionToUpdateWorklog(this.createTokenIfNecessary(token), worklogId);
    }

    public void updateWorklogWithNewRemainingEstimate(String token, String issueKey, String worklogId, String newRemainingEstimate, String comment, String groupLevel, String roleLevelId) {
        this.getClient().updateWorklogWithNewRemainingEstimate(this.createTokenIfNecessary(token), issueKey, worklogId, comment, groupLevel, roleLevelId, newRemainingEstimate);
    }

    public RemoteVersion addVersion(String token, String projectKey, String versionName, Boolean archived, Boolean released, String releaseDate) {
        return this.getClient().addVersion(this.createTokenIfNecessary(token), projectKey, versionName, archived, released, releaseDate);
    }

    public Calendar getResolutionDateByKey(String token, String issueKey) {
        return this.getClient().getResolutionDateByKey(this.createTokenIfNecessary(token), issueKey);
    }

    public Calendar getResolutionDateById(String token, Long issueId) {
        return this.getClient().getResolutionDateById(this.createTokenIfNecessary(token), issueId);
    }

    public long getIssueCountForFilter(String token, String filterId) {
        return this.getClient().getIssueCountForFilter(this.createTokenIfNecessary(token), filterId);
    }

    public RemoteIssue[] getIssuesFromTextSearchWithProject(String token, String[] projectKeys, String searchTerms, Integer maxNumResults) {
        return this.getClient().getIssuesFromTextSearchWithProject(this.createTokenIfNecessary(token), projectKeys, searchTerms, maxNumResults);
    }

    public RemoteIssue[] getIssuesFromJqlSearch(String token, String jqlSearch, Integer maxNumResults) {
        return this.getClient().getIssuesFromJqlSearch(this.createTokenIfNecessary(token), jqlSearch, maxNumResults);
    }

    public void deleteUser(String token, String username) {
        this.getClient().deleteUser(this.createTokenIfNecessary(token), username);
    }

    public void deleteGroup(String token, String groupName, String swapGroupName) {
        this.getClient().deleteGroup(this.createTokenIfNecessary(token), groupName, swapGroupName);
    }

    public void refreshCustomFields(String token) {
        this.getClient().refreshCustomFields(this.createTokenIfNecessary(token));
    }

    public boolean addBase64EncodedAttachmentsToIssue(String token, String issueKey, String[] fileNames, String[] base64EncodedAttachmentData) {
        return this.getClient().addBase64EncodedAttachmentsToIssue(this.createTokenIfNecessary(token), issueKey, fileNames, base64EncodedAttachmentData);
    }

    public RemoteIssue[] getIssuesFromFilterWithLimit(String token, String filterId, Integer offset, Integer maxNumResults) {
        return this.getClient().getIssuesFromFilterWithLimit(this.createTokenIfNecessary(token), filterId, offset, maxNumResults);
    }

    public RemoteIssue[] getIssuesFromTextSearchWithLimit(String token, String searchTerms, Integer offset, Integer maxNumResults) {
        return this.getClient().getIssuesFromTextSearchWithLimit(this.createTokenIfNecessary(token), searchTerms, offset, maxNumResults);
    }

    public RemoteProject[] getProjectsNoSchemes(String token) {
        return this.getClient().getProjectsNoSchemes(this.createTokenIfNecessary(token));
    }

    public void setNewProjectAvatar(String token, String projectKey, String contentType, String base64ImageData) {
        this.getClient().setNewProjectAvatar(this.createTokenIfNecessary(token), projectKey, contentType, base64ImageData);
    }

    public RemoteIssue progressWorkflowAction(String token, String issueKey, String actionIdString, String[] fieldIds, String[] fieldsValues) {
        return this.getClient().progressWorkflowAction(this.createTokenIfNecessary(token), issueKey, actionIdString, fieldIds, fieldsValues);
    }

    public RemoteScheme[] getSecuritySchemes(String token) {
        return this.getClient().getSecuritySchemes(this.createTokenIfNecessary(token));
    }

    public synchronized JiraClient getClient() {
        if (this.client == null) {
            this.client = JiraClientFactory.getClient(this.address);
        }
        return this.client;
    }

    public void setClient(JiraClient client) {
        this.client = JiraClientAdaptor.adapt(client);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    private String createTokenIfNecessary(String token) {
        if (token != null) {
            return token;
        }
        return this.login(this.username, this.password);
    }
}

