/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jira;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import org.apache.axis.AxisFault;
import org.mule.module.jira.JiraCloudConnector;
import org.mule.module.jira.JiraCloudConnectorException;
import org.mule.module.jira.api.JiraClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JiraClientAdaptor {
    private static Logger log = LoggerFactory.getLogger(JiraCloudConnector.class);

    private JiraClientAdaptor() {
    }

    public static JiraClient adapt(final JiraClient receptor) {
        return (JiraClient)Proxy.newProxyInstance(JiraClientAdaptor.class.getClassLoader(), new Class[]{JiraClient.class}, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Entering {} with args {}", (Object)method.getName(), (Object)args);
                    }
                    Object ret = method.invoke((Object)receptor, args);
                    if (log.isDebugEnabled()) {
                        log.debug("Returning from {} with value {}", (Object)method.getName(), ret);
                    }
                    return ret;
                }
                catch (InvocationTargetException e) {
                    if (log.isWarnEnabled()) {
                        log.warn("An exception was thrown while invoking {}: {}", (Object)method.getName(), (Object)e.getCause());
                    }
                    throw JiraClientAdaptor.adaptException(e.getCause());
                }
            }
        });
    }

    private static Throwable adaptException(Throwable e) {
        if (e instanceof AxisFault) {
            return new JiraCloudConnectorException(((AxisFault)e).getFaultString(), e);
        }
        if (e instanceof RemoteException) {
            return new JiraCloudConnectorException(e);
        }
        return e;
    }
}

