/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.janrain.processors;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.MessageTransformer;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.TemplateParser;

public abstract class AbstractExpressionEvaluator {
    protected void computeClassHierarchy(Class clazz, List classes) {
        for (Class current = clazz; current != null; current = current.getSuperclass()) {
            if (classes.contains(current)) {
                return;
            }
            classes.add(current);
            for (Class<?> currentInterface : current.getInterfaces()) {
                this.computeClassHierarchy(currentInterface, classes);
            }
        }
    }

    protected boolean isListClass(Class clazz) {
        ArrayList classes = new ArrayList();
        this.computeClassHierarchy(clazz, classes);
        return classes.contains(List.class);
    }

    protected boolean isMapClass(Class clazz) {
        ArrayList classes = new ArrayList();
        this.computeClassHierarchy(clazz, classes);
        return classes.contains(Map.class);
    }

    protected boolean isList(Type type) {
        if (type instanceof Class && this.isListClass((Class)type)) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            return this.isList(((ParameterizedType)type).getRawType());
        }
        if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            return upperBounds.length != 0 && this.isList(upperBounds[0]);
        }
        return false;
    }

    protected boolean isMap(Type type) {
        if (type instanceof Class && this.isMapClass((Class)type)) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            return this.isMap(((ParameterizedType)type).getRawType());
        }
        if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            return upperBounds.length != 0 && this.isMap(upperBounds[0]);
        }
        return false;
    }

    protected boolean isAssignableFrom(Type expectedType, Class clazz) {
        Type[] upperBounds;
        if (expectedType instanceof Class) {
            if (((Class)expectedType).isPrimitive()) {
                if (((Class)expectedType).getName().equals("boolean") && clazz == Boolean.class) {
                    return true;
                }
                if (((Class)expectedType).getName().equals("byte") && clazz == Byte.class) {
                    return true;
                }
                if (((Class)expectedType).getName().equals("short") && clazz == Short.class) {
                    return true;
                }
                if (((Class)expectedType).getName().equals("char") && clazz == Character.class) {
                    return true;
                }
                if (((Class)expectedType).getName().equals("int") && clazz == Integer.class) {
                    return true;
                }
                if (((Class)expectedType).getName().equals("float") && clazz == Float.class) {
                    return true;
                }
                if (((Class)expectedType).getName().equals("long") && clazz == Long.class) {
                    return true;
                }
                return ((Class)expectedType).getName().equals("double") && clazz == Double.class;
            }
            return ((Class)expectedType).isAssignableFrom(clazz);
        }
        if (expectedType instanceof ParameterizedType) {
            return this.isAssignableFrom(((ParameterizedType)expectedType).getRawType(), clazz);
        }
        if (expectedType instanceof WildcardType && (upperBounds = ((WildcardType)expectedType).getUpperBounds()).length != 0) {
            return this.isAssignableFrom(upperBounds[0], clazz);
        }
        return false;
    }

    protected Object evaluate(TemplateParser.PatternInfo patternInfo, ExpressionManager expressionManager, MuleMessage muleMessage, Object source) {
        if (source instanceof String) {
            String stringSource = (String)source;
            if (stringSource.startsWith(patternInfo.getPrefix()) && stringSource.endsWith(patternInfo.getSuffix())) {
                return expressionManager.evaluate(stringSource, muleMessage);
            }
            return expressionManager.parse(stringSource, muleMessage);
        }
        return source;
    }

    protected Object evaluateAndTransform(MuleContext muleContext, MuleEvent event, Type expectedType, String expectedMimeType, Object source) throws TransformerException, TransformerMessagingException {
        if (source == null) {
            return source;
        }
        Cloneable target = null;
        if (this.isList(source.getClass())) {
            if (this.isList(expectedType)) {
                ArrayList<Object> newList = new ArrayList<Object>();
                Type valueType = ((ParameterizedType)expectedType).getActualTypeArguments()[0];
                ListIterator iterator = ((List)source).listIterator();
                while (iterator.hasNext()) {
                    Object subTarget = iterator.next();
                    newList.add(this.evaluateAndTransform(muleContext, event, valueType, expectedMimeType, subTarget));
                }
                target = newList;
            } else {
                target = source;
            }
        } else if (this.isMap(source.getClass())) {
            if (this.isMap(expectedType)) {
                Object keyType = Object.class;
                Object valueType = Object.class;
                if (expectedType instanceof ParameterizedType) {
                    keyType = ((ParameterizedType)expectedType).getActualTypeArguments()[0];
                    valueType = ((ParameterizedType)expectedType).getActualTypeArguments()[1];
                }
                Map map = (Map)((Object)source);
                HashMap<Object, Object> newMap = new HashMap<Object, Object>();
                Iterator i$ = map.entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry entryObj;
                    Map.Entry entry = entryObj = i$.next();
                    Object newKey = this.evaluateAndTransform(muleContext, event, (Type)keyType, expectedMimeType, entry.getKey());
                    Object newValue = this.evaluateAndTransform(muleContext, event, (Type)valueType, expectedMimeType, entry.getValue());
                    newMap.put(newKey, newValue);
                }
                target = newMap;
            } else {
                target = source;
            }
        } else {
            target = this.evaluate(TemplateParser.createMuleStyleParser().getStyle(), muleContext.getExpressionManager(), event.getMessage(), source);
        }
        return this.transform(muleContext, event, expectedType, expectedMimeType, (Object)target);
    }

    protected Object evaluateAndTransform(MuleContext muleContext, MuleMessage muleMessage, Type expectedType, String expectedMimeType, Object source) throws TransformerException, TransformerMessagingException {
        if (source == null) {
            return source;
        }
        Cloneable target = null;
        if (this.isList(source.getClass())) {
            if (this.isList(expectedType)) {
                ArrayList<Object> newList = new ArrayList<Object>();
                Type valueType = ((ParameterizedType)expectedType).getActualTypeArguments()[0];
                ListIterator iterator = ((List)source).listIterator();
                while (iterator.hasNext()) {
                    Object subTarget = iterator.next();
                    newList.add(this.evaluateAndTransform(muleContext, muleMessage, valueType, expectedMimeType, subTarget));
                }
                target = newList;
            } else {
                target = source;
            }
        } else if (this.isMap(source.getClass())) {
            if (this.isMap(expectedType)) {
                Object keyType = Object.class;
                Object valueType = Object.class;
                if (expectedType instanceof ParameterizedType) {
                    keyType = ((ParameterizedType)expectedType).getActualTypeArguments()[0];
                    valueType = ((ParameterizedType)expectedType).getActualTypeArguments()[1];
                }
                Map map = (Map)((Object)source);
                HashMap<Object, Object> newMap = new HashMap<Object, Object>();
                Iterator i$ = map.entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry entryObj;
                    Map.Entry entry = entryObj = i$.next();
                    Object newKey = this.evaluateAndTransform(muleContext, muleMessage, (Type)keyType, expectedMimeType, entry.getKey());
                    Object newValue = this.evaluateAndTransform(muleContext, muleMessage, (Type)valueType, expectedMimeType, entry.getValue());
                    newMap.put(newKey, newValue);
                }
                target = newMap;
            } else {
                target = source;
            }
        } else {
            target = this.evaluate(TemplateParser.createMuleStyleParser().getStyle(), muleContext.getExpressionManager(), muleMessage, source);
        }
        return this.transform(muleContext, muleMessage, expectedType, expectedMimeType, (Object)target);
    }

    protected Object transform(MuleMessage muleMessage, Type expectedType, Object source) throws TransformerException {
        Object valueType;
        if (source == null) {
            return source;
        }
        Cloneable target = null;
        if (this.isList(source.getClass())) {
            if (this.isList(expectedType)) {
                ArrayList<Object> newList = new ArrayList<Object>();
                valueType = ((ParameterizedType)expectedType).getActualTypeArguments()[0];
                ListIterator iterator = ((List)source).listIterator();
                while (iterator.hasNext()) {
                    Object subTarget = iterator.next();
                    newList.add(this.transform(muleMessage, (Type)valueType, subTarget));
                }
                target = newList;
            } else {
                target = source;
            }
        } else if (this.isMap(source.getClass())) {
            if (this.isMap(expectedType)) {
                Object keyType = Object.class;
                valueType = Object.class;
                if (expectedType instanceof ParameterizedType) {
                    keyType = ((ParameterizedType)expectedType).getActualTypeArguments()[0];
                    valueType = ((ParameterizedType)expectedType).getActualTypeArguments()[1];
                }
                Map map = (Map)((Object)source);
                HashMap<Object, Object> newMap = new HashMap<Object, Object>();
                Iterator i$ = map.entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry entryObj;
                    Map.Entry entry = entryObj = i$.next();
                    Object newKey = this.transform(muleMessage, (Type)keyType, entry.getKey());
                    Object newValue = this.transform(muleMessage, (Type)valueType, entry.getValue());
                    newMap.put(newKey, newValue);
                }
                target = newMap;
            } else {
                target = source;
            }
        } else {
            target = source;
        }
        if (target != null && !this.isAssignableFrom(expectedType, target.getClass())) {
            DataType sourceDataType = DataTypeFactory.create(target.getClass());
            if (expectedType instanceof ParameterizedType) {
                expectedType = ((ParameterizedType)expectedType).getRawType();
            }
            DataType targetDataType = DataTypeFactory.create((Class)((Class)expectedType));
            Transformer t = muleMessage.getMuleContext().getRegistry().lookupTransformer(sourceDataType, targetDataType);
            return t.transform(target);
        }
        return target;
    }

    protected Object transform(MuleContext muleContext, MuleEvent event, Type expectedType, String expectedMimeType, Object source) throws TransformerException, TransformerMessagingException {
        if (source != null && !this.isAssignableFrom(expectedType, source.getClass())) {
            DataType sourceDataType = DataTypeFactory.create(source.getClass());
            DataType targetDataType = null;
            if (expectedType instanceof ParameterizedType) {
                expectedType = ((ParameterizedType)expectedType).getRawType();
            }
            targetDataType = expectedMimeType != null ? DataTypeFactory.create((Class)((Class)expectedType), (String)expectedMimeType) : DataTypeFactory.create((Class)((Class)expectedType));
            Transformer t = muleContext.getRegistry().lookupTransformer(sourceDataType, targetDataType);
            if (t instanceof MessageTransformer) {
                return ((MessageTransformer)t).transform(source, event);
            }
            return t.transform(source);
        }
        return source;
    }

    protected Object transform(MuleContext muleContext, MuleMessage message, Type expectedType, String expectedMimeType, Object source) throws TransformerException, TransformerMessagingException {
        if (source != null && !this.isAssignableFrom(expectedType, source.getClass())) {
            DataType sourceDataType = DataTypeFactory.create(source.getClass());
            DataType targetDataType = null;
            if (expectedType instanceof ParameterizedType) {
                expectedType = ((ParameterizedType)expectedType).getRawType();
            }
            targetDataType = expectedMimeType != null ? DataTypeFactory.create((Class)((Class)expectedType), (String)expectedMimeType) : DataTypeFactory.create((Class)((Class)expectedType));
            Transformer t = muleContext.getRegistry().lookupTransformer(sourceDataType, targetDataType);
            return t.transform(source);
        }
        return source;
    }
}

