/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.janrain.process;

import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.modules.janrain.adapters.JanrainConnectorConnectionIdentifierAdapter;
import org.mule.modules.janrain.connection.ConnectionManager;
import org.mule.modules.janrain.connection.UnableToAcquireConnectionException;
import org.mule.modules.janrain.connection.UnableToReleaseConnectionException;
import org.mule.modules.janrain.connectivity.JanrainConnectorConnectionKey;
import org.mule.modules.janrain.process.ProcessCallback;
import org.mule.modules.janrain.process.ProcessInterceptor;
import org.mule.modules.janrain.processors.AbstractConnectedProcessor;
import org.mule.modules.janrain.processors.AbstractExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedConnectionProcessInterceptor<T>
extends AbstractExpressionEvaluator
implements ProcessInterceptor<T, JanrainConnectorConnectionIdentifierAdapter> {
    private static Logger logger = LoggerFactory.getLogger(ManagedConnectionProcessInterceptor.class);
    private final ConnectionManager<JanrainConnectorConnectionKey, JanrainConnectorConnectionIdentifierAdapter> connectionManager;
    private final MuleContext muleContext;
    private final ProcessInterceptor<T, JanrainConnectorConnectionIdentifierAdapter> next;

    public ManagedConnectionProcessInterceptor(ProcessInterceptor<T, JanrainConnectorConnectionIdentifierAdapter> next, ConnectionManager<JanrainConnectorConnectionKey, JanrainConnectorConnectionIdentifierAdapter> connectionManager, MuleContext muleContext) {
        this.next = next;
        this.connectionManager = connectionManager;
        this.muleContext = muleContext;
    }

    @Override
    public T execute(ProcessCallback<T, JanrainConnectorConnectionIdentifierAdapter> processCallback, JanrainConnectorConnectionIdentifierAdapter object, MessageProcessor messageProcessor, MuleEvent event) throws Exception {
        String _transformedApiKey;
        JanrainConnectorConnectionIdentifierAdapter connection = null;
        JanrainConnectorConnectionKey key = null;
        if (messageProcessor != null && messageProcessor instanceof AbstractConnectedProcessor && ((AbstractConnectedProcessor)messageProcessor).getApiKey() != null) {
            _transformedApiKey = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_apiKeyType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getApiKey());
            if (_transformedApiKey == null) {
                throw new UnableToAcquireConnectionException("Parameter apiKey in method connect can't be null because is not @Optional");
            }
            String _transformedAppName = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_appNameType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getAppName());
            if (_transformedAppName == null) {
                throw new UnableToAcquireConnectionException("Parameter appName in method connect can't be null because is not @Optional");
            }
            String _transformedAppId = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_appIdType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getAppId());
            if (_transformedAppId == null) {
                throw new UnableToAcquireConnectionException("Parameter appId in method connect can't be null because is not @Optional");
            }
            String _transformedCaptureHost = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_captureHostType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getCaptureHost());
            if (_transformedCaptureHost == null) {
                throw new UnableToAcquireConnectionException("Parameter captureHost in method connect can't be null because is not @Optional");
            }
            key = new JanrainConnectorConnectionKey(_transformedApiKey, _transformedAppName, _transformedAppId, _transformedCaptureHost);
        } else {
            key = this.connectionManager.getDefaultConnectionKey();
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Attempting to acquire connection using " + key.toString());
            }
            if ((connection = this.connectionManager.acquireConnection(key)) == null) {
                throw new UnableToAcquireConnectionException();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Connection has been acquired with [id=" + connection.getConnectionIdentifier() + "]");
            }
            _transformedApiKey = this.next.execute(processCallback, connection, messageProcessor, event);
            return (T)_transformedApiKey;
        }
        catch (Exception e) {
            if (processCallback.getManagedExceptions() != null) {
                for (Class exceptionClass : processCallback.getManagedExceptions()) {
                    if (!exceptionClass.isInstance(e)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("An exception ( " + exceptionClass.getName() + ") has been thrown. Destroying the connection with [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    try {
                        this.connectionManager.destroyConnection(key, connection);
                        connection = null;
                    }
                    catch (Exception innerException) {
                        logger.error(innerException.getMessage(), (Throwable)innerException);
                    }
                }
            }
            throw e;
        }
        finally {
            try {
                if (connection != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Releasing the connection back into the pool [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    this.connectionManager.releaseConnection(key, connection);
                }
            }
            catch (Exception e) {
                throw new UnableToReleaseConnectionException(e);
            }
        }
    }

    @Override
    public T execute(ProcessCallback<T, JanrainConnectorConnectionIdentifierAdapter> processCallback, JanrainConnectorConnectionIdentifierAdapter object, Filter filter, MuleMessage message) throws Exception {
        throw new UnsupportedOperationException();
    }
}

