/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.janrain.connectivity;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.modules.janrain.adapters.JanrainConnectorConnectionIdentifierAdapter;
import org.mule.modules.janrain.connectivity.JanrainConnectorConnectionKey;
import org.mule.modules.janrain.connectivity.JanrainConnectorConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JanrainConnectorConnectionFactory
implements KeyedPoolableObjectFactory {
    private static Logger logger = LoggerFactory.getLogger(JanrainConnectorConnectionFactory.class);
    private JanrainConnectorConnectionManager connectionManager;

    public JanrainConnectorConnectionFactory(JanrainConnectorConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public Object makeObject(Object key) throws Exception {
        if (!(key instanceof JanrainConnectorConnectionKey)) {
            if (key == null) {
                logger.warn("Connection key is null");
            } else {
                logger.warn("Cannot cast key of type ".concat(key.getClass().getName().concat(" to ").concat("org.mule.modules.janrain.connectivity.JanrainConnectorConnectionKey")));
            }
            throw new RuntimeException("Invalid key type ".concat(key.getClass().getName()));
        }
        JanrainConnectorConnectionIdentifierAdapter connector = new JanrainConnectorConnectionIdentifierAdapter();
        if (connector instanceof Initialisable) {
            connector.initialise();
        }
        if (connector instanceof MuleContextAware) {
            ((MuleContextAware)connector).setMuleContext(this.connectionManager.getMuleContext());
        }
        if (connector instanceof Startable) {
            connector.start();
        }
        if (!connector.isConnected()) {
            connector.connect(((JanrainConnectorConnectionKey)key).getApiKey(), ((JanrainConnectorConnectionKey)key).getAppName(), ((JanrainConnectorConnectionKey)key).getAppId(), ((JanrainConnectorConnectionKey)key).getCaptureHost());
        }
        return connector;
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        if (!(key instanceof JanrainConnectorConnectionKey)) {
            if (key == null) {
                logger.warn("Connection key is null");
            } else {
                logger.warn("Cannot cast key of type ".concat(key.getClass().getName().concat(" to ").concat("org.mule.modules.janrain.connectivity.JanrainConnectorConnectionKey")));
            }
            throw new RuntimeException("Invalid key type ".concat(key.getClass().getName()));
        }
        if (!(obj instanceof JanrainConnectorConnectionIdentifierAdapter)) {
            if (obj == null) {
                logger.warn("Connector is null");
            } else {
                logger.warn("Cannot cast connector of type ".concat(obj.getClass().getName().concat(" to ").concat("org.mule.modules.janrain.adapters.JanrainConnectorConnectionIdentifierAdapter")));
            }
            throw new RuntimeException("Invalid connector type ".concat(obj.getClass().getName()));
        }
        try {
            ((JanrainConnectorConnectionIdentifierAdapter)obj).disconnect();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if ((JanrainConnectorConnectionIdentifierAdapter)obj instanceof Stoppable) {
                ((Stoppable)obj).stop();
            }
            if ((JanrainConnectorConnectionIdentifierAdapter)obj instanceof Disposable) {
                ((Disposable)obj).dispose();
            }
        }
    }

    public boolean validateObject(Object key, Object obj) {
        if (!(obj instanceof JanrainConnectorConnectionIdentifierAdapter)) {
            if (obj == null) {
                logger.warn("Connector is null");
            } else {
                logger.warn("Cannot cast connector of type ".concat(obj.getClass().getName().concat(" to ").concat("org.mule.modules.janrain.adapters.JanrainConnectorConnectionIdentifierAdapter")));
            }
            throw new RuntimeException("Invalid connector type ".concat(obj.getClass().getName()));
        }
        try {
            return ((JanrainConnectorConnectionIdentifierAdapter)obj).isConnected();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void activateObject(Object key, Object obj) throws Exception {
        if (!(key instanceof JanrainConnectorConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        if (!(obj instanceof JanrainConnectorConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        if (!((JanrainConnectorConnectionIdentifierAdapter)obj).isConnected()) {
            ((JanrainConnectorConnectionIdentifierAdapter)obj).connect(((JanrainConnectorConnectionKey)key).getApiKey(), ((JanrainConnectorConnectionKey)key).getAppName(), ((JanrainConnectorConnectionKey)key).getAppId(), ((JanrainConnectorConnectionKey)key).getCaptureHost());
        }
    }

    public void passivateObject(Object key, Object obj) throws Exception {
    }
}

