/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.janrain.client;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.mule.modules.janrain.client.JanrainClientImpl;
import org.mule.modules.janrain.client.JanrainEngageClient;
import org.mule.modules.janrain.engage.AuthInfos;
import org.mule.modules.janrain.engage.AvailableProviders;
import org.mule.modules.janrain.engage.Backplane;
import org.mule.modules.janrain.engage.Broadcast;
import org.mule.modules.janrain.engage.Contacts;
import org.mule.modules.janrain.engage.Direct;
import org.mule.modules.janrain.engage.DomainPatterns;
import org.mule.modules.janrain.engage.Identifiers;
import org.mule.modules.janrain.engage.Plugin;
import org.mule.modules.janrain.engage.ShareProviders;
import org.mule.modules.janrain.engage.UserInfo;
import org.mule.modules.janrain.engage.WidgetProviders;
import org.mule.modules.janrain.exception.JanrainException;

public class JanrainEngageClientImpl
extends JanrainClientImpl
implements JanrainEngageClient {
    private static final String API_ENGAGE_URL = ".rpxnow.com/api/v2/";

    public JanrainEngageClientImpl(String appName, String appId, String apiKey, Client jerseyClient, Gson gson) {
        super(appName, appId, apiKey, gson);
        this.setApiResource(jerseyClient.resource("https://" + appName + API_ENGAGE_URL));
    }

    @Override
    public UserInfo authInfo(String token, Boolean extended, String tokenURL) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"apiKey", (Object)this.getApiKey());
        params.add((Object)"token", (Object)token);
        if (extended != null) {
            params.add((Object)"extended", (Object)extended.toString());
        }
        if (tokenURL != null) {
            params.add((Object)"tokenURL", (Object)tokenURL);
        }
        return (UserInfo)this.getGson().fromJson((String)this.execute("auth_info", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class), UserInfo.class);
    }

    @Override
    public boolean addOrUpdateAccessToken(String token, String identifier) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"apiKey", (Object)this.getApiKey());
        params.add((Object)"token", (Object)token);
        params.add((Object)"identifier", (Object)identifier);
        this.execute("add_or_update_access_token", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST");
        return true;
    }

    @Override
    public Map<String, String> analyticsAccess(String start, String end) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"apiKey", (Object)this.getApiKey());
        params.add((Object)"start", (Object)start);
        params.add((Object)"end", (Object)end);
        return (Map)this.getGson().fromJson((String)this.execute("analytics_access", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class), new TypeToken<Map<String, String>>(){}.getType());
    }

    @Override
    public Map<String, String> getAppSettings() {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"apiKey", (Object)this.getApiKey());
        return (Map)this.getGson().fromJson((String)this.execute("get_app_settings", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class), new TypeToken<Map<String, String>>(){}.getType());
    }

    @Override
    public AvailableProviders getAvailableProviders() {
        return (AvailableProviders)this.getGson().fromJson((String)this.execute("get_available_providers", null, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class), AvailableProviders.class);
    }

    @Override
    public Contacts getContacts(String identifier, String contactType, Boolean existingUser) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"apiKey", (Object)this.getApiKey());
        params.add((Object)"identifier", (Object)identifier);
        params.add((Object)"contactType", (Object)contactType);
        if (existingUser != null) {
            params.add((Object)"existingUser", (Object)existingUser.toString());
        }
        return (Contacts)this.getGson().fromJson((String)this.execute("get_contacts", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class), Contacts.class);
    }

    @Override
    public UserInfo getUserData(String identifier, Boolean extended) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"apiKey", (Object)this.getApiKey());
        params.add((Object)"identifier", (Object)identifier);
        if (extended != null) {
            params.add((Object)"existingUser", (Object)extended.toString());
        }
        return (UserInfo)this.getGson().fromJson((String)this.execute("get_user_data", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class), UserInfo.class);
    }

    @Override
    public WidgetProviders providers() {
        return (WidgetProviders)this.getGson().fromJson((String)this.execute("providers", null, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class), WidgetProviders.class);
    }

    @Override
    public boolean setAppSettings(String privacyPolicy, String favicon, String domainRedirect, Boolean postToTokenUrl, Boolean oneTimeUseTokens, Boolean googleProfileUrl) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"apiKey", (Object)this.getApiKey());
        if (privacyPolicy != null) {
            params.add((Object)"privacyPolicy", (Object)privacyPolicy);
        }
        if (favicon != null) {
            params.add((Object)"favicon", (Object)favicon);
        }
        if (domainRedirect != null) {
            params.add((Object)"domainRedirect", (Object)domainRedirect);
        }
        if (postToTokenUrl != null) {
            params.add((Object)"postToTokenUrl", (Object)postToTokenUrl.toString());
        }
        if (oneTimeUseTokens != null) {
            params.add((Object)"oneTimeUseTokens", (Object)oneTimeUseTokens.toString());
        }
        if (googleProfileUrl != null) {
            params.add((Object)"googleProfileUrl", (Object)googleProfileUrl.toString());
        }
        this.execute("set_app_settings", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST");
        return true;
    }

    @Override
    public boolean setAuthProviders(String providers, String deviceType) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"apiKey", (Object)this.getApiKey());
        params.add((Object)"providers", (Object)providers);
        if (deviceType != null) {
            params.add((Object)"device_type", (Object)deviceType);
        }
        this.execute("set_auth_providers", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST");
        return true;
    }

    @Override
    public String allMappings() {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"apiKey", (Object)this.getApiKey());
        return (String)this.execute("all_mappings", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class);
    }

    @Override
    public boolean map(String identifier, String primaryKey, Boolean overwrite) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"apiKey", (Object)this.getApiKey());
        params.add((Object)"identifier", (Object)identifier);
        params.add((Object)"primaryKey", (Object)primaryKey);
        if (overwrite != null) {
            params.add((Object)"overwrite", (Object)overwrite.toString());
        }
        this.execute("map", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST");
        return true;
    }

    @Override
    public Identifiers mappings(String primaryKey) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"apiKey", (Object)this.getApiKey());
        params.add((Object)"primaryKey", (Object)primaryKey);
        return (Identifiers)this.getGson().fromJson((String)this.execute("mappings", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class), Identifiers.class);
    }

    @Override
    public boolean unmap(String identifier, Boolean allIdentifiers, String primaryKey, Boolean unlink) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"apiKey", (Object)this.getApiKey());
        params.add((Object)"identifier", (Object)identifier);
        params.add((Object)"all_identifiers", (Object)allIdentifiers.toString());
        params.add((Object)"primaryKey", (Object)primaryKey);
        params.add((Object)"unlink", (Object)unlink.toString());
        this.execute("unmap", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST");
        return true;
    }

    @Override
    public Broadcast broadcast(String identifier, String deviceToken, String title, String url, String source, String message, String description, String image, String media, String actionLink, String objectId) {
        if (identifier == null && deviceToken == null || identifier != null && deviceToken != null) {
            throw new JanrainException("Broadcast requires either the identifier parameter or the deviceToken parameter.");
        }
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"apiKey", (Object)this.getApiKey());
        if (identifier != null) {
            params.add((Object)"identifier", (Object)identifier);
        }
        if (deviceToken != null) {
            params.add((Object)"device_token", (Object)deviceToken);
        }
        if (title != null) {
            params.add((Object)"title", (Object)title);
        }
        if (url != null) {
            params.add((Object)"url", (Object)url);
        }
        if (source != null) {
            params.add((Object)"source", (Object)source);
        }
        if (message != null) {
            params.add((Object)"message", (Object)message);
        }
        if (description != null) {
            params.add((Object)"description", (Object)description);
        }
        if (image != null) {
            params.add((Object)"image", (Object)image);
        }
        if (media != null) {
            params.add((Object)"media", (Object)media);
        }
        if (actionLink != null) {
            params.add((Object)"actionLink", (Object)actionLink);
        }
        if (objectId != null) {
            params.add((Object)"objectId", (Object)objectId);
        }
        return (Broadcast)this.getGson().fromJson((String)this.execute("sharing/broadcast", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class), Broadcast.class);
    }

    @Override
    public Direct direct(String identifier, String deviceToken, String title, String url, String recipients, String source, String message, String description, String image, String media, String actionLink, String recipientUrls) {
        if (identifier == null && deviceToken == null || identifier != null && deviceToken != null) {
            throw new JanrainException("Broadcast requires either the identifier parameter or the deviceToken parameter.");
        }
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"apiKey", (Object)this.getApiKey());
        params.add((Object)"recipients", (Object)recipients);
        if (identifier != null) {
            params.add((Object)"identifier", (Object)identifier);
        }
        if (deviceToken != null) {
            params.add((Object)"device_token", (Object)deviceToken);
        }
        if (title != null) {
            params.add((Object)"title", (Object)title);
        }
        if (url != null) {
            params.add((Object)"url", (Object)url);
        }
        if (source != null) {
            params.add((Object)"source", (Object)source);
        }
        if (message != null) {
            params.add((Object)"message", (Object)message);
        }
        if (description != null) {
            params.add((Object)"description", (Object)description);
        }
        if (image != null) {
            params.add((Object)"image", (Object)image);
        }
        if (media != null) {
            params.add((Object)"media", (Object)media);
        }
        if (actionLink != null) {
            params.add((Object)"actionLink", (Object)actionLink);
        }
        if (recipientUrls != null) {
            params.add((Object)"recipientUrls", (Object)recipientUrls);
        }
        return (Direct)this.getGson().fromJson((String)this.execute("sharing/direct", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class), Direct.class);
    }

    @Override
    public String getShareCount(String url, String callback) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"apiKey", (Object)this.getApiKey());
        params.add((Object)"url", (Object)url);
        if (callback != null) {
            params.add((Object)"callback", (Object)callback);
        }
        return (String)this.execute("get_share_count", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class);
    }

    @Override
    public ShareProviders getShareProviders() {
        return (ShareProviders)this.getGson().fromJson((String)this.execute("get_share_providers", null, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class), ShareProviders.class);
    }

    @Override
    public boolean setShareProviders(String share, String email) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"apiKey", (Object)this.getApiKey());
        params.add((Object)"share", (Object)share);
        if (email != null) {
            params.add((Object)"email", (Object)email);
        }
        this.execute("set_share_providers", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST");
        return true;
    }

    @Override
    public boolean addDomainPatterns(String domains) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"apiKey", (Object)this.getApiKey());
        params.add((Object)"domains", (Object)domains);
        this.execute("add_domain_patterns", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST");
        return true;
    }

    @Override
    public Backplane getBackplaneProperties() {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"apiKey", (Object)this.getApiKey());
        return (Backplane)this.getGson().fromJson((String)this.execute("get_backplane_properties", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class), Backplane.class);
    }

    @Override
    public DomainPatterns getDomainPatterns() {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"apiKey", (Object)this.getApiKey());
        return (DomainPatterns)this.getGson().fromJson((String)this.execute("get_domain_patterns", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class), DomainPatterns.class);
    }

    @Override
    public Plugin lookupRp(String pluginName, String pluginVersion) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"apiKey", (Object)this.getApiKey());
        if (pluginName != null) {
            params.add((Object)"pluginName", (Object)pluginName);
        }
        if (pluginVersion != null) {
            params.add((Object)"pluginVersion", (Object)pluginVersion);
        }
        return (Plugin)this.getGson().fromJson((String)this.execute("lookup_rp", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class), Plugin.class);
    }

    @Override
    public boolean setBackplaneProperties(String server, String bus, String version, Boolean remove, String username, String password) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"apiKey", (Object)this.getApiKey());
        params.add((Object)"server", (Object)server);
        params.add((Object)"bus", (Object)bus);
        params.add((Object)"username", (Object)username);
        params.add((Object)"password", (Object)password);
        if (version != null) {
            params.add((Object)"version", (Object)version);
        }
        if (remove != null) {
            params.add((Object)"remove", (Object)remove.toString());
        }
        this.execute("set_backplane_properties", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST");
        return true;
    }

    @Override
    public boolean setDomainPatterns(String domains) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"apiKey", (Object)this.getApiKey());
        params.add((Object)"domains", (Object)domains);
        this.execute("set_domain_patterns", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST");
        return true;
    }

    @Override
    public boolean activity(String activity, String identifier, String deviceToken, Boolean truncate, Boolean prependName, String urlShortening, String source) {
        if (identifier == null && deviceToken == null || identifier != null && deviceToken != null) {
            throw new JanrainException("Activity requires either the identifier parameter or the deviceToken parameter.");
        }
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"apiKey", (Object)this.getApiKey());
        params.add((Object)"activity", (Object)activity);
        if (identifier != null) {
            params.add((Object)"identifier", (Object)identifier);
        }
        if (deviceToken != null) {
            params.add((Object)"device_token", (Object)deviceToken);
        }
        if (truncate != null) {
            params.add((Object)"truncate", (Object)truncate.toString());
        }
        if (prependName != null) {
            params.add((Object)"prepend_name", (Object)prependName.toString());
        }
        if (urlShortening != null) {
            params.add((Object)"url_shortening", (Object)urlShortening);
        }
        if (source != null) {
            params.add((Object)"source", (Object)source);
        }
        this.execute("activity", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST");
        return true;
    }

    @Override
    public AuthInfos authInfos(String tokens, Boolean extended) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"apiKey", (Object)this.getApiKey());
        params.add((Object)"tokens", (Object)tokens);
        if (extended != null) {
            params.add((Object)"extended", (Object)extended.toString());
        }
        return (AuthInfos)this.getGson().fromJson((String)this.execute("auth_infos", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class), AuthInfos.class);
    }

    @Override
    public boolean setStatus(String identifier, String status, String location, Boolean truncate, String source) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"apiKey", (Object)this.getApiKey());
        params.add((Object)"identifier", (Object)identifier);
        params.add((Object)"status", (Object)status);
        if (location != null) {
            params.add((Object)"location", (Object)location);
        }
        if (truncate != null) {
            params.add((Object)"truncate", (Object)truncate.toString());
        }
        if (source != null) {
            params.add((Object)"source", (Object)source);
        }
        this.execute("set_status", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST");
        return true;
    }
}

