/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.janrain.client;

import com.google.gson.Gson;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.modules.janrain.exception.JanrainException;

public class JanrainClientImpl {
    private static final Log logger = LogFactory.getLog(JanrainClientImpl.class);
    private Gson gson;
    private String appId;
    private String apiKey;
    private String appName;
    private WebResource apiResource;

    public JanrainClientImpl(String appName, String appId, String apiKey, Gson gson) {
        this.appName = appName;
        this.apiKey = apiKey;
        this.appId = appId;
        this.gson = gson;
    }

    protected ClientResponse execute(String path, MultivaluedMap<String, String> params, MediaType type, String method) {
        ClientResponse response;
        if (params != null) {
            WebResource wr = this.getApiResource().path(path).queryParams(params);
            logger.debug((Object)("Calling url: " + wr.toString()));
            response = (ClientResponse)wr.accept(new MediaType[]{type}).method(method, ClientResponse.class);
        } else {
            response = (ClientResponse)this.getApiResource().path(path).accept(new MediaType[]{type}).method(method, ClientResponse.class);
        }
        if (response.getClientResponseStatus() != ClientResponse.Status.OK) {
            throw new JanrainException((String)response.getEntity(String.class));
        }
        return response;
    }

    public Gson getGson() {
        return this.gson;
    }

    public void setGson(Gson gson) {
        this.gson = gson;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public WebResource getApiResource() {
        return this.apiResource;
    }

    public void setApiResource(WebResource apiResource) {
        this.apiResource = apiResource;
    }
}

