/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.janrain.client;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.mule.modules.janrain.capture.BulkResponse;
import org.mule.modules.janrain.capture.ClientInfo;
import org.mule.modules.janrain.capture.ClientListInfo;
import org.mule.modules.janrain.client.JanrainCaptureClient;
import org.mule.modules.janrain.client.JanrainClientImpl;

public class JanrainCaptureClientImpl
extends JanrainClientImpl
implements JanrainCaptureClient {
    public JanrainCaptureClientImpl(String captureHost, String appId, String apiKey, Client jerseyClient, Gson gson) {
        super(captureHost, appId, apiKey, gson);
        this.setApiResource(jerseyClient.resource(captureHost));
    }

    @Override
    public ClientInfo addClient(String client_id, String client_secret, String description, String features) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"client_secret", (Object)client_secret);
        params.add((Object)"description", (Object)description);
        if (features != null) {
            params.add((Object)"features", (Object)features);
        }
        String result = (String)this.execute("clients/add", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class);
        return (ClientInfo)this.getGson().fromJson(result, ClientInfo.class);
    }

    @Override
    public boolean clearWhitelist(String client_id, String client_secret, String for_client_id) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"client_secret", (Object)client_secret);
        if (for_client_id != null) {
            params.add((Object)"for_client_id", (Object)for_client_id);
        }
        this.execute("clients/clear_whitelist", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST");
        return true;
    }

    @Override
    public boolean deleteClient(String client_id, String client_secret, String client_id_for_deletion) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"client_secret", (Object)client_secret);
        params.add((Object)"client_id_for_deletion", (Object)client_id_for_deletion);
        this.execute("clients/delete", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST");
        return true;
    }

    @Override
    public ClientListInfo listClients(String client_id, String client_secret, String has_features) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"client_secret", (Object)client_secret);
        if (has_features != null) {
            params.add((Object)"has_features", (Object)has_features);
        }
        return (ClientListInfo)this.getGson().fromJson((String)this.execute("clients/list", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class), ClientListInfo.class);
    }

    @Override
    public boolean setDescription(String client_id, String client_secret, String for_client_id, String description) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"client_secret", (Object)client_secret);
        params.add((Object)"description", (Object)description);
        if (for_client_id != null) {
            params.add((Object)"for_client_id", (Object)for_client_id);
        }
        this.execute("clients/set_description", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST");
        return true;
    }

    @Override
    public boolean setFeatures(String client_id, String client_secret, String for_client_id, String features) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"client_secret", (Object)client_secret);
        params.add((Object)"features", (Object)features);
        if (for_client_id != null) {
            params.add((Object)"for_client_id", (Object)for_client_id);
        }
        this.execute("clients/set_features", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST");
        return true;
    }

    @Override
    public boolean setWhitelist(String client_id, String client_secret, String for_client_id, String whitelist) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"client_secret", (Object)client_secret);
        params.add((Object)"whitelist", (Object)whitelist);
        if (for_client_id != null) {
            params.add((Object)"for_client_id", (Object)for_client_id);
        }
        this.execute("clients/set_whitelist", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST");
        return true;
    }

    @Override
    public String retrieveEntity(String client_secret, String client_id, String access_token, String uuid, String id, String key_attribute, String key_value, String password_attribute, String password_value, String type_name, String attribute_name, String attributes, String created, String last_updated) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"type_name", (Object)type_name);
        if (client_secret != null) {
            params.add((Object)"client_secret", (Object)client_secret);
        }
        if (client_id != null) {
            params.add((Object)"client_id", (Object)client_id);
        }
        if (access_token != null) {
            params.add((Object)"access_token", (Object)access_token);
        }
        if (uuid != null) {
            params.add((Object)"uuid", (Object)uuid);
        }
        if (id != null) {
            params.add((Object)"id", (Object)id);
        }
        if (key_attribute != null) {
            params.add((Object)"key_attribute", (Object)key_attribute);
        }
        if (key_value != null) {
            params.add((Object)"key_value", (Object)key_value);
        }
        if (password_attribute != null) {
            params.add((Object)"password_attribute", (Object)password_attribute);
        }
        if (password_value != null) {
            params.add((Object)"password_value", (Object)password_value);
        }
        if (attribute_name != null) {
            params.add((Object)"attribute_name", (Object)attribute_name);
        }
        if (attributes != null) {
            params.add((Object)"attributes", (Object)attributes);
        }
        if (created != null) {
            params.add((Object)"created", (Object)created);
        }
        if (last_updated != null) {
            params.add((Object)"last_updated", (Object)last_updated);
        }
        return (String)this.execute("entity", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class);
    }

    @Override
    public boolean entityAdopt(String client_secret, String client_id, String type_name, String id, String access_token, String attribute_name, String child_id) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"attribute_name", (Object)attribute_name);
        params.add((Object)"child_id", (Object)child_id);
        params.add((Object)"type_name", (Object)type_name);
        params.add((Object)"id", (Object)id);
        if (client_secret != null) {
            params.add((Object)"client_secret", (Object)client_secret);
        }
        if (client_id != null) {
            params.add((Object)"client_id", (Object)client_id);
        }
        if (access_token != null) {
            params.add((Object)"access_token", (Object)access_token);
        }
        this.execute("entity.adopt", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST");
        return true;
    }

    @Override
    public BulkResponse entityBulkCreate(String client_id, String client_secret, String type_name, String all_attributes) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"client_secret", (Object)client_secret);
        params.add((Object)"type_name", (Object)type_name);
        params.add((Object)"all_attributes", (Object)all_attributes);
        return (BulkResponse)this.getGson().fromJson((String)this.execute("entity.bulkCreate", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class), BulkResponse.class);
    }

    @Override
    public String entityCount(String client_id, String client_secret, String type_name, String filter) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"client_secret", (Object)client_secret);
        params.add((Object)"type_name", (Object)type_name);
        if (filter != null) {
            params.add((Object)"filter", (Object)filter);
        }
        return (String)this.execute("entity.count", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class);
    }

    @Override
    public Map<String, String> entityCreate(String client_id, String client_secret, String type_name, String attributes, Boolean include_record) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"client_secret", (Object)client_secret);
        params.add((Object)"attributes", (Object)attributes);
        if (type_name != null) {
            params.add((Object)"type_name", (Object)type_name);
        }
        if (include_record != null) {
            params.add((Object)"include_record", (Object)include_record.toString());
        }
        return (Map)this.getGson().fromJson((String)this.execute("entity.create", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class), new TypeToken<Map<String, String>>(){}.getType());
    }

    @Override
    public boolean entityDelete(String client_secret, String client_id, String access_token, String uuid, String id, String key_attribute, String key_value, String type_name, String attribute_name, String created, String last_updated) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"type_name", (Object)type_name);
        if (client_secret != null) {
            params.add((Object)"client_secret", (Object)client_secret);
        }
        if (client_id != null) {
            params.add((Object)"client_id", (Object)client_id);
        }
        if (access_token != null) {
            params.add((Object)"access_token", (Object)access_token);
        }
        if (uuid != null) {
            params.add((Object)"uuid", (Object)uuid);
        }
        if (id != null) {
            params.add((Object)"id", (Object)id);
        }
        if (key_attribute != null) {
            params.add((Object)"key_attribute", (Object)key_attribute);
        }
        if (key_value != null) {
            params.add((Object)"key_value", (Object)key_value);
        }
        if (attribute_name != null) {
            params.add((Object)"attribute_name", (Object)attribute_name);
        }
        if (created != null) {
            params.add((Object)"created", (Object)created);
        }
        if (last_updated != null) {
            params.add((Object)"last_updated", (Object)last_updated);
        }
        this.execute("entity.delete", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST");
        return true;
    }

    @Override
    public String entityBulkDelete(String client_id, String client_secret, String type_name, String filter, Boolean commit) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"client_secret", (Object)client_secret);
        params.add((Object)"type_name", (Object)type_name);
        params.add((Object)"filter", (Object)filter);
        if (commit != null) {
            params.add((Object)"commit", (Object)commit.toString());
        }
        return (String)this.execute("entity.bulkDelete", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class);
    }

    @Override
    public String entityPurge(String client_id, String client_secret, String type_name, Boolean commit) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"client_secret", (Object)client_secret);
        params.add((Object)"type_name", (Object)type_name);
        params.add((Object)"commit", (Object)commit.toString());
        return (String)this.execute("entity.purge", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class);
    }

    @Override
    public boolean entityReplace(String client_secret, String client_id, String access_token, String uuid, String id, String key_attribute, String key_value, String type_name, String value, String attribute_name, String created, String last_updated, Boolean include_record) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"type_name", (Object)type_name);
        params.add((Object)"value", (Object)value);
        if (client_secret != null) {
            params.add((Object)"client_secret", (Object)client_secret);
        }
        if (client_id != null) {
            params.add((Object)"client_id", (Object)client_id);
        }
        if (access_token != null) {
            params.add((Object)"access_token", (Object)access_token);
        }
        if (uuid != null) {
            params.add((Object)"uuid", (Object)uuid);
        }
        if (id != null) {
            params.add((Object)"id", (Object)id);
        }
        if (key_attribute != null) {
            params.add((Object)"key_attribute", (Object)key_attribute);
        }
        if (key_value != null) {
            params.add((Object)"key_value", (Object)key_value);
        }
        if (attribute_name != null) {
            params.add((Object)"attribute_name", (Object)attribute_name);
        }
        if (created != null) {
            params.add((Object)"created", (Object)created);
        }
        if (last_updated != null) {
            params.add((Object)"last_updated", (Object)last_updated);
        }
        if (include_record != null) {
            params.add((Object)"include_record", (Object)include_record.toString());
        }
        this.execute("entity.replace", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST");
        return true;
    }

    @Override
    public boolean entityUpdate(String client_secret, String client_id, String access_token, String uuid, String id, String key_attribute, String key_value, String type_name, String value, String attribute_name, String created, String last_updated, Boolean include_record) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"type_name", (Object)type_name);
        params.add((Object)"value", (Object)value);
        if (client_secret != null) {
            params.add((Object)"client_secret", (Object)client_secret);
        }
        if (client_id != null) {
            params.add((Object)"client_id", (Object)client_id);
        }
        if (access_token != null) {
            params.add((Object)"access_token", (Object)access_token);
        }
        if (uuid != null) {
            params.add((Object)"uuid", (Object)uuid);
        }
        if (id != null) {
            params.add((Object)"id", (Object)id);
        }
        if (key_attribute != null) {
            params.add((Object)"key_attribute", (Object)key_attribute);
        }
        if (key_value != null) {
            params.add((Object)"key_value", (Object)key_value);
        }
        if (attribute_name != null) {
            params.add((Object)"attribute_name", (Object)attribute_name);
        }
        if (created != null) {
            params.add((Object)"created", (Object)created);
        }
        if (last_updated != null) {
            params.add((Object)"last_updated", (Object)last_updated);
        }
        if (include_record != null) {
            params.add((Object)"include_record", (Object)include_record.toString());
        }
        this.execute("entity.update", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST");
        return true;
    }

    @Override
    public String entityFind(String client_secret, String client_id, String type_name, String filter, String max_results, String first_result, Boolean show_total_count, String sort_on, String attributes) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_secret", (Object)client_secret);
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"type_name", (Object)type_name);
        if (filter != null) {
            params.add((Object)"filter", (Object)filter);
        }
        if (max_results != null) {
            params.add((Object)"max_results", (Object)max_results);
        }
        if (first_result != null) {
            params.add((Object)"first_result", (Object)first_result);
        }
        if (show_total_count != null) {
            params.add((Object)"show_total_count", (Object)show_total_count.toString());
        }
        if (sort_on != null) {
            params.add((Object)"sort_on", (Object)sort_on);
        }
        if (attributes != null) {
            params.add((Object)"attributes", (Object)attributes);
        }
        return (String)this.execute("entity.find", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class);
    }

    @Override
    public boolean deleteSettings(String client_id, String client_secret, String key, String for_client_id) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"client_secret", (Object)client_secret);
        params.add((Object)"key", (Object)key);
        params.add((Object)"for_client_id", (Object)for_client_id);
        this.execute("settings/delete", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST");
        return true;
    }

    @Override
    public boolean deleteDefault(String client_id, String client_secret, String key) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"client_secret", (Object)client_secret);
        params.add((Object)"key", (Object)key);
        this.execute("settings/delete_default", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST");
        return true;
    }

    @Override
    public String getSettings(String client_id, String client_secret, String key, String for_client_id) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"client_secret", (Object)client_secret);
        params.add((Object)"key", (Object)key);
        params.add((Object)"for_client_id", (Object)for_client_id);
        return (String)this.execute("settings/get", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class);
    }

    @Override
    public String getMultisettings(String client_id, String client_secret, String key, String for_client_id) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"client_secret", (Object)client_secret);
        params.add((Object)"key", (Object)key);
        params.add((Object)"for_client_id", (Object)for_client_id);
        return (String)this.execute("settings/get_multi", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class);
    }

    @Override
    public String getItems(String client_id, String client_secret, String for_client_id) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"client_secret", (Object)client_secret);
        params.add((Object)"for_client_id", (Object)for_client_id);
        return (String)this.execute("settings/items", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class);
    }

    @Override
    public String getKeys(String client_id, String client_secret, String for_client_id) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"client_secret", (Object)client_secret);
        params.add((Object)"for_client_id", (Object)for_client_id);
        return (String)this.execute("settings/keys", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class);
    }

    @Override
    public String setSettings(String client_id, String client_secret, String key, String value, String for_client_id) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"client_secret", (Object)client_secret);
        params.add((Object)"key", (Object)key);
        params.add((Object)"value", (Object)value);
        params.add((Object)"for_client_id", (Object)for_client_id);
        return (String)this.execute("settings/set", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class);
    }

    @Override
    public String getDefault(String client_id, String client_secret, String key) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"client_secret", (Object)client_secret);
        params.add((Object)"key", (Object)key);
        return (String)this.execute("settings/get_default", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class);
    }

    @Override
    public boolean setDefault(String client_id, String client_secret, String key, String value) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"client_secret", (Object)client_secret);
        params.add((Object)"key", (Object)key);
        params.add((Object)"value", (Object)value);
        this.execute("settings/set_default", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST");
        return true;
    }

    @Override
    public String setMultisettings(String client_id, String client_secret, String items, String for_client_id) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"client_secret", (Object)client_secret);
        params.add((Object)"items", (Object)items);
        params.add((Object)"for_client_id", (Object)for_client_id);
        return (String)this.execute("settings/set_multi", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class);
    }

    @Override
    public String entityVersions(String type_name, String id, String timestamp, String client_id, String client_secret) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"client_secret", (Object)client_secret);
        params.add((Object)"timestamp", (Object)timestamp);
        params.add((Object)"id", (Object)id);
        params.add((Object)"type_name", (Object)type_name);
        return (String)this.execute("versions/entity", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class);
    }

    @Override
    public String getEntityType(String type_name, String timestamp, String client_id, String client_secret) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"client_secret", (Object)client_secret);
        params.add((Object)"timestamp", (Object)timestamp);
        params.add((Object)"type_name", (Object)type_name);
        return (String)this.execute("versions/entityType", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class);
    }

    @Override
    public String getAccessToken(String uuid, String id, String key_attribute, String key_value, String client_id, String client_secret, String type_name, String for_client_id) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"client_secret", (Object)client_secret);
        params.add((Object)"type_name", (Object)type_name);
        if (uuid != null) {
            params.add((Object)"uuid", (Object)uuid);
        }
        if (id != null) {
            params.add((Object)"id", (Object)id);
        }
        if (key_attribute != null) {
            params.add((Object)"key_attribute", (Object)key_attribute);
        }
        if (key_value != null) {
            params.add((Object)"key_value", (Object)key_value);
        }
        if (for_client_id != null) {
            params.add((Object)"for_client_id", (Object)for_client_id);
        }
        return (String)this.execute("access/getAccessToken", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class);
    }

    @Override
    public String getAuthorizationCode(String uuid, String id, String key_attribute, String key_value, String client_id, String client_secret, String redirect_uri, String type_name, String transaction_state, String lifetime, String for_client_id) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"client_secret", (Object)client_secret);
        params.add((Object)"type_name", (Object)type_name);
        params.add((Object)"redirect_uri", (Object)redirect_uri);
        if (uuid != null) {
            params.add((Object)"uuid", (Object)uuid);
        }
        if (id != null) {
            params.add((Object)"id", (Object)id);
        }
        if (key_attribute != null) {
            params.add((Object)"key_attribute", (Object)key_attribute);
        }
        if (key_value != null) {
            params.add((Object)"key_value", (Object)key_value);
        }
        if (for_client_id != null) {
            params.add((Object)"transaction_state", (Object)transaction_state);
        }
        if (lifetime != null) {
            params.add((Object)"lifetime", (Object)lifetime);
        }
        if (for_client_id != null) {
            params.add((Object)"for_client_id", (Object)for_client_id);
        }
        return (String)this.execute("access/getAuthorizationCode", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class);
    }

    @Override
    public String getCreationToken(String client_id, String client_secret, String type_name, String lifetime, String for_client_id) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"client_secret", (Object)client_secret);
        params.add((Object)"type_name", (Object)type_name);
        params.add((Object)"lifetime", (Object)lifetime);
        params.add((Object)"for_client_id", (Object)for_client_id);
        return (String)this.execute("access/getCreationToken", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class);
    }

    @Override
    public String getVerificationCode(String uuid, String id, String key_attribute, String key_value, String client_id, String client_secret, String type_name, String attribute_name, String lifetime) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"client_secret", (Object)client_secret);
        params.add((Object)"type_name", (Object)type_name);
        params.add((Object)"lifetime", (Object)lifetime);
        params.add((Object)"attribute_name", (Object)attribute_name);
        if (uuid != null) {
            params.add((Object)"uuid", (Object)uuid);
        }
        if (id != null) {
            params.add((Object)"id", (Object)id);
        }
        if (key_attribute != null) {
            params.add((Object)"key_attribute", (Object)key_attribute);
        }
        if (key_value != null) {
            params.add((Object)"key_value", (Object)key_value);
        }
        return (String)this.execute("access/getVerificationCode", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class);
    }

    @Override
    public boolean useVerificationCode(String verification_code) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"verification_code", (Object)verification_code);
        this.execute("access/useVerificationCode", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST");
        return true;
    }

    @Override
    public String webhooksAdd(String client_id, String client_secret, String attributes, String callback, String event_type, String entity_type) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"client_secret", (Object)client_secret);
        params.add((Object)"callback", (Object)callback);
        params.add((Object)"event_type", (Object)event_type);
        params.add((Object)"entity_type", (Object)entity_type);
        if (attributes != null) {
            params.add((Object)"attributes", (Object)attributes);
        }
        return (String)this.execute("webhooks/add", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class);
    }

    @Override
    public String webhooksDelete(String client_id, String client_secret, String uuid) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"client_secret", (Object)client_secret);
        params.add((Object)"uuid", (Object)uuid);
        return (String)this.execute("webhooks/delete", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class);
    }

    @Override
    public String webhooksFind(String client_id, String client_secret, String uuid) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"client_secret", (Object)client_secret);
        params.add((Object)"uuid", (Object)uuid);
        return (String)this.execute("webhooks/find", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class);
    }

    @Override
    public String webhooksList(String client_id, String client_secret) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"client_secret", (Object)client_secret);
        return (String)this.execute("webhooks/list", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class);
    }

    @Override
    public String webhooksUpdate(String client_id, String client_secret, String callback, String event_type, String entity_type, String attributes, String uuid) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"client_secret", (Object)client_secret);
        params.add((Object)"uuid", (Object)uuid);
        if (callback != null) {
            params.add((Object)"callback", (Object)callback);
        }
        if (event_type != null) {
            params.add((Object)"event_type", (Object)event_type);
        }
        if (entity_type != null) {
            params.add((Object)"entity_type", (Object)entity_type);
        }
        if (attributes != null) {
            params.add((Object)"attributes", (Object)attributes);
        }
        return (String)this.execute("webhooks/update", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class);
    }

    @Override
    public String authNative(String client_id, String locale, String response_type, String redirect_uri, String token, String thin_registration, String merge_token, String flow_name, String flow_version) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"locale", (Object)locale);
        params.add((Object)"response_type", (Object)response_type);
        params.add((Object)"redirect_uri", (Object)redirect_uri);
        params.add((Object)"token", (Object)token);
        if (thin_registration != null) {
            params.add((Object)"thin_registration", (Object)thin_registration);
        }
        if (merge_token != null) {
            params.add((Object)"merge_token", (Object)merge_token);
        }
        if (flow_name != null) {
            params.add((Object)"flow_name", (Object)flow_name);
        }
        if (flow_version != null) {
            params.add((Object)"flow_version", (Object)flow_version);
        }
        return (String)this.execute("oauth/auth_native", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class);
    }

    @Override
    public String authNativeTraditional(String client_id, String locale, String response_type, String redirect_uri, String email, String password, String form, String flow_name, String flow_version) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"locale", (Object)locale);
        params.add((Object)"response_type", (Object)response_type);
        params.add((Object)"redirect_uri", (Object)redirect_uri);
        params.add((Object)"email", (Object)email);
        params.add((Object)"password", (Object)password);
        params.add((Object)"form", (Object)form);
        if (flow_name != null) {
            params.add((Object)"flow_name", (Object)flow_name);
        }
        if (flow_version != null) {
            params.add((Object)"flow_version", (Object)flow_version);
        }
        return (String)this.execute("oauth/auth_native_traditional", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class);
    }

    @Override
    public String forgotPasswordNative(String client_id, String locale, String response_type, String redirect_uri, String form, String email, String flow_name, String flow_version) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"locale", (Object)locale);
        params.add((Object)"response_type", (Object)response_type);
        params.add((Object)"redirect_uri", (Object)redirect_uri);
        params.add((Object)"email", (Object)email);
        params.add((Object)"form", (Object)form);
        if (flow_name != null) {
            params.add((Object)"flow_name", (Object)flow_name);
        }
        if (flow_version != null) {
            params.add((Object)"flow_version", (Object)flow_version);
        }
        return (String)this.execute("oauth/forgot_password_native", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class);
    }

    @Override
    public String linkAccountNative(String client_id, String locale, String response_type, String redirect_uri, String token, String flow_name, String flow_version) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"locale", (Object)locale);
        params.add((Object)"response_type", (Object)response_type);
        params.add((Object)"redirect_uri", (Object)redirect_uri);
        params.add((Object)"token", (Object)token);
        if (flow_name != null) {
            params.add((Object)"flow_name", (Object)flow_name);
        }
        if (flow_version != null) {
            params.add((Object)"flow_version", (Object)flow_version);
        }
        return (String)this.execute("oauth/link_account_native", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class);
    }

    @Override
    public String registerNative(String client_id, String locale, String response_type, String redirect_uri, String token, String flow_name, String flow_version) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"locale", (Object)locale);
        params.add((Object)"response_type", (Object)response_type);
        params.add((Object)"redirect_uri", (Object)redirect_uri);
        params.add((Object)"token", (Object)token);
        if (flow_name != null) {
            params.add((Object)"flow_name", (Object)flow_name);
        }
        if (flow_version != null) {
            params.add((Object)"flow_version", (Object)flow_version);
        }
        return (String)this.execute("oauth/register_native", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class);
    }

    @Override
    public String verifyEmailNative(String client_id, String locale, String response_type, String redirect_uri, String form, String email, String flow_name, String flow_version) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"locale", (Object)locale);
        params.add((Object)"response_type", (Object)response_type);
        params.add((Object)"redirect_uri", (Object)redirect_uri);
        params.add((Object)"form", (Object)form);
        params.add((Object)"email", (Object)email);
        if (flow_name != null) {
            params.add((Object)"flow_name", (Object)flow_name);
        }
        if (flow_version != null) {
            params.add((Object)"flow_version", (Object)flow_version);
        }
        return (String)this.execute("oauth/verify_email_native", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class);
    }

    @Override
    public String getToken(String client_id, String client_secret, String grant_type, String code, String redirect_uri, String refresh_token) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"client_secret", (Object)client_secret);
        params.add((Object)"grant_type", (Object)grant_type);
        params.add((Object)"code", (Object)code);
        params.add((Object)"redirect_uri", (Object)redirect_uri);
        if (refresh_token != null) {
            params.add((Object)"refresh_token", (Object)refresh_token);
        }
        return (String)this.execute("oauth/token", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class);
    }

    @Override
    public String registerNativeTraditional(String client_id, String locale, String response_type, String redirect_uri, String password, String password_confirm, String email, String flow_name, String flow_version) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"client_id", (Object)client_id);
        params.add((Object)"redirect_uri", (Object)redirect_uri);
        params.add((Object)"response_type", (Object)response_type);
        params.add((Object)"email", (Object)email);
        params.add((Object)"password", (Object)password);
        params.add((Object)"password_confirm", (Object)password_confirm);
        params.add((Object)"locale", (Object)locale);
        if (flow_name != null) {
            params.add((Object)"flow_name", (Object)flow_name);
        }
        if (flow_version != null) {
            params.add((Object)"flow_version", (Object)flow_version);
        }
        return (String)this.execute("oauth/register_native_traditional", (MultivaluedMap<String, String>)params, MediaType.APPLICATION_JSON_TYPE, "POST").getEntity(String.class);
    }
}

