/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.janrain;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.core.impl.provider.entity.FormMultivaluedMapProvider;
import com.sun.jersey.core.impl.provider.entity.FormProvider;
import com.sun.jersey.core.impl.provider.entity.InputStreamProvider;
import com.sun.jersey.core.impl.provider.entity.MimeMultipartProvider;
import com.sun.jersey.multipart.impl.MultiPartWriter;
import java.util.Map;
import org.mule.api.ConnectionException;
import org.mule.modules.janrain.capture.BulkResponse;
import org.mule.modules.janrain.capture.ClientInfo;
import org.mule.modules.janrain.capture.ClientListInfo;
import org.mule.modules.janrain.client.JanrainCaptureClient;
import org.mule.modules.janrain.client.JanrainCaptureClientImpl;
import org.mule.modules.janrain.client.JanrainEngageClient;
import org.mule.modules.janrain.client.JanrainEngageClientImpl;
import org.mule.modules.janrain.client.JanrainPartnerClient;
import org.mule.modules.janrain.client.JanrainPartnerClientImpl;
import org.mule.modules.janrain.engage.AuthInfos;
import org.mule.modules.janrain.engage.AvailableProviders;
import org.mule.modules.janrain.engage.Backplane;
import org.mule.modules.janrain.engage.Broadcast;
import org.mule.modules.janrain.engage.Contacts;
import org.mule.modules.janrain.engage.Direct;
import org.mule.modules.janrain.engage.DomainPatterns;
import org.mule.modules.janrain.engage.Identifiers;
import org.mule.modules.janrain.engage.Plugin;
import org.mule.modules.janrain.engage.ShareProviders;
import org.mule.modules.janrain.engage.UserInfo;
import org.mule.modules.janrain.engage.WidgetProviders;
import org.mule.modules.janrain.partner.Admins;
import org.mule.modules.janrain.partner.AppInfo;
import org.mule.modules.janrain.partner.Apps;
import org.mule.modules.janrain.partner.Invites;
import org.mule.modules.janrain.partner.Permissions;

public class JanrainConnector {
    private String appName;
    private String appId;
    private String captureHost;
    private String apiKey;
    private JanrainEngageClient janrainEngageClient;
    private JanrainPartnerClient janrainPartnerClient;
    private JanrainCaptureClient janrainCaptureClient;
    private Client jerseyClient;
    private Gson gson;

    public void connect(String apiKey, String appName, String appId, String captureHost) throws ConnectionException {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        clientConfig.getClasses().add(MultiPartWriter.class);
        clientConfig.getClasses().add(MimeMultipartProvider.class);
        clientConfig.getClasses().add(InputStreamProvider.class);
        clientConfig.getClasses().add(FormProvider.class);
        clientConfig.getClasses().add(FormMultivaluedMapProvider.class);
        this.setAppId(appId);
        this.setApiKey(apiKey);
        this.setAppName(appName);
        this.setCaptureHost(captureHost);
        this.gson = new GsonBuilder().create();
        this.setJerseyClient(Client.create((ClientConfig)clientConfig));
    }

    public void disconnect() {
        this.jerseyClient = null;
        this.janrainEngageClient = null;
        this.janrainPartnerClient = null;
        this.janrainCaptureClient = null;
    }

    public boolean isConnected() {
        return this.jerseyClient != null && this.janrainEngageClient != null && this.janrainPartnerClient != null && this.janrainCaptureClient != null;
    }

    public String connectionId() {
        return this.apiKey;
    }

    public UserInfo authInfo(String token, Boolean extended, String tokenURL) {
        return this.getJanrainEngageClient().authInfo(token, extended, tokenURL);
    }

    public boolean addOrUpdateAccessToken(String token, String identifier) {
        return this.getJanrainEngageClient().addOrUpdateAccessToken(token, identifier);
    }

    public Map<String, String> analyticsAccess(String start, String end) {
        return this.getJanrainEngageClient().analyticsAccess(start, end);
    }

    public Map<String, String> getAppSettings() {
        return this.getJanrainEngageClient().getAppSettings();
    }

    public AvailableProviders getAvailableProviders() {
        return this.getJanrainEngageClient().getAvailableProviders();
    }

    public Contacts getContacts(String identifier, String contactType, Boolean existingUser) {
        return this.getJanrainEngageClient().getContacts(identifier, contactType, existingUser);
    }

    public UserInfo getUserData(String identifier, Boolean extended) {
        return this.getJanrainEngageClient().getUserData(identifier, extended);
    }

    public WidgetProviders providers() {
        return this.getJanrainEngageClient().providers();
    }

    public boolean setAppSettings(String privacyPolicy, String favicon, String domainRedirect, Boolean postToTokenUrl, Boolean oneTimeUseTokens, Boolean googleProfileUrl) {
        return this.getJanrainEngageClient().setAppSettings(privacyPolicy, favicon, domainRedirect, postToTokenUrl, oneTimeUseTokens, googleProfileUrl);
    }

    public boolean setAuthProviders(String providers, String deviceType) {
        return this.getJanrainEngageClient().setAuthProviders(providers, deviceType);
    }

    public String allMappings() {
        return this.getJanrainEngageClient().allMappings();
    }

    public boolean map(String identifier, String primaryKey, Boolean overwrite) {
        return this.getJanrainEngageClient().map(identifier, primaryKey, overwrite);
    }

    public Identifiers mappings(String primaryKey) {
        return this.getJanrainEngageClient().mappings(primaryKey);
    }

    public boolean unmap(String identifier, Boolean allIdentifiers, String primaryKey, Boolean unlink) {
        return this.getJanrainEngageClient().unmap(identifier, allIdentifiers, primaryKey, unlink);
    }

    public Broadcast broadcast(String identifier, String deviceToken, String title, String url, String source, String message, String description, String image, String media, String actionLink, String objectId) {
        return this.getJanrainEngageClient().broadcast(identifier, deviceToken, title, url, source, message, description, image, media, actionLink, objectId);
    }

    public Direct direct(String identifier, String deviceToken, String title, String url, String recipients, String source, String message, String description, String image, String media, String actionLink, String recipientUrls) {
        return this.getJanrainEngageClient().direct(identifier, deviceToken, title, url, recipients, source, message, description, image, media, actionLink, recipientUrls);
    }

    public String getShareCount(String url, String callback) {
        return this.getJanrainEngageClient().getShareCount(url, callback);
    }

    public ShareProviders getShareProviders() {
        return this.getJanrainEngageClient().getShareProviders();
    }

    public boolean setShareProviders(String share, String email) {
        return this.getJanrainEngageClient().setShareProviders(share, email);
    }

    public boolean addDomainPatterns(String domains) {
        return this.getJanrainEngageClient().addDomainPatterns(domains);
    }

    public Backplane getBackplaneProperties() {
        return this.getJanrainEngageClient().getBackplaneProperties();
    }

    public DomainPatterns getDomainPatterns() {
        return this.getJanrainEngageClient().getDomainPatterns();
    }

    public Plugin lookupRp(String pluginName, String pluginVersion) {
        return this.getJanrainEngageClient().lookupRp(pluginName, pluginVersion);
    }

    public boolean setBackplaneProperties(String server, String bus, String version, Boolean remove, String username, String password) {
        return this.getJanrainEngageClient().setBackplaneProperties(server, bus, version, remove, username, password);
    }

    public boolean setDomainPatterns(String domains) {
        return this.getJanrainEngageClient().setDomainPatterns(domains);
    }

    public boolean activity(String activity, String identifier, String deviceToken, Boolean truncate, Boolean prependName, String urlShortening, String source) {
        return this.getJanrainEngageClient().activity(activity, identifier, deviceToken, truncate, prependName, urlShortening, source);
    }

    public AuthInfos authInfos(String tokens, Boolean extended) {
        return this.getJanrainEngageClient().authInfos(tokens, extended);
    }

    public boolean setStatus(String identifier, String status, String location, Boolean truncate, String source) {
        return this.getJanrainEngageClient().setStatus(identifier, status, location, truncate, source);
    }

    public Map<String, String> addBpBus(String partnerKey) {
        return this.getJanrainPartnerClient().addBpBus(partnerKey);
    }

    public Apps apps(String partnerKey) {
        return this.getJanrainPartnerClient().apps(partnerKey);
    }

    public boolean addAdmin(String partnerKey, String email, Boolean verify) {
        return this.getJanrainPartnerClient().addAdmin(partnerKey, email, verify);
    }

    public boolean deleteAdmin(String partnerKey, String email) {
        return this.getJanrainPartnerClient().deleteAdmin(partnerKey, email);
    }

    public Admins getAdmins(String partnerKey) {
        return this.getJanrainPartnerClient().getAdmins(partnerKey);
    }

    public boolean addDomain(String partnerKey, String engageApiKey, String domain) {
        return this.getJanrainPartnerClient().addDomain(partnerKey, engageApiKey, domain);
    }

    public AppInfo createApp(String partnerKey, String email, String displayName, String domain) {
        return this.getJanrainPartnerClient().createApp(partnerKey, email, displayName, domain);
    }

    public String createInvite(String engageApiKey, String partnerKey, String email) {
        return this.getJanrainPartnerClient().createInvite(engageApiKey, partnerKey, email);
    }

    public boolean deleteApp(String engageApiKey, String partnerKey) {
        return this.getJanrainPartnerClient().deleteApp(engageApiKey, partnerKey);
    }

    public Invites getPendingInvites(String engageApiKey, String partnerKey) {
        return this.getJanrainPartnerClient().getPendingInvites(engageApiKey, partnerKey);
    }

    public Map<String, String> getProperties(String partnerKey, String engageApiKey, String provider) {
        return this.getJanrainPartnerClient().getProperties(engageApiKey, partnerKey, provider);
    }

    public Permissions getProviderPermissions(String partnerKey, String engageApiKey, String provider) {
        return this.getJanrainPartnerClient().getProviderPermissions(engageApiKey, partnerKey, provider);
    }

    public String resetApiKey(String rpAppId, String partnerKey) {
        return this.getJanrainPartnerClient().resetApiKey(rpAppId, partnerKey);
    }

    public boolean setProperties(String engageApiKey, String partnerKey, String provider, String fbAppID, String fbSecret, Boolean emailPerm, String uninstallURL, String consumerKey, String secret, String paypalDisplayName, String email, String liveidAppID, String liveidSecret, String liveidPrivacyPolicyUrl, String yahooAppID, Boolean activityScopesSet, Boolean contactsScopeSet) {
        return this.getJanrainPartnerClient().setProperties(engageApiKey, partnerKey, provider, fbAppID, fbSecret, emailPerm, uninstallURL, consumerKey, secret, paypalDisplayName, email, liveidAppID, liveidSecret, liveidPrivacyPolicyUrl, yahooAppID, activityScopesSet, contactsScopeSet);
    }

    public boolean setProviderPermissions(String engageApiKey, String partnerKey, String provider, String permissions) {
        return this.getJanrainPartnerClient().setProviderPermissions(engageApiKey, partnerKey, provider, permissions);
    }

    public boolean verifyDomain(String engageApiKey, String partnerKey, String provider, String code, String filename) {
        return this.getJanrainPartnerClient().verifyDomain(engageApiKey, partnerKey, provider, code, filename);
    }

    public ClientInfo addClient(String client_id, String client_secret, String description, String features) {
        return this.getJanrainCaptureClient().addClient(client_id, client_secret, description, features);
    }

    public boolean clearWhitelist(String client_id, String client_secret, String for_client_id) {
        return this.getJanrainCaptureClient().clearWhitelist(client_id, client_secret, for_client_id);
    }

    public boolean deleteClient(String client_id, String client_secret, String client_id_for_deletion) {
        return this.getJanrainCaptureClient().deleteClient(client_id, client_secret, client_id_for_deletion);
    }

    public ClientListInfo listClients(String client_id, String client_secret, String has_features) {
        return this.getJanrainCaptureClient().listClients(client_id, client_secret, has_features);
    }

    public boolean setDescription(String client_id, String client_secret, String for_client_id, String description) {
        return this.getJanrainCaptureClient().setDescription(client_id, client_secret, for_client_id, description);
    }

    public boolean setFeatures(String client_id, String client_secret, String for_client_id, String features) {
        return this.getJanrainCaptureClient().setFeatures(client_id, client_secret, for_client_id, features);
    }

    public boolean setWhitelist(String client_id, String client_secret, String for_client_id, String whitelist) {
        return this.getJanrainCaptureClient().setWhitelist(client_id, client_secret, for_client_id, whitelist);
    }

    public String retrieveEntity(String client_secret, String client_id, String access_token, String uuid, String id, String key_attribute, String key_value, String password_attribute, String password_value, String type_name, String attribute_name, String attributes, String created, String last_updated) {
        return this.getJanrainCaptureClient().retrieveEntity(client_secret, client_id, access_token, uuid, id, key_attribute, key_value, password_attribute, password_value, type_name, attribute_name, attributes, created, last_updated);
    }

    public boolean entityAdopt(String client_secret, String client_id, String type_name, String id, String access_token, String attribute_name, String child_id) {
        return this.getJanrainCaptureClient().entityAdopt(client_secret, client_id, type_name, id, access_token, attribute_name, child_id);
    }

    public BulkResponse entityBulkCreate(String client_id, String client_secret, String type_name, String all_attributes) {
        return this.getJanrainCaptureClient().entityBulkCreate(client_id, client_secret, type_name, all_attributes);
    }

    public String entityCount(String client_id, String client_secret, String type_name, String filter) {
        return this.getJanrainCaptureClient().entityCount(client_id, client_secret, type_name, filter);
    }

    public Map<String, String> entityCreate(String client_id, String client_secret, String type_name, String attributes, Boolean include_record) {
        return this.getJanrainCaptureClient().entityCreate(client_id, client_secret, type_name, attributes, include_record);
    }

    public boolean entityDelete(String client_secret, String client_id, String access_token, String uuid, String id, String key_attribute, String key_value, String type_name, String attribute_name, String created, String last_updated) {
        return this.getJanrainCaptureClient().entityDelete(client_secret, client_id, access_token, uuid, id, key_attribute, key_value, type_name, attribute_name, created, last_updated);
    }

    public String entityBulkDelete(String client_id, String client_secret, String type_name, String filter, Boolean commit) {
        return this.getJanrainCaptureClient().entityBulkDelete(client_id, client_secret, type_name, filter, commit);
    }

    public String entityPurge(String client_id, String client_secret, String type_name, Boolean commit) {
        return this.getJanrainCaptureClient().entityPurge(client_id, client_secret, type_name, commit);
    }

    public boolean entityReplace(String client_secret, String client_id, String access_token, String uuid, String id, String key_attribute, String key_value, String type_name, String value, String attribute_name, String created, String last_updated, Boolean include_record) {
        return this.getJanrainCaptureClient().entityReplace(client_secret, client_id, access_token, uuid, id, key_attribute, key_value, type_name, value, attribute_name, created, last_updated, include_record);
    }

    public boolean entityUpdate(String client_secret, String client_id, String access_token, String uuid, String id, String key_attribute, String key_value, String type_name, String value, String attribute_name, String created, String last_updated, Boolean include_record) {
        return this.getJanrainCaptureClient().entityUpdate(client_secret, client_id, access_token, uuid, id, key_attribute, key_value, type_name, value, attribute_name, created, last_updated, include_record);
    }

    public String entityFind(String client_secret, String client_id, String type_name, String filter, String max_results, String first_result, Boolean show_total_count, String sort_on, String attributes) {
        return this.getJanrainCaptureClient().entityFind(client_secret, client_id, type_name, filter, max_results, first_result, show_total_count, sort_on, attributes);
    }

    public boolean deleteSettings(String client_id, String client_secret, String key, String for_client_id) {
        return this.getJanrainCaptureClient().deleteSettings(client_id, client_secret, key, for_client_id);
    }

    public boolean deleteDefault(String client_id, String client_secret, String key) {
        return this.getJanrainCaptureClient().deleteDefault(client_id, client_secret, key);
    }

    public String getSettings(String client_id, String client_secret, String key, String for_client_id) {
        return this.getJanrainCaptureClient().getSettings(client_id, client_secret, key, for_client_id);
    }

    public String getMultisettings(String client_id, String client_secret, String key, String for_client_id) {
        return this.getJanrainCaptureClient().getMultisettings(client_id, client_secret, key, for_client_id);
    }

    public String getItems(String client_id, String client_secret, String for_client_id) {
        return this.getJanrainCaptureClient().getItems(client_id, client_secret, for_client_id);
    }

    public String getKeys(String client_id, String client_secret, String for_client_id) {
        return this.getJanrainCaptureClient().getKeys(client_id, client_secret, for_client_id);
    }

    public String setSettings(String client_id, String client_secret, String key, String value, String for_client_id) {
        return this.getJanrainCaptureClient().setSettings(client_id, client_secret, key, value, for_client_id);
    }

    public String getDefault(String client_id, String client_secret, String key) {
        return this.getJanrainCaptureClient().getDefault(client_id, client_secret, key);
    }

    public boolean setDefault(String client_id, String client_secret, String key, String value) {
        return this.getJanrainCaptureClient().setDefault(client_id, client_secret, key, value);
    }

    public String setMultisettings(String client_id, String client_secret, String items, String for_client_id) {
        return this.getJanrainCaptureClient().setMultisettings(client_id, client_secret, items, for_client_id);
    }

    public String entityVersions(String type_name, String id, String timestamp, String client_id, String client_secret) {
        return this.getJanrainCaptureClient().entityVersions(type_name, id, timestamp, client_id, client_secret);
    }

    public String getEntityType(String type_name, String timestamp, String client_id, String client_secret) {
        return this.getJanrainCaptureClient().getEntityType(type_name, timestamp, client_id, client_secret);
    }

    public String getAccessToken(String uuid, String id, String key_attribute, String key_value, String client_id, String client_secret, String type_name, String for_client_id) {
        return this.getJanrainCaptureClient().getAccessToken(uuid, id, key_attribute, key_value, client_id, client_secret, type_name, for_client_id);
    }

    public String getAuthorizationCode(String uuid, String id, String key_attribute, String key_value, String client_id, String client_secret, String redirect_uri, String type_name, String transaction_state, String lifetime, String for_client_id) {
        return this.getJanrainCaptureClient().getAuthorizationCode(uuid, id, key_attribute, key_value, client_id, client_secret, redirect_uri, type_name, transaction_state, lifetime, for_client_id);
    }

    public String getCreationToken(String client_id, String client_secret, String type_name, String lifetime, String for_client_id) {
        return this.getJanrainCaptureClient().getCreationToken(client_id, client_secret, type_name, lifetime, for_client_id);
    }

    public String getVerificationCode(String uuid, String id, String key_attribute, String key_value, String client_id, String client_secret, String type_name, String attribute_name, String lifetime) {
        return this.getJanrainCaptureClient().getVerificationCode(uuid, id, key_attribute, key_value, client_id, client_secret, type_name, attribute_name, lifetime);
    }

    public boolean useVerificationCode(String verification_code) {
        return this.getJanrainCaptureClient().useVerificationCode(verification_code);
    }

    public String webhooksAdd(String client_id, String client_secret, String attributes, String callback, String event_type, String entity_type) {
        return this.getJanrainCaptureClient().webhooksAdd(client_id, client_secret, attributes, callback, event_type, entity_type);
    }

    public String webhooksDelete(String client_id, String client_secret, String uuid) {
        return this.getJanrainCaptureClient().webhooksDelete(client_id, client_secret, uuid);
    }

    public String webhooksFind(String client_id, String client_secret, String uuid) {
        return this.getJanrainCaptureClient().webhooksFind(client_id, client_secret, uuid);
    }

    public String webhooksList(String client_id, String client_secret) {
        return this.getJanrainCaptureClient().webhooksList(client_id, client_secret);
    }

    public String webhooksUpdate(String client_id, String client_secret, String callback, String event_type, String entity_type, String attributes, String uuid) {
        return this.getJanrainCaptureClient().webhooksUpdate(client_id, client_secret, callback, event_type, entity_type, attributes, uuid);
    }

    public String authNative(String client_id, String locale, String response_type, String redirect_uri, String token, String thin_registration, String merge_token, String flow_name, String flow_version) {
        return this.getJanrainCaptureClient().authNative(client_id, locale, response_type, redirect_uri, token, thin_registration, merge_token, flow_name, flow_version);
    }

    public String authNativeTraditional(String client_id, String locale, String response_type, String redirect_uri, String email, String password, String form, String flow_name, String flow_version) {
        return this.getJanrainCaptureClient().authNativeTraditional(client_id, locale, response_type, redirect_uri, email, password, form, flow_name, flow_version);
    }

    public String forgotPasswordNative(String client_id, String locale, String response_type, String redirect_uri, String form, String email, String flow_name, String flow_version) {
        return this.getJanrainCaptureClient().forgotPasswordNative(client_id, locale, response_type, redirect_uri, form, email, flow_name, flow_version);
    }

    public String linkAccountNative(String client_id, String locale, String response_type, String redirect_uri, String token, String flow_name, String flow_version) {
        return this.getJanrainCaptureClient().linkAccountNative(client_id, locale, response_type, redirect_uri, token, flow_name, flow_version);
    }

    public String registerNative(String client_id, String locale, String response_type, String redirect_uri, String token, String flow_name, String flow_version) {
        return this.getJanrainCaptureClient().registerNative(client_id, locale, response_type, redirect_uri, token, flow_name, flow_version);
    }

    public String verifyEmailNative(String client_id, String locale, String response_type, String redirect_uri, String form, String email, String flow_name, String flow_version) {
        return this.getJanrainCaptureClient().verifyEmailNative(client_id, locale, response_type, redirect_uri, form, email, flow_name, flow_version);
    }

    public String getToken(String client_id, String client_secret, String grant_type, String code, String redirect_uri, String refresh_token) {
        return this.getJanrainCaptureClient().getToken(client_id, client_secret, grant_type, code, redirect_uri, refresh_token);
    }

    public String registerNativeTraditional(String client_id, String locale, String response_type, String redirect_uri, String password, String password_confirm, String email, String flow_name, String flow_version) {
        return this.getJanrainCaptureClient().registerNativeTraditional(client_id, locale, response_type, redirect_uri, password, password_confirm, email, flow_name, flow_version);
    }

    public JanrainEngageClient getJanrainEngageClient() {
        if (this.janrainEngageClient != null) {
            return this.janrainEngageClient;
        }
        this.janrainEngageClient = new JanrainEngageClientImpl(this.appName, this.appId, this.apiKey, this.jerseyClient, this.gson);
        return this.janrainEngageClient;
    }

    public JanrainPartnerClient getJanrainPartnerClient() {
        if (this.janrainPartnerClient != null) {
            return this.janrainPartnerClient;
        }
        this.janrainPartnerClient = new JanrainPartnerClientImpl(this.appName, this.appId, this.apiKey, this.jerseyClient, this.gson);
        return this.janrainPartnerClient;
    }

    public JanrainCaptureClient getJanrainCaptureClient() {
        if (this.janrainCaptureClient != null) {
            return this.janrainCaptureClient;
        }
        this.janrainCaptureClient = new JanrainCaptureClientImpl(this.captureHost, this.appId, this.apiKey, this.jerseyClient, this.gson);
        return this.janrainCaptureClient;
    }

    public Client getJerseyClient() {
        return this.jerseyClient;
    }

    public void setJerseyClient(Client jerseyClient) {
        this.jerseyClient = jerseyClient;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getCaptureHost() {
        return this.captureHost;
    }

    public void setCaptureHost(String captureHost) {
        this.captureHost = captureHost;
    }
}

