
package org.mule.module.intacct.config;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.module.intacct.processors.ExecuteMessageProcessor;
import org.mule.util.TemplateParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ExecuteDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public ExecuteDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ExecuteMessageProcessor.class.getName());
        String configRef = element.getAttribute("config-ref");
        if ((configRef!= null)&&(!StringUtils.isBlank(configRef))) {
            builder.addPropertyValue("moduleObject", configRef);
        }
        if ((element.getAttribute("functionControlId")!= null)&&(!StringUtils.isBlank(element.getAttribute("functionControlId")))) {
            builder.addPropertyValue("functionControlId", element.getAttribute("functionControlId"));
        }
        if (element.hasAttribute("type")) {
            builder.addPropertyValue("type", element.getAttribute("type"));
        }
        Element commandsListElement = null;
        commandsListElement = DomUtils.getChildElementByTagName(element, "commands");
        List<Element> commandsListChilds = null;
        if (commandsListElement!= null) {
            String commandsRef = commandsListElement.getAttribute("ref");
            if ((commandsRef!= null)&&(!StringUtils.isBlank(commandsRef))) {
                if ((!commandsRef.startsWith(patternInfo.getPrefix()))&&(!commandsRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("commands", new RuntimeBeanReference(commandsRef));
                } else {
                    builder.addPropertyValue("commands", commandsRef);
                }
            } else {
                ManagedList commands = new ManagedList();
                commandsListChilds = DomUtils.getChildElementsByTagName(commandsListElement, "command");
                if (commandsListChilds!= null) {
                    for (Element commandsChild: commandsListChilds) {
                        String valueRef = commandsChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            if ((!valueRef.startsWith(patternInfo.getPrefix()))&&(!valueRef.endsWith(patternInfo.getSuffix()))) {
                                commands.add(new RuntimeBeanReference(valueRef));
                            } else {
                                commands.add(valueRef);
                            }
                        } else {
                            List<Element> innercommandMapChilds = null;
                            if (commandsChild!= null) {
                                String innercommandRef = commandsChild.getAttribute("ref");
                                if ((innercommandRef!= null)&&(!StringUtils.isBlank(innercommandRef))) {
                                    if ((!innercommandRef.startsWith(patternInfo.getPrefix()))&&(!innercommandRef.endsWith(patternInfo.getSuffix()))) {
                                        builder.addPropertyValue("inner-command", new RuntimeBeanReference(innercommandRef));
                                    } else {
                                        builder.addPropertyValue("inner-command", innercommandRef);
                                    }
                                } else {
                                    ManagedMap innercommand = new ManagedMap();
                                    innercommandMapChilds = DomUtils.getChildElementsByTagName(commandsChild, "inner-command");
                                    if (innercommandMapChilds!= null) {
                                        if (innercommandMapChilds.size() == 0) {
                                            innercommandMapChilds = DomUtils.getChildElements(commandsChild);
                                        }
                                        for (Element innercommandChild: innercommandMapChilds) {
                                            String innercommandValueRef = innercommandChild.getAttribute("value-ref");
                                            String innercommandKeyRef = innercommandChild.getAttribute("key-ref");
                                            Object valueObject = null;
                                            Object keyObject = null;
                                            if ((innercommandValueRef!= null)&&(!StringUtils.isBlank(innercommandValueRef))) {
                                                if ((!innercommandValueRef.startsWith(patternInfo.getPrefix()))&&(!innercommandValueRef.endsWith(patternInfo.getSuffix()))) {
                                                    valueObject = new RuntimeBeanReference(innercommandValueRef);
                                                } else {
                                                    valueObject = innercommandValueRef;
                                                }
                                            } else {
                                                valueObject = innercommandChild.getTextContent();
                                            }
                                            if ((innercommandKeyRef!= null)&&(!StringUtils.isBlank(innercommandKeyRef))) {
                                                keyObject = new RuntimeBeanReference(innercommandKeyRef);
                                            } else {
                                                keyObject = innercommandChild.getAttribute("key");
                                            }
                                            if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                                                keyObject = innercommandChild.getTagName();
                                            }
                                            innercommand.put(keyObject, valueObject);
                                        }
                                    }
                                    commands.add(innercommand);
                                }
                            }
                        }
                    }
                }
                builder.addPropertyValue("commands", commands);
            }
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        MutablePropertyValues propertyValues = parserContent.getContainingBeanDefinition().getPropertyValues();
        if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.config.spring.factories.PollingMessageSourceFactoryBean")) {
            propertyValues.addPropertyValue("messageProcessor", definition);
        } else {
            if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.enricher.MessageEnricher")) {
                propertyValues.addPropertyValue("enrichmentMessageProcessor", definition);
            } else {
                PropertyValue messageProcessors = propertyValues.getPropertyValue("messageProcessors");
                if ((messageProcessors == null)||(messageProcessors.getValue() == null)) {
                    propertyValues.addPropertyValue("messageProcessors", new ManagedList());
                }
                List listMessageProcessors = ((List) propertyValues.getPropertyValue("messageProcessors").getValue());
                listMessageProcessors.add(definition);
            }
        }
        return definition;
    }

    protected String getAttributeValue(Element element, String attributeName) {
        if (!StringUtils.isEmpty(element.getAttribute(attributeName))) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    private String generateChildBeanName(Element element) {
        String id = SpringXMLUtils.getNameOrId(element);
        if (StringUtils.isBlank(id)) {
            String parentId = SpringXMLUtils.getNameOrId(((Element) element.getParentNode()));
            return ((("."+ parentId)+":")+ element.getLocalName());
        } else {
            return id;
        }
    }

}
