
package org.mule.module.intacct.config;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.module.intacct.processors.CreateInvoiceBatchMessageProcessor;
import org.mule.util.TemplateParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class CreateInvoiceBatchDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public CreateInvoiceBatchDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(CreateInvoiceBatchMessageProcessor.class.getName());
        String configRef = element.getAttribute("config-ref");
        if ((configRef!= null)&&(!StringUtils.isBlank(configRef))) {
            builder.addPropertyValue("moduleObject", configRef);
        }
        if ((element.getAttribute("functionControlId")!= null)&&(!StringUtils.isBlank(element.getAttribute("functionControlId")))) {
            builder.addPropertyValue("functionControlId", element.getAttribute("functionControlId"));
        }
        if ((element.getAttribute("batchTitle")!= null)&&(!StringUtils.isBlank(element.getAttribute("batchTitle")))) {
            builder.addPropertyValue("batchTitle", element.getAttribute("batchTitle"));
        }
        Element dateCreatedListElement = null;
        dateCreatedListElement = DomUtils.getChildElementByTagName(element, "date-created");
        List<Element> dateCreatedMapChilds = null;
        if (dateCreatedListElement!= null) {
            String dateCreatedRef = dateCreatedListElement.getAttribute("ref");
            if ((dateCreatedRef!= null)&&(!StringUtils.isBlank(dateCreatedRef))) {
                if ((!dateCreatedRef.startsWith(patternInfo.getPrefix()))&&(!dateCreatedRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("dateCreated", new RuntimeBeanReference(dateCreatedRef));
                } else {
                    builder.addPropertyValue("dateCreated", dateCreatedRef);
                }
            } else {
                ManagedMap dateCreated = new ManagedMap();
                dateCreatedMapChilds = DomUtils.getChildElementsByTagName(dateCreatedListElement, "date-created");
                if (dateCreatedMapChilds!= null) {
                    if (dateCreatedMapChilds.size() == 0) {
                        dateCreatedMapChilds = DomUtils.getChildElements(dateCreatedListElement);
                    }
                    for (Element dateCreatedChild: dateCreatedMapChilds) {
                        String dateCreatedValueRef = dateCreatedChild.getAttribute("value-ref");
                        String dateCreatedKeyRef = dateCreatedChild.getAttribute("key-ref");
                        Object valueObject = null;
                        Object keyObject = null;
                        if ((dateCreatedValueRef!= null)&&(!StringUtils.isBlank(dateCreatedValueRef))) {
                            if ((!dateCreatedValueRef.startsWith(patternInfo.getPrefix()))&&(!dateCreatedValueRef.endsWith(patternInfo.getSuffix()))) {
                                valueObject = new RuntimeBeanReference(dateCreatedValueRef);
                            } else {
                                valueObject = dateCreatedValueRef;
                            }
                        } else {
                            valueObject = dateCreatedChild.getTextContent();
                        }
                        if ((dateCreatedKeyRef!= null)&&(!StringUtils.isBlank(dateCreatedKeyRef))) {
                            keyObject = new RuntimeBeanReference(dateCreatedKeyRef);
                        } else {
                            keyObject = dateCreatedChild.getAttribute("key");
                        }
                        if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                            keyObject = dateCreatedChild.getTagName();
                        }
                        dateCreated.put(keyObject, valueObject);
                    }
                }
                builder.addPropertyValue("dateCreated", dateCreated);
            }
        }
        Element createInvoicesListElement = null;
        createInvoicesListElement = DomUtils.getChildElementByTagName(element, "create-invoices");
        List<Element> createInvoicesListChilds = null;
        if (createInvoicesListElement!= null) {
            String createInvoicesRef = createInvoicesListElement.getAttribute("ref");
            if ((createInvoicesRef!= null)&&(!StringUtils.isBlank(createInvoicesRef))) {
                if ((!createInvoicesRef.startsWith(patternInfo.getPrefix()))&&(!createInvoicesRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("createInvoices", new RuntimeBeanReference(createInvoicesRef));
                } else {
                    builder.addPropertyValue("createInvoices", createInvoicesRef);
                }
            } else {
                ManagedList createInvoices = new ManagedList();
                createInvoicesListChilds = DomUtils.getChildElementsByTagName(createInvoicesListElement, "create-invoice");
                if (createInvoicesListChilds!= null) {
                    for (Element createInvoicesChild: createInvoicesListChilds) {
                        String valueRef = createInvoicesChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            if ((!valueRef.startsWith(patternInfo.getPrefix()))&&(!valueRef.endsWith(patternInfo.getSuffix()))) {
                                createInvoices.add(new RuntimeBeanReference(valueRef));
                            } else {
                                createInvoices.add(valueRef);
                            }
                        } else {
                            List<Element> innercreateinvoiceMapChilds = null;
                            if (createInvoicesChild!= null) {
                                String innercreateinvoiceRef = createInvoicesChild.getAttribute("ref");
                                if ((innercreateinvoiceRef!= null)&&(!StringUtils.isBlank(innercreateinvoiceRef))) {
                                    if ((!innercreateinvoiceRef.startsWith(patternInfo.getPrefix()))&&(!innercreateinvoiceRef.endsWith(patternInfo.getSuffix()))) {
                                        builder.addPropertyValue("inner-create-invoice", new RuntimeBeanReference(innercreateinvoiceRef));
                                    } else {
                                        builder.addPropertyValue("inner-create-invoice", innercreateinvoiceRef);
                                    }
                                } else {
                                    ManagedMap innercreateinvoice = new ManagedMap();
                                    innercreateinvoiceMapChilds = DomUtils.getChildElementsByTagName(createInvoicesChild, "inner-create-invoice");
                                    if (innercreateinvoiceMapChilds!= null) {
                                        if (innercreateinvoiceMapChilds.size() == 0) {
                                            innercreateinvoiceMapChilds = DomUtils.getChildElements(createInvoicesChild);
                                        }
                                        for (Element innercreateinvoiceChild: innercreateinvoiceMapChilds) {
                                            String innercreateinvoiceValueRef = innercreateinvoiceChild.getAttribute("value-ref");
                                            String innercreateinvoiceKeyRef = innercreateinvoiceChild.getAttribute("key-ref");
                                            Object valueObject = null;
                                            Object keyObject = null;
                                            if ((innercreateinvoiceValueRef!= null)&&(!StringUtils.isBlank(innercreateinvoiceValueRef))) {
                                                if ((!innercreateinvoiceValueRef.startsWith(patternInfo.getPrefix()))&&(!innercreateinvoiceValueRef.endsWith(patternInfo.getSuffix()))) {
                                                    valueObject = new RuntimeBeanReference(innercreateinvoiceValueRef);
                                                } else {
                                                    valueObject = innercreateinvoiceValueRef;
                                                }
                                            } else {
                                                valueObject = innercreateinvoiceChild.getTextContent();
                                            }
                                            if ((innercreateinvoiceKeyRef!= null)&&(!StringUtils.isBlank(innercreateinvoiceKeyRef))) {
                                                keyObject = new RuntimeBeanReference(innercreateinvoiceKeyRef);
                                            } else {
                                                keyObject = innercreateinvoiceChild.getAttribute("key");
                                            }
                                            if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                                                keyObject = innercreateinvoiceChild.getTagName();
                                            }
                                            innercreateinvoice.put(keyObject, valueObject);
                                        }
                                    }
                                    createInvoices.add(innercreateinvoice);
                                }
                            }
                        }
                    }
                }
                builder.addPropertyValue("createInvoices", createInvoices);
            }
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        MutablePropertyValues propertyValues = parserContent.getContainingBeanDefinition().getPropertyValues();
        if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.config.spring.factories.PollingMessageSourceFactoryBean")) {
            propertyValues.addPropertyValue("messageProcessor", definition);
        } else {
            if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.enricher.MessageEnricher")) {
                propertyValues.addPropertyValue("enrichmentMessageProcessor", definition);
            } else {
                PropertyValue messageProcessors = propertyValues.getPropertyValue("messageProcessors");
                if ((messageProcessors == null)||(messageProcessors.getValue() == null)) {
                    propertyValues.addPropertyValue("messageProcessors", new ManagedList());
                }
                List listMessageProcessors = ((List) propertyValues.getPropertyValue("messageProcessors").getValue());
                listMessageProcessors.add(definition);
            }
        }
        return definition;
    }

    protected String getAttributeValue(Element element, String attributeName) {
        if (!StringUtils.isEmpty(element.getAttribute(attributeName))) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    private String generateChildBeanName(Element element) {
        String id = SpringXMLUtils.getNameOrId(element);
        if (StringUtils.isBlank(id)) {
            String parentId = SpringXMLUtils.getNameOrId(((Element) element.getParentNode()));
            return ((("."+ parentId)+":")+ element.getLocalName());
        } else {
            return id;
        }
    }

}
