
package org.mule.module.intacct.transformers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;

public class RequestTypeJaxbTransformer
    extends AbstractTransformer
    implements DiscoverableTransformer
{

    private int weighting = (DiscoverableTransformer.DEFAULT_PRIORITY_WEIGHTING + 1);
    private static JAXBContext JAXB_CONTEXT = loadJaxbContext(org.mule.module.intacct.schema.request.Request.class);

    public RequestTypeJaxbTransformer() {
        registerSourceType(DataTypeFactory.STRING);
        setReturnClass(org.mule.module.intacct.schema.request.Request.class);
        setName("RequestTypeJaxbTransformer");
    }

    private static JAXBContext loadJaxbContext(Class clazz) {
        JAXBContext context;
        try {
            context = JAXBContext.newInstance(clazz);
        } catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        return context;
    }

    protected Object doTransform(Object src, String encoding)
        throws TransformerException
    {
        org.mule.module.intacct.schema.request.Request result = null;
        try {
            Unmarshaller unmarshaller;
            unmarshaller = JAXB_CONTEXT.createUnmarshaller();
            InputStream is = new ByteArrayInputStream(((String) src).getBytes(encoding));
            StreamSource ss = new StreamSource(is);
            result = unmarshaller.unmarshal(ss, org.mule.module.intacct.schema.request.Request.class).getValue();
        } catch (UnsupportedEncodingException unsupportedEncoding) {
            throw new TransformerException(CoreMessages.transformFailed("String", "org.mule.module.intacct.schema.request.Request"), this, unsupportedEncoding);
        } catch (JAXBException jaxbException) {
            throw new TransformerException(CoreMessages.transformFailed("String", "org.mule.module.intacct.schema.request.Request"), this, jaxbException);
        }
        return result;
    }

    public int getPriorityWeighting() {
        return weighting;
    }

    public void setPriorityWeighting(int weighting) {
        this.weighting = weighting;
    }

}
