
package org.mule.module.intacct.config;

import org.springframework.beans.factory.xml.NamespaceHandlerSupport;


/**
 * Registers bean definitions parsers for handling elements in <code>http://www.mulesoft.org/schema/mule/intacct</code>.
 * 
 */
public class IntacctCloudConnectorNamespaceHandler
    extends NamespaceHandlerSupport
{


    /**
     * Invoked by the {@link DefaultBeanDefinitionDocumentReader} after construction but before any custom elements are parsed. 
     * @see NamespaceHandlerSupport#registerBeanDefinitionParser(String, BeanDefinitionParser)
     * 
     */
    public void init() {
        registerBeanDefinitionParser("config", new IntacctCloudConnectorConfigDefinitionParser());
        registerBeanDefinitionParser("operation", new OperationDefinitionParser());
        registerBeanDefinitionParser("execute", new ExecuteDefinitionParser());
        registerBeanDefinitionParser("create-invoice", new CreateInvoiceDefinitionParser());
        registerBeanDefinitionParser("create-invoice-batch", new CreateInvoiceBatchDefinitionParser());
        registerBeanDefinitionParser("create-a-r-adjustment", new CreateARAdjustmentDefinitionParser());
        registerBeanDefinitionParser("create-s-o-transaction", new CreateSOTransactionDefinitionParser());
        registerBeanDefinitionParser("get-list", new GetListDefinitionParser());
        registerBeanDefinitionParser("get", new GetDefinitionParser());
        registerBeanDefinitionParser("operation-with-request", new OperationWithRequestDefinitionParser());
    }

}
