
package org.mule.module.intacct.config.spring;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.module.intacct.config.CreateSOTransactionMessageProcessor;
import org.mule.util.TemplateParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class CreateSOTransactionDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public CreateSOTransactionDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(CreateSOTransactionMessageProcessor.class.getName());
        String configRef = element.getAttribute("config-ref");
        if ((configRef!= null)&&(!StringUtils.isBlank(configRef))) {
            builder.addPropertyValue("moduleObject", configRef);
        }
        if ((element.getAttribute("functionControlId")!= null)&&(!StringUtils.isBlank(element.getAttribute("functionControlId")))) {
            builder.addPropertyValue("functionControlId", element.getAttribute("functionControlId"));
        }
        if ((element.getAttribute("transactionType")!= null)&&(!StringUtils.isBlank(element.getAttribute("transactionType")))) {
            builder.addPropertyValue("transactionType", element.getAttribute("transactionType"));
        }
        Element dateCreatedListElement = null;
        dateCreatedListElement = DomUtils.getChildElementByTagName(element, "date-created");
        List<Element> dateCreatedListChilds = null;
        if (dateCreatedListElement!= null) {
            String dateCreatedRef = dateCreatedListElement.getAttribute("ref");
            if ((dateCreatedRef!= null)&&(!StringUtils.isBlank(dateCreatedRef))) {
                if ((!dateCreatedRef.startsWith(patternInfo.getPrefix()))&&(!dateCreatedRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("dateCreated", new RuntimeBeanReference(dateCreatedRef));
                } else {
                    builder.addPropertyValue("dateCreated", dateCreatedRef);
                }
            } else {
                ManagedMap dateCreated = new ManagedMap();
                dateCreatedListChilds = DomUtils.getChildElementsByTagName(dateCreatedListElement, "date-created");
                if (dateCreatedListChilds!= null) {
                    if (dateCreatedListChilds.size() == 0) {
                        dateCreatedListChilds = DomUtils.getChildElements(dateCreatedListElement);
                    }
                    for (Element dateCreatedChild: dateCreatedListChilds) {
                        String dateCreatedValueRef = dateCreatedChild.getAttribute("value-ref");
                        String dateCreatedKeyRef = dateCreatedChild.getAttribute("key-ref");
                        Object valueObject = null;
                        Object keyObject = null;
                        if ((dateCreatedValueRef!= null)&&(!StringUtils.isBlank(dateCreatedValueRef))) {
                            valueObject = new RuntimeBeanReference(dateCreatedValueRef);
                        } else {
                            valueObject = dateCreatedChild.getTextContent();
                        }
                        if ((dateCreatedKeyRef!= null)&&(!StringUtils.isBlank(dateCreatedKeyRef))) {
                            keyObject = new RuntimeBeanReference(dateCreatedKeyRef);
                        } else {
                            keyObject = dateCreatedChild.getAttribute("key");
                        }
                        if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                            keyObject = dateCreatedChild.getTagName();
                        }
                        dateCreated.put(keyObject, valueObject);
                    }
                }
                builder.addPropertyValue("dateCreated", dateCreated);
            }
        }
        if ((element.getAttribute("createdFrom")!= null)&&(!StringUtils.isBlank(element.getAttribute("createdFrom")))) {
            builder.addPropertyValue("createdFrom", element.getAttribute("createdFrom"));
        }
        if ((element.getAttribute("customerId")!= null)&&(!StringUtils.isBlank(element.getAttribute("customerId")))) {
            builder.addPropertyValue("customerId", element.getAttribute("customerId"));
        }
        if ((element.getAttribute("documentNo")!= null)&&(!StringUtils.isBlank(element.getAttribute("documentNo")))) {
            builder.addPropertyValue("documentNo", element.getAttribute("documentNo"));
        }
        if ((element.getAttribute("referenceNo")!= null)&&(!StringUtils.isBlank(element.getAttribute("referenceNo")))) {
            builder.addPropertyValue("referenceNo", element.getAttribute("referenceNo"));
        }
        if ((element.getAttribute("termName")!= null)&&(!StringUtils.isBlank(element.getAttribute("termName")))) {
            builder.addPropertyValue("termName", element.getAttribute("termName"));
        }
        Element dateDueListElement = null;
        dateDueListElement = DomUtils.getChildElementByTagName(element, "date-due");
        List<Element> dateDueListChilds = null;
        if (dateDueListElement!= null) {
            String dateDueRef = dateDueListElement.getAttribute("ref");
            if ((dateDueRef!= null)&&(!StringUtils.isBlank(dateDueRef))) {
                if ((!dateDueRef.startsWith(patternInfo.getPrefix()))&&(!dateDueRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("dateDue", new RuntimeBeanReference(dateDueRef));
                } else {
                    builder.addPropertyValue("dateDue", dateDueRef);
                }
            } else {
                ManagedMap dateDue = new ManagedMap();
                dateDueListChilds = DomUtils.getChildElementsByTagName(dateDueListElement, "date-due");
                if (dateDueListChilds!= null) {
                    if (dateDueListChilds.size() == 0) {
                        dateDueListChilds = DomUtils.getChildElements(dateDueListElement);
                    }
                    for (Element dateDueChild: dateDueListChilds) {
                        String dateDueValueRef = dateDueChild.getAttribute("value-ref");
                        String dateDueKeyRef = dateDueChild.getAttribute("key-ref");
                        Object valueObject = null;
                        Object keyObject = null;
                        if ((dateDueValueRef!= null)&&(!StringUtils.isBlank(dateDueValueRef))) {
                            valueObject = new RuntimeBeanReference(dateDueValueRef);
                        } else {
                            valueObject = dateDueChild.getTextContent();
                        }
                        if ((dateDueKeyRef!= null)&&(!StringUtils.isBlank(dateDueKeyRef))) {
                            keyObject = new RuntimeBeanReference(dateDueKeyRef);
                        } else {
                            keyObject = dateDueChild.getAttribute("key");
                        }
                        if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                            keyObject = dateDueChild.getTagName();
                        }
                        dateDue.put(keyObject, valueObject);
                    }
                }
                builder.addPropertyValue("dateDue", dateDue);
            }
        }
        if ((element.getAttribute("message")!= null)&&(!StringUtils.isBlank(element.getAttribute("message")))) {
            builder.addPropertyValue("message", element.getAttribute("message"));
        }
        if ((element.getAttribute("shippingMethod")!= null)&&(!StringUtils.isBlank(element.getAttribute("shippingMethod")))) {
            builder.addPropertyValue("shippingMethod", element.getAttribute("shippingMethod"));
        }
        if (element.hasAttribute("billToContactType")) {
            builder.addPropertyValue("billToContactType", element.getAttribute("billToContactType"));
        }
        Element billToContactsListElement = null;
        billToContactsListElement = DomUtils.getChildElementByTagName(element, "bill-to-contacts");
        List<Element> billToContactsListChilds = null;
        if (billToContactsListElement!= null) {
            String billToContactsRef = billToContactsListElement.getAttribute("ref");
            if ((billToContactsRef!= null)&&(!StringUtils.isBlank(billToContactsRef))) {
                if ((!billToContactsRef.startsWith(patternInfo.getPrefix()))&&(!billToContactsRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("billToContacts", new RuntimeBeanReference(billToContactsRef));
                } else {
                    builder.addPropertyValue("billToContacts", billToContactsRef);
                }
            } else {
                ManagedList billToContacts = new ManagedList();
                billToContactsListChilds = DomUtils.getChildElementsByTagName(billToContactsListElement, "bill-to-contact");
                if (billToContactsListChilds!= null) {
                    for (Element billToContactsChild: billToContactsListChilds) {
                        String valueRef = billToContactsChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            billToContacts.add(new RuntimeBeanReference(valueRef));
                        } else {
                            List<Element> innerbilltocontactListChilds = null;
                            if (billToContactsChild!= null) {
                                String innerbilltocontactRef = billToContactsChild.getAttribute("ref");
                                if ((innerbilltocontactRef!= null)&&(!StringUtils.isBlank(innerbilltocontactRef))) {
                                    if ((!innerbilltocontactRef.startsWith(patternInfo.getPrefix()))&&(!innerbilltocontactRef.endsWith(patternInfo.getSuffix()))) {
                                        builder.addPropertyValue("inner-bill-to-contact", new RuntimeBeanReference(innerbilltocontactRef));
                                    } else {
                                        builder.addPropertyValue("inner-bill-to-contact", innerbilltocontactRef);
                                    }
                                } else {
                                    ManagedMap innerbilltocontact = new ManagedMap();
                                    innerbilltocontactListChilds = DomUtils.getChildElementsByTagName(billToContactsChild, "inner-bill-to-contact");
                                    if (innerbilltocontactListChilds!= null) {
                                        if (innerbilltocontactListChilds.size() == 0) {
                                            innerbilltocontactListChilds = DomUtils.getChildElements(billToContactsChild);
                                        }
                                        for (Element innerbilltocontactChild: innerbilltocontactListChilds) {
                                            String innerbilltocontactValueRef = innerbilltocontactChild.getAttribute("value-ref");
                                            String innerbilltocontactKeyRef = innerbilltocontactChild.getAttribute("key-ref");
                                            Object valueObject = null;
                                            Object keyObject = null;
                                            if ((innerbilltocontactValueRef!= null)&&(!StringUtils.isBlank(innerbilltocontactValueRef))) {
                                                valueObject = new RuntimeBeanReference(innerbilltocontactValueRef);
                                            } else {
                                                valueObject = innerbilltocontactChild.getTextContent();
                                            }
                                            if ((innerbilltocontactKeyRef!= null)&&(!StringUtils.isBlank(innerbilltocontactKeyRef))) {
                                                keyObject = new RuntimeBeanReference(innerbilltocontactKeyRef);
                                            } else {
                                                keyObject = innerbilltocontactChild.getAttribute("key");
                                            }
                                            if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                                                keyObject = innerbilltocontactChild.getTagName();
                                            }
                                            innerbilltocontact.put(keyObject, valueObject);
                                        }
                                    }
                                    billToContacts.add(innerbilltocontact);
                                }
                            }
                        }
                    }
                }
                builder.addPropertyValue("billToContacts", billToContacts);
            }
        }
        if (element.hasAttribute("shipToContactType")) {
            builder.addPropertyValue("shipToContactType", element.getAttribute("shipToContactType"));
        }
        Element shipToContactsListElement = null;
        shipToContactsListElement = DomUtils.getChildElementByTagName(element, "ship-to-contacts");
        List<Element> shipToContactsListChilds = null;
        if (shipToContactsListElement!= null) {
            String shipToContactsRef = shipToContactsListElement.getAttribute("ref");
            if ((shipToContactsRef!= null)&&(!StringUtils.isBlank(shipToContactsRef))) {
                if ((!shipToContactsRef.startsWith(patternInfo.getPrefix()))&&(!shipToContactsRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("shipToContacts", new RuntimeBeanReference(shipToContactsRef));
                } else {
                    builder.addPropertyValue("shipToContacts", shipToContactsRef);
                }
            } else {
                ManagedList shipToContacts = new ManagedList();
                shipToContactsListChilds = DomUtils.getChildElementsByTagName(shipToContactsListElement, "ship-to-contact");
                if (shipToContactsListChilds!= null) {
                    for (Element shipToContactsChild: shipToContactsListChilds) {
                        String valueRef = shipToContactsChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            shipToContacts.add(new RuntimeBeanReference(valueRef));
                        } else {
                            List<Element> innershiptocontactListChilds = null;
                            if (shipToContactsChild!= null) {
                                String innershiptocontactRef = shipToContactsChild.getAttribute("ref");
                                if ((innershiptocontactRef!= null)&&(!StringUtils.isBlank(innershiptocontactRef))) {
                                    if ((!innershiptocontactRef.startsWith(patternInfo.getPrefix()))&&(!innershiptocontactRef.endsWith(patternInfo.getSuffix()))) {
                                        builder.addPropertyValue("inner-ship-to-contact", new RuntimeBeanReference(innershiptocontactRef));
                                    } else {
                                        builder.addPropertyValue("inner-ship-to-contact", innershiptocontactRef);
                                    }
                                } else {
                                    ManagedMap innershiptocontact = new ManagedMap();
                                    innershiptocontactListChilds = DomUtils.getChildElementsByTagName(shipToContactsChild, "inner-ship-to-contact");
                                    if (innershiptocontactListChilds!= null) {
                                        if (innershiptocontactListChilds.size() == 0) {
                                            innershiptocontactListChilds = DomUtils.getChildElements(shipToContactsChild);
                                        }
                                        for (Element innershiptocontactChild: innershiptocontactListChilds) {
                                            String innershiptocontactValueRef = innershiptocontactChild.getAttribute("value-ref");
                                            String innershiptocontactKeyRef = innershiptocontactChild.getAttribute("key-ref");
                                            Object valueObject = null;
                                            Object keyObject = null;
                                            if ((innershiptocontactValueRef!= null)&&(!StringUtils.isBlank(innershiptocontactValueRef))) {
                                                valueObject = new RuntimeBeanReference(innershiptocontactValueRef);
                                            } else {
                                                valueObject = innershiptocontactChild.getTextContent();
                                            }
                                            if ((innershiptocontactKeyRef!= null)&&(!StringUtils.isBlank(innershiptocontactKeyRef))) {
                                                keyObject = new RuntimeBeanReference(innershiptocontactKeyRef);
                                            } else {
                                                keyObject = innershiptocontactChild.getAttribute("key");
                                            }
                                            if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                                                keyObject = innershiptocontactChild.getTagName();
                                            }
                                            innershiptocontact.put(keyObject, valueObject);
                                        }
                                    }
                                    shipToContacts.add(innershiptocontact);
                                }
                            }
                        }
                    }
                }
                builder.addPropertyValue("shipToContacts", shipToContacts);
            }
        }
        if ((element.getAttribute("externalId")!= null)&&(!StringUtils.isBlank(element.getAttribute("externalId")))) {
            builder.addPropertyValue("externalId", element.getAttribute("externalId"));
        }
        if ((element.getAttribute("basecurr")!= null)&&(!StringUtils.isBlank(element.getAttribute("basecurr")))) {
            builder.addPropertyValue("basecurr", element.getAttribute("basecurr"));
        }
        if ((element.getAttribute("currency")!= null)&&(!StringUtils.isBlank(element.getAttribute("currency")))) {
            builder.addPropertyValue("currency", element.getAttribute("currency"));
        }
        if (element.hasAttribute("exchType")) {
            builder.addPropertyValue("exchType", element.getAttribute("exchType"));
        }
        Element exchRateDatesOrExchRateTypesOrExchRatesListElement = null;
        exchRateDatesOrExchRateTypesOrExchRatesListElement = DomUtils.getChildElementByTagName(element, "exch-rate-dates-or-exch-rate-types-or-exch-rates");
        List<Element> exchRateDatesOrExchRateTypesOrExchRatesListChilds = null;
        if (exchRateDatesOrExchRateTypesOrExchRatesListElement!= null) {
            String exchRateDatesOrExchRateTypesOrExchRatesRef = exchRateDatesOrExchRateTypesOrExchRatesListElement.getAttribute("ref");
            if ((exchRateDatesOrExchRateTypesOrExchRatesRef!= null)&&(!StringUtils.isBlank(exchRateDatesOrExchRateTypesOrExchRatesRef))) {
                if ((!exchRateDatesOrExchRateTypesOrExchRatesRef.startsWith(patternInfo.getPrefix()))&&(!exchRateDatesOrExchRateTypesOrExchRatesRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("exchRateDatesOrExchRateTypesOrExchRates", new RuntimeBeanReference(exchRateDatesOrExchRateTypesOrExchRatesRef));
                } else {
                    builder.addPropertyValue("exchRateDatesOrExchRateTypesOrExchRates", exchRateDatesOrExchRateTypesOrExchRatesRef);
                }
            } else {
                ManagedList exchRateDatesOrExchRateTypesOrExchRates = new ManagedList();
                exchRateDatesOrExchRateTypesOrExchRatesListChilds = DomUtils.getChildElementsByTagName(exchRateDatesOrExchRateTypesOrExchRatesListElement, "exch-rate-dates-or-exch-rate-types-or-exch-rate");
                if (exchRateDatesOrExchRateTypesOrExchRatesListChilds!= null) {
                    for (Element exchRateDatesOrExchRateTypesOrExchRatesChild: exchRateDatesOrExchRateTypesOrExchRatesListChilds) {
                        String valueRef = exchRateDatesOrExchRateTypesOrExchRatesChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            exchRateDatesOrExchRateTypesOrExchRates.add(new RuntimeBeanReference(valueRef));
                        } else {
                            List<Element> innerexchratedatesorexchratetypesorexchrateListChilds = null;
                            if (exchRateDatesOrExchRateTypesOrExchRatesChild!= null) {
                                String innerexchratedatesorexchratetypesorexchrateRef = exchRateDatesOrExchRateTypesOrExchRatesChild.getAttribute("ref");
                                if ((innerexchratedatesorexchratetypesorexchrateRef!= null)&&(!StringUtils.isBlank(innerexchratedatesorexchratetypesorexchrateRef))) {
                                    if ((!innerexchratedatesorexchratetypesorexchrateRef.startsWith(patternInfo.getPrefix()))&&(!innerexchratedatesorexchratetypesorexchrateRef.endsWith(patternInfo.getSuffix()))) {
                                        builder.addPropertyValue("inner-exch-rate-dates-or-exch-rate-types-or-exch-rate", new RuntimeBeanReference(innerexchratedatesorexchratetypesorexchrateRef));
                                    } else {
                                        builder.addPropertyValue("inner-exch-rate-dates-or-exch-rate-types-or-exch-rate", innerexchratedatesorexchratetypesorexchrateRef);
                                    }
                                } else {
                                    ManagedMap innerexchratedatesorexchratetypesorexchrate = new ManagedMap();
                                    innerexchratedatesorexchratetypesorexchrateListChilds = DomUtils.getChildElementsByTagName(exchRateDatesOrExchRateTypesOrExchRatesChild, "inner-exch-rate-dates-or-exch-rate-types-or-exch-rate");
                                    if (innerexchratedatesorexchratetypesorexchrateListChilds!= null) {
                                        if (innerexchratedatesorexchratetypesorexchrateListChilds.size() == 0) {
                                            innerexchratedatesorexchratetypesorexchrateListChilds = DomUtils.getChildElements(exchRateDatesOrExchRateTypesOrExchRatesChild);
                                        }
                                        for (Element innerexchratedatesorexchratetypesorexchrateChild: innerexchratedatesorexchratetypesorexchrateListChilds) {
                                            String innerexchratedatesorexchratetypesorexchrateValueRef = innerexchratedatesorexchratetypesorexchrateChild.getAttribute("value-ref");
                                            String innerexchratedatesorexchratetypesorexchrateKeyRef = innerexchratedatesorexchratetypesorexchrateChild.getAttribute("key-ref");
                                            Object valueObject = null;
                                            Object keyObject = null;
                                            if ((innerexchratedatesorexchratetypesorexchrateValueRef!= null)&&(!StringUtils.isBlank(innerexchratedatesorexchratetypesorexchrateValueRef))) {
                                                valueObject = new RuntimeBeanReference(innerexchratedatesorexchratetypesorexchrateValueRef);
                                            } else {
                                                valueObject = innerexchratedatesorexchratetypesorexchrateChild.getTextContent();
                                            }
                                            if ((innerexchratedatesorexchratetypesorexchrateKeyRef!= null)&&(!StringUtils.isBlank(innerexchratedatesorexchratetypesorexchrateKeyRef))) {
                                                keyObject = new RuntimeBeanReference(innerexchratedatesorexchratetypesorexchrateKeyRef);
                                            } else {
                                                keyObject = innerexchratedatesorexchratetypesorexchrateChild.getAttribute("key");
                                            }
                                            if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                                                keyObject = innerexchratedatesorexchratetypesorexchrateChild.getTagName();
                                            }
                                            innerexchratedatesorexchratetypesorexchrate.put(keyObject, valueObject);
                                        }
                                    }
                                    exchRateDatesOrExchRateTypesOrExchRates.add(innerexchratedatesorexchratetypesorexchrate);
                                }
                            }
                        }
                    }
                }
                builder.addPropertyValue("exchRateDatesOrExchRateTypesOrExchRates", exchRateDatesOrExchRateTypesOrExchRates);
            }
        }
        if ((element.getAttribute("vsoePriceList")!= null)&&(!StringUtils.isBlank(element.getAttribute("vsoePriceList")))) {
            builder.addPropertyValue("vsoePriceList", element.getAttribute("vsoePriceList"));
        }
        Element customFieldsListElement = null;
        customFieldsListElement = DomUtils.getChildElementByTagName(element, "custom-fields");
        List<Element> customFieldsListChilds = null;
        if (customFieldsListElement!= null) {
            String customFieldsRef = customFieldsListElement.getAttribute("ref");
            if ((customFieldsRef!= null)&&(!StringUtils.isBlank(customFieldsRef))) {
                if ((!customFieldsRef.startsWith(patternInfo.getPrefix()))&&(!customFieldsRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("customFields", new RuntimeBeanReference(customFieldsRef));
                } else {
                    builder.addPropertyValue("customFields", customFieldsRef);
                }
            } else {
                ManagedList customFields = new ManagedList();
                customFieldsListChilds = DomUtils.getChildElementsByTagName(customFieldsListElement, "custom-field");
                if (customFieldsListChilds!= null) {
                    for (Element customFieldsChild: customFieldsListChilds) {
                        String valueRef = customFieldsChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            customFields.add(new RuntimeBeanReference(valueRef));
                        } else {
                            List<Element> innercustomfieldListChilds = null;
                            if (customFieldsChild!= null) {
                                String innercustomfieldRef = customFieldsChild.getAttribute("ref");
                                if ((innercustomfieldRef!= null)&&(!StringUtils.isBlank(innercustomfieldRef))) {
                                    if ((!innercustomfieldRef.startsWith(patternInfo.getPrefix()))&&(!innercustomfieldRef.endsWith(patternInfo.getSuffix()))) {
                                        builder.addPropertyValue("inner-custom-field", new RuntimeBeanReference(innercustomfieldRef));
                                    } else {
                                        builder.addPropertyValue("inner-custom-field", innercustomfieldRef);
                                    }
                                } else {
                                    ManagedMap innercustomfield = new ManagedMap();
                                    innercustomfieldListChilds = DomUtils.getChildElementsByTagName(customFieldsChild, "inner-custom-field");
                                    if (innercustomfieldListChilds!= null) {
                                        if (innercustomfieldListChilds.size() == 0) {
                                            innercustomfieldListChilds = DomUtils.getChildElements(customFieldsChild);
                                        }
                                        for (Element innercustomfieldChild: innercustomfieldListChilds) {
                                            String innercustomfieldValueRef = innercustomfieldChild.getAttribute("value-ref");
                                            String innercustomfieldKeyRef = innercustomfieldChild.getAttribute("key-ref");
                                            Object valueObject = null;
                                            Object keyObject = null;
                                            if ((innercustomfieldValueRef!= null)&&(!StringUtils.isBlank(innercustomfieldValueRef))) {
                                                valueObject = new RuntimeBeanReference(innercustomfieldValueRef);
                                            } else {
                                                valueObject = innercustomfieldChild.getTextContent();
                                            }
                                            if ((innercustomfieldKeyRef!= null)&&(!StringUtils.isBlank(innercustomfieldKeyRef))) {
                                                keyObject = new RuntimeBeanReference(innercustomfieldKeyRef);
                                            } else {
                                                keyObject = innercustomfieldChild.getAttribute("key");
                                            }
                                            if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                                                keyObject = innercustomfieldChild.getTagName();
                                            }
                                            innercustomfield.put(keyObject, valueObject);
                                        }
                                    }
                                    customFields.add(innercustomfield);
                                }
                            }
                        }
                    }
                }
                builder.addPropertyValue("customFields", customFields);
            }
        }
        Element sOTransItemsListElement = null;
        sOTransItemsListElement = DomUtils.getChildElementByTagName(element, "s-o-trans-items");
        List<Element> sOTransItemsListChilds = null;
        if (sOTransItemsListElement!= null) {
            String sOTransItemsRef = sOTransItemsListElement.getAttribute("ref");
            if ((sOTransItemsRef!= null)&&(!StringUtils.isBlank(sOTransItemsRef))) {
                if ((!sOTransItemsRef.startsWith(patternInfo.getPrefix()))&&(!sOTransItemsRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("sOTransItems", new RuntimeBeanReference(sOTransItemsRef));
                } else {
                    builder.addPropertyValue("sOTransItems", sOTransItemsRef);
                }
            } else {
                ManagedList sOTransItems = new ManagedList();
                sOTransItemsListChilds = DomUtils.getChildElementsByTagName(sOTransItemsListElement, "s-o-trans-item");
                if (sOTransItemsListChilds!= null) {
                    for (Element sOTransItemsChild: sOTransItemsListChilds) {
                        String valueRef = sOTransItemsChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            sOTransItems.add(new RuntimeBeanReference(valueRef));
                        } else {
                            List<Element> innersotransitemListChilds = null;
                            if (sOTransItemsChild!= null) {
                                String innersotransitemRef = sOTransItemsChild.getAttribute("ref");
                                if ((innersotransitemRef!= null)&&(!StringUtils.isBlank(innersotransitemRef))) {
                                    if ((!innersotransitemRef.startsWith(patternInfo.getPrefix()))&&(!innersotransitemRef.endsWith(patternInfo.getSuffix()))) {
                                        builder.addPropertyValue("inner-s-o-trans-item", new RuntimeBeanReference(innersotransitemRef));
                                    } else {
                                        builder.addPropertyValue("inner-s-o-trans-item", innersotransitemRef);
                                    }
                                } else {
                                    ManagedMap innersotransitem = new ManagedMap();
                                    innersotransitemListChilds = DomUtils.getChildElementsByTagName(sOTransItemsChild, "inner-s-o-trans-item");
                                    if (innersotransitemListChilds!= null) {
                                        if (innersotransitemListChilds.size() == 0) {
                                            innersotransitemListChilds = DomUtils.getChildElements(sOTransItemsChild);
                                        }
                                        for (Element innersotransitemChild: innersotransitemListChilds) {
                                            String innersotransitemValueRef = innersotransitemChild.getAttribute("value-ref");
                                            String innersotransitemKeyRef = innersotransitemChild.getAttribute("key-ref");
                                            Object valueObject = null;
                                            Object keyObject = null;
                                            if ((innersotransitemValueRef!= null)&&(!StringUtils.isBlank(innersotransitemValueRef))) {
                                                valueObject = new RuntimeBeanReference(innersotransitemValueRef);
                                            } else {
                                                valueObject = innersotransitemChild.getTextContent();
                                            }
                                            if ((innersotransitemKeyRef!= null)&&(!StringUtils.isBlank(innersotransitemKeyRef))) {
                                                keyObject = new RuntimeBeanReference(innersotransitemKeyRef);
                                            } else {
                                                keyObject = innersotransitemChild.getAttribute("key");
                                            }
                                            if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                                                keyObject = innersotransitemChild.getTagName();
                                            }
                                            innersotransitem.put(keyObject, valueObject);
                                        }
                                    }
                                    sOTransItems.add(innersotransitem);
                                }
                            }
                        }
                    }
                }
                builder.addPropertyValue("sOTransItems", sOTransItems);
            }
        }
        Element subTotalsListElement = null;
        subTotalsListElement = DomUtils.getChildElementByTagName(element, "sub-totals");
        List<Element> subTotalsListChilds = null;
        if (subTotalsListElement!= null) {
            String subTotalsRef = subTotalsListElement.getAttribute("ref");
            if ((subTotalsRef!= null)&&(!StringUtils.isBlank(subTotalsRef))) {
                if ((!subTotalsRef.startsWith(patternInfo.getPrefix()))&&(!subTotalsRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("subTotals", new RuntimeBeanReference(subTotalsRef));
                } else {
                    builder.addPropertyValue("subTotals", subTotalsRef);
                }
            } else {
                ManagedList subTotals = new ManagedList();
                subTotalsListChilds = DomUtils.getChildElementsByTagName(subTotalsListElement, "sub-total");
                if (subTotalsListChilds!= null) {
                    for (Element subTotalsChild: subTotalsListChilds) {
                        String valueRef = subTotalsChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            subTotals.add(new RuntimeBeanReference(valueRef));
                        } else {
                            List<Element> innersubtotalListChilds = null;
                            if (subTotalsChild!= null) {
                                String innersubtotalRef = subTotalsChild.getAttribute("ref");
                                if ((innersubtotalRef!= null)&&(!StringUtils.isBlank(innersubtotalRef))) {
                                    if ((!innersubtotalRef.startsWith(patternInfo.getPrefix()))&&(!innersubtotalRef.endsWith(patternInfo.getSuffix()))) {
                                        builder.addPropertyValue("inner-sub-total", new RuntimeBeanReference(innersubtotalRef));
                                    } else {
                                        builder.addPropertyValue("inner-sub-total", innersubtotalRef);
                                    }
                                } else {
                                    ManagedMap innersubtotal = new ManagedMap();
                                    innersubtotalListChilds = DomUtils.getChildElementsByTagName(subTotalsChild, "inner-sub-total");
                                    if (innersubtotalListChilds!= null) {
                                        if (innersubtotalListChilds.size() == 0) {
                                            innersubtotalListChilds = DomUtils.getChildElements(subTotalsChild);
                                        }
                                        for (Element innersubtotalChild: innersubtotalListChilds) {
                                            String innersubtotalValueRef = innersubtotalChild.getAttribute("value-ref");
                                            String innersubtotalKeyRef = innersubtotalChild.getAttribute("key-ref");
                                            Object valueObject = null;
                                            Object keyObject = null;
                                            if ((innersubtotalValueRef!= null)&&(!StringUtils.isBlank(innersubtotalValueRef))) {
                                                valueObject = new RuntimeBeanReference(innersubtotalValueRef);
                                            } else {
                                                valueObject = innersubtotalChild.getTextContent();
                                            }
                                            if ((innersubtotalKeyRef!= null)&&(!StringUtils.isBlank(innersubtotalKeyRef))) {
                                                keyObject = new RuntimeBeanReference(innersubtotalKeyRef);
                                            } else {
                                                keyObject = innersubtotalChild.getAttribute("key");
                                            }
                                            if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                                                keyObject = innersubtotalChild.getTagName();
                                            }
                                            innersubtotal.put(keyObject, valueObject);
                                        }
                                    }
                                    subTotals.add(innersubtotal);
                                }
                            }
                        }
                    }
                }
                builder.addPropertyValue("subTotals", subTotals);
            }
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        MutablePropertyValues propertyValues = parserContent.getContainingBeanDefinition().getPropertyValues();
        if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.config.spring.factories.PollingMessageSourceFactoryBean")) {
            propertyValues.addPropertyValue("messageProcessor", definition);
        } else {
            if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.enricher.MessageEnricher")) {
                propertyValues.addPropertyValue("enrichmentMessageProcessor", definition);
            } else {
                PropertyValue messageProcessors = propertyValues.getPropertyValue("messageProcessors");
                if ((messageProcessors == null)||(messageProcessors.getValue() == null)) {
                    propertyValues.addPropertyValue("messageProcessors", new ManagedList());
                }
                List listMessageProcessors = ((List) propertyValues.getPropertyValue("messageProcessors").getValue());
                listMessageProcessors.add(definition);
            }
        }
        return definition;
    }

    protected String getAttributeValue(Element element, String attributeName) {
        if (!StringUtils.isEmpty(element.getAttribute(attributeName))) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    private String generateChildBeanName(Element element) {
        String id = SpringXMLUtils.getNameOrId(element);
        if (StringUtils.isBlank(id)) {
            String parentId = SpringXMLUtils.getNameOrId(((Element) element.getParentNode()));
            return ((("."+ parentId)+":")+ element.getLocalName());
        } else {
            return id;
        }
    }

}
