
package org.mule.module.intacct.config.spring;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.module.intacct.config.CreateARAdjustmentMessageProcessor;
import org.mule.util.TemplateParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class CreateARAdjustmentDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public CreateARAdjustmentDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(CreateARAdjustmentMessageProcessor.class.getName());
        String configRef = element.getAttribute("config-ref");
        if ((configRef!= null)&&(!StringUtils.isBlank(configRef))) {
            builder.addPropertyValue("moduleObject", configRef);
        }
        if ((element.getAttribute("functionControlId")!= null)&&(!StringUtils.isBlank(element.getAttribute("functionControlId")))) {
            builder.addPropertyValue("functionControlId", element.getAttribute("functionControlId"));
        }
        if ((element.getAttribute("customerId")!= null)&&(!StringUtils.isBlank(element.getAttribute("customerId")))) {
            builder.addPropertyValue("customerId", element.getAttribute("customerId"));
        }
        Element dateCreatedListElement = null;
        dateCreatedListElement = DomUtils.getChildElementByTagName(element, "date-created");
        List<Element> dateCreatedListChilds = null;
        if (dateCreatedListElement!= null) {
            String dateCreatedRef = dateCreatedListElement.getAttribute("ref");
            if ((dateCreatedRef!= null)&&(!StringUtils.isBlank(dateCreatedRef))) {
                if ((!dateCreatedRef.startsWith(patternInfo.getPrefix()))&&(!dateCreatedRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("dateCreated", new RuntimeBeanReference(dateCreatedRef));
                } else {
                    builder.addPropertyValue("dateCreated", dateCreatedRef);
                }
            } else {
                ManagedMap dateCreated = new ManagedMap();
                dateCreatedListChilds = DomUtils.getChildElementsByTagName(dateCreatedListElement, "date-created");
                if (dateCreatedListChilds!= null) {
                    if (dateCreatedListChilds.size() == 0) {
                        dateCreatedListChilds = DomUtils.getChildElements(dateCreatedListElement);
                    }
                    for (Element dateCreatedChild: dateCreatedListChilds) {
                        String dateCreatedValueRef = dateCreatedChild.getAttribute("value-ref");
                        String dateCreatedKeyRef = dateCreatedChild.getAttribute("key-ref");
                        Object valueObject = null;
                        Object keyObject = null;
                        if ((dateCreatedValueRef!= null)&&(!StringUtils.isBlank(dateCreatedValueRef))) {
                            valueObject = new RuntimeBeanReference(dateCreatedValueRef);
                        } else {
                            valueObject = dateCreatedChild.getTextContent();
                        }
                        if ((dateCreatedKeyRef!= null)&&(!StringUtils.isBlank(dateCreatedKeyRef))) {
                            keyObject = new RuntimeBeanReference(dateCreatedKeyRef);
                        } else {
                            keyObject = dateCreatedChild.getAttribute("key");
                        }
                        if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                            keyObject = dateCreatedChild.getTagName();
                        }
                        dateCreated.put(keyObject, valueObject);
                    }
                }
                builder.addPropertyValue("dateCreated", dateCreated);
            }
        }
        Element datePostedListElement = null;
        datePostedListElement = DomUtils.getChildElementByTagName(element, "date-posted");
        List<Element> datePostedListChilds = null;
        if (datePostedListElement!= null) {
            String datePostedRef = datePostedListElement.getAttribute("ref");
            if ((datePostedRef!= null)&&(!StringUtils.isBlank(datePostedRef))) {
                if ((!datePostedRef.startsWith(patternInfo.getPrefix()))&&(!datePostedRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("datePosted", new RuntimeBeanReference(datePostedRef));
                } else {
                    builder.addPropertyValue("datePosted", datePostedRef);
                }
            } else {
                ManagedMap datePosted = new ManagedMap();
                datePostedListChilds = DomUtils.getChildElementsByTagName(datePostedListElement, "date-posted");
                if (datePostedListChilds!= null) {
                    if (datePostedListChilds.size() == 0) {
                        datePostedListChilds = DomUtils.getChildElements(datePostedListElement);
                    }
                    for (Element datePostedChild: datePostedListChilds) {
                        String datePostedValueRef = datePostedChild.getAttribute("value-ref");
                        String datePostedKeyRef = datePostedChild.getAttribute("key-ref");
                        Object valueObject = null;
                        Object keyObject = null;
                        if ((datePostedValueRef!= null)&&(!StringUtils.isBlank(datePostedValueRef))) {
                            valueObject = new RuntimeBeanReference(datePostedValueRef);
                        } else {
                            valueObject = datePostedChild.getTextContent();
                        }
                        if ((datePostedKeyRef!= null)&&(!StringUtils.isBlank(datePostedKeyRef))) {
                            keyObject = new RuntimeBeanReference(datePostedKeyRef);
                        } else {
                            keyObject = datePostedChild.getAttribute("key");
                        }
                        if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                            keyObject = datePostedChild.getTagName();
                        }
                        datePosted.put(keyObject, valueObject);
                    }
                }
                builder.addPropertyValue("datePosted", datePosted);
            }
        }
        if ((element.getAttribute("batchKey")!= null)&&(!StringUtils.isBlank(element.getAttribute("batchKey")))) {
            builder.addPropertyValue("batchKey", element.getAttribute("batchKey"));
        }
        if ((element.getAttribute("adjustmentNo")!= null)&&(!StringUtils.isBlank(element.getAttribute("adjustmentNo")))) {
            builder.addPropertyValue("adjustmentNo", element.getAttribute("adjustmentNo"));
        }
        if ((element.getAttribute("invoiceNo")!= null)&&(!StringUtils.isBlank(element.getAttribute("invoiceNo")))) {
            builder.addPropertyValue("invoiceNo", element.getAttribute("invoiceNo"));
        }
        if ((element.getAttribute("description")!= null)&&(!StringUtils.isBlank(element.getAttribute("description")))) {
            builder.addPropertyValue("description", element.getAttribute("description"));
        }
        if ((element.getAttribute("externalId")!= null)&&(!StringUtils.isBlank(element.getAttribute("externalId")))) {
            builder.addPropertyValue("externalId", element.getAttribute("externalId"));
        }
        if ((element.getAttribute("basecurr")!= null)&&(!StringUtils.isBlank(element.getAttribute("basecurr")))) {
            builder.addPropertyValue("basecurr", element.getAttribute("basecurr"));
        }
        if ((element.getAttribute("currency")!= null)&&(!StringUtils.isBlank(element.getAttribute("currency")))) {
            builder.addPropertyValue("currency", element.getAttribute("currency"));
        }
        if (element.hasAttribute("exchType")) {
            builder.addPropertyValue("exchType", element.getAttribute("exchType"));
        }
        Element exchRateDatesOrExchRateTypesOrExchRatesListElement = null;
        exchRateDatesOrExchRateTypesOrExchRatesListElement = DomUtils.getChildElementByTagName(element, "exch-rate-dates-or-exch-rate-types-or-exch-rates");
        List<Element> exchRateDatesOrExchRateTypesOrExchRatesListChilds = null;
        if (exchRateDatesOrExchRateTypesOrExchRatesListElement!= null) {
            String exchRateDatesOrExchRateTypesOrExchRatesRef = exchRateDatesOrExchRateTypesOrExchRatesListElement.getAttribute("ref");
            if ((exchRateDatesOrExchRateTypesOrExchRatesRef!= null)&&(!StringUtils.isBlank(exchRateDatesOrExchRateTypesOrExchRatesRef))) {
                if ((!exchRateDatesOrExchRateTypesOrExchRatesRef.startsWith(patternInfo.getPrefix()))&&(!exchRateDatesOrExchRateTypesOrExchRatesRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("exchRateDatesOrExchRateTypesOrExchRates", new RuntimeBeanReference(exchRateDatesOrExchRateTypesOrExchRatesRef));
                } else {
                    builder.addPropertyValue("exchRateDatesOrExchRateTypesOrExchRates", exchRateDatesOrExchRateTypesOrExchRatesRef);
                }
            } else {
                ManagedList exchRateDatesOrExchRateTypesOrExchRates = new ManagedList();
                exchRateDatesOrExchRateTypesOrExchRatesListChilds = DomUtils.getChildElementsByTagName(exchRateDatesOrExchRateTypesOrExchRatesListElement, "exch-rate-dates-or-exch-rate-types-or-exch-rate");
                if (exchRateDatesOrExchRateTypesOrExchRatesListChilds!= null) {
                    for (Element exchRateDatesOrExchRateTypesOrExchRatesChild: exchRateDatesOrExchRateTypesOrExchRatesListChilds) {
                        String valueRef = exchRateDatesOrExchRateTypesOrExchRatesChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            exchRateDatesOrExchRateTypesOrExchRates.add(new RuntimeBeanReference(valueRef));
                        } else {
                            List<Element> innerexchratedatesorexchratetypesorexchrateListChilds = null;
                            if (exchRateDatesOrExchRateTypesOrExchRatesChild!= null) {
                                String innerexchratedatesorexchratetypesorexchrateRef = exchRateDatesOrExchRateTypesOrExchRatesChild.getAttribute("ref");
                                if ((innerexchratedatesorexchratetypesorexchrateRef!= null)&&(!StringUtils.isBlank(innerexchratedatesorexchratetypesorexchrateRef))) {
                                    if ((!innerexchratedatesorexchratetypesorexchrateRef.startsWith(patternInfo.getPrefix()))&&(!innerexchratedatesorexchratetypesorexchrateRef.endsWith(patternInfo.getSuffix()))) {
                                        builder.addPropertyValue("inner-exch-rate-dates-or-exch-rate-types-or-exch-rate", new RuntimeBeanReference(innerexchratedatesorexchratetypesorexchrateRef));
                                    } else {
                                        builder.addPropertyValue("inner-exch-rate-dates-or-exch-rate-types-or-exch-rate", innerexchratedatesorexchratetypesorexchrateRef);
                                    }
                                } else {
                                    ManagedMap innerexchratedatesorexchratetypesorexchrate = new ManagedMap();
                                    innerexchratedatesorexchratetypesorexchrateListChilds = DomUtils.getChildElementsByTagName(exchRateDatesOrExchRateTypesOrExchRatesChild, "inner-exch-rate-dates-or-exch-rate-types-or-exch-rate");
                                    if (innerexchratedatesorexchratetypesorexchrateListChilds!= null) {
                                        if (innerexchratedatesorexchratetypesorexchrateListChilds.size() == 0) {
                                            innerexchratedatesorexchratetypesorexchrateListChilds = DomUtils.getChildElements(exchRateDatesOrExchRateTypesOrExchRatesChild);
                                        }
                                        for (Element innerexchratedatesorexchratetypesorexchrateChild: innerexchratedatesorexchratetypesorexchrateListChilds) {
                                            String innerexchratedatesorexchratetypesorexchrateValueRef = innerexchratedatesorexchratetypesorexchrateChild.getAttribute("value-ref");
                                            String innerexchratedatesorexchratetypesorexchrateKeyRef = innerexchratedatesorexchratetypesorexchrateChild.getAttribute("key-ref");
                                            Object valueObject = null;
                                            Object keyObject = null;
                                            if ((innerexchratedatesorexchratetypesorexchrateValueRef!= null)&&(!StringUtils.isBlank(innerexchratedatesorexchratetypesorexchrateValueRef))) {
                                                valueObject = new RuntimeBeanReference(innerexchratedatesorexchratetypesorexchrateValueRef);
                                            } else {
                                                valueObject = innerexchratedatesorexchratetypesorexchrateChild.getTextContent();
                                            }
                                            if ((innerexchratedatesorexchratetypesorexchrateKeyRef!= null)&&(!StringUtils.isBlank(innerexchratedatesorexchratetypesorexchrateKeyRef))) {
                                                keyObject = new RuntimeBeanReference(innerexchratedatesorexchratetypesorexchrateKeyRef);
                                            } else {
                                                keyObject = innerexchratedatesorexchratetypesorexchrateChild.getAttribute("key");
                                            }
                                            if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                                                keyObject = innerexchratedatesorexchratetypesorexchrateChild.getTagName();
                                            }
                                            innerexchratedatesorexchratetypesorexchrate.put(keyObject, valueObject);
                                        }
                                    }
                                    exchRateDatesOrExchRateTypesOrExchRates.add(innerexchratedatesorexchratetypesorexchrate);
                                }
                            }
                        }
                    }
                }
                builder.addPropertyValue("exchRateDatesOrExchRateTypesOrExchRates", exchRateDatesOrExchRateTypesOrExchRates);
            }
        }
        if ((element.getAttribute("nogl")!= null)&&(!StringUtils.isBlank(element.getAttribute("nogl")))) {
            builder.addPropertyValue("nogl", element.getAttribute("nogl"));
        }
        Element aRAdjustmentItemsListElement = null;
        aRAdjustmentItemsListElement = DomUtils.getChildElementByTagName(element, "a-r-adjustment-items");
        List<Element> aRAdjustmentItemsListChilds = null;
        if (aRAdjustmentItemsListElement!= null) {
            String aRAdjustmentItemsRef = aRAdjustmentItemsListElement.getAttribute("ref");
            if ((aRAdjustmentItemsRef!= null)&&(!StringUtils.isBlank(aRAdjustmentItemsRef))) {
                if ((!aRAdjustmentItemsRef.startsWith(patternInfo.getPrefix()))&&(!aRAdjustmentItemsRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("aRAdjustmentItems", new RuntimeBeanReference(aRAdjustmentItemsRef));
                } else {
                    builder.addPropertyValue("aRAdjustmentItems", aRAdjustmentItemsRef);
                }
            } else {
                ManagedList aRAdjustmentItems = new ManagedList();
                aRAdjustmentItemsListChilds = DomUtils.getChildElementsByTagName(aRAdjustmentItemsListElement, "a-r-adjustment-item");
                if (aRAdjustmentItemsListChilds!= null) {
                    for (Element aRAdjustmentItemsChild: aRAdjustmentItemsListChilds) {
                        String valueRef = aRAdjustmentItemsChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            aRAdjustmentItems.add(new RuntimeBeanReference(valueRef));
                        } else {
                            List<Element> inneraradjustmentitemListChilds = null;
                            if (aRAdjustmentItemsChild!= null) {
                                String inneraradjustmentitemRef = aRAdjustmentItemsChild.getAttribute("ref");
                                if ((inneraradjustmentitemRef!= null)&&(!StringUtils.isBlank(inneraradjustmentitemRef))) {
                                    if ((!inneraradjustmentitemRef.startsWith(patternInfo.getPrefix()))&&(!inneraradjustmentitemRef.endsWith(patternInfo.getSuffix()))) {
                                        builder.addPropertyValue("inner-a-r-adjustment-item", new RuntimeBeanReference(inneraradjustmentitemRef));
                                    } else {
                                        builder.addPropertyValue("inner-a-r-adjustment-item", inneraradjustmentitemRef);
                                    }
                                } else {
                                    ManagedMap inneraradjustmentitem = new ManagedMap();
                                    inneraradjustmentitemListChilds = DomUtils.getChildElementsByTagName(aRAdjustmentItemsChild, "inner-a-r-adjustment-item");
                                    if (inneraradjustmentitemListChilds!= null) {
                                        if (inneraradjustmentitemListChilds.size() == 0) {
                                            inneraradjustmentitemListChilds = DomUtils.getChildElements(aRAdjustmentItemsChild);
                                        }
                                        for (Element inneraradjustmentitemChild: inneraradjustmentitemListChilds) {
                                            String inneraradjustmentitemValueRef = inneraradjustmentitemChild.getAttribute("value-ref");
                                            String inneraradjustmentitemKeyRef = inneraradjustmentitemChild.getAttribute("key-ref");
                                            Object valueObject = null;
                                            Object keyObject = null;
                                            if ((inneraradjustmentitemValueRef!= null)&&(!StringUtils.isBlank(inneraradjustmentitemValueRef))) {
                                                valueObject = new RuntimeBeanReference(inneraradjustmentitemValueRef);
                                            } else {
                                                valueObject = inneraradjustmentitemChild.getTextContent();
                                            }
                                            if ((inneraradjustmentitemKeyRef!= null)&&(!StringUtils.isBlank(inneraradjustmentitemKeyRef))) {
                                                keyObject = new RuntimeBeanReference(inneraradjustmentitemKeyRef);
                                            } else {
                                                keyObject = inneraradjustmentitemChild.getAttribute("key");
                                            }
                                            if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                                                keyObject = inneraradjustmentitemChild.getTagName();
                                            }
                                            inneraradjustmentitem.put(keyObject, valueObject);
                                        }
                                    }
                                    aRAdjustmentItems.add(inneraradjustmentitem);
                                }
                            }
                        }
                    }
                }
                builder.addPropertyValue("aRAdjustmentItems", aRAdjustmentItems);
            }
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        MutablePropertyValues propertyValues = parserContent.getContainingBeanDefinition().getPropertyValues();
        if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.config.spring.factories.PollingMessageSourceFactoryBean")) {
            propertyValues.addPropertyValue("messageProcessor", definition);
        } else {
            if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.enricher.MessageEnricher")) {
                propertyValues.addPropertyValue("enrichmentMessageProcessor", definition);
            } else {
                PropertyValue messageProcessors = propertyValues.getPropertyValue("messageProcessors");
                if ((messageProcessors == null)||(messageProcessors.getValue() == null)) {
                    propertyValues.addPropertyValue("messageProcessors", new ManagedList());
                }
                List listMessageProcessors = ((List) propertyValues.getPropertyValue("messageProcessors").getValue());
                listMessageProcessors.add(definition);
            }
        }
        return definition;
    }

    protected String getAttributeValue(Element element, String attributeName) {
        if (!StringUtils.isEmpty(element.getAttribute(attributeName))) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    private String generateChildBeanName(Element element) {
        String id = SpringXMLUtils.getNameOrId(element);
        if (StringUtils.isBlank(id)) {
            String parentId = SpringXMLUtils.getNameOrId(((Element) element.getParentNode()));
            return ((("."+ parentId)+":")+ element.getLocalName());
        } else {
            return id;
        }
    }

}
