
package org.mule.module.intacct.config.spring;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.module.intacct.config.OperationMessageProcessor;
import org.mule.util.TemplateParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class OperationDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public OperationDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(OperationMessageProcessor.class.getName());
        String configRef = element.getAttribute("config-ref");
        if ((configRef!= null)&&(!StringUtils.isBlank(configRef))) {
            builder.addPropertyValue("moduleObject", configRef);
        }
        Element functionListElement = null;
        functionListElement = DomUtils.getChildElementByTagName(element, "function");
        List<Element> functionListChilds = null;
        if (functionListElement!= null) {
            String functionRef = functionListElement.getAttribute("ref");
            if ((functionRef!= null)&&(!StringUtils.isBlank(functionRef))) {
                if ((!functionRef.startsWith(patternInfo.getPrefix()))&&(!functionRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("function", new RuntimeBeanReference(functionRef));
                } else {
                    builder.addPropertyValue("function", functionRef);
                }
            } else {
                ManagedMap function = new ManagedMap();
                functionListChilds = DomUtils.getChildElementsByTagName(functionListElement, "function");
                if (functionListChilds!= null) {
                    if (functionListChilds.size() == 0) {
                        functionListChilds = DomUtils.getChildElements(functionListElement);
                    }
                    for (Element functionChild: functionListChilds) {
                        String functionValueRef = functionChild.getAttribute("value-ref");
                        String functionKeyRef = functionChild.getAttribute("key-ref");
                        Object valueObject = null;
                        Object keyObject = null;
                        if ((functionValueRef!= null)&&(!StringUtils.isBlank(functionValueRef))) {
                            valueObject = new RuntimeBeanReference(functionValueRef);
                        } else {
                            valueObject = functionChild.getTextContent();
                        }
                        if ((functionKeyRef!= null)&&(!StringUtils.isBlank(functionKeyRef))) {
                            keyObject = new RuntimeBeanReference(functionKeyRef);
                        } else {
                            keyObject = functionChild.getAttribute("key");
                        }
                        if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                            keyObject = functionChild.getTagName();
                        }
                        function.put(keyObject, valueObject);
                    }
                }
                builder.addPropertyValue("function", function);
            }
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        MutablePropertyValues propertyValues = parserContent.getContainingBeanDefinition().getPropertyValues();
        if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.config.spring.factories.PollingMessageSourceFactoryBean")) {
            propertyValues.addPropertyValue("messageProcessor", definition);
        } else {
            if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.enricher.MessageEnricher")) {
                propertyValues.addPropertyValue("enrichmentMessageProcessor", definition);
            } else {
                PropertyValue messageProcessors = propertyValues.getPropertyValue("messageProcessors");
                if ((messageProcessors == null)||(messageProcessors.getValue() == null)) {
                    propertyValues.addPropertyValue("messageProcessors", new ManagedList());
                }
                List listMessageProcessors = ((List) propertyValues.getPropertyValue("messageProcessors").getValue());
                listMessageProcessors.add(definition);
            }
        }
        return definition;
    }

    protected String getAttributeValue(Element element, String attributeName) {
        if (!StringUtils.isEmpty(element.getAttribute(attributeName))) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    private String generateChildBeanName(Element element) {
        String id = SpringXMLUtils.getNameOrId(element);
        if (StringUtils.isBlank(id)) {
            String parentId = SpringXMLUtils.getNameOrId(((Element) element.getParentNode()));
            return ((("."+ parentId)+":")+ element.getLocalName());
        } else {
            return id;
        }
    }

}
