
package org.mule.module.intacct.config.spring;

import org.apache.commons.lang.StringUtils;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.parsers.generic.AutoIdUtils;
import org.mule.module.intacct.config.IntacctCloudConnectorLifecycleAdapter;
import org.mule.util.TemplateParser;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class IntacctCloudConnectorConfigDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public IntacctCloudConnectorConfigDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        String name = element.getAttribute("name");
        if ((name == null)||StringUtils.isBlank(name)) {
            element.setAttribute("name", AutoIdUtils.getUniqueName(element, "mule-bean"));
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(IntacctCloudConnectorLifecycleAdapter.class.getName());
        if (Initialisable.class.isAssignableFrom(IntacctCloudConnectorLifecycleAdapter.class)) {
            builder.setInitMethodName(Initialisable.PHASE_NAME);
        }
        if (Disposable.class.isAssignableFrom(IntacctCloudConnectorLifecycleAdapter.class)) {
            builder.setDestroyMethodName(Disposable.PHASE_NAME);
        }
        if ((element.getAttribute("senderId")!= null)&&(!StringUtils.isBlank(element.getAttribute("senderId")))) {
            builder.addPropertyValue("senderId", element.getAttribute("senderId"));
        }
        if ((element.getAttribute("controlPassword")!= null)&&(!StringUtils.isBlank(element.getAttribute("controlPassword")))) {
            builder.addPropertyValue("controlPassword", element.getAttribute("controlPassword"));
        }
        if ((element.getAttribute("controlId")!= null)&&(!StringUtils.isBlank(element.getAttribute("controlId")))) {
            builder.addPropertyValue("controlId", element.getAttribute("controlId"));
        }
        if ((element.getAttribute("uniqueId")!= null)&&(!StringUtils.isBlank(element.getAttribute("uniqueId")))) {
            builder.addPropertyValue("uniqueId", element.getAttribute("uniqueId"));
        }
        if ((element.getAttribute("userId")!= null)&&(!StringUtils.isBlank(element.getAttribute("userId")))) {
            builder.addPropertyValue("userId", element.getAttribute("userId"));
        }
        if ((element.getAttribute("userPassword")!= null)&&(!StringUtils.isBlank(element.getAttribute("userPassword")))) {
            builder.addPropertyValue("userPassword", element.getAttribute("userPassword"));
        }
        if ((element.getAttribute("companyId")!= null)&&(!StringUtils.isBlank(element.getAttribute("companyId")))) {
            builder.addPropertyValue("companyId", element.getAttribute("companyId"));
        }
        if ((element.getAttribute("intacctImplementation-ref")!= null)&&(!StringUtils.isBlank(element.getAttribute("intacctImplementation-ref")))) {
            builder.addPropertyValue("intacctImplementation", new RuntimeBeanReference(element.getAttribute("intacctImplementation-ref")));
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        return definition;
    }

}
