
package org.mule.module.intacct.config.spring;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.module.intacct.config.GetListMessageProcessor;
import org.mule.util.TemplateParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class GetListDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public GetListDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(GetListMessageProcessor.class.getName());
        String configRef = element.getAttribute("config-ref");
        if ((configRef!= null)&&(!StringUtils.isBlank(configRef))) {
            builder.addPropertyValue("moduleObject", configRef);
        }
        if ((element.getAttribute("functionControlId")!= null)&&(!StringUtils.isBlank(element.getAttribute("functionControlId")))) {
            builder.addPropertyValue("functionControlId", element.getAttribute("functionControlId"));
        }
        if ((element.getAttribute("obj")!= null)&&(!StringUtils.isBlank(element.getAttribute("obj")))) {
            builder.addPropertyValue("obj", element.getAttribute("obj"));
        }
        if ((element.getAttribute("start")!= null)&&(!StringUtils.isBlank(element.getAttribute("start")))) {
            builder.addPropertyValue("start", element.getAttribute("start"));
        }
        if ((element.getAttribute("maxItems")!= null)&&(!StringUtils.isBlank(element.getAttribute("maxItems")))) {
            builder.addPropertyValue("maxItems", element.getAttribute("maxItems"));
        }
        if ((element.getAttribute("showPrivate")!= null)&&(!StringUtils.isBlank(element.getAttribute("showPrivate")))) {
            builder.addPropertyValue("showPrivate", element.getAttribute("showPrivate"));
        }
        Element filtersListElement = null;
        filtersListElement = DomUtils.getChildElementByTagName(element, "filters");
        List<Element> filtersListChilds = null;
        if (filtersListElement!= null) {
            String filtersRef = filtersListElement.getAttribute("ref");
            if ((filtersRef!= null)&&(!StringUtils.isBlank(filtersRef))) {
                if ((!filtersRef.startsWith(patternInfo.getPrefix()))&&(!filtersRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("filters", new RuntimeBeanReference(filtersRef));
                } else {
                    builder.addPropertyValue("filters", filtersRef);
                }
            } else {
                ManagedList filters = new ManagedList();
                filtersListChilds = DomUtils.getChildElementsByTagName(filtersListElement, "filter");
                if (filtersListChilds!= null) {
                    for (Element filtersChild: filtersListChilds) {
                        String valueRef = filtersChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            filters.add(new RuntimeBeanReference(valueRef));
                        } else {
                            filters.add(filtersChild.getTextContent());
                        }
                    }
                }
                builder.addPropertyValue("filters", filters);
            }
        }
        Element sortsListElement = null;
        sortsListElement = DomUtils.getChildElementByTagName(element, "sorts");
        List<Element> sortsListChilds = null;
        if (sortsListElement!= null) {
            String sortsRef = sortsListElement.getAttribute("ref");
            if ((sortsRef!= null)&&(!StringUtils.isBlank(sortsRef))) {
                if ((!sortsRef.startsWith(patternInfo.getPrefix()))&&(!sortsRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("sorts", new RuntimeBeanReference(sortsRef));
                } else {
                    builder.addPropertyValue("sorts", sortsRef);
                }
            } else {
                ManagedList sorts = new ManagedList();
                sortsListChilds = DomUtils.getChildElementsByTagName(sortsListElement, "sort");
                if (sortsListChilds!= null) {
                    for (Element sortsChild: sortsListChilds) {
                        String valueRef = sortsChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            sorts.add(new RuntimeBeanReference(valueRef));
                        } else {
                            List<Element> innersortListChilds = null;
                            if (sortsChild!= null) {
                                String innersortRef = sortsChild.getAttribute("ref");
                                if ((innersortRef!= null)&&(!StringUtils.isBlank(innersortRef))) {
                                    if ((!innersortRef.startsWith(patternInfo.getPrefix()))&&(!innersortRef.endsWith(patternInfo.getSuffix()))) {
                                        builder.addPropertyValue("inner-sort", new RuntimeBeanReference(innersortRef));
                                    } else {
                                        builder.addPropertyValue("inner-sort", innersortRef);
                                    }
                                } else {
                                    ManagedMap innersort = new ManagedMap();
                                    innersortListChilds = DomUtils.getChildElementsByTagName(sortsChild, "inner-sort");
                                    if (innersortListChilds!= null) {
                                        if (innersortListChilds.size() == 0) {
                                            innersortListChilds = DomUtils.getChildElements(sortsChild);
                                        }
                                        for (Element innersortChild: innersortListChilds) {
                                            String innersortValueRef = innersortChild.getAttribute("value-ref");
                                            String innersortKeyRef = innersortChild.getAttribute("key-ref");
                                            Object valueObject = null;
                                            Object keyObject = null;
                                            if ((innersortValueRef!= null)&&(!StringUtils.isBlank(innersortValueRef))) {
                                                valueObject = new RuntimeBeanReference(innersortValueRef);
                                            } else {
                                                valueObject = innersortChild.getTextContent();
                                            }
                                            if ((innersortKeyRef!= null)&&(!StringUtils.isBlank(innersortKeyRef))) {
                                                keyObject = new RuntimeBeanReference(innersortKeyRef);
                                            } else {
                                                keyObject = innersortChild.getAttribute("key");
                                            }
                                            if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                                                keyObject = innersortChild.getTagName();
                                            }
                                            innersort.put(keyObject, valueObject);
                                        }
                                    }
                                    sorts.add(innersort);
                                }
                            }
                        }
                    }
                }
                builder.addPropertyValue("sorts", sorts);
            }
        }
        Element fieldsListElement = null;
        fieldsListElement = DomUtils.getChildElementByTagName(element, "fields");
        List<Element> fieldsListChilds = null;
        if (fieldsListElement!= null) {
            String fieldsRef = fieldsListElement.getAttribute("ref");
            if ((fieldsRef!= null)&&(!StringUtils.isBlank(fieldsRef))) {
                if ((!fieldsRef.startsWith(patternInfo.getPrefix()))&&(!fieldsRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("fields", new RuntimeBeanReference(fieldsRef));
                } else {
                    builder.addPropertyValue("fields", fieldsRef);
                }
            } else {
                ManagedList fields = new ManagedList();
                fieldsListChilds = DomUtils.getChildElementsByTagName(fieldsListElement, "field");
                if (fieldsListChilds!= null) {
                    for (Element fieldsChild: fieldsListChilds) {
                        String valueRef = fieldsChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            fields.add(new RuntimeBeanReference(valueRef));
                        } else {
                            List<Element> innerfieldListChilds = null;
                            if (fieldsChild!= null) {
                                String innerfieldRef = fieldsChild.getAttribute("ref");
                                if ((innerfieldRef!= null)&&(!StringUtils.isBlank(innerfieldRef))) {
                                    if ((!innerfieldRef.startsWith(patternInfo.getPrefix()))&&(!innerfieldRef.endsWith(patternInfo.getSuffix()))) {
                                        builder.addPropertyValue("inner-field", new RuntimeBeanReference(innerfieldRef));
                                    } else {
                                        builder.addPropertyValue("inner-field", innerfieldRef);
                                    }
                                } else {
                                    ManagedMap innerfield = new ManagedMap();
                                    innerfieldListChilds = DomUtils.getChildElementsByTagName(fieldsChild, "inner-field");
                                    if (innerfieldListChilds!= null) {
                                        if (innerfieldListChilds.size() == 0) {
                                            innerfieldListChilds = DomUtils.getChildElements(fieldsChild);
                                        }
                                        for (Element innerfieldChild: innerfieldListChilds) {
                                            String innerfieldValueRef = innerfieldChild.getAttribute("value-ref");
                                            String innerfieldKeyRef = innerfieldChild.getAttribute("key-ref");
                                            Object valueObject = null;
                                            Object keyObject = null;
                                            if ((innerfieldValueRef!= null)&&(!StringUtils.isBlank(innerfieldValueRef))) {
                                                valueObject = new RuntimeBeanReference(innerfieldValueRef);
                                            } else {
                                                valueObject = innerfieldChild.getTextContent();
                                            }
                                            if ((innerfieldKeyRef!= null)&&(!StringUtils.isBlank(innerfieldKeyRef))) {
                                                keyObject = new RuntimeBeanReference(innerfieldKeyRef);
                                            } else {
                                                keyObject = innerfieldChild.getAttribute("key");
                                            }
                                            if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                                                keyObject = innerfieldChild.getTagName();
                                            }
                                            innerfield.put(keyObject, valueObject);
                                        }
                                    }
                                    fields.add(innerfield);
                                }
                            }
                        }
                    }
                }
                builder.addPropertyValue("fields", fields);
            }
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        MutablePropertyValues propertyValues = parserContent.getContainingBeanDefinition().getPropertyValues();
        if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.config.spring.factories.PollingMessageSourceFactoryBean")) {
            propertyValues.addPropertyValue("messageProcessor", definition);
        } else {
            if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.enricher.MessageEnricher")) {
                propertyValues.addPropertyValue("enrichmentMessageProcessor", definition);
            } else {
                PropertyValue messageProcessors = propertyValues.getPropertyValue("messageProcessors");
                if ((messageProcessors == null)||(messageProcessors.getValue() == null)) {
                    propertyValues.addPropertyValue("messageProcessors", new ManagedList());
                }
                List listMessageProcessors = ((List) propertyValues.getPropertyValue("messageProcessors").getValue());
                listMessageProcessors.add(definition);
            }
        }
        return definition;
    }

    protected String getAttributeValue(Element element, String attributeName) {
        if (!StringUtils.isEmpty(element.getAttribute(attributeName))) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    private String generateChildBeanName(Element element) {
        String id = SpringXMLUtils.getNameOrId(element);
        if (StringUtils.isBlank(id)) {
            String parentId = SpringXMLUtils.getNameOrId(((Element) element.getParentNode()));
            return ((("."+ parentId)+":")+ element.getLocalName());
        } else {
            return id;
        }
    }

}
