
package org.mule.module.intacct.config.spring;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.module.intacct.config.CreateInvoiceMessageProcessor;
import org.mule.util.TemplateParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class CreateInvoiceDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public CreateInvoiceDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(CreateInvoiceMessageProcessor.class.getName());
        String configRef = element.getAttribute("config-ref");
        if ((configRef!= null)&&(!StringUtils.isBlank(configRef))) {
            builder.addPropertyValue("moduleObject", configRef);
        }
        if ((element.getAttribute("functionControlId")!= null)&&(!StringUtils.isBlank(element.getAttribute("functionControlId")))) {
            builder.addPropertyValue("functionControlId", element.getAttribute("functionControlId"));
        }
        if ((element.getAttribute("customerId")!= null)&&(!StringUtils.isBlank(element.getAttribute("customerId")))) {
            builder.addPropertyValue("customerId", element.getAttribute("customerId"));
        }
        Element dateCreatedListElement = null;
        dateCreatedListElement = DomUtils.getChildElementByTagName(element, "date-created");
        List<Element> dateCreatedListChilds = null;
        if (dateCreatedListElement!= null) {
            String dateCreatedRef = dateCreatedListElement.getAttribute("ref");
            if ((dateCreatedRef!= null)&&(!StringUtils.isBlank(dateCreatedRef))) {
                if ((!dateCreatedRef.startsWith(patternInfo.getPrefix()))&&(!dateCreatedRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("dateCreated", new RuntimeBeanReference(dateCreatedRef));
                } else {
                    builder.addPropertyValue("dateCreated", dateCreatedRef);
                }
            } else {
                ManagedMap dateCreated = new ManagedMap();
                dateCreatedListChilds = DomUtils.getChildElementsByTagName(dateCreatedListElement, "date-created");
                if (dateCreatedListChilds!= null) {
                    if (dateCreatedListChilds.size() == 0) {
                        dateCreatedListChilds = DomUtils.getChildElements(dateCreatedListElement);
                    }
                    for (Element dateCreatedChild: dateCreatedListChilds) {
                        String dateCreatedValueRef = dateCreatedChild.getAttribute("value-ref");
                        String dateCreatedKeyRef = dateCreatedChild.getAttribute("key-ref");
                        Object valueObject = null;
                        Object keyObject = null;
                        if ((dateCreatedValueRef!= null)&&(!StringUtils.isBlank(dateCreatedValueRef))) {
                            valueObject = new RuntimeBeanReference(dateCreatedValueRef);
                        } else {
                            valueObject = dateCreatedChild.getTextContent();
                        }
                        if ((dateCreatedKeyRef!= null)&&(!StringUtils.isBlank(dateCreatedKeyRef))) {
                            keyObject = new RuntimeBeanReference(dateCreatedKeyRef);
                        } else {
                            keyObject = dateCreatedChild.getAttribute("key");
                        }
                        if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                            keyObject = dateCreatedChild.getTagName();
                        }
                        dateCreated.put(keyObject, valueObject);
                    }
                }
                builder.addPropertyValue("dateCreated", dateCreated);
            }
        }
        Element datePostedListElement = null;
        datePostedListElement = DomUtils.getChildElementByTagName(element, "date-posted");
        List<Element> datePostedListChilds = null;
        if (datePostedListElement!= null) {
            String datePostedRef = datePostedListElement.getAttribute("ref");
            if ((datePostedRef!= null)&&(!StringUtils.isBlank(datePostedRef))) {
                if ((!datePostedRef.startsWith(patternInfo.getPrefix()))&&(!datePostedRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("datePosted", new RuntimeBeanReference(datePostedRef));
                } else {
                    builder.addPropertyValue("datePosted", datePostedRef);
                }
            } else {
                ManagedMap datePosted = new ManagedMap();
                datePostedListChilds = DomUtils.getChildElementsByTagName(datePostedListElement, "date-posted");
                if (datePostedListChilds!= null) {
                    if (datePostedListChilds.size() == 0) {
                        datePostedListChilds = DomUtils.getChildElements(datePostedListElement);
                    }
                    for (Element datePostedChild: datePostedListChilds) {
                        String datePostedValueRef = datePostedChild.getAttribute("value-ref");
                        String datePostedKeyRef = datePostedChild.getAttribute("key-ref");
                        Object valueObject = null;
                        Object keyObject = null;
                        if ((datePostedValueRef!= null)&&(!StringUtils.isBlank(datePostedValueRef))) {
                            valueObject = new RuntimeBeanReference(datePostedValueRef);
                        } else {
                            valueObject = datePostedChild.getTextContent();
                        }
                        if ((datePostedKeyRef!= null)&&(!StringUtils.isBlank(datePostedKeyRef))) {
                            keyObject = new RuntimeBeanReference(datePostedKeyRef);
                        } else {
                            keyObject = datePostedChild.getAttribute("key");
                        }
                        if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                            keyObject = datePostedChild.getTagName();
                        }
                        datePosted.put(keyObject, valueObject);
                    }
                }
                builder.addPropertyValue("datePosted", datePosted);
            }
        }
        Element dateDueListElement = null;
        dateDueListElement = DomUtils.getChildElementByTagName(element, "date-due");
        List<Element> dateDueListChilds = null;
        if (dateDueListElement!= null) {
            String dateDueRef = dateDueListElement.getAttribute("ref");
            if ((dateDueRef!= null)&&(!StringUtils.isBlank(dateDueRef))) {
                if ((!dateDueRef.startsWith(patternInfo.getPrefix()))&&(!dateDueRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("dateDue", new RuntimeBeanReference(dateDueRef));
                } else {
                    builder.addPropertyValue("dateDue", dateDueRef);
                }
            } else {
                ManagedMap dateDue = new ManagedMap();
                dateDueListChilds = DomUtils.getChildElementsByTagName(dateDueListElement, "date-due");
                if (dateDueListChilds!= null) {
                    if (dateDueListChilds.size() == 0) {
                        dateDueListChilds = DomUtils.getChildElements(dateDueListElement);
                    }
                    for (Element dateDueChild: dateDueListChilds) {
                        String dateDueValueRef = dateDueChild.getAttribute("value-ref");
                        String dateDueKeyRef = dateDueChild.getAttribute("key-ref");
                        Object valueObject = null;
                        Object keyObject = null;
                        if ((dateDueValueRef!= null)&&(!StringUtils.isBlank(dateDueValueRef))) {
                            valueObject = new RuntimeBeanReference(dateDueValueRef);
                        } else {
                            valueObject = dateDueChild.getTextContent();
                        }
                        if ((dateDueKeyRef!= null)&&(!StringUtils.isBlank(dateDueKeyRef))) {
                            keyObject = new RuntimeBeanReference(dateDueKeyRef);
                        } else {
                            keyObject = dateDueChild.getAttribute("key");
                        }
                        if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                            keyObject = dateDueChild.getTagName();
                        }
                        dateDue.put(keyObject, valueObject);
                    }
                }
                builder.addPropertyValue("dateDue", dateDue);
            }
        }
        if ((element.getAttribute("termName")!= null)&&(!StringUtils.isBlank(element.getAttribute("termName")))) {
            builder.addPropertyValue("termName", element.getAttribute("termName"));
        }
        if ((element.getAttribute("batchKey")!= null)&&(!StringUtils.isBlank(element.getAttribute("batchKey")))) {
            builder.addPropertyValue("batchKey", element.getAttribute("batchKey"));
        }
        if ((element.getAttribute("invoiceNo")!= null)&&(!StringUtils.isBlank(element.getAttribute("invoiceNo")))) {
            builder.addPropertyValue("invoiceNo", element.getAttribute("invoiceNo"));
        }
        if ((element.getAttribute("poNumber")!= null)&&(!StringUtils.isBlank(element.getAttribute("poNumber")))) {
            builder.addPropertyValue("poNumber", element.getAttribute("poNumber"));
        }
        if ((element.getAttribute("description")!= null)&&(!StringUtils.isBlank(element.getAttribute("description")))) {
            builder.addPropertyValue("description", element.getAttribute("description"));
        }
        if ((element.getAttribute("externalId")!= null)&&(!StringUtils.isBlank(element.getAttribute("externalId")))) {
            builder.addPropertyValue("externalId", element.getAttribute("externalId"));
        }
        if (element.hasAttribute("billToContactType")) {
            builder.addPropertyValue("billToContactType", element.getAttribute("billToContactType"));
        }
        Element billToContactsListElement = null;
        billToContactsListElement = DomUtils.getChildElementByTagName(element, "bill-to-contacts");
        List<Element> billToContactsListChilds = null;
        if (billToContactsListElement!= null) {
            String billToContactsRef = billToContactsListElement.getAttribute("ref");
            if ((billToContactsRef!= null)&&(!StringUtils.isBlank(billToContactsRef))) {
                if ((!billToContactsRef.startsWith(patternInfo.getPrefix()))&&(!billToContactsRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("billToContacts", new RuntimeBeanReference(billToContactsRef));
                } else {
                    builder.addPropertyValue("billToContacts", billToContactsRef);
                }
            } else {
                ManagedList billToContacts = new ManagedList();
                billToContactsListChilds = DomUtils.getChildElementsByTagName(billToContactsListElement, "bill-to-contact");
                if (billToContactsListChilds!= null) {
                    for (Element billToContactsChild: billToContactsListChilds) {
                        String valueRef = billToContactsChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            billToContacts.add(new RuntimeBeanReference(valueRef));
                        } else {
                            List<Element> innerbilltocontactListChilds = null;
                            if (billToContactsChild!= null) {
                                String innerbilltocontactRef = billToContactsChild.getAttribute("ref");
                                if ((innerbilltocontactRef!= null)&&(!StringUtils.isBlank(innerbilltocontactRef))) {
                                    if ((!innerbilltocontactRef.startsWith(patternInfo.getPrefix()))&&(!innerbilltocontactRef.endsWith(patternInfo.getSuffix()))) {
                                        builder.addPropertyValue("inner-bill-to-contact", new RuntimeBeanReference(innerbilltocontactRef));
                                    } else {
                                        builder.addPropertyValue("inner-bill-to-contact", innerbilltocontactRef);
                                    }
                                } else {
                                    ManagedMap innerbilltocontact = new ManagedMap();
                                    innerbilltocontactListChilds = DomUtils.getChildElementsByTagName(billToContactsChild, "inner-bill-to-contact");
                                    if (innerbilltocontactListChilds!= null) {
                                        if (innerbilltocontactListChilds.size() == 0) {
                                            innerbilltocontactListChilds = DomUtils.getChildElements(billToContactsChild);
                                        }
                                        for (Element innerbilltocontactChild: innerbilltocontactListChilds) {
                                            String innerbilltocontactValueRef = innerbilltocontactChild.getAttribute("value-ref");
                                            String innerbilltocontactKeyRef = innerbilltocontactChild.getAttribute("key-ref");
                                            Object valueObject = null;
                                            Object keyObject = null;
                                            if ((innerbilltocontactValueRef!= null)&&(!StringUtils.isBlank(innerbilltocontactValueRef))) {
                                                valueObject = new RuntimeBeanReference(innerbilltocontactValueRef);
                                            } else {
                                                valueObject = innerbilltocontactChild.getTextContent();
                                            }
                                            if ((innerbilltocontactKeyRef!= null)&&(!StringUtils.isBlank(innerbilltocontactKeyRef))) {
                                                keyObject = new RuntimeBeanReference(innerbilltocontactKeyRef);
                                            } else {
                                                keyObject = innerbilltocontactChild.getAttribute("key");
                                            }
                                            if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                                                keyObject = innerbilltocontactChild.getTagName();
                                            }
                                            innerbilltocontact.put(keyObject, valueObject);
                                        }
                                    }
                                    billToContacts.add(innerbilltocontact);
                                }
                            }
                        }
                    }
                }
                builder.addPropertyValue("billToContacts", billToContacts);
            }
        }
        if (element.hasAttribute("shipToContactType")) {
            builder.addPropertyValue("shipToContactType", element.getAttribute("shipToContactType"));
        }
        Element shipToContactsListElement = null;
        shipToContactsListElement = DomUtils.getChildElementByTagName(element, "ship-to-contacts");
        List<Element> shipToContactsListChilds = null;
        if (shipToContactsListElement!= null) {
            String shipToContactsRef = shipToContactsListElement.getAttribute("ref");
            if ((shipToContactsRef!= null)&&(!StringUtils.isBlank(shipToContactsRef))) {
                if ((!shipToContactsRef.startsWith(patternInfo.getPrefix()))&&(!shipToContactsRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("shipToContacts", new RuntimeBeanReference(shipToContactsRef));
                } else {
                    builder.addPropertyValue("shipToContacts", shipToContactsRef);
                }
            } else {
                ManagedList shipToContacts = new ManagedList();
                shipToContactsListChilds = DomUtils.getChildElementsByTagName(shipToContactsListElement, "ship-to-contact");
                if (shipToContactsListChilds!= null) {
                    for (Element shipToContactsChild: shipToContactsListChilds) {
                        String valueRef = shipToContactsChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            shipToContacts.add(new RuntimeBeanReference(valueRef));
                        } else {
                            List<Element> innershiptocontactListChilds = null;
                            if (shipToContactsChild!= null) {
                                String innershiptocontactRef = shipToContactsChild.getAttribute("ref");
                                if ((innershiptocontactRef!= null)&&(!StringUtils.isBlank(innershiptocontactRef))) {
                                    if ((!innershiptocontactRef.startsWith(patternInfo.getPrefix()))&&(!innershiptocontactRef.endsWith(patternInfo.getSuffix()))) {
                                        builder.addPropertyValue("inner-ship-to-contact", new RuntimeBeanReference(innershiptocontactRef));
                                    } else {
                                        builder.addPropertyValue("inner-ship-to-contact", innershiptocontactRef);
                                    }
                                } else {
                                    ManagedMap innershiptocontact = new ManagedMap();
                                    innershiptocontactListChilds = DomUtils.getChildElementsByTagName(shipToContactsChild, "inner-ship-to-contact");
                                    if (innershiptocontactListChilds!= null) {
                                        if (innershiptocontactListChilds.size() == 0) {
                                            innershiptocontactListChilds = DomUtils.getChildElements(shipToContactsChild);
                                        }
                                        for (Element innershiptocontactChild: innershiptocontactListChilds) {
                                            String innershiptocontactValueRef = innershiptocontactChild.getAttribute("value-ref");
                                            String innershiptocontactKeyRef = innershiptocontactChild.getAttribute("key-ref");
                                            Object valueObject = null;
                                            Object keyObject = null;
                                            if ((innershiptocontactValueRef!= null)&&(!StringUtils.isBlank(innershiptocontactValueRef))) {
                                                valueObject = new RuntimeBeanReference(innershiptocontactValueRef);
                                            } else {
                                                valueObject = innershiptocontactChild.getTextContent();
                                            }
                                            if ((innershiptocontactKeyRef!= null)&&(!StringUtils.isBlank(innershiptocontactKeyRef))) {
                                                keyObject = new RuntimeBeanReference(innershiptocontactKeyRef);
                                            } else {
                                                keyObject = innershiptocontactChild.getAttribute("key");
                                            }
                                            if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                                                keyObject = innershiptocontactChild.getTagName();
                                            }
                                            innershiptocontact.put(keyObject, valueObject);
                                        }
                                    }
                                    shipToContacts.add(innershiptocontact);
                                }
                            }
                        }
                    }
                }
                builder.addPropertyValue("shipToContacts", shipToContacts);
            }
        }
        if ((element.getAttribute("basecurr")!= null)&&(!StringUtils.isBlank(element.getAttribute("basecurr")))) {
            builder.addPropertyValue("basecurr", element.getAttribute("basecurr"));
        }
        if ((element.getAttribute("currency")!= null)&&(!StringUtils.isBlank(element.getAttribute("currency")))) {
            builder.addPropertyValue("currency", element.getAttribute("currency"));
        }
        if (element.hasAttribute("exchType")) {
            builder.addPropertyValue("exchType", element.getAttribute("exchType"));
        }
        Element exchRateDatesOrExchRateTypesOrExchRatesListElement = null;
        exchRateDatesOrExchRateTypesOrExchRatesListElement = DomUtils.getChildElementByTagName(element, "exch-rate-dates-or-exch-rate-types-or-exch-rates");
        List<Element> exchRateDatesOrExchRateTypesOrExchRatesListChilds = null;
        if (exchRateDatesOrExchRateTypesOrExchRatesListElement!= null) {
            String exchRateDatesOrExchRateTypesOrExchRatesRef = exchRateDatesOrExchRateTypesOrExchRatesListElement.getAttribute("ref");
            if ((exchRateDatesOrExchRateTypesOrExchRatesRef!= null)&&(!StringUtils.isBlank(exchRateDatesOrExchRateTypesOrExchRatesRef))) {
                if ((!exchRateDatesOrExchRateTypesOrExchRatesRef.startsWith(patternInfo.getPrefix()))&&(!exchRateDatesOrExchRateTypesOrExchRatesRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("exchRateDatesOrExchRateTypesOrExchRates", new RuntimeBeanReference(exchRateDatesOrExchRateTypesOrExchRatesRef));
                } else {
                    builder.addPropertyValue("exchRateDatesOrExchRateTypesOrExchRates", exchRateDatesOrExchRateTypesOrExchRatesRef);
                }
            } else {
                ManagedList exchRateDatesOrExchRateTypesOrExchRates = new ManagedList();
                exchRateDatesOrExchRateTypesOrExchRatesListChilds = DomUtils.getChildElementsByTagName(exchRateDatesOrExchRateTypesOrExchRatesListElement, "exch-rate-dates-or-exch-rate-types-or-exch-rate");
                if (exchRateDatesOrExchRateTypesOrExchRatesListChilds!= null) {
                    for (Element exchRateDatesOrExchRateTypesOrExchRatesChild: exchRateDatesOrExchRateTypesOrExchRatesListChilds) {
                        String valueRef = exchRateDatesOrExchRateTypesOrExchRatesChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            exchRateDatesOrExchRateTypesOrExchRates.add(new RuntimeBeanReference(valueRef));
                        } else {
                            List<Element> innerexchratedatesorexchratetypesorexchrateListChilds = null;
                            if (exchRateDatesOrExchRateTypesOrExchRatesChild!= null) {
                                String innerexchratedatesorexchratetypesorexchrateRef = exchRateDatesOrExchRateTypesOrExchRatesChild.getAttribute("ref");
                                if ((innerexchratedatesorexchratetypesorexchrateRef!= null)&&(!StringUtils.isBlank(innerexchratedatesorexchratetypesorexchrateRef))) {
                                    if ((!innerexchratedatesorexchratetypesorexchrateRef.startsWith(patternInfo.getPrefix()))&&(!innerexchratedatesorexchratetypesorexchrateRef.endsWith(patternInfo.getSuffix()))) {
                                        builder.addPropertyValue("inner-exch-rate-dates-or-exch-rate-types-or-exch-rate", new RuntimeBeanReference(innerexchratedatesorexchratetypesorexchrateRef));
                                    } else {
                                        builder.addPropertyValue("inner-exch-rate-dates-or-exch-rate-types-or-exch-rate", innerexchratedatesorexchratetypesorexchrateRef);
                                    }
                                } else {
                                    ManagedMap innerexchratedatesorexchratetypesorexchrate = new ManagedMap();
                                    innerexchratedatesorexchratetypesorexchrateListChilds = DomUtils.getChildElementsByTagName(exchRateDatesOrExchRateTypesOrExchRatesChild, "inner-exch-rate-dates-or-exch-rate-types-or-exch-rate");
                                    if (innerexchratedatesorexchratetypesorexchrateListChilds!= null) {
                                        if (innerexchratedatesorexchratetypesorexchrateListChilds.size() == 0) {
                                            innerexchratedatesorexchratetypesorexchrateListChilds = DomUtils.getChildElements(exchRateDatesOrExchRateTypesOrExchRatesChild);
                                        }
                                        for (Element innerexchratedatesorexchratetypesorexchrateChild: innerexchratedatesorexchratetypesorexchrateListChilds) {
                                            String innerexchratedatesorexchratetypesorexchrateValueRef = innerexchratedatesorexchratetypesorexchrateChild.getAttribute("value-ref");
                                            String innerexchratedatesorexchratetypesorexchrateKeyRef = innerexchratedatesorexchratetypesorexchrateChild.getAttribute("key-ref");
                                            Object valueObject = null;
                                            Object keyObject = null;
                                            if ((innerexchratedatesorexchratetypesorexchrateValueRef!= null)&&(!StringUtils.isBlank(innerexchratedatesorexchratetypesorexchrateValueRef))) {
                                                valueObject = new RuntimeBeanReference(innerexchratedatesorexchratetypesorexchrateValueRef);
                                            } else {
                                                valueObject = innerexchratedatesorexchratetypesorexchrateChild.getTextContent();
                                            }
                                            if ((innerexchratedatesorexchratetypesorexchrateKeyRef!= null)&&(!StringUtils.isBlank(innerexchratedatesorexchratetypesorexchrateKeyRef))) {
                                                keyObject = new RuntimeBeanReference(innerexchratedatesorexchratetypesorexchrateKeyRef);
                                            } else {
                                                keyObject = innerexchratedatesorexchratetypesorexchrateChild.getAttribute("key");
                                            }
                                            if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                                                keyObject = innerexchratedatesorexchratetypesorexchrateChild.getTagName();
                                            }
                                            innerexchratedatesorexchratetypesorexchrate.put(keyObject, valueObject);
                                        }
                                    }
                                    exchRateDatesOrExchRateTypesOrExchRates.add(innerexchratedatesorexchratetypesorexchrate);
                                }
                            }
                        }
                    }
                }
                builder.addPropertyValue("exchRateDatesOrExchRateTypesOrExchRates", exchRateDatesOrExchRateTypesOrExchRates);
            }
        }
        if ((element.getAttribute("nogl")!= null)&&(!StringUtils.isBlank(element.getAttribute("nogl")))) {
            builder.addPropertyValue("nogl", element.getAttribute("nogl"));
        }
        Element customFieldsListElement = null;
        customFieldsListElement = DomUtils.getChildElementByTagName(element, "custom-fields");
        List<Element> customFieldsListChilds = null;
        if (customFieldsListElement!= null) {
            String customFieldsRef = customFieldsListElement.getAttribute("ref");
            if ((customFieldsRef!= null)&&(!StringUtils.isBlank(customFieldsRef))) {
                if ((!customFieldsRef.startsWith(patternInfo.getPrefix()))&&(!customFieldsRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("customFields", new RuntimeBeanReference(customFieldsRef));
                } else {
                    builder.addPropertyValue("customFields", customFieldsRef);
                }
            } else {
                ManagedList customFields = new ManagedList();
                customFieldsListChilds = DomUtils.getChildElementsByTagName(customFieldsListElement, "custom-field");
                if (customFieldsListChilds!= null) {
                    for (Element customFieldsChild: customFieldsListChilds) {
                        String valueRef = customFieldsChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            customFields.add(new RuntimeBeanReference(valueRef));
                        } else {
                            List<Element> innercustomfieldListChilds = null;
                            if (customFieldsChild!= null) {
                                String innercustomfieldRef = customFieldsChild.getAttribute("ref");
                                if ((innercustomfieldRef!= null)&&(!StringUtils.isBlank(innercustomfieldRef))) {
                                    if ((!innercustomfieldRef.startsWith(patternInfo.getPrefix()))&&(!innercustomfieldRef.endsWith(patternInfo.getSuffix()))) {
                                        builder.addPropertyValue("inner-custom-field", new RuntimeBeanReference(innercustomfieldRef));
                                    } else {
                                        builder.addPropertyValue("inner-custom-field", innercustomfieldRef);
                                    }
                                } else {
                                    ManagedMap innercustomfield = new ManagedMap();
                                    innercustomfieldListChilds = DomUtils.getChildElementsByTagName(customFieldsChild, "inner-custom-field");
                                    if (innercustomfieldListChilds!= null) {
                                        if (innercustomfieldListChilds.size() == 0) {
                                            innercustomfieldListChilds = DomUtils.getChildElements(customFieldsChild);
                                        }
                                        for (Element innercustomfieldChild: innercustomfieldListChilds) {
                                            String innercustomfieldValueRef = innercustomfieldChild.getAttribute("value-ref");
                                            String innercustomfieldKeyRef = innercustomfieldChild.getAttribute("key-ref");
                                            Object valueObject = null;
                                            Object keyObject = null;
                                            if ((innercustomfieldValueRef!= null)&&(!StringUtils.isBlank(innercustomfieldValueRef))) {
                                                valueObject = new RuntimeBeanReference(innercustomfieldValueRef);
                                            } else {
                                                valueObject = innercustomfieldChild.getTextContent();
                                            }
                                            if ((innercustomfieldKeyRef!= null)&&(!StringUtils.isBlank(innercustomfieldKeyRef))) {
                                                keyObject = new RuntimeBeanReference(innercustomfieldKeyRef);
                                            } else {
                                                keyObject = innercustomfieldChild.getAttribute("key");
                                            }
                                            if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                                                keyObject = innercustomfieldChild.getTagName();
                                            }
                                            innercustomfield.put(keyObject, valueObject);
                                        }
                                    }
                                    customFields.add(innercustomfield);
                                }
                            }
                        }
                    }
                }
                builder.addPropertyValue("customFields", customFields);
            }
        }
        Element invoiceItemsListElement = null;
        invoiceItemsListElement = DomUtils.getChildElementByTagName(element, "invoice-items");
        List<Element> invoiceItemsListChilds = null;
        if (invoiceItemsListElement!= null) {
            String invoiceItemsRef = invoiceItemsListElement.getAttribute("ref");
            if ((invoiceItemsRef!= null)&&(!StringUtils.isBlank(invoiceItemsRef))) {
                if ((!invoiceItemsRef.startsWith(patternInfo.getPrefix()))&&(!invoiceItemsRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("invoiceItems", new RuntimeBeanReference(invoiceItemsRef));
                } else {
                    builder.addPropertyValue("invoiceItems", invoiceItemsRef);
                }
            } else {
                ManagedList invoiceItems = new ManagedList();
                invoiceItemsListChilds = DomUtils.getChildElementsByTagName(invoiceItemsListElement, "invoice-item");
                if (invoiceItemsListChilds!= null) {
                    for (Element invoiceItemsChild: invoiceItemsListChilds) {
                        String valueRef = invoiceItemsChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            invoiceItems.add(new RuntimeBeanReference(valueRef));
                        } else {
                            List<Element> innerinvoiceitemListChilds = null;
                            if (invoiceItemsChild!= null) {
                                String innerinvoiceitemRef = invoiceItemsChild.getAttribute("ref");
                                if ((innerinvoiceitemRef!= null)&&(!StringUtils.isBlank(innerinvoiceitemRef))) {
                                    if ((!innerinvoiceitemRef.startsWith(patternInfo.getPrefix()))&&(!innerinvoiceitemRef.endsWith(patternInfo.getSuffix()))) {
                                        builder.addPropertyValue("inner-invoice-item", new RuntimeBeanReference(innerinvoiceitemRef));
                                    } else {
                                        builder.addPropertyValue("inner-invoice-item", innerinvoiceitemRef);
                                    }
                                } else {
                                    ManagedMap innerinvoiceitem = new ManagedMap();
                                    innerinvoiceitemListChilds = DomUtils.getChildElementsByTagName(invoiceItemsChild, "inner-invoice-item");
                                    if (innerinvoiceitemListChilds!= null) {
                                        if (innerinvoiceitemListChilds.size() == 0) {
                                            innerinvoiceitemListChilds = DomUtils.getChildElements(invoiceItemsChild);
                                        }
                                        for (Element innerinvoiceitemChild: innerinvoiceitemListChilds) {
                                            String innerinvoiceitemValueRef = innerinvoiceitemChild.getAttribute("value-ref");
                                            String innerinvoiceitemKeyRef = innerinvoiceitemChild.getAttribute("key-ref");
                                            Object valueObject = null;
                                            Object keyObject = null;
                                            if ((innerinvoiceitemValueRef!= null)&&(!StringUtils.isBlank(innerinvoiceitemValueRef))) {
                                                valueObject = new RuntimeBeanReference(innerinvoiceitemValueRef);
                                            } else {
                                                valueObject = innerinvoiceitemChild.getTextContent();
                                            }
                                            if ((innerinvoiceitemKeyRef!= null)&&(!StringUtils.isBlank(innerinvoiceitemKeyRef))) {
                                                keyObject = new RuntimeBeanReference(innerinvoiceitemKeyRef);
                                            } else {
                                                keyObject = innerinvoiceitemChild.getAttribute("key");
                                            }
                                            if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                                                keyObject = innerinvoiceitemChild.getTagName();
                                            }
                                            innerinvoiceitem.put(keyObject, valueObject);
                                        }
                                    }
                                    invoiceItems.add(innerinvoiceitem);
                                }
                            }
                        }
                    }
                }
                builder.addPropertyValue("invoiceItems", invoiceItems);
            }
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        MutablePropertyValues propertyValues = parserContent.getContainingBeanDefinition().getPropertyValues();
        if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.config.spring.factories.PollingMessageSourceFactoryBean")) {
            propertyValues.addPropertyValue("messageProcessor", definition);
        } else {
            if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.enricher.MessageEnricher")) {
                propertyValues.addPropertyValue("enrichmentMessageProcessor", definition);
            } else {
                PropertyValue messageProcessors = propertyValues.getPropertyValue("messageProcessors");
                if ((messageProcessors == null)||(messageProcessors.getValue() == null)) {
                    propertyValues.addPropertyValue("messageProcessors", new ManagedList());
                }
                List listMessageProcessors = ((List) propertyValues.getPropertyValue("messageProcessors").getValue());
                listMessageProcessors.add(definition);
            }
        }
        return definition;
    }

    protected String getAttributeValue(Element element, String attributeName) {
        if (!StringUtils.isEmpty(element.getAttribute(attributeName))) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    private String generateChildBeanName(Element element) {
        String id = SpringXMLUtils.getNameOrId(element);
        if (StringUtils.isBlank(id)) {
            String parentId = SpringXMLUtils.getNameOrId(((Element) element.getParentNode()));
            return ((("."+ parentId)+":")+ element.getLocalName());
        } else {
            return id;
        }
    }

}
