
package org.mule.modules.drupal.connectivity;

import javax.annotation.Generated;
import org.apache.commons.pool.KeyedObjectPool;
import org.mule.api.MetadataAware;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.config.MuleProperties;
import org.mule.api.context.MuleContextAware;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.devkit.capability.Capabilities;
import org.mule.api.devkit.capability.ModuleCapability;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.common.DefaultTestResult;
import org.mule.common.TestResult;
import org.mule.common.Testable;
import org.mule.config.PoolingProfile;
import org.mule.devkit.processor.ExpressionEvaluatorSupport;
import org.mule.devkit.shade.connection.management.ConnectionManagementConnectionAdapter;
import org.mule.devkit.shade.connection.management.ConnectionManagementConnectionManager;
import org.mule.devkit.shade.connection.management.ConnectionManagementConnectorAdapter;
import org.mule.devkit.shade.connection.management.ConnectionManagementConnectorFactory;
import org.mule.devkit.shade.connection.management.ConnectionManagementProcessTemplate;
import org.mule.devkit.shade.connection.management.UnableToAcquireConnectionException;
import org.mule.devkit.shade.connectivity.ConnectivityTestingErrorHandler;
import org.mule.modules.drupal.DrupalConnector;
import org.mule.modules.drupal.adapters.DrupalConnectorConnectionManagementAdapter;
import org.mule.modules.drupal.pooling.DevkitGenericKeyedObjectPool;
import org.mule.modules.drupal.strategy.DrupalConnectorConnectionStrategy;


/**
 * A {@code DrupalConnectorConfigConnectionManagementConnectionManager} is a wrapper around {@link DrupalConnector } that adds connection management capabilities to the pojo.
 * 
 */
@SuppressWarnings("all")
@Generated(value = "Mule DevKit Version 3.6.1", date = "2016-01-21T09:59:19-03:00", comments = "Build UNNAMED.2405.44720b7")
public class DrupalConnectorConfigConnectionManagementConnectionManager
    extends ExpressionEvaluatorSupport
    implements MetadataAware, MuleContextAware, ProcessAdapter<DrupalConnectorConnectionManagementAdapter> , Capabilities, Disposable, Initialisable, Testable, ConnectionManagementConnectionManager<ConnectionManagementConfigDrupalConnectorConnectionKey, DrupalConnectorConnectionManagementAdapter, DrupalConnectorConnectionStrategy>
{

    /**
     * 
     */
    private String username;
    /**
     * 
     */
    private String password;
    private String server;
    private String apiUrl;
    private int port;
    private String userEndpoint;
    private String nodeEndpoint;
    private String commentEndpoint;
    private String fileEndpoint;
    private String taxonomyTermEndpoint;
    private String taxonomyVocabularyEndpoint;
    /**
     * Mule Context
     * 
     */
    protected MuleContext muleContext;
    /**
     * Connector Pool
     * 
     */
    private KeyedObjectPool connectionPool;
    protected PoolingProfile poolingProfile;
    protected RetryPolicyTemplate retryPolicyTemplate;
    private final static String MODULE_NAME = "Drupal";
    private final static String MODULE_VERSION = "2.0.0";
    private final static String DEVKIT_VERSION = "3.6.1";
    private final static String DEVKIT_BUILD = "UNNAMED.2405.44720b7";
    private final static String MIN_MULE_VERSION = "3.5.0";

    /**
     * Sets username
     * 
     * @param value Value to set
     */
    public void setUsername(String value) {
        this.username = value;
    }

    /**
     * Retrieves username
     * 
     */
    public String getUsername() {
        return this.username;
    }

    /**
     * Sets password
     * 
     * @param value Value to set
     */
    public void setPassword(String value) {
        this.password = value;
    }

    /**
     * Retrieves password
     * 
     */
    public String getPassword() {
        return this.password;
    }

    /**
     * Sets server
     * 
     * @param value Value to set
     */
    public void setServer(String value) {
        this.server = value;
    }

    /**
     * Retrieves server
     * 
     */
    public String getServer() {
        return this.server;
    }

    /**
     * Sets apiUrl
     * 
     * @param value Value to set
     */
    public void setApiUrl(String value) {
        this.apiUrl = value;
    }

    /**
     * Retrieves apiUrl
     * 
     */
    public String getApiUrl() {
        return this.apiUrl;
    }

    /**
     * Sets port
     * 
     * @param value Value to set
     */
    public void setPort(int value) {
        this.port = value;
    }

    /**
     * Retrieves port
     * 
     */
    public int getPort() {
        return this.port;
    }

    /**
     * Sets userEndpoint
     * 
     * @param value Value to set
     */
    public void setUserEndpoint(String value) {
        this.userEndpoint = value;
    }

    /**
     * Retrieves userEndpoint
     * 
     */
    public String getUserEndpoint() {
        return this.userEndpoint;
    }

    /**
     * Sets nodeEndpoint
     * 
     * @param value Value to set
     */
    public void setNodeEndpoint(String value) {
        this.nodeEndpoint = value;
    }

    /**
     * Retrieves nodeEndpoint
     * 
     */
    public String getNodeEndpoint() {
        return this.nodeEndpoint;
    }

    /**
     * Sets commentEndpoint
     * 
     * @param value Value to set
     */
    public void setCommentEndpoint(String value) {
        this.commentEndpoint = value;
    }

    /**
     * Retrieves commentEndpoint
     * 
     */
    public String getCommentEndpoint() {
        return this.commentEndpoint;
    }

    /**
     * Sets fileEndpoint
     * 
     * @param value Value to set
     */
    public void setFileEndpoint(String value) {
        this.fileEndpoint = value;
    }

    /**
     * Retrieves fileEndpoint
     * 
     */
    public String getFileEndpoint() {
        return this.fileEndpoint;
    }

    /**
     * Sets taxonomyTermEndpoint
     * 
     * @param value Value to set
     */
    public void setTaxonomyTermEndpoint(String value) {
        this.taxonomyTermEndpoint = value;
    }

    /**
     * Retrieves taxonomyTermEndpoint
     * 
     */
    public String getTaxonomyTermEndpoint() {
        return this.taxonomyTermEndpoint;
    }

    /**
     * Sets taxonomyVocabularyEndpoint
     * 
     * @param value Value to set
     */
    public void setTaxonomyVocabularyEndpoint(String value) {
        this.taxonomyVocabularyEndpoint = value;
    }

    /**
     * Retrieves taxonomyVocabularyEndpoint
     * 
     */
    public String getTaxonomyVocabularyEndpoint() {
        return this.taxonomyVocabularyEndpoint;
    }

    /**
     * Sets muleContext
     * 
     * @param value Value to set
     */
    public void setMuleContext(MuleContext value) {
        this.muleContext = value;
    }

    /**
     * Retrieves muleContext
     * 
     */
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    /**
     * Sets poolingProfile
     * 
     * @param value Value to set
     */
    public void setPoolingProfile(PoolingProfile value) {
        this.poolingProfile = value;
    }

    /**
     * Retrieves poolingProfile
     * 
     */
    public PoolingProfile getPoolingProfile() {
        return this.poolingProfile;
    }

    /**
     * Sets retryPolicyTemplate
     * 
     * @param value Value to set
     */
    public void setRetryPolicyTemplate(RetryPolicyTemplate value) {
        this.retryPolicyTemplate = value;
    }

    /**
     * Retrieves retryPolicyTemplate
     * 
     */
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    public void initialise() {
        connectionPool = new DevkitGenericKeyedObjectPool(new ConnectionManagementConnectorFactory(this), poolingProfile);
        if (retryPolicyTemplate == null) {
            retryPolicyTemplate = muleContext.getRegistry().lookupObject(MuleProperties.OBJECT_DEFAULT_RETRY_POLICY_TEMPLATE);
        }
    }

    @Override
    public void dispose() {
        try {
            connectionPool.close();
        } catch (Exception e) {
        }
    }

    public DrupalConnectorConnectionManagementAdapter acquireConnection(ConnectionManagementConfigDrupalConnectorConnectionKey key)
        throws Exception
    {
        return ((DrupalConnectorConnectionManagementAdapter) connectionPool.borrowObject(key));
    }

    public void releaseConnection(ConnectionManagementConfigDrupalConnectorConnectionKey key, DrupalConnectorConnectionManagementAdapter connection)
        throws Exception
    {
        connectionPool.returnObject(key, connection);
    }

    public void destroyConnection(ConnectionManagementConfigDrupalConnectorConnectionKey key, DrupalConnectorConnectionManagementAdapter connection)
        throws Exception
    {
        connectionPool.invalidateObject(key, connection);
    }

    /**
     * Returns true if this module implements such capability
     * 
     */
    public boolean isCapableOf(ModuleCapability capability) {
        if (capability == ModuleCapability.LIFECYCLE_CAPABLE) {
            return true;
        }
        if (capability == ModuleCapability.CONNECTION_MANAGEMENT_CAPABLE) {
            return true;
        }
        return false;
    }

    @Override
    public<P >ProcessTemplate<P, DrupalConnectorConnectionManagementAdapter> getProcessTemplate() {
        return new ConnectionManagementProcessTemplate(this, muleContext);
    }

    @Override
    public ConnectionManagementConfigDrupalConnectorConnectionKey getDefaultConnectionKey() {
        return new ConnectionManagementConfigDrupalConnectorConnectionKey(getUsername(), getPassword());
    }

    @Override
    public ConnectionManagementConfigDrupalConnectorConnectionKey getEvaluatedConnectionKey(MuleEvent event)
        throws Exception
    {
        if (event!= null) {
            final String _transformedUsername = ((String) evaluateAndTransform(muleContext, event, this.getClass().getDeclaredField("username").getGenericType(), null, getUsername()));
            if (_transformedUsername == null) {
                throw new UnableToAcquireConnectionException("Parameter username in method connect can't be null because is not @Optional");
            }
            final String _transformedPassword = ((String) evaluateAndTransform(muleContext, event, this.getClass().getDeclaredField("password").getGenericType(), null, getPassword()));
            if (_transformedPassword == null) {
                throw new UnableToAcquireConnectionException("Parameter password in method connect can't be null because is not @Optional");
            }
            return new ConnectionManagementConfigDrupalConnectorConnectionKey(_transformedUsername, _transformedPassword);
        }
        return getDefaultConnectionKey();
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getModuleVersion() {
        return MODULE_VERSION;
    }

    public String getDevkitVersion() {
        return DEVKIT_VERSION;
    }

    public String getDevkitBuild() {
        return DEVKIT_BUILD;
    }

    public String getMinMuleVersion() {
        return MIN_MULE_VERSION;
    }

    @Override
    public ConnectionManagementConfigDrupalConnectorConnectionKey getConnectionKey(MessageProcessor messageProcessor, MuleEvent event)
        throws Exception
    {
        return getEvaluatedConnectionKey(event);
    }

    @Override
    public ConnectionManagementConnectionAdapter newConnection() {
        DrupalConnectorConnectionStrategyDrupalConnectorAdapter connection = new DrupalConnectorConnectionStrategyDrupalConnectorAdapter();
        connection.setServer(getServer());
        connection.setApiUrl(getApiUrl());
        connection.setPort(getPort());
        connection.setUserEndpoint(getUserEndpoint());
        connection.setNodeEndpoint(getNodeEndpoint());
        connection.setCommentEndpoint(getCommentEndpoint());
        connection.setFileEndpoint(getFileEndpoint());
        connection.setTaxonomyTermEndpoint(getTaxonomyTermEndpoint());
        connection.setTaxonomyVocabularyEndpoint(getTaxonomyVocabularyEndpoint());
        return connection;
    }

    @Override
    public ConnectionManagementConnectorAdapter newConnector(ConnectionManagementConnectionAdapter<DrupalConnectorConnectionStrategy, ConnectionManagementConfigDrupalConnectorConnectionKey> connection) {
        DrupalConnectorConnectionManagementAdapter connector = new DrupalConnectorConnectionManagementAdapter();
        connector.setConnectionStrategy(connection.getStrategy());
        return connector;
    }

    public ConnectionManagementConnectionAdapter getConnectionAdapter(ConnectionManagementConnectorAdapter adapter) {
        DrupalConnectorConnectionManagementAdapter connector = ((DrupalConnectorConnectionManagementAdapter) adapter);
        ConnectionManagementConnectionAdapter strategy = ((ConnectionManagementConnectionAdapter) connector.getConnectionStrategy());
        return strategy;
    }

    public TestResult test() {
        DrupalConnectorConnectionManagementAdapter connection = null;
        DefaultTestResult result;
        ConnectionManagementConfigDrupalConnectorConnectionKey key = getDefaultConnectionKey();
        try {
            connection = acquireConnection(key);
            result = new DefaultTestResult(org.mule.common.Result.Status.SUCCESS);
        } catch (Exception e) {
            try {
                destroyConnection(key, connection);
            } catch (Exception ie) {
            }
            result = ((DefaultTestResult) ConnectivityTestingErrorHandler.buildFailureTestResult(e));
        } finally {
            if (connection!= null) {
                try {
                    releaseConnection(key, connection);
                } catch (Exception ie) {
                }
            }
        }
        return result;
    }

}
