
package org.mule.modules.drupal.config;

import javax.annotation.Generated;
import org.mule.config.MuleManifest;
import org.mule.modules.drupal.model.holders.CustomFieldExpressionHolder;
import org.mule.modules.drupal.model.holders.NodeExpressionHolder;
import org.mule.modules.drupal.processors.UpdateNodeMessageProcessor;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser.ParseDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

@SuppressWarnings("all")
@Generated(value = "Mule DevKit Version 3.6.1", date = "2016-01-21T09:59:19-03:00", comments = "Build UNNAMED.2405.44720b7")
public class UpdateNodeDefinitionParser
    extends AbstractDevkitBasedDefinitionParser
{

    private static Logger logger = LoggerFactory.getLogger(UpdateNodeDefinitionParser.class);

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition(UpdateNodeMessageProcessor.class.getName());
        } catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            } catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error(("Cannot launch the mule app, the @Processor [update-node] within the connector [drupal] is not supported in mule "+ muleVersion));
            throw new BeanDefinitionParsingException(new Problem(("Cannot launch the mule app, the @Processor [update-node] within the connector [drupal] is not supported in mule "+ muleVersion), new Location(parserContext.getReaderContext().getResource()), null, noClassDefFoundError));
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = getBeanDefinitionBuilder(parserContext);
        builder.addConstructorArgValue("updateNode");
        builder.setScope(BeanDefinition.SCOPE_PROTOTYPE);
        if (!hasAttribute(element, "config-ref")) {
            throw new BeanDefinitionParsingException(new Problem("It seems that the config-ref for @Processor [update-node] within the connector [drupal] is null or missing. Please, fill the value with the correct global element.", new Location(parserContext.getReaderContext().getResource()), null));
        }
        parseConfigRef(element, builder);
        if (!parseObjectRefWithDefault(element, builder, "node", "node", "#[payload]")) {
            BeanDefinitionBuilder nodeBuilder = BeanDefinitionBuilder.rootBeanDefinition(NodeExpressionHolder.class.getName());
            Element nodeChildElement = DomUtils.getChildElementByTagName(element, "node");
            if (nodeChildElement!= null) {
                parseProperty(nodeBuilder, nodeChildElement, "serialVersionUID", "serialVersionUID");
                if (hasAttribute(nodeChildElement, "rdfMapping-ref")) {
                    if (nodeChildElement.getAttribute("rdfMapping-ref").startsWith("#")) {
                        nodeBuilder.addPropertyValue("rdfMapping", nodeChildElement.getAttribute("rdfMapping-ref"));
                    } else {
                        nodeBuilder.addPropertyValue("rdfMapping", (("#[registry:"+ nodeChildElement.getAttribute("rdfMapping-ref"))+"]"));
                    }
                }
                parseProperty(nodeBuilder, nodeChildElement, "uri", "uri");
                parseMapAndSetProperty(nodeChildElement, nodeBuilder, "customFields", "custom-fields", "custom-field", new ParseDelegate<String>() {


                    public String parse(Element element) {
                        return element.getTextContent();
                    }

                }
                );
                parseProperty(nodeBuilder, nodeChildElement, "nid", "nid");
                parseProperty(nodeBuilder, nodeChildElement, "uid", "uid");
                parseProperty(nodeBuilder, nodeChildElement, "vid", "vid");
                parseProperty(nodeBuilder, nodeChildElement, "type", "type");
                parseProperty(nodeBuilder, nodeChildElement, "language", "language");
                parseProperty(nodeBuilder, nodeChildElement, "title", "title");
                parseProperty(nodeBuilder, nodeChildElement, "status", "status");
                parseProperty(nodeBuilder, nodeChildElement, "comment", "comment");
                parseProperty(nodeBuilder, nodeChildElement, "promote", "promote");
                parseProperty(nodeBuilder, nodeChildElement, "sticky", "sticky");
                parseProperty(nodeBuilder, nodeChildElement, "tnid", "tnid");
                parseProperty(nodeBuilder, nodeChildElement, "translated", "translated");
                parseProperty(nodeBuilder, nodeChildElement, "revisionTimestamp", "revisionTimestamp");
                parseProperty(nodeBuilder, nodeChildElement, "revisionUid", "revisionUid");
                if (!parseObjectRef(nodeChildElement, nodeBuilder, "body", "body")) {
                    BeanDefinitionBuilder _bodyBuilder = BeanDefinitionBuilder.rootBeanDefinition(CustomFieldExpressionHolder.class.getName());
                    Element _bodyChildElement = DomUtils.getChildElementByTagName(nodeChildElement, "body");
                    if (_bodyChildElement!= null) {
                        parseListAndSetProperty(_bodyChildElement, _bodyBuilder, "und", "und", "und", new ParseDelegate<Object>() {


                            public Object parse(Element element) {
                                if (element.hasAttribute("ref")) {
                                    if (!isMuleExpression(element.getAttribute("ref"))) {
                                        return new RuntimeBeanReference(element.getAttribute("ref"));
                                    } else {
                                        return element.getAttribute("ref");
                                    }
                                }
                                return parseMap(element, "inner-und", new ParseDelegate<String>() {


                                    public String parse(Element element) {
                                        return element.getTextContent();
                                    }

                                }
                                );
                            }

                        }
                        );
                        nodeBuilder.addPropertyValue("body", _bodyBuilder.getBeanDefinition());
                    }
                }
                parseProperty(nodeBuilder, nodeChildElement, "created", "created");
                parseProperty(nodeBuilder, nodeChildElement, "changed", "changed");
                parseProperty(nodeBuilder, nodeChildElement, "cid", "cid");
                parseProperty(nodeBuilder, nodeChildElement, "lastCommentTimestamp", "lastCommentTimestamp");
                parseProperty(nodeBuilder, nodeChildElement, "lastCommentName", "lastCommentName");
                parseProperty(nodeBuilder, nodeChildElement, "lastCommentUid", "lastCommentUid");
                parseProperty(nodeBuilder, nodeChildElement, "commentCount", "commentCount");
                parseProperty(nodeBuilder, nodeChildElement, "name", "name");
                parseProperty(nodeBuilder, nodeChildElement, "picture", "picture");
                parseProperty(nodeBuilder, nodeChildElement, "data", "data");
                parseProperty(nodeBuilder, nodeChildElement, "path", "path");
                builder.addPropertyValue("node", nodeBuilder.getBeanDefinition());
            }
        }
        BeanDefinition definition = builder.getBeanDefinition();
        setNoRecurseOnDefinition(definition);
        attachProcessorDefinition(parserContext, definition);
        return definition;
    }

}
