
package org.mule.modules.drupal.config;

import javax.annotation.Generated;
import org.mule.config.MuleManifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;


/**
 * Registers bean definitions parsers for handling elements in <code>http://www.mulesoft.org/schema/mule/drupal</code>.
 * 
 */
@SuppressWarnings("all")
@Generated(value = "Mule DevKit Version 3.6.1", date = "2016-01-21T09:59:19-03:00", comments = "Build UNNAMED.2405.44720b7")
public class DrupalNamespaceHandler
    extends NamespaceHandlerSupport
{

    private static Logger logger = LoggerFactory.getLogger(DrupalNamespaceHandler.class);

    private void handleException(String beanName, String beanScope, NoClassDefFoundError noClassDefFoundError) {
        String muleVersion = "";
        try {
            muleVersion = MuleManifest.getProductVersion();
        } catch (Exception _x) {
            logger.error("Problem while reading mule version");
        }
        logger.error(((((("Cannot launch the mule app, the  "+ beanScope)+" [")+ beanName)+"] within the connector [drupal] is not supported in mule ")+ muleVersion));
        throw new FatalBeanException(((((("Cannot launch the mule app, the  "+ beanScope)+" [")+ beanName)+"] within the connector [drupal] is not supported in mule ")+ muleVersion), noClassDefFoundError);
    }

    /**
     * Invoked by the {@link DefaultBeanDefinitionDocumentReader} after construction but before any custom elements are parsed. 
     * @see NamespaceHandlerSupport#registerBeanDefinitionParser(String, BeanDefinitionParser)
     * 
     */
    public void init() {
        try {
            this.registerBeanDefinitionParser("config", new DrupalConnectorDrupalConnectorConnectionStrategyConfigDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("config", "@Config", ex);
        }
        try {
            this.registerBeanDefinitionParser("read-node", new ReadNodeDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("read-node", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("read-comment", new ReadCommentDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("read-comment", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("read-user", new ReadUserDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("read-user", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("read-taxonomy-term", new ReadTaxonomyTermDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("read-taxonomy-term", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("read-file", new ReadFileDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("read-file", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("read-taxonomy-vocabulary", new ReadTaxonomyVocabularyDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("read-taxonomy-vocabulary", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("create-node", new CreateNodeDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("create-node", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("create-comment", new CreateCommentDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("create-comment", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("create-user", new CreateUserDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("create-user", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("create-taxonomy-term", new CreateTaxonomyTermDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("create-taxonomy-term", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("create-file", new CreateFileDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("create-file", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("create-taxonomy-vocabulary", new CreateTaxonomyVocabularyDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("create-taxonomy-vocabulary", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("register-user", new RegisterUserDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("register-user", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("update-node", new UpdateNodeDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("update-node", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("update-comment", new UpdateCommentDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("update-comment", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("update-user", new UpdateUserDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("update-user", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("update-taxonomy-term", new UpdateTaxonomyTermDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("update-taxonomy-term", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("update-taxonomy-vocabulary", new UpdateTaxonomyVocabularyDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("update-taxonomy-vocabulary", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("delete-node", new DeleteNodeDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("delete-node", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("delete-comment", new DeleteCommentDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("delete-comment", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("delete-file", new DeleteFileDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("delete-file", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("delete-taxonomy-vocabulary", new DeleteTaxonomyVocabularyDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("delete-taxonomy-vocabulary", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("delete-taxonomy-term", new DeleteTaxonomyTermDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("delete-taxonomy-term", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("delete-user", new DeleteUserDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("delete-user", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("count-all-comments", new CountAllCommentsDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("count-all-comments", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("count-new-comments", new CountNewCommentsDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("count-new-comments", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("index-nodes", new IndexNodesDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("index-nodes", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("index-comments", new IndexCommentsDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("index-comments", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("index-users", new IndexUsersDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("index-users", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("index-taxonomy-terms", new IndexTaxonomyTermsDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("index-taxonomy-terms", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("index-taxonomy-vocabulary", new IndexTaxonomyVocabularyDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("index-taxonomy-vocabulary", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("index-files", new IndexFilesDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("index-files", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-nodes-with-term", new GetNodesWithTermDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-nodes-with-term", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-taxonomy-vocabulary-tree", new GetTaxonomyVocabularyTreeDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-taxonomy-vocabulary-tree", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-comments-for-node", new GetCommentsForNodeDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-comments-for-node", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-files-for-node", new GetFilesForNodeDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-files-for-node", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("update-custom-field-for-node", new UpdateCustomFieldForNodeDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("update-custom-field-for-node", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("attach-files-to-node", new AttachFilesToNodeDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("attach-files-to-node", "@Processor", ex);
        }
    }

}
